/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisService;

public class JAXWSServiceDescriptorImpl
implements WSServiceDescriptor,
Constants {
    private Service service;
    private WSModuleDescriptor parent;
    private ArrayList endpointList;
    private Definition wsdlDefinition;
    private String wsdlLocation;
    private Boolean deployedWithWSDL = true;
    private static final TraceComponent _tc = Tr.register(JAXWSServiceDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    JAXWSServiceDescriptorImpl(AxisService aServ, Service serv, WSModuleDescriptor mDesc) {
        AxisService axisService = aServ;
        this.service = serv;
        this.parent = mDesc;
        this.endpointList = new ArrayList();
        this.setWSDLDefinition(axisService);
        this.setWSDLLocationBaseName(axisService);
        this.setDeployedWithWSDL(axisService);
    }

    public Iterator getEndpoints() {
        return this.endpointList.iterator();
    }

    public void addEndpoint(WSEndpointDescriptor endpointDesc) {
        this.endpointList.add(endpointDesc);
    }

    public String getName() {
        return this.service.getQName().getLocalPart();
    }

    public WSModuleDescriptor getParent() {
        return this.parent;
    }

    public QName getQName() {
        return this.service.getQName();
    }

    public void setWSDLDefinition(AxisService axisService) {
        this.wsdlDefinition = Axis2Utils.getWSDLDefinition(axisService);
    }

    public Definition getWSDLDefinition() {
        return this.wsdlDefinition;
    }

    public void setWSDLLocationBaseName(AxisService axisService) {
        this.wsdlLocation = Axis2Utils.getWSDLLocation(axisService);
    }

    public String getWSDLLocationBaseName() {
        return this.wsdlLocation;
    }

    public URI getWSDLLocationURI() {
        String uriString = this.getWSDLLocationBaseName();
        URI uri = null;
        try {
            uri = new URI(uriString);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.desc.JAXWSServiceDescriptorImpl.getWSDLLocationURI", "160", this);
        }
        return uri;
    }

    public boolean isJAXRPCService() {
        return false;
    }

    public boolean isJAXWSService() {
        return true;
    }

    private void setDeployedWithWSDL(AxisService axisService) {
        if (Axis2Utils.getWsdlComposite(axisService) != null) {
            this.deployedWithWSDL = false;
        }
    }

    public boolean deployedWithWSDL() {
        return this.deployedWithWSDL;
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

