/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.desc.DDClientEndpointDescriptorImpl;
import com.ibm.ws.websvcs.desc.ServiceRefWSDLInfo;
import com.ibm.wsspi.websvcs.desc.ServiceRefInfo;
import com.ibm.wsspi.websvcs.desc.WSClientEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Port;
import javax.xml.namespace.QName;

public class DDClientServiceDescriptorImpl
implements WSClientServiceDescriptor {
    private static final TraceComponent _tc = Tr.register(DDClientServiceDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private ServiceRefWSDLInfo wsdlInfo = null;
    private boolean endpointsBuilt;
    private WSClientType type;
    private List<WSClientEndpointDescriptor> endpointDescList;
    private ServiceRefInfo srInfo;

    DDClientServiceDescriptorImpl(ServiceRefWSDLInfo srwi, WSClientType type, ServiceRefInfo srInfo) {
        this.wsdlInfo = srwi;
        this.type = type;
        this.endpointsBuilt = false;
        this.endpointDescList = new ArrayList<WSClientEndpointDescriptor>();
        this.srInfo = srInfo;
    }

    public Iterator getEndpoints() {
        this.buildEndpoints();
        return this.endpointDescList.iterator();
    }

    public QName getQName() {
        return this.wsdlInfo.getServiceQName();
    }

    private void buildEndpoints() {
        if (!this.endpointsBuilt) {
            if (this.wsdlInfo.getService() != null) {
                if (this.wsdlInfo.getService().getPorts() != null) {
                    for (Port port : this.wsdlInfo.getService().getPorts().values()) {
                        DDClientEndpointDescriptorImpl endpoint = new DDClientEndpointDescriptorImpl(port);
                        this.endpointDescList.add(endpoint);
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.debug(_tc, "Built DDClientEndpointDescriptorImpl: " + port.getName());
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "No client endpoint descriptors can be built for the service-ref client service descriptor: " + this.getQName() + ". A " + "wsdl:port could not be found for the wsdl:service");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No client endpoint descriptors can be built for the service-ref client service descriptor: " + this.getQName() + ". A " + "WSDL definition could not be found");
            }
            this.endpointsBuilt = true;
        }
    }

    public WSClientType getClientType() {
        return this.type;
    }

    public boolean isServiceRef() {
        return true;
    }

    public ServiceRefInfo getServiceRefInfo() {
        return this.srInfo;
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

