/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.deployment.JAXWSEndpointDDInfo;
import com.ibm.ws.websvcs.deployment.PortComponentInfo;
import com.ibm.ws.websvcs.deployment.PortComponentInfoStore;
import com.ibm.ws.websvcs.deployment.WASWSDLReaderConfigurator;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.wsdl.JaxWSCatalogAccessor;
import com.ibm.ws.websvcs.wsdl.ModuleWSDLLocator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.description.builder.BindingTypeAnnot;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.HandlerChainAnnot;
import org.apache.axis2.jaxws.description.builder.MTOMAnnot;
import org.apache.axis2.jaxws.description.builder.PortComposite;
import org.apache.axis2.jaxws.description.builder.WebServiceAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceProviderAnnot;
import org.apache.axis2.jaxws.description.xml.handler.FullyQualifiedClassType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;
import org.apache.axis2.jaxws.description.xml.handler.ObjectFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.Handler;
import org.eclipse.jst.j2ee.webservice.wsdd.HandlerChain;
import org.eclipse.jst.j2ee.webservice.wsdd.HandlerChains;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSServerMetadataMerger {
    private static final TraceComponent _tc = Tr.register(WSServerMetadataMerger.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    Map<String, DescriptionBuilderComposite> dbcMap;
    private List<String> pcProcessedList;
    private static WASWSDLReaderConfigurator wsdlConfigurator = new WASWSDLReaderConfigurator();
    WebServices webServices;
    private static final String SOAP_11_TOKEN = "##SOAP11_HTTP";
    private static final String SOAP_12_TOKEN = "##SOAP12_HTTP";
    private static final String SOAP_11_MTOM_TOKEN = "##SOAP11_HTTP_MTOM";
    private static final String SOAP_12_MTOM_TOKEN = "##SOAP12_HTTP_MTOM";
    private static final String XML_HTTP_TOKEN = "#XML_HTTP";
    private static final String disableMerge = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("com.ibm.websphere.webservices.disableDeploymentDescriptorMerge");
        }
    });
    private LoadStrategy loadStrategy;
    private String moduleName;
    private boolean pcStoreInitialized;
    private PortComponentInfoStore pcInfoStore;
    private Set<QName> serviceQNames;
    private Map<DescriptionBuilderComposite, QName> dbcToSQName;
    private QName currentServiceQName;

    public WSServerMetadataMerger(Map<String, DescriptionBuilderComposite> dbcMap, WebServices webServices, LoadStrategy loadStrategy, String moduleName) {
        this.dbcMap = dbcMap;
        this.webServices = webServices;
        this.loadStrategy = loadStrategy;
        this.moduleName = moduleName;
        this.pcProcessedList = new ArrayList<String>();
        this.pcInfoStore = new PortComponentInfoStore();
        this.pcStoreInitialized = false;
        this.serviceQNames = new HashSet<QName>();
        this.dbcToSQName = new HashMap<DescriptionBuilderComposite, QName>();
    }

    List<JAXWSEndpointDDInfo> getDDInfo(DescriptionBuilderComposite dbc) throws Exception {
        int pcEntries;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Getting deployment descriptor information for class: " + dbc.getClassName());
        }
        List<JAXWSEndpointDDInfo> ddInfoList = null;
        PCNames pcNames = this.getPortComponentName(dbc);
        if (pcNames == null) {
            throw new Exception("A port component name could not be determined for the JAX-WS web service implementation class: " + dbc.getClassName());
        }
        ddInfoList = this.getJAXWSEndpointDDInfo(pcNames);
        int n = pcEntries = ddInfoList != null ? ddInfoList.size() : 0;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "The JAX-WS class " + dbc.getClassName() + " mapped to " + pcEntries + " port " + "component entries in the webservices.xml");
        }
        return ddInfoList;
    }

    List<JAXWSEndpointDDInfo> getJAXWSEndpointDDInfo(PCNames pcNames) {
        if (!this.pcStoreInitialized) {
            this.initPCStore();
        }
        List<JAXWSEndpointDDInfo> ddInfoList = null;
        List<PortComponentInfo> pcInfoList = null;
        String pcName = null;
        pcName = pcNames.getImplName();
        pcInfoList = this.pcInfoStore.getPCInfoByImplLink(pcName);
        if (pcInfoList == null) {
            pcName = pcNames.getPrimaryName();
            PortComponentInfo pcInfo = this.pcInfoStore.getPCInfoByPCName(pcName);
            if (pcInfo == null) {
                pcName = pcNames.getSecondaryName();
                pcInfo = this.pcInfoStore.getPCInfoByPCName(pcName);
            }
            if (pcInfo != null) {
                pcInfoList = new LinkedList<PortComponentInfo>();
                pcInfoList.add(pcInfo);
            }
        }
        if (pcInfoList != null && !pcInfoList.isEmpty()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found port component information in webservices.xml that corresponds to the: " + pcNames.getImplName() + " annotated JAX-WS web service implementation class.");
            }
            ddInfoList = this.constructJAXWSEndpointDDInfo(pcInfoList);
        }
        return ddInfoList;
    }

    void initPCStore() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initPCStore, module= " + this.moduleName);
        }
        for (WebServiceDescription wsd : this.webServices.getWebServiceDescriptions()) {
            for (PortComponent pc : wsd.getPortComponents()) {
                String implClassName = this.findImplClassName(pc);
                PortComponentInfo pcInfo = new PortComponentInfo(wsd, pc, implClassName);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding port component info based on port component name: " + pc.getPortComponentName());
                }
                this.pcInfoStore.addPCInfoByPCName(pc.getPortComponentName(), pcInfo);
                if (implClassName == null || "".equals(implClassName)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding port component info for port component: " + pc.getPortComponentName() + " based on implementation class: " + implClassName);
                }
                this.pcInfoStore.addPCInfoByImplLink(implClassName, pcInfo);
            }
        }
        this.pcStoreInitialized = true;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initPCStore, module= " + this.moduleName);
        }
    }

    String getLinkValue(PortComponent pc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getLinkValue, portComponent= " + pc.getPortComponentName());
        }
        String linkValue = null;
        if (pc.getServiceImplBean() != null && pc.getServiceImplBean().getEServletLink() != null) {
            linkValue = pc.getServiceImplBean().getEServletLink().getServletLink();
        } else if (pc.getServiceImplBean() != null && pc.getServiceImplBean().getEEJBLink() != null) {
            linkValue = pc.getServiceImplBean().getEEJBLink().getEjbLink();
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getLinkValue, portComponent= " + pc.getPortComponentName() + ", linkValue= " + linkValue);
        }
        return linkValue;
    }

    String findImplClassName(PortComponent pc) {
        String implClassName = null;
        if (this.loadStrategy.getContainer() != null && this.loadStrategy.getContainer() instanceof ModuleFile) {
            if (this.loadStrategy.getContainer() instanceof WARFile) {
                if (pc.getServiceImplBean() != null && pc.getServiceImplBean().getEServletLink() != null && pc.getServiceImplBean().getEServletLink().getServletLink() != null) {
                    String servletLink = pc.getServiceImplBean().getEServletLink().getServletLink();
                    WARFile warFile = (WARFile)this.loadStrategy.getContainer();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Looking for implementation class for the " + servletLink + " servlet in the " + warFile.getName() + " WAR module");
                    }
                    implClassName = this.getServletClassName(servletLink, warFile.getDeploymentDescriptor());
                }
            } else if (this.loadStrategy.getContainer() instanceof EJBJarFile) {
                if (pc.getServiceImplBean() != null && pc.getServiceImplBean().getEEJBLink() != null && pc.getServiceImplBean().getEEJBLink().getEjbLink() != null) {
                    String ejbLink = pc.getServiceImplBean().getEEJBLink().getEjbLink();
                    EJBJarFile ejbJarFile = (EJBJarFile)this.loadStrategy.getContainer();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Looking for implementation class for the " + ejbLink + " EJB in the " + ejbJarFile.getName() + " EJB module");
                    }
                    implClassName = this.getEJBClassName(ejbLink, ejbJarFile.getDeploymentDescriptor());
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Not looking for implementation class for the " + pc.getPortComponentName() + " port-component in the " + this.loadStrategy.getContainer().getName() + " module");
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "LoadStrategy did not have a container or the container was not a ModuleFile");
        }
        return implClassName;
    }

    String getServletClassName(String servletLink, WebApp webApp) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getServletClassName, servletLink= " + servletLink);
        }
        String servletClassName = null;
        if (webApp != null && webApp.getServletNamed(servletLink) != null) {
            Servlet servlet = webApp.getServletNamed(servletLink);
            String string = servletClassName = servlet.getServletClass() != null ? servlet.getServletClass().getQualifiedName() : null;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getServletClassName, servletLink= " + servletLink + ", servletClass= " + servletClassName);
        }
        return servletClassName;
    }

    String getEJBClassName(String ejbLink, EJBJar ejbJar) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getEJBClassName, ejbLink= " + ejbLink);
        }
        String ejbClassName = null;
        if (ejbJar != null && ejbJar.getEnterpriseBeanNamed(ejbLink) != null) {
            EnterpriseBean bean = ejbJar.getEnterpriseBeanNamed(ejbLink);
            ejbClassName = bean.getEjbClassName();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getEJBClassName, ejbLink= " + ejbLink + ", ejbClassName= " + ejbClassName);
        }
        return ejbClassName;
    }

    List<JAXWSEndpointDDInfo> constructJAXWSEndpointDDInfo(List<PortComponentInfo> pcInfoList) {
        LinkedList<JAXWSEndpointDDInfo> ddInfoList = new LinkedList<JAXWSEndpointDDInfo>();
        for (PortComponentInfo pcInfo : pcInfoList) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Processing JAX-WS port component: " + pcInfo.getPortComponent().getPortComponentName());
            }
            this.pcProcessedList.add(pcInfo.getPortComponent().getPortComponentName());
            JAXWSEndpointDDInfo ddInfo = this.constructJAXWSEndpointDDInfo(pcInfo.getWebServiceDescription(), pcInfo.getPortComponent());
            ddInfoList.add(ddInfo);
        }
        return ddInfoList;
    }

    JAXWSEndpointDDInfo constructJAXWSEndpointDDInfo(WebServiceDescription wsd, PortComponent pc) {
        ServiceImplBean bean;
        HandlerChains handlerChains;
        String protocolBinding;
        JAXWSEndpointDDInfo ddInfo = new JAXWSEndpointDDInfo();
        ddInfo.setPortComponentName(pc.getPortComponentName());
        ddInfo.setServiceEndpointInterface(pc.getServiceEndpointInterface());
        ddInfo.setWebServiceWsdlLoc(wsd.getWsdlFile());
        if (pc.getWsdlPort() != null) {
            ddInfo.setPortQName(new QName(pc.getWsdlPort().getNamespaceURI(), pc.getWsdlPort().getLocalPart()));
        }
        if (pc.getWsdlService() != null) {
            ddInfo.setServiceQName(new QName(pc.getWsdlService().getNamespaceURI(), pc.getWsdlService().getLocalPart()));
        }
        if ((protocolBinding = pc.getProtocolBinding()) != null) {
            protocolBinding = this.getProtocolBinding(protocolBinding);
            ddInfo.setProtocolBinding(protocolBinding);
        }
        if (pc.isSetEnableMtom()) {
            ddInfo.setEnableMTOM(pc.isEnableMtom());
        }
        if ((handlerChains = pc.getHandlerChains()) != null) {
            ddInfo.setHandlerChains(handlerChains);
        }
        if ((bean = pc.getServiceImplBean()) != null) {
            if (bean.getEServletLink() != null) {
                ddInfo.setServletLink(bean.getEServletLink().getServletLink());
            }
            if (bean.getEEJBLink() != null) {
                ddInfo.setEjbLink(bean.getEEJBLink().getEjbLink());
            }
        }
        return ddInfo;
    }

    String getProtocolBinding(String protocolBinding) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getProtocolBinding, value= " + protocolBinding);
        }
        if (protocolBinding.equals(SOAP_11_TOKEN)) {
            protocolBinding = "http://schemas.xmlsoap.org/wsdl/soap/http";
        } else if (protocolBinding.equals(SOAP_11_MTOM_TOKEN)) {
            protocolBinding = "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true";
        } else if (protocolBinding.equals(SOAP_12_TOKEN)) {
            protocolBinding = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        } else if (protocolBinding.equals(SOAP_12_MTOM_TOKEN)) {
            protocolBinding = "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true";
        } else if (protocolBinding.equals(XML_HTTP_TOKEN)) {
            protocolBinding = "http://www.w3.org/2004/08/wsdl/http";
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getProtocolBinding, value= " + protocolBinding);
        }
        return protocolBinding;
    }

    PCNames getPortComponentName(DescriptionBuilderComposite dbc) {
        String preferredName = dbc.getClassName();
        String secondaryName = null;
        PCNames pcNames = null;
        if (dbc.getWebServiceAnnot() != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Looking for port component name for @WebService annotated class: " + dbc.getClassName());
            }
            secondaryName = dbc.getWebServiceAnnot().name();
            DescriptionBuilderComposite seiDBC = null;
            if (secondaryName == null || "".equals(secondaryName)) {
                String seiName = dbc.getWebServiceAnnot().endpointInterface();
                if (seiName.indexOf("/") != -1) {
                    seiName = seiName.replace("/", ".");
                }
                if ((seiDBC = this.dbcMap.get(seiName)) != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Checking for @WebService.name attribute in SEI: " + seiDBC.getClassName());
                    }
                    if (seiDBC.getWebServiceAnnot() != null) {
                        secondaryName = seiDBC.getWebServiceAnnot().name();
                    }
                }
            }
            if (secondaryName == null || "".equals(secondaryName)) {
                secondaryName = seiDBC != null ? seiDBC.getClassName().substring(dbc.getClassName().lastIndexOf(".") + 1) : dbc.getClassName().substring(dbc.getClassName().lastIndexOf(".") + 1);
            }
        }
        pcNames = new PCNames(preferredName, secondaryName, dbc.getClassName());
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "The JAX-WS implementation class: " + dbc.getClassName() + " will be " + "associated with the " + pcNames + " in the webservices.xml if present.");
        }
        return pcNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, DescriptionBuilderComposite> mergeMetadata() throws Exception {
        block15: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "mergeMetadata, moduleName= " + this.moduleName);
            }
            if (this.webServices == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The " + this.moduleName + " did not contain a webservices.xml. No " + "metadata needs to be merged for this module");
                }
                this.associateWSDLDefinitions(this.dbcMap.values().iterator());
                return this.dbcMap;
            }
            if (Boolean.valueOf(disableMerge).equals(true)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Merging of the webservices.xml with annotation metadata has been disabled via the com.ibm.websphere.webservices.disableDeploymentDescriptorMerge system property.");
                }
                this.associateWSDLDefinitions(this.dbcMap.values().iterator());
                return this.dbcMap;
            }
            try {
                for (DescriptionBuilderComposite dbc : this.dbcMap.values()) {
                    List<JAXWSEndpointDDInfo> ddInfoList;
                    this.serviceQNames = new HashSet<QName>();
                    if (dbc.isInterface() || dbc.getWebServiceAnnot() == null && dbc.getWebServiceProviderAnnot() == null) continue;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Looking for port-component for JAX-WS class: " + dbc.getClassName());
                    }
                    if ((ddInfoList = this.getDDInfo(dbc)) != null && !ddInfoList.isEmpty()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "For JAX-WS web service implementation class: " + dbc.getClassName() + " deployment descriptor metadata was found." + " This information will be used to augment or override " + "annotation metadata.");
                        }
                        int pcIndex = 0;
                        for (JAXWSEndpointDDInfo ddInfo : ddInfoList) {
                            PortComposite portComposite = new PortComposite(dbc);
                            this.setupComposite(portComposite, dbc);
                            this.merge(portComposite, dbc, ddInfo, pcIndex);
                            this.setDBCProperties(portComposite, ddInfo);
                            this.configureBaseDBC(dbc, portComposite);
                            this.currentServiceQName = null;
                            ++pcIndex;
                        }
                        continue;
                    }
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "For JAX-WS web service implementation class: " + dbc.getClassName() + " no deployment descriptor metadata was found.");
                }
                this.validate();
                Object var9_9 = null;
                if (!_tc.isEntryEnabled()) break block15;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "mergeMetadata");
                }
                throw throwable;
            }
            Tr.exit(_tc, "mergeMetadata");
        }
        this.associateWSDLDefinitions(this.dbcMap.values().iterator());
        return this.dbcMap;
    }

    void setupComposite(PortComposite portComposite, DescriptionBuilderComposite baseDBC) {
        if (baseDBC.getWebServiceAnnot() != null) {
            portComposite.setWebServiceAnnot(WebServiceAnnot.createFromAnnotation((Annotation)((Object)baseDBC.getWebServiceAnnot())));
        }
        if (baseDBC.getWebServiceProviderAnnot() != null) {
            portComposite.setWebServiceProviderAnnot(WebServiceProviderAnnot.createFromAnnotation((Annotation)((Object)baseDBC.getWebServiceProviderAnnot())));
        }
        if (baseDBC.getHandlerChainAnnot() != null) {
            portComposite.setHandlerChainAnnot(HandlerChainAnnot.createFromAnnotation((Annotation)((Object)baseDBC.getHandlerChainAnnot())));
        }
        if (baseDBC.getBindingTypeAnnot() != null) {
            portComposite.setBindingTypeAnnot(BindingTypeAnnot.createFromAnnotation((Annotation)((Object)baseDBC.getBindingTypeAnnot())));
        }
        portComposite.setProperties(new HashMap<String, Object>());
        portComposite.getProperties().put("reduceWSDLMemoryCache", true);
    }

    void merge(DescriptionBuilderComposite dbc, DescriptionBuilderComposite parentDBC, JAXWSEndpointDDInfo ddInfo, int pcIndex) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "merge= " + dbc.getClassName());
        }
        this.mergeWSServiceQName(ddInfo.getServiceQName(), dbc, pcIndex);
        this.mergeWSPortQName(ddInfo.getPortQName(), dbc, pcIndex);
        this.mergeWSWsdlLocation(ddInfo.getWebServiceWsdlLoc(), dbc, parentDBC, ddInfo, pcIndex);
        this.mergeProtocolBinding(ddInfo.getProtocolBinding(), dbc);
        this.mergeEnableMTOM(ddInfo.isEnableMTOM(), dbc);
        this.mergeSEI(ddInfo.getServiceEndpointInterface(), dbc, pcIndex);
        this.mergeHandlerChain(ddInfo.getHandlerChains(), dbc, parentDBC);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "merge= " + dbc.getClassName());
        }
    }

    void mergeProtocolBinding(String protocolBinding, DescriptionBuilderComposite dbc) {
        BindingTypeAnnot btAnnot = dbc.getBindingTypeAnnot();
        if (btAnnot == null) {
            btAnnot = BindingTypeAnnot.createBindingTypeAnnotImpl();
        }
        if (protocolBinding != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "For JAX-WS implementation: " + dbc.getClassName() + " setting " + "protocol-binding to: " + protocolBinding);
            }
            btAnnot.setValue(protocolBinding);
        } else if (protocolBinding == null && (btAnnot.value() == null || "".equals(btAnnot.value()))) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "For JAX-WS implementation: " + dbc.getClassName() + " setting protocol-binding to default: " + "http://schemas.xmlsoap.org/wsdl/soap/http");
            }
            btAnnot.setValue("http://schemas.xmlsoap.org/wsdl/soap/http");
        }
        dbc.setBindingTypeAnnot(btAnnot);
    }

    void mergeEnableMTOM(Boolean enableMTOM, DescriptionBuilderComposite dbc) {
        if (enableMTOM == null) {
            return;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "For JAX-WS implementation: " + dbc.getClassName() + " setting " + "enable-mtom to: " + String.valueOf(enableMTOM));
        }
        MTOMAnnot mtomAnnot = new MTOMAnnot();
        if (enableMTOM.booleanValue()) {
            mtomAnnot.setEnabled(true);
        } else {
            mtomAnnot.setEnabled(false);
        }
        dbc.addWebServiceFeature((Annotation)((Object)mtomAnnot));
    }

    void mergeWSServiceQName(QName serviceQName, DescriptionBuilderComposite dbc, int pcIndex) {
        if (serviceQName != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The qualified service name: " + serviceQName + " was specified in the " + "webservices.xml for the JAX-WS implementation: " + dbc.getClassName());
            }
            this.serviceQNames.add(serviceQName);
            this.currentServiceQName = serviceQName;
            this.dbcToSQName.put(dbc, serviceQName);
            if (dbc.getWebServiceAnnot() != null) {
                WebServiceAnnot wsAnnot = dbc.getWebServiceAnnot();
                if (serviceQName.getLocalPart() != null) {
                    wsAnnot.setServiceName(serviceQName.getLocalPart());
                }
                if (serviceQName.getNamespaceURI() != null) {
                    wsAnnot.setTargetNamespace(serviceQName.getNamespaceURI());
                }
            } else if (dbc.getWebServiceProviderAnnot() != null) {
                WebServiceProviderAnnot wspAnnot = dbc.getWebServiceProviderAnnot();
                if (serviceQName.getLocalPart() != null) {
                    wspAnnot.setServiceName(serviceQName.getLocalPart());
                }
                if (serviceQName.getNamespaceURI() != null) {
                    wspAnnot.setTargetNamespace(serviceQName.getNamespaceURI());
                }
            }
        }
    }

    void mergeWSPortQName(QName portQName, DescriptionBuilderComposite dbc, int pcIndex) throws DeploymentException {
        if (portQName != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The qualified port name: " + portQName + " was specified in the " + "webservices.xml for the JAX-WS implementation: " + dbc.getClassName());
            }
            if (dbc.getWebServiceAnnot() != null) {
                WebServiceAnnot wsAnnot = dbc.getWebServiceAnnot();
                if (portQName.getLocalPart() != null) {
                    wsAnnot.setPortName(portQName.getLocalPart());
                }
                if (portQName.getNamespaceURI() != null) {
                    if (!this.checkPortNamespace(portQName.getNamespaceURI(), wsAnnot.targetNamespace())) {
                        String msg = NLSProvider.getNLS().getFormattedMessage("badPortNSURI", new Object[]{portQName.getNamespaceURI(), wsAnnot.targetNamespace(), dbc.getClassName()}, "The {0} namespace URI was specififed for the {1} port, but this does not correspond to the {2} target namespace URI for the {3} JAX-WS Web service implementation class.");
                        throw new DeploymentException(msg);
                    }
                    wsAnnot.setTargetNamespace(portQName.getNamespaceURI());
                }
            } else if (dbc.getWebServiceProviderAnnot() != null) {
                WebServiceProviderAnnot wspAnnot = dbc.getWebServiceProviderAnnot();
                if (portQName.getLocalPart() != null) {
                    wspAnnot.setPortName(portQName.getLocalPart());
                }
                if (portQName.getNamespaceURI() != null) {
                    if (!this.checkPortNamespace(portQName.getNamespaceURI(), wspAnnot.targetNamespace())) {
                        String msg = NLSProvider.getNLS().getFormattedMessage("badPortNSURI", new Object[]{portQName.getNamespaceURI(), wspAnnot.targetNamespace(), dbc.getClassName()}, "The {0} port namespace URI did not correspond to the {1} target namespace URI for the {2} JAX-WS Web service implementation class.");
                        throw new DeploymentException(msg);
                    }
                    wspAnnot.setTargetNamespace(portQName.getNamespaceURI());
                }
            }
        }
    }

    boolean checkPortNamespace(String portNSURI, String tnsURI) {
        boolean match = true;
        if (tnsURI != null && !"".equals(tnsURI) && !tnsURI.equals(portNSURI)) {
            match = false;
        }
        return match;
    }

    /*
     * Enabled aggressive block sorting
     */
    void mergeWSWsdlLocation(String wsdlLocation, DescriptionBuilderComposite dbc, DescriptionBuilderComposite parentDBC, JAXWSEndpointDDInfo ddInfo, int pcIndex) throws DeploymentException {
        block13: {
            block14: {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "mergeWSWsdlLocation, wsdlLocation= " + wsdlLocation);
                }
                if (wsdlLocation == null) break block13;
                if (dbc.getWebServiceAnnot() == null) break block14;
                WebServiceAnnot wsAnnot = dbc.getWebServiceAnnot();
                String seiName = null;
                if (wsAnnot.endpointInterface() != null && !"".equals(wsAnnot.endpointInterface())) {
                    seiName = wsAnnot.endpointInterface();
                } else if (ddInfo.getServiceEndpointInterface() != null && !"".equals(ddInfo.getServiceEndpointInterface())) {
                    seiName = ddInfo.getServiceEndpointInterface();
                }
                if (seiName != null && !"".equals(seiName)) {
                    WebServiceAnnot seiWSAnnot;
                    DescriptionBuilderComposite seiDBC;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Looking for SEI: " + seiName + " for implementation: " + dbc.getClassName());
                    }
                    if ((seiDBC = this.dbcMap.get(seiName)) == null) {
                        String msg = NLSProvider.getNLS().getFormattedMessage("seiClassMissing", new Object[]{dbc.getClassName(), dbc.getWebServiceAnnot().endpointInterface()}, "The {0} JAX-WS Web service implementation class referred to the {1} Service Endpoint Interface (SEI) class, but the SEI class could not be found.");
                        throw new DeploymentException(msg);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found wsdl location in webservices.xml for JAX-WS web service implementation: " + dbc.getClassName() + ". The wsdl " + "location: " + wsdlLocation + " will be set as the wsdl location on " + "the SEI: " + seiDBC.getClassName());
                    }
                    if ((seiWSAnnot = seiDBC.getWebServiceAnnot()) == null) {
                        String msg = NLSProvider.getNLS().getFormattedMessage("seiWSAnnotMissing", new Object[]{dbc.getClassName(), seiDBC.getClassName()}, "The {0} JAX-WS The {0} JAX-WS Web service implementation class referred to the {1} Service Endpoint Interface (SEI) class, but the SEI class did not have an @WebService annotation.");
                        throw new DeploymentException(msg);
                    }
                    WebServiceAnnot cSeiWSAnnot = seiDBC.getWebServiceAnnot();
                    cSeiWSAnnot.setWsdlLocation(wsdlLocation);
                    wsAnnot.setWsdlLocation(null);
                    if (parentDBC != null && parentDBC.getWebServiceAnnot() != null) {
                        parentDBC.getWebServiceAnnot().setWsdlLocation(null);
                    }
                    break block13;
                } else {
                    wsAnnot.setWsdlLocation(wsdlLocation);
                }
                break block13;
            }
            if (dbc.getWebServiceProviderAnnot() != null) {
                WebServiceProviderAnnot wspAnnot = dbc.getWebServiceProviderAnnot();
                wspAnnot.setWsdlLocation(wsdlLocation);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "mergeWSWsdlLocation, wsdlLocation= " + wsdlLocation);
        }
    }

    void mergeSEI(String seiName, DescriptionBuilderComposite dbc, int pcIndex) throws DeploymentException {
        if (seiName != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting the service-endpoint-interface value: " + seiName + " on " + "JAX-WS implementation class: " + dbc.getClassName());
            }
            if (dbc.getWebServiceAnnot() != null) {
                WebServiceAnnot wsAnnot = dbc.getWebServiceAnnot();
                if (wsAnnot.endpointInterface() != null && !"".equals(wsAnnot.endpointInterface())) {
                    if (!wsAnnot.endpointInterface().equals(seiName) && _tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The SEI class: " + seiName + " specified in the " + "webservices.xml did not correspond with the SEI class: " + wsAnnot.endpointInterface() + " specified " + "on the @WebService annotation in the class: " + dbc.getClassName() + ". The value in the webservices.xml will " + "be ignored.");
                    }
                } else {
                    if (this.dbcMap.get(seiName) == null || this.dbcMap.get(seiName).getWebServiceAnnot() == null) {
                        String msg = NLSProvider.getNLS().getFormattedMessage("seiWSAnnotMissing01", new Object[]{seiName, dbc.getClassName()}, "The {0} service-endpoint-interface was defined in the webservices.xml for the {1} JAX-WS implementation class, but an @WebService annotation was not found on the service-endpoint-interface.");
                        Tr.error(_tc, msg);
                        throw new DeploymentException(msg);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting SEI: " + seiName + " for web service implementation: " + dbc.getClassName());
                    }
                    wsAnnot.setEndpointInterface(seiName);
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The service-endpoint-interface: " + seiName + " was defined " + "for the javax.xml.ws.Provider implementation: " + dbc.getClassName() + ". This value will be ignored.");
            }
        }
    }

    void mergeHandlerChain(HandlerChains handlerChains, DescriptionBuilderComposite dbc, DescriptionBuilderComposite parentDBC) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "mergeHandlerChain");
        }
        if (handlerChains != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Attaching handler chain configuration for JAX-WS implementation: " + dbc.getClassName() + " from the webservices.xml");
            }
            HandlerChainsType hcsType = this.createHandlerChainsType(handlerChains);
            dbc.setHandlerChainsType(hcsType);
            if (dbc.getHandlerChainAnnot() != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found existing handler chain annotation. Handler Chain types overrideannotation.  Annotation being removed : " + dbc.getHandlerChainAnnot().toString());
                }
                dbc.setHandlerChainAnnot(null);
            }
            if (parentDBC != null && parentDBC.getHandlerChainAnnot() != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found existing handler chain annotation on parentDBC. Handler Chain types overrideannotation.  Annotation being removed : " + parentDBC.getHandlerChainAnnot().toString());
                }
                parentDBC.setHandlerChainAnnot(null);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "mergeHandlerChain");
        }
    }

    HandlerChainsType createHandlerChainsType(HandlerChains handlerChains) {
        ObjectFactory factory = new ObjectFactory();
        HandlerChainsType hcsType = factory.createHandlerChainsType();
        List<HandlerChainType> hcTypeList = hcsType.getHandlerChain();
        EList hcList = handlerChains.getHandlerChains();
        if (hcList != null && !hcList.isEmpty()) {
            for (HandlerChain hChain : hcList) {
                HandlerChainType hcType = this.populateHandlerChainType(factory, hChain);
                EList hList = hChain.getHandlers();
                if (hList != null && hList.size() > 0) {
                    Iterator hListIter = hList.iterator();
                    List<HandlerType> handlerTypeList = hcType.getHandler();
                    while (hListIter.hasNext()) {
                        Handler handler = (Handler)hListIter.next();
                        HandlerType handlerType = this.populateHandlerType(factory, handler);
                        handlerTypeList.add(handlerType);
                    }
                }
                hcTypeList.add(hcType);
            }
        }
        return hcsType;
    }

    HandlerChainType populateHandlerChainType(ObjectFactory factory, HandlerChain hChain) {
        HandlerChainType hcType = factory.createHandlerChainType();
        if (hChain.getPortNamePattern() != null) {
            QName portNamePattern = new QName(hChain.getPortNamePattern().getNamespaceURI(), hChain.getPortNamePattern().getLocalPart());
            hcType.setPortNamePattern(portNamePattern);
        }
        if (hChain.getServiceNamePattern() != null) {
            QName serviceNamePattern = new QName(hChain.getServiceNamePattern().getNamespaceURI(), hChain.getServiceNamePattern().getLocalPart());
            hcType.setServiceNamePattern(serviceNamePattern);
        }
        if (hChain.getProtocolBindings() != null && hChain.getProtocolBindings().size() > 0) {
            List<String> protocolBindingList = hcType.getProtocolBindings();
            EList pbList = hChain.getProtocolBindings();
            for (String pb : pbList) {
                protocolBindingList.add(pb);
            }
        }
        return hcType;
    }

    HandlerType populateHandlerType(ObjectFactory factory, Handler handler) {
        HandlerType handlerType = factory.createHandlerType();
        FullyQualifiedClassType handlerClass = factory.createFullyQualifiedClassType();
        handlerClass.setValue(handler.getHandlerClass().getQualifiedName());
        org.apache.axis2.jaxws.description.xml.handler.String hName = factory.createString();
        hName.setValue(handler.getHandlerName());
        handlerType.setHandlerClass(handlerClass);
        handlerType.setHandlerName(hName);
        EList soapRoleList = handler.getSoapRoles();
        if (soapRoleList != null && !soapRoleList.isEmpty()) {
            List<org.apache.axis2.jaxws.description.xml.handler.String> soapRoles = handlerType.getSoapRole();
            for (String role : soapRoleList) {
                org.apache.axis2.jaxws.description.xml.handler.String jaxbRole = new org.apache.axis2.jaxws.description.xml.handler.String();
                jaxbRole.setValue(role);
                soapRoles.add(jaxbRole);
            }
        }
        return handlerType;
    }

    DescriptionBuilderComposite getSEI(WebServiceAnnot wsAnnot, JAXWSEndpointDDInfo ddInfo) {
        DescriptionBuilderComposite seiDBC = null;
        String seiName = wsAnnot.endpointInterface();
        if (seiName == null || "".equals(seiName)) {
            seiName = ddInfo.getServiceEndpointInterface();
        }
        if (seiName != null) {
            seiDBC = this.dbcMap.get(seiName);
        }
        return seiDBC;
    }

    void validate() throws DeploymentException {
        Iterator wsdIter = this.webServices.getWebServiceDescriptions().iterator();
        while (wsdIter.hasNext()) {
            boolean jaxwspcFound = false;
            WebServiceDescription wsd = (WebServiceDescription)wsdIter.next();
            Iterator pcIter = wsd.getPortComponents().iterator();
            int pcSize = wsd.getPortComponents().size();
            int pcCount = 0;
            while (pcIter.hasNext()) {
                String msg;
                PortComponent pc = (PortComponent)pcIter.next();
                if (this.pcProcessedList.contains(pc.getPortComponentName())) {
                    jaxwspcFound = true;
                    ++pcCount;
                    continue;
                }
                if (jaxwspcFound) {
                    msg = NLSProvider.getNLS().getFormattedMessage("mixedPortComponent00", new Object[]{pc.getPortComponentName(), wsd.getWebServiceDescriptionName()}, "The {0} port-component element was identified as a JAX-RPC port component but was found in the {1} webservice-description element, which also contains JAX-WS port components. Mixing JAX-RPC and JAX-WS port components within the same webservice-description element is not allowed.");
                    throw new DeploymentException(msg);
                }
                if (pc.getServiceEndpointInterface() == null || "".equals(pc.getServiceEndpointInterface())) {
                    msg = NLSProvider.getNLS().getFormattedMessage("badJAXRPCPC00", new Object[]{pc.getPortComponentName(), wsd.getWebServiceDescriptionName()}, "The {0} port-component in the {1} webservice-description was identified as a JAX-RPC port component, but it did not contain a value in the service-endpoint-interface element.");
                    throw new DeploymentException(msg);
                }
                DescriptionBuilderComposite dbc = this.dbcMap.get(pc.getServiceEndpointInterface());
                if (dbc == null || dbc.getWebServiceAnnot() == null) continue;
                String msg2 = NLSProvider.getNLS().getFormattedMessage("badJAXRPCPC01", new Object[]{pc.getPortComponentName(), wsd.getWebServiceDescriptionName(), pc.getServiceEndpointInterface()}, "The {0} port-component in the {1} webservice-description was identified as a JAX-RPC port component, but the {2} SEI class specified by the service-endpoint-interface element contained the @WebService annotation.");
                throw new DeploymentException(msg2);
            }
        }
    }

    private void associateWSDLDefinitions(Iterator<DescriptionBuilderComposite> dbcIter) throws DeploymentException, IOException {
        HashMap<String, WSDLInfo> wsdlInfoMap = new HashMap<String, WSDLInfo>();
        JaxWSCatalogAccessor catalogAccessor = null;
        while (dbcIter.hasNext()) {
            LinkedList<DescriptionBuilderComposite> dbcList = new LinkedList<DescriptionBuilderComposite>();
            DescriptionBuilderComposite parentDBC = null;
            DescriptionBuilderComposite tmpDBC = dbcIter.next();
            Set<QName> sQNames = tmpDBC.getServiceQNames();
            if (sQNames != null && !sQNames.isEmpty()) {
                for (QName sQName : sQNames) {
                    List<PortComposite> pcList = tmpDBC.getPortComposites(sQName);
                    dbcList.addAll(pcList);
                }
                parentDBC = tmpDBC;
            } else if (tmpDBC.getPortComposites() == null || tmpDBC.getPortComposites().isEmpty()) {
                dbcList.add(tmpDBC);
            } else {
                parentDBC = tmpDBC;
                for (PortComposite pDBC : tmpDBC.getPortComposites()) {
                    dbcList.add(pDBC);
                }
            }
            for (DescriptionBuilderComposite dbc : dbcList) {
                if (catalogAccessor == null) {
                    ClassLoader cl = null;
                    cl = this.loadStrategy.getContainer() instanceof ModuleFile ? ((ModuleFile)this.loadStrategy.getContainer()).getArchiveClassLoader() : dbc.getClassLoader();
                    catalogAccessor = new JaxWSCatalogAccessor(cl);
                }
                String wsdlLocation = null;
                if (dbc.getWebServiceAnnot() != null) {
                    wsdlLocation = dbc.getWebServiceAnnot().wsdlLocation();
                } else if (dbc.getWebServiceProviderAnnot() != null) {
                    wsdlLocation = dbc.getWebServiceProviderAnnot().wsdlLocation();
                }
                if (wsdlLocation == null || "".equals(wsdlLocation)) continue;
                if (Axis2Utils.isAbsolutePath(wsdlLocation)) {
                    Object[] inserts = new Object[]{dbc.getClassName(), wsdlLocation};
                    String msg = NLSProvider.getNLS().getFormattedMessage("badWsdlLocation00", inserts, "The Web service implementation class {0} refers to the absolute WSDL location {1} via annotations. Absolute WSDL references are not allowed in @WebService or @WebServiceProvider annotations according to JAX-WS.");
                    throw new DeploymentException(msg);
                }
                wsdlLocation = catalogAccessor.resolveLocation(wsdlLocation);
                if (dbc.getWebServiceAnnot() != null) {
                    dbc.getWebServiceAnnot().setWsdlLocation(wsdlLocation);
                } else if (dbc.getWebServiceProviderAnnot() != null) {
                    dbc.getWebServiceProviderAnnot().setWsdlLocation(wsdlLocation);
                }
                if (wsdlInfoMap.get(wsdlLocation) == null) {
                    this.attachWSDLDefinition(wsdlLocation, dbc, parentDBC, wsdlInfoMap, catalogAccessor);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Read in WSDL document: " + wsdlLocation + " for web service " + " class: " + dbc.getClassName() + " in module: " + this.moduleName);
                    continue;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Already read in WSDL document: " + wsdlLocation + " for web service " + " class: " + dbc.getClassName() + " in module: " + this.moduleName);
                }
                WSDLInfo info = (WSDLInfo)wsdlInfoMap.get(wsdlLocation);
                this.setWSDLInfoOnDBC(parentDBC, dbc, info);
                dbc.getProperties().put("com.ibm.ws.websvcs.RESOLVED_IMPORT_LOCATIONS", info.getResolvedImports());
            }
        }
    }

    private void attachWSDLDefinition(String wsdlLocation, DescriptionBuilderComposite composite, DescriptionBuilderComposite parentComposite, Map<String, WSDLInfo> wsdlDefMap, JaxWSCatalogAccessor catalogAccessor) throws DeploymentException {
        block16: {
            ClassLoader classLoader = composite.getClassLoader();
            try {
                WSDLInfo info;
                block18: {
                    URL url = null;
                    WSDLFactory factory = WSDLFactory.newInstance();
                    WSDLReader reader = factory.newWSDLReader();
                    wsdlConfigurator.configureReaderInstance(reader);
                    reader.setFeature("com.ibm.wsdl.useWSDLLocatorAsEntityResolver", true);
                    if (Axis2Utils.isAbsolutePath(wsdlLocation)) {
                        WSDLInfo info2;
                        block17: {
                            ModuleWSDLLocator wsdlLoc;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "The wsdlLocation: " + wsdlLocation + " is an absolute path");
                            }
                            try {
                                url = new URL(wsdlLocation);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (url == null) {
                                url = classLoader.getResource(wsdlLocation);
                            }
                            if (url == null) {
                                wsdlLoc = new ModuleWSDLLocator(wsdlLocation, null, this.loadStrategy, catalogAccessor);
                                url = wsdlLoc.getWsdlUrl(wsdlLocation);
                            }
                            if (url == null) break block16;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "The wsdlLocation: " + wsdlLocation + " has the following URL: " + url);
                            }
                            wsdlLoc = new ModuleWSDLLocator(wsdlLocation, url.openStream(), this.loadStrategy, catalogAccessor);
                            Definition def = reader.readWSDL(wsdlLoc);
                            composite.getProperties().put("com.ibm.ws.websvcs.RESOLVED_IMPORT_LOCATIONS", wsdlLoc.getResolvedImportLocations());
                            info2 = new WSDLInfo(def, url, wsdlLoc.getResolvedImportLocations());
                            wsdlDefMap.put(wsdlLocation, info2);
                            if (url != null) {
                                try {
                                    def.setDocumentBaseURI(url.toURI().toString());
                                }
                                catch (Exception ex) {
                                    if (!_tc.isDebugEnabled()) break block17;
                                    Tr.debug(_tc, "Could not set document base URI on WSDL definition");
                                }
                            }
                        }
                        this.setWSDLInfoOnDBC(parentComposite, composite, info2);
                        break block16;
                    }
                    InputStream is = null;
                    if (classLoader != null) {
                        url = classLoader.getResource(wsdlLocation);
                    }
                    if ((is = url != null ? url.openStream() : this.loadStrategy.getResourceInputStream(wsdlLocation)) == null) break block16;
                    ModuleWSDLLocator wsdlLoc = new ModuleWSDLLocator(wsdlLocation, is, this.loadStrategy, catalogAccessor);
                    reader.setFeature("javax.wsdl.verbose", false);
                    Definition definition = reader.readWSDL(wsdlLoc);
                    composite.getProperties().put("com.ibm.ws.websvcs.RESOLVED_IMPORT_LOCATIONS", wsdlLoc.getResolvedImportLocations());
                    info = new WSDLInfo(definition, url, wsdlLoc.getResolvedImportLocations());
                    wsdlDefMap.put(wsdlLocation, info);
                    if (url != null) {
                        try {
                            definition.setDocumentBaseURI(url.toURI().toString());
                        }
                        catch (Exception ex) {
                            if (!_tc.isDebugEnabled()) break block18;
                            Tr.debug(_tc, "Could not set document base URI on WSDL definition");
                        }
                    }
                }
                this.setWSDLInfoOnDBC(parentComposite, composite, info);
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.websvcs.deployment.WSServerMetadataMerger.attachWSDLDefinition", "1069", this);
                Object[] inserts = new Object[]{wsdlLocation, composite.getClassName().replace('/', '.'), t};
                String msg = NLSProvider.getNLS().getFormattedMessage("loadWsdlFail02", inserts, "Error occurred attempting to load the WSDL file {0} specified by annotations in the class {1}: {2}");
                Tr.error(_tc, msg);
                throw new DeploymentException(t);
            }
        }
    }

    void setWSDLInfoOnDBC(DescriptionBuilderComposite parentDBC, DescriptionBuilderComposite dbc, WSDLInfo info) {
        if (parentDBC == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Storing WSDL on DescriptionBuilderComposite: " + info.getURL());
            }
            dbc.setWsdlDefinition(info.getDefinition());
            dbc.setwsdlURL(info.getURL());
        } else {
            QName sQName = this.dbcToSQName.get(dbc);
            if (sQName != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "For service QName: " + sQName + " storing WSDL on parent " + "DescriptionBuilderComposite: " + info.getURL());
                }
                parentDBC.setWsdlDefinition(sQName, info.getDefinition());
                parentDBC.setwsdlURL(sQName, info.getURL());
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Storing WSDL on parent DescriptionBuilderComposite: " + info.getURL());
                }
                parentDBC.setWsdlDefinition(info.getDefinition());
                parentDBC.setwsdlURL(info.getURL());
            }
        }
    }

    protected void setDBCProperties(DescriptionBuilderComposite dbc, JAXWSEndpointDDInfo ddInfo) {
        Map<String, Object> props = dbc.getProperties();
        props.put("com.ibm.ws.websvcs.SERVLET_LINK_VALUE", ddInfo.getServletLink());
        props.put("com.ibm.ws.websvcs.EJB_LINK_VALUE", ddInfo.getEjbLink());
        props.put("WSDL_PORTTYPE_NAME", ddInfo.getPortComponentName());
    }

    protected void configureBaseDBC(DescriptionBuilderComposite dbc, PortComposite portComposite) {
        dbc.setServiceQNames(this.serviceQNames);
        if (this.currentServiceQName != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Adding PortComposite for implementation class" + dbc.getClassName() + " by service QName: " + this.currentServiceQName);
            }
            dbc.addPortComposite(this.currentServiceQName, portComposite);
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Adding PortComposite for implementation class: " + dbc.getClassName());
            }
            dbc.addPortComposite(portComposite);
        }
    }

    class PCNames {
        String primaryName;
        String secondaryName;
        String implName;

        PCNames(String primaryName, String secondaryName, String implName) {
            this.primaryName = primaryName;
            this.secondaryName = secondaryName;
            this.implName = implName;
        }

        public String getPrimaryName() {
            return this.primaryName;
        }

        public String getSecondaryName() {
            return this.secondaryName;
        }

        public String getImplName() {
            return this.implName;
        }

        public String toString() {
            return "primaryName= " + this.primaryName + ", secondaryName= " + this.secondaryName + ", implName= " + this.implName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WSDLInfo {
        Definition definition;
        URL url;
        List<String> resolvedImports;

        WSDLInfo(Definition definition, URL url, List<String> resolvedImports) {
            this.definition = definition;
            this.url = url;
            this.resolvedImports = resolvedImports;
        }

        public Definition getDefinition() {
            return this.definition;
        }

        public URL getURL() {
            return this.url;
        }

        public List<String> getResolvedImports() {
            return this.resolvedImports;
        }
    }
}

