/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.utils.ServiceRefPartialInfo;
import com.ibm.ws.webservices.utils.ServiceRefPartialInfoBuilder;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRefInfoBuilder
implements ServiceRefPartialInfoBuilder {
    private static TraceComponent tc = Tr.register(WSRefInfoBuilder.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private Map<String, DescriptionBuilderComposite> dbcMap;

    public WSRefInfoBuilder(Map<String, DescriptionBuilderComposite> dbcMap) {
        this.dbcMap = dbcMap;
    }

    @Override
    public Map<String, ServiceRefPartialInfo> buildInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildInfo");
        }
        HashMap<String, ServiceRefPartialInfo> partialInfoMap = new HashMap<String, ServiceRefPartialInfo>();
        if (this.dbcMap != null && !this.dbcMap.isEmpty()) {
            for (String key : this.dbcMap.keySet()) {
                DescriptionBuilderComposite dbc = this.dbcMap.get(key);
                if (dbc.getWebServiceClientAnnot() != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Attempting to build ServiceRefPartialInfo from @WebServiceClient class: " + dbc.getClassName());
                    }
                    ServiceRefPartialInfo info = this.buildPartialInfoFromWSC(dbc);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding @WebServiceClient ServiceRefPartialInfo: " + info.toString());
                    }
                    partialInfoMap.put(info.getKey(), info);
                    continue;
                }
                if ((dbc.getWebServiceAnnot() == null || dbc.isInterface()) && dbc.getWebServiceProviderAnnot() == null) continue;
                DescriptionBuilderComposite seiDBC = null;
                if (dbc.getWebServiceAnnot() != null && dbc.getWebServiceAnnot().endpointInterface() != null && !"".equals(dbc.getWebServiceAnnot().endpointInterface())) {
                    seiDBC = this.dbcMap.get(dbc.getWebServiceAnnot().endpointInterface());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempting to build ServiceRefPartialInfo from @WebService impl class: " + dbc.getClassName() + (seiDBC != null ? " with SEI class: " + seiDBC.getClassName() : " with no SEI"));
                }
                ServiceRefPartialInfo info = this.buildPartialInfoFromWS(dbc, seiDBC);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding @WebService/@WebServiceProvider ServiceRefPartialInfo: " + info.toString());
                }
                partialInfoMap.put(info.getKey(), info);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildInfo");
        }
        return partialInfoMap;
    }

    private ServiceRefPartialInfo buildPartialInfoFromWSC(DescriptionBuilderComposite dbc) {
        String wsdlLocation = dbc.getWebServiceClientAnnot().wsdlLocation();
        QName serviceQName = null;
        String localPart = dbc.getWebServiceClientAnnot().name();
        if (localPart != null) {
            serviceQName = new QName(dbc.getWebServiceClientAnnot().targetNamespace(), localPart);
        }
        String className = dbc.getClassName();
        ServiceRefPartialInfo info = new ServiceRefPartialInfo(className, wsdlLocation, serviceQName, null);
        return info;
    }

    private ServiceRefPartialInfo buildPartialInfoFromWS(DescriptionBuilderComposite dbc, DescriptionBuilderComposite seiDBC) {
        String localPart;
        String key = null;
        if (seiDBC != null) {
            key = seiDBC.getWebServiceAnnot().name();
            if (key == null || "".equals(key)) {
                key = this.getSimpleClassName(seiDBC);
            }
        } else if (dbc.getWebServiceAnnot() != null) {
            key = dbc.getWebServiceAnnot().name();
            if (key == null || "".equals(key)) {
                key = this.getSimpleClassName(dbc);
            }
        } else {
            key = dbc.getClassName();
        }
        String wsdlLocation = null;
        if (seiDBC != null) {
            wsdlLocation = seiDBC.getWebServiceAnnot().wsdlLocation();
        }
        if (wsdlLocation == null || "".equals(wsdlLocation)) {
            wsdlLocation = dbc.getWebServiceAnnot() != null ? dbc.getWebServiceAnnot().wsdlLocation() : dbc.getWebServiceProviderAnnot().wsdlLocation();
        }
        QName portQName = null;
        if (dbc.getWebServiceAnnot() != null) {
            String tns;
            localPart = dbc.getWebServiceAnnot().portName();
            if (localPart == null || "".equals(localPart)) {
                localPart = key + "Port";
            }
            if ((tns = dbc.getWebServiceAnnot().targetNamespace()) == null || "".equals(tns)) {
                String packageName = WebServiceUtils.getPackageName(dbc.getClassName());
                tns = WebServiceUtils.getNamespaceFromPackageName(packageName, null);
            }
            portQName = new QName(tns, localPart);
        } else {
            localPart = dbc.getWebServiceProviderAnnot().portName();
            String tns = dbc.getWebServiceProviderAnnot().targetNamespace();
            if (tns == null || "".equals(tns)) {
                String packageName = WebServiceUtils.getPackageName(dbc.getClassName());
                tns = WebServiceUtils.getNamespaceFromPackageName(packageName, null);
            }
            portQName = new QName(tns, localPart);
        }
        ServiceRefPartialInfo info = new ServiceRefPartialInfo(key, wsdlLocation, null, portQName);
        return info;
    }

    private String getSimpleClassName(DescriptionBuilderComposite dbc) {
        return dbc.getClassName().substring(dbc.getClassName().lastIndexOf(".") + 1, dbc.getClassName().length());
    }
}

