/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.webapplication.HTTPMethodTypeEnum;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.TransportGuaranteeType;
import org.eclipse.jst.j2ee.webapplication.UserDataConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;
import org.eclipse.jst.j2ee.webapplication.internal.impl.SecurityConstraintImpl;
import org.eclipse.jst.j2ee.webapplication.internal.impl.UserDataConstraintImpl;
import org.eclipse.jst.j2ee.webapplication.internal.impl.WebResourceCollectionImpl;

public class WASAxis2URISecurityConstrainer
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAxis2URISecurityConstrainer.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private ConfigurationContext configContext = null;
    private WebApp webapp = null;

    public WASAxis2URISecurityConstrainer(ConfigurationContext cc, WebApp wa) {
        this.configContext = cc;
        this.webapp = wa;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void constrainURIs() throws DeploymentException {
        block11: {
            block10: {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "WASAxis2URISecurityConstrainer.constrainURIs()...");
                }
                try {
                    try {
                        Set userConstrainedURIs = this.getUserConstrainedURIs();
                        Set serviceURIs = this.getServiceURIs();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "WebApp: " + this.webapp);
                            Tr.debug(_tc, "User defined constrained URIs: " + userConstrainedURIs);
                            Tr.debug(_tc, "URIs defined by services to constrain: " + serviceURIs);
                        }
                        Set urisToConstrain = this.getRemainingURIsToConstrain(userConstrainedURIs, serviceURIs);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Remaining URIs to constrain: " + urisToConstrain);
                        }
                        if (urisToConstrain.size() == 0) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "All URIs constrained by web.xml, returning.");
                            }
                            Object var5_7 = null;
                            if (!_tc.isEntryEnabled()) return;
                            break block10;
                        }
                        this.constrainURIs(urisToConstrain);
                        break block11;
                    }
                    catch (Throwable t) {
                        Object[] inserts = new Object[]{t};
                        String msg = NLSProvider.getNLS().getFormattedMessage("caughtException", inserts, "Caught unexpected exception: {0}");
                        Tr.error(_tc, "caughtException", inserts);
                        throw new DeploymentException(msg);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    if (!_tc.isEntryEnabled()) throw throwable;
                    Tr.exit(_tc, "...WASAxis2URISecurityConstrainer.constrainURIs()");
                    throw throwable;
                }
            }
            Tr.exit(_tc, "...WASAxis2URISecurityConstrainer.constrainURIs()");
            return;
        }
        Object var5_8 = null;
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "...WASAxis2URISecurityConstrainer.constrainURIs()");
    }

    private Set getServiceURIs() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2URISecurityConstrainer.getServiceURIs()...");
        }
        HashSet<String> serviceURIs = new HashSet<String>();
        AxisConfiguration ac = this.configContext.getAxisConfiguration();
        Iterator svcGroupIter = ac.getServiceGroups();
        while (svcGroupIter.hasNext()) {
            AxisServiceGroup svcGroup = (AxisServiceGroup)svcGroupIter.next();
            Iterator svcIter = svcGroup.getServices();
            while (svcIter.hasNext()) {
                AxisService axisService = (AxisService)svcIter.next();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "ServiceName: " + Axis2Utils.getServiceName(axisService));
                }
                if (!Axis2Utils.isServiceConstrained(axisService)) continue;
                String uri = Axis2Utils.getURLPattern(axisService);
                serviceURIs.add(uri);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Service needs URI constrained: " + uri);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WASAxis2URISecurityConstrainer.getServiceURIs()");
        }
        return serviceURIs;
    }

    private Set getUserConstrainedURIs() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2URISecurityConstrainer.getConstraintUserDefinedURIs()...");
        }
        HashSet definedURIs = new HashSet();
        if (this.webapp == null) {
            return definedURIs;
        }
        EList constraints = this.webapp.getConstraints();
        for (SecurityConstraint sc : constraints) {
            EList wrc = sc.getWebResourceCollections();
            for (WebResourceCollection rc : wrc) {
                EList url_list = rc.getUrlPattern();
                definedURIs.addAll(url_list);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "URI list added: " + url_list);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WASAxis2URISecurityConstrainer.getConstraintUserDefinedURIs()");
        }
        return definedURIs;
    }

    private Set getRemainingURIsToConstrain(Set userConstrainedURIs, Set serviceURIs) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2URISecurityConstrainer.getRemainingURIsToConstrain()...");
        }
        if (userConstrainedURIs.size() == 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No user constrained uris, constrain all.");
            }
            return serviceURIs;
        }
        HashSet remainingURIs = new HashSet(serviceURIs);
        for (String userURI : userConstrainedURIs) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "User defined URI: " + userURI);
            }
            if (userURI.endsWith("*")) {
                userURI = userURI.substring(0, userURI.length() - 1);
                for (String serviceURI : serviceURIs) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Service URI: " + serviceURI);
                    }
                    if (!serviceURI.startsWith(userURI)) continue;
                    remainingURIs.remove(serviceURI);
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Removed service URI from set.");
                }
                if (!userURI.endsWith("/")) continue;
                userURI = userURI.substring(0, userURI.length() - 1);
                remainingURIs.remove(userURI);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Removed URI from set: " + userURI);
                continue;
            }
            remainingURIs.remove(userURI);
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "Removed URI from set: " + userURI);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WASAxis2URISecurityConstrainer.getRemainingURIsToConstrain()");
        }
        return remainingURIs;
    }

    private void constrainURIs(Set urisToConstrain) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2URISecurityConstrainer.constrainURIs()...");
        }
        SecurityConstraintImpl sc = new SecurityConstraintImpl();
        WebResourceCollectionImpl wrc = new WebResourceCollectionImpl();
        UserDataConstraintImpl udc = new UserDataConstraintImpl();
        for (String uri : urisToConstrain) {
            wrc.getUrlPattern().add(uri + "/*");
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "URI now constrained: " + uri + "/*");
        }
        udc.setTransportGuarantee(TransportGuaranteeType.CONFIDENTIAL_LITERAL);
        wrc.getHttpMethod().add(HTTPMethodTypeEnum.GET_LITERAL);
        wrc.getHttpMethod().add(HTTPMethodTypeEnum.POST_LITERAL);
        sc.getWebResourceCollections().add(wrc);
        sc.setUserDataConstraint((UserDataConstraint)udc);
        sc.setWebApp(this.webapp);
        this.webapp.getConstraints().add(sc);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WASAxis2URISecurityConstrainer.constrainURIs()");
        }
    }
}

