/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webservices.shared.cache.CacheRootDirectoryTLS;
import com.ibm.ws.webservices.shared.cache.WebServicesModuleCache;
import com.ibm.ws.webservices.shared.cache.WebServicesModuleCacheMgr;
import com.ibm.ws.webservices.shared.cache.jaxb.JaxwsWebServiceInfo;
import com.ibm.ws.webservices.shared.cache.jaxb.WebServiceClientInfo;
import com.ibm.ws.webservices.shared.cache.jaxb.WsClientType;
import com.ibm.ws.webservices.utils.ClassUtils;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector;
import com.ibm.ws.websvcs.annotations.generator.WASAnnotationInputBuilder;
import com.ibm.ws.websvcs.deploy.WSCacheWriter;
import com.ibm.ws.websvcs.deployment.CachedFileLocator;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorerFactory;
import com.ibm.ws.websvcs.deployment.WASAxis2DescriptionBuilder;
import com.ibm.ws.websvcs.deployment.WSServerMetadataMerger;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.wsdl.JaxWSCatalogAccessor;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import com.ibm.wsspi.webservices.models.WSModels;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.WsdlComposite;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAxis2MetaDataProcessor
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAxis2MetaDataProcessor.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private ConfigurationContext configContext;
    private WASAxis2Service runtimeService;
    private String applicationName;
    private String moduleName;
    private boolean cacheNeeded;
    private WebServicesModuleCache cache;
    private ModuleFile moduleFile;
    private HashMap<String, DescriptionBuilderComposite> dbcMap;
    private WebAppConfig webAppConfig;
    private ClassLoader deployedObjectClassLoader;

    public WASAxis2MetaDataProcessor(ModuleFile moduleFile, ClassLoader classLoader, WebAppConfig webAppConfig, MetaDataEvent mde) {
        ModuleMetaData mmd;
        this.moduleFile = moduleFile;
        this.deployedObjectClassLoader = classLoader;
        this.webAppConfig = webAppConfig;
        this.applicationName = null;
        if (mde != null && mde.getMetaData() instanceof ModuleMetaData && (mmd = (ModuleMetaData)mde.getMetaData()).getApplicationMetaData() != null) {
            this.applicationName = mmd.getApplicationMetaData().getName();
        }
    }

    public ConfigurationContext processApplicationMetaData() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processApplicationMetaData");
        }
        try {
            this.getRuntimeService();
            this.setAppAndModuleName();
            this.initCache();
            AxisServiceGroup serviceGroup = null;
            if (this.cache.exists(true) && !this.cache.jaxwsCacheExists() && !this.cache.jaxwsClientCacheExists()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found cache for module " + this.moduleName + ", but " + "the module contains no annotations.");
                }
                return null;
            }
            if (this.cache.exists(true) && !this.cache.jaxwsCacheExists() && this.cache.jaxwsClientCacheExists()) {
                List<ClassDataObject> cdoList = this.getClassDataObjects();
                this.buildAnnotationDBCInputs(cdoList);
            } else {
                serviceGroup = this.processModuleMetadata();
                if (serviceGroup != null) {
                    this.finishRuntimeConfiguration(this.configContext.getAxisConfiguration(), serviceGroup);
                }
            }
            if (this.configContext != null) {
                this.storeMetaDataFileList(serviceGroup);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "processApplicationMetaData");
            }
            return this.configContext;
        }
        catch (Exception e) {
            Object[] inserts = new Object[]{this.moduleName, e};
            String msg = NLSProvider.getNLS().getFormattedMessage("loadConfigContextFail00", inserts, "Error occurred while attempting to create ConfigurationContext for application module{0}: {1}");
            Tr.error(_tc, msg);
            throw e;
        }
    }

    void storeMetaDataFileList(AxisServiceGroup axisServiceGroup) {
        HashMap filePathMappings = new HashMap();
        if (axisServiceGroup != null && axisServiceGroup.getServices() != null) {
            Iterator svcIter = axisServiceGroup.getServices();
            while (svcIter.hasNext()) {
                ArrayList<String> mappings = new ArrayList<String>();
                AxisService svc = (AxisService)svcIter.next();
                WsdlComposite composite = Axis2Utils.getWsdlComposite(svc);
                if (composite != null && composite.getWsdlDefinitionsMap() != null && !composite.getWsdlDefinitionsMap().isEmpty()) {
                    for (String wsdlFile : composite.getWsdlDefinitionsMap().keySet()) {
                        if (mappings.contains(wsdlFile)) continue;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Adding generated WSDL file to metadata file list: " + wsdlFile);
                        }
                        mappings.add(wsdlFile);
                    }
                }
                if (composite != null && composite.getSchemaMap() != null && !composite.getSchemaMap().isEmpty()) {
                    for (String xsdFile : composite.getSchemaMap().keySet()) {
                        if (mappings.contains(xsdFile)) continue;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Adding generated XSD file to metadata file list: " + xsdFile);
                        }
                        mappings.add(xsdFile);
                    }
                }
                String wsdlLocation = Axis2Utils.getWSDLLocation(svc);
                String filePathMapping = null;
                String filePathPrefix = null;
                boolean isAbsolute = false;
                if (wsdlLocation == null || "".equals(wsdlLocation)) continue;
                if (Axis2Utils.isAbsolutePath(wsdlLocation)) {
                    isAbsolute = true;
                    filePathMapping = Axis2Utils.getServletFilePath(wsdlLocation);
                    filePathPrefix = Axis2Utils.getServletFilePathPrefix(wsdlLocation);
                    if (!mappings.contains(filePathMapping)) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Adding servlet file path mapping: " + filePathMapping + " for AxisService: " + svc + " with prefix: " + filePathPrefix);
                        }
                        mappings.add(filePathMapping);
                    }
                    Axis2Utils.createAndSetAxisParameter(svc, "com.ibm.ws.websvcs.FILE_PATH_PREFIX", filePathPrefix);
                } else {
                    String packagedMapping = wsdlLocation.replace("\\", "/");
                    if (!mappings.contains(packagedMapping)) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Adding servlet path for WSDL: " + packagedMapping + " for AxisService: " + svc);
                        }
                        mappings.add(packagedMapping);
                    }
                }
                List importedMappings = (List)Axis2Utils.getParameterValue(svc, "com.ibm.ws.websvcs.RESOLVED_IMPORT_LOCATIONS");
                if (importedMappings != null && !importedMappings.isEmpty()) {
                    for (String importedMapping : importedMappings) {
                        String mapping = null;
                        if (isAbsolute) {
                            mapping = Axis2Utils.getServletFilePath(importedMapping);
                        } else if (!Axis2Utils.isAbsolutePath(importedMapping)) {
                            mapping = importedMapping;
                        }
                        if (mapping == null || mappings.contains(mapping)) continue;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Adding servlet path mapping: " + mapping + " for AxisService: " + svc);
                        }
                        mappings.add(mapping);
                    }
                }
                filePathMappings.put(svc.getName(), mappings);
            }
        }
        this.configContext.setProperty("com.ibm.ws.websvcs.FILE_PATH_SERVLET_MAPPINGS", filePathMappings);
        this.configContext.setProperty("com.ibm.ws.websvcs.JAXWS_CATALOG_ACCESSOR", new JaxWSCatalogAccessor(this.moduleFile.getArchiveClassLoader()));
    }

    private void setAppAndModuleName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setAppAndModuleName");
        }
        if (this.applicationName == null) {
            this.applicationName = this.moduleFile.getEARFile() != null ? this.moduleFile.getEARFile().getName() : null;
        }
        this.moduleName = this.moduleFile.getName();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setAppAndModuleName");
        }
    }

    private void getRuntimeService() throws Exception, DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRuntimeService");
        }
        this.runtimeService = WsServiceRegistry.getService(this, WASAxis2Service.class);
        if (this.runtimeService == null) {
            throw new DeploymentException("WASAxis2Service not available. Module processing will be aborted");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getRuntimeService");
        }
    }

    private AxisServiceGroup processModuleMetadata() throws Exception {
        AxisServiceGroup axisServiceGroup;
        block9: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "processModuleMetadata");
            }
            try {
                AxisServiceGroup serviceGroup = null;
                List<ClassDataObject> cdoList = this.getClassDataObjects();
                if (cdoList != null && cdoList.size() > 0) {
                    this.loadConfiguration();
                    this.setWebAppName();
                    this.buildAnnotationDBCInputs(cdoList);
                    if (this.dbcMap != null && !this.dbcMap.isEmpty()) {
                        List<ServiceDescription> sdList = DescriptionFactory.createServiceDescriptionFromDBCMap(this.dbcMap);
                        serviceGroup = this.buildAxisServices(cdoList, sdList);
                        if (this.moduleFile.isWARFile()) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Locating JAX-WS injectable classes for module: " + this.moduleFile.getName());
                            }
                            this.locateJAXWSClassesForScan(this.webAppConfig, serviceGroup);
                        }
                    }
                }
                axisServiceGroup = serviceGroup;
                Object var5_5 = null;
                if (!_tc.isEntryEnabled()) break block9;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    block10: {
                        Object var5_6 = null;
                        if (!_tc.isEntryEnabled()) break block10;
                        Tr.exit(_tc, "processWARMetadata");
                    }
                    throw throwable;
                }
            }
            Tr.exit(_tc, "processWARMetadata");
        }
        return axisServiceGroup;
    }

    private void loadConfiguration() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadConfiguration");
        }
        this.configContext = this.runtimeService.loadAxis2ConfigurationContext(this.applicationName, this.moduleName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadConfiguration");
        }
    }

    private AxisServiceGroup buildAxisServices(List<ClassDataObject> cdoList, List<ServiceDescription> sdList) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildAxisServices");
        }
        WASAxis2DescriptionBuilder descBuilder = new WASAxis2DescriptionBuilder(this.moduleFile, this.deployedObjectClassLoader);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildAxisServices");
        }
        return descBuilder != null ? descBuilder.buildAxisServiceGroup(sdList) : null;
    }

    private List<FileLocator> getFileLocators() throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getFileLocators");
        }
        if (this.cache.jaxwsCacheExists() || this.cache.jaxwsClientCacheExists()) {
            List<WebServiceClientInfo> clientInfoList;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found existing annotated class cache file for module: " + this.moduleName);
            }
            List<JaxwsWebServiceInfo> jaxwsInfoList = this.cache.getWsCacheInfo().getJaxwsServices();
            LinkedList<String> classNames = new LinkedList<String>();
            if (jaxwsInfoList != null && !jaxwsInfoList.isEmpty()) {
                this.addServiceClassNames(jaxwsInfoList, classNames);
            }
            if ((clientInfoList = this.cache.getWsCacheInfo().getWebServiceClient()) != null && !clientInfoList.isEmpty()) {
                this.addClientClassNames(clientInfoList, classNames);
            }
            try {
                List<FileLocator> locators = this.buildLocators(classNames);
                this.cacheNeeded = false;
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getFileLocators");
                }
                return locators;
            }
            catch (Exception e) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getFileLocators");
                }
                return this.getLocatorsFromModule();
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Did not find existing annotated class cache file for module: " + this.moduleName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getFileLocators");
        }
        return this.getLocatorsFromModule();
    }

    void addServiceClassNames(List<JaxwsWebServiceInfo> jaxwsInfoList, List<String> classNames) {
        for (JaxwsWebServiceInfo info : jaxwsInfoList) {
            classNames.add(info.getClassName());
        }
    }

    void addClientClassNames(List<WebServiceClientInfo> clientInfoList, List<String> classNames) {
        for (WebServiceClientInfo info : clientInfoList) {
            String className;
            if (info.getClientType() != null && !info.getClientType().equals((Object)WsClientType.JAX_WS) || (className = info.getServiceClassName()) == null) continue;
            if (!(className = className.replace(".", "/")).endsWith(".class")) {
                className = className + ".class";
            }
            classNames.add(className);
        }
    }

    private List<FileLocator> getLocatorsFromModule() throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getLocatorsFromModule");
        }
        FileExplorer explorer = FileExplorerFactory.getFileExplorer(this.moduleFile, this.deployedObjectClassLoader);
        this.cacheNeeded = true;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getLocatorsFromModule");
        }
        List<FileLocator> locators = null;
        if (explorer != null) {
            locators = explorer.explore();
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "The module file: " + this.moduleFile.getName() + " is not a " + "WAR or EJB module and will not be processed for web service metadata.");
        }
        return locators;
    }

    private List<ClassDataObject> getClassDataObjects() throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getClassDataObjects");
        }
        List<FileLocator> fileLocators = this.getFileLocators();
        WASAnnotationCollector collector = new WASAnnotationCollector();
        collector.setClassLoader(this.deployedObjectClassLoader);
        List<ClassDataObject> cdoList = null;
        if (fileLocators != null) {
            cdoList = this.cacheNeeded ? collector.collect(fileLocators) : collector.collectCachedList(fileLocators);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getClassDataObjects");
        }
        return cdoList;
    }

    private HashMap<String, DescriptionBuilderComposite> buildAnnotationDBCInputs(List<ClassDataObject> cdoList) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildAnnotationDBCInputs");
        }
        WASAnnotationInputBuilder inputBuilder = new WASAnnotationInputBuilder(cdoList, this.deployedObjectClassLoader, this.moduleFile);
        this.dbcMap = inputBuilder.buildInputs();
        String xmlFileName = this.moduleFile.isWARFile() ? "WEB-INF/webservices.xml" : "META-INF/webservices.xml";
        WebServices webServices = WSModels.getWebServices(this.moduleFile.getLoadStrategy(), xmlFileName);
        WSServerMetadataMerger merger = new WSServerMetadataMerger(this.dbcMap, webServices, this.moduleFile.getLoadStrategy(), this.moduleFile.getName());
        this.dbcMap.putAll(merger.mergeMetadata());
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildAnnotationDBCInputs, size= " + (this.dbcMap != null ? this.dbcMap.size() : 0));
        }
        return this.dbcMap;
    }

    private void setWebAppName() {
        WebApp webapp;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setWebAppName");
        }
        if (this.moduleFile instanceof WARFile && ((webapp = ((WARFile)this.moduleFile).getDeploymentDescriptor()).getDisplayName() == null || webapp.getDisplayName().equals(""))) {
            webapp.setDisplayName(this.moduleName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setWebAppName");
        }
    }

    private void finishRuntimeConfiguration(AxisConfiguration axisCfg, AxisServiceGroup serviceGroup) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "finishRuntimeConfiguration");
        }
        if (!serviceGroup.getServices().hasNext()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The AxisServiceGroup for the module: " + this.moduleName + " has no services and will not be added to the AxisConfiguration");
            }
        } else {
            axisCfg.addServiceGroup(serviceGroup);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "finishRuntimeConfiguration");
        }
    }

    private List<FileLocator> buildLocators(List<String> classNames) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildLocators");
        }
        ArrayList<FileLocator> locators = new ArrayList<FileLocator>();
        for (String className : classNames) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Constructed FileLocator from cache: " + className);
            }
            URL url = null;
            try {
                URL uRL = url = this.moduleFile.getArchiveClassLoader() != null ? this.moduleFile.getArchiveClassLoader().getResource(className) : null;
                if (url == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "URL for class: " + className + " not found using archive's " + "classloader... attempting DeployedObject classloader");
                    }
                    url = this.deployedObjectClassLoader.getResource(className);
                }
                if (url == null) continue;
                CachedFileLocator locator = new CachedFileLocator(url, className);
                locators.add(locator);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Found the following cached class file: " + url.toString());
            }
            catch (Exception e) {
                Tr.warning(_tc, "The following problem occurred when trying to load application metadata from cache: " + e.toString() + ". The application " + "metadata will now be loaded from the web module.");
                throw e;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildLocators");
        }
        return locators;
    }

    private void initCache() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initCache");
        }
        CacheRootDirectoryTLS.set(null);
        String appName = WebServiceUtils.getApplicationName(this.moduleFile);
        String cacheLocation = appName + File.separator + this.moduleName + File.separator;
        this.cache = WebServicesModuleCacheMgr.getModuleCache(cacheLocation);
        this.cache.setClassLoader(this.deployedObjectClassLoader);
        boolean regenCache = false;
        if (!this.cache.exists()) {
            String appDisplayName;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Cache does not exist for location: " + cacheLocation);
            }
            if (this.cache.displayNameCacheExists(appDisplayName = WebServiceUtils.getApplicationDisplayName(this.moduleFile), appName, this.moduleName)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "For module: " + this.moduleName + " an old copy of " + "the web services metadata cache was found under Application Display Name " + appDisplayName + ". This cache will be updated.");
                }
                regenCache = true;
            }
            if (this.cache.oldCacheExists()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "For module: " + this.moduleName + " a feature pack version of " + "the web services metadata cache was found. This cache will be updated.");
                }
                regenCache = true;
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Found existing cache for location: " + cacheLocation);
        }
        if (regenCache) {
            try {
                WSCacheWriter writer = new WSCacheWriter(appName);
                writer.writeModuleCache(this.moduleFile, true, this.deployedObjectClassLoader);
            }
            catch (Exception e) {
                Tr.info(_tc, "writeCacheFail00", new Object[]{this.moduleName, this.applicationName, e});
            }
        }
        this.cache.load();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initCache");
        }
    }

    void locateJAXWSClassesForScan(WebAppConfig webAppConfig, AxisServiceGroup svcGroup) throws Exception {
        if (svcGroup != null) {
            Iterator svcIter = svcGroup.getServices();
            while (svcIter.hasNext()) {
                AxisService axisService = (AxisService)svcIter.next();
                this.locateJAXWSClassesForScan(webAppConfig, axisService);
            }
        }
    }

    void locateJAXWSClassesForScan(WebAppConfig webAppConfig, AxisService axisService) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "locateJAXWSClassesForScan, axisService= " + axisService.getName() + ", moduleFile= " + this.moduleFile.getName());
        }
        LinkedList classesToScan = new LinkedList();
        String implClassName = Axis2Utils.getServiceImplClass(axisService);
        classesToScan.add(ClassUtils.forName(implClassName, false, axisService.getClassLoader()));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Added JAX-WS implementation class: " + implClassName + " to injectable " + "class list");
        }
        EndpointDescription ed = (EndpointDescription)(axisService.getParameter("org.apache.axis2.jaxws.description.EndpointDescription") != null ? axisService.getParameter("org.apache.axis2.jaxws.description.EndpointDescription").getValue() : null);
        if (ed != null && ed.getHandlerChain() != null) {
            HandlerChainsType hcsType = ed.getHandlerChain();
            for (HandlerChainType hcType : hcsType.getHandlerChain()) {
                for (HandlerType hType : hcType.getHandler()) {
                    String handlerClassName = hType.getHandlerClass() != null ? hType.getHandlerClass().getValue() : null;
                    if (handlerClassName == null || "".equals(handlerClassName)) continue;
                    classesToScan.add(ClassUtils.forName(handlerClassName, false, axisService.getClassLoader()));
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "Added JAX-WS handler class: " + handlerClassName + " to injectable class list");
                }
            }
        }
        webAppConfig.addClassesToScan(classesToScan);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "locateJAXWSClassesForScan, axisService= " + axisService.getName() + ", moduleFile= " + this.moduleFile.getName(), ", classesToScan= " + classesToScan);
        }
    }

    public Map<String, DescriptionBuilderComposite> getDBCs() {
        return this.dbcMap;
    }
}

