/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.utils.PluginUtils;
import com.ibm.ws.websvcs.deployment.ACMPluginConfig;
import com.ibm.ws.websvcs.deployment.QOSModuleConfig;
import com.ibm.ws.websvcs.deployment.TCMPluginConfig;
import com.ibm.ws.websvcs.resources.NLSProvider;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.deployment.URLBasedAxisConfigurator;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Flow;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigrator;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigratorUtil;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.ThreadContextMigrator;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class WASAxis2ConfigurationBuilder {
    private static final TraceComponent _tc = Tr.register(WASAxis2ConfigurationBuilder.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private DeploymentEngine de;
    private ArrayList clientModuleFiles = null;
    private ArrayList serverModuleFiles = null;
    private ArrayList clientTCMPlugins = null;
    private ArrayList serverTCMPlugins = null;
    private ArrayList clientACMPlugins = null;
    private ArrayList serverACMPlugins = null;

    public WASAxis2ConfigurationBuilder() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2ConfigurationBuilder ctor");
        }
        this.clientModuleFiles = new ArrayList();
        this.serverModuleFiles = new ArrayList();
        this.clientTCMPlugins = new ArrayList();
        this.serverTCMPlugins = new ArrayList();
        this.clientACMPlugins = new ArrayList();
        this.serverACMPlugins = new ArrayList();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WASAxis2ConfigurationBuilder ctor");
        }
    }

    public WASAxis2ConfigurationBuilder(ArrayList sModFiles, ArrayList cModFiles) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2ConfigurationBuilder ctor");
        }
        this.serverModuleFiles = sModFiles;
        this.clientModuleFiles = cModFiles;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WASAxis2ConfigurationBuilder ctor");
        }
    }

    public WASAxis2ConfigurationBuilder(ArrayList serverModuleFiles, ArrayList clientModuleFiles, ArrayList serverTCMPlugins, ArrayList clientTCMPlugins, ArrayList serverACMPlugins, ArrayList clientACMPlugins) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2ConfigurationBuilder ctor");
        }
        this.serverModuleFiles = serverModuleFiles;
        this.clientModuleFiles = clientModuleFiles;
        this.serverTCMPlugins = serverTCMPlugins;
        this.clientTCMPlugins = clientTCMPlugins;
        this.serverACMPlugins = serverACMPlugins;
        this.clientACMPlugins = clientACMPlugins;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WASAxis2ConfigurationBuilder ctor");
        }
    }

    public AxisConfiguration loadAxisServerConfiguration() throws Exception {
        return this.loadAxisCfg("META-INF/config/ibmaxis2.xml");
    }

    public AxisConfiguration loadAxisClientConfiguration() throws Exception {
        return this.loadAxisCfg("META-INF/config/ibmaxis2.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAxisServerModules(AxisConfiguration axisCfg, ConfigurationContext configContext) throws DeploymentException {
        ArrayList arrayList = this.serverModuleFiles;
        synchronized (arrayList) {
            try {
                if (this.serverModuleFiles.isEmpty()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Need to discover AxisModules for server");
                    }
                    this.discoverAxisModules(axisCfg, this.serverModuleFiles, "com.ibm.wsfp.main.ibmaxis2-qos-module-server");
                    this.discoverAxisModules(axisCfg, this.serverModuleFiles, "com.ibm.wsfp.main.custom-handler-server");
                    this.loadAxisModules(this.serverModuleFiles, axisCfg);
                    this.initModules(axisCfg, configContext);
                    this.engageModules(axisCfg);
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Already discovered AxisModules for server");
                    }
                    this.loadAxisModules(this.serverModuleFiles, axisCfg);
                    this.initModules(axisCfg, configContext);
                    this.engageModules(axisCfg);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.loadAxisServerModules", "197", this);
                Object[] inserts = new Object[]{e};
                String msg = NLSProvider.getNLS().getFormattedMessage("qosModLoadFail00", inserts, "Error occurred while attempting to load QoS(Quality of Service) modules on the server: {0}");
                throw new DeploymentException(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAxisClientModules(AxisConfiguration axisCfg, ConfigurationContext configContext) throws DeploymentException {
        ArrayList arrayList = this.clientModuleFiles;
        synchronized (arrayList) {
            try {
                if (this.clientModuleFiles.isEmpty()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Need to discover AxisModules for client");
                    }
                    this.discoverAxisModules(axisCfg, this.clientModuleFiles, "com.ibm.wsfp.main.ibmaxis2-qos-module-client");
                    this.discoverAxisModules(axisCfg, this.clientModuleFiles, "com.ibm.wsfp.thinclient.ibmaxis2-qos-module-client");
                    this.discoverAxisModules(axisCfg, this.clientModuleFiles, "com.ibm.wsfp.main.custom-handler-client");
                    this.discoverAxisModules(axisCfg, this.clientModuleFiles, "com.ibm.wsfp.thinclient.custom-handler-thinclient");
                    this.loadAxisModules(this.clientModuleFiles, axisCfg);
                    this.initModules(axisCfg, configContext);
                    this.engageModules(axisCfg);
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Already discovered AxisModules for client");
                    }
                    this.loadAxisModules(this.clientModuleFiles, axisCfg);
                    this.initModules(axisCfg, configContext);
                    this.engageModules(axisCfg);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.loadAxisClientModules", "245", this);
                Object[] inserts = new Object[]{e};
                String msg = NLSProvider.getNLS().getFormattedMessage("qosModLoadClientFail00", inserts, "Error occurred while attempting to load QoS(Quality of Service) modules on the client: {0}");
                throw new DeploymentException(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAxisServerTCMPlugins(ConfigurationContext configCtx) throws DeploymentException {
        ArrayList arrayList = this.serverTCMPlugins;
        synchronized (arrayList) {
            if (this.serverTCMPlugins.isEmpty()) {
                this.discoverTCMPlugins("com.ibm.wsfp.main.ibmaxis2-thread-ctx-migrator-server", this.serverTCMPlugins);
                this.registerTCMPlugins(this.serverTCMPlugins, configCtx);
            } else {
                this.registerTCMPlugins(this.serverTCMPlugins, configCtx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAxisClientTCMPlugins(ConfigurationContext configCtx) throws DeploymentException {
        ArrayList arrayList = this.clientTCMPlugins;
        synchronized (arrayList) {
            if (this.clientTCMPlugins.isEmpty()) {
                this.discoverTCMPlugins("com.ibm.wsfp.main.ibmaxis2-thread-ctx-migrator-client", this.clientTCMPlugins);
                this.discoverTCMPlugins("com.ibm.wsfp.thinclient.ibmaxis2-thread-ctx-migrator-client", this.clientTCMPlugins);
                this.registerTCMPlugins(this.clientTCMPlugins, configCtx);
            } else {
                this.registerTCMPlugins(this.clientTCMPlugins, configCtx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAxisServerACMPlugins(ConfigurationContext configCtx) throws DeploymentException {
        ArrayList arrayList = this.serverACMPlugins;
        synchronized (arrayList) {
            if (this.serverACMPlugins.isEmpty()) {
                this.discoverACMPlugins("com.ibm.wsfp.main.ibmaxis2-app-ctx-migrator-server", this.serverACMPlugins);
                this.registerACMPlugins(this.serverACMPlugins, configCtx);
            } else {
                this.registerACMPlugins(this.serverACMPlugins, configCtx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAxisClientACMPlugins(ConfigurationContext configCtx) throws DeploymentException {
        ArrayList arrayList = this.clientACMPlugins;
        synchronized (arrayList) {
            if (this.clientACMPlugins.isEmpty()) {
                this.discoverACMPlugins("com.ibm.wsfp.main.ibmaxis2-app-ctx-migrator-client", this.clientACMPlugins);
                this.discoverACMPlugins("com.ibm.wsfp.thinclient.ibmaxis2-app-ctx-migrator-client", this.clientACMPlugins);
                this.registerACMPlugins(this.clientACMPlugins, configCtx);
            } else {
                this.registerACMPlugins(this.clientACMPlugins, configCtx);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AxisConfiguration loadAxisCfg(String cfgFile) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadAxisCfg, cfgFile=" + cfgFile);
        }
        ClassLoader oldCCL = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        AxisConfiguration axisCfg = new AxisConfiguration();
        try {
            block25: {
                try {
                    ClassLoader cl;
                    URL cfgFileURI;
                    block24: {
                        PrintWriter pw;
                        StringWriter sw;
                        block23: {
                            ExtClassLoader extCL = ExtClassLoader.getInstance();
                            cfgFileURI = null;
                            try {
                                cfgFileURI = extCL.getResource(cfgFile);
                            }
                            catch (Throwable t) {
                                sw = new StringWriter();
                                pw = new PrintWriter(sw);
                                t.printStackTrace(pw);
                                if (!_tc.isDebugEnabled()) break block23;
                                Tr.debug(_tc, "Failed to load config file URL using ExtClassLoader due to the following error: \n" + sw.toString());
                            }
                        }
                        if (cfgFileURI != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Loaded config file URL using ExtClassLoader: " + cfgFileURI.toString());
                            }
                        } else {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Config file not loaded using ExtClassLoader, using thread classloader: " + oldCCL);
                            }
                            try {
                                cfgFileURI = oldCCL.getResource(cfgFile);
                            }
                            catch (Throwable t) {
                                sw = new StringWriter();
                                pw = new PrintWriter(sw);
                                t.printStackTrace(pw);
                                if (!_tc.isDebugEnabled()) break block24;
                                Tr.debug(_tc, "Failed to load config file URL using Thread's classloader due to the following error: \n" + sw.toString());
                            }
                        }
                    }
                    if (cfgFileURI != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Loaded config file URL using Thread's classloader: " + cfgFileURI.toString());
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Config file not loaded with either classloader");
                    }
                    InputStream is = null;
                    if (cfgFileURI != null) {
                        is = cfgFileURI.openStream();
                    }
                    if (is == null) break block25;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found Axis2 configuration file: " + cfgFileURI.toString());
                    }
                    final WASAxis2ConfigurationBuilder builder = this;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            Thread.currentThread().setContextClassLoader(builder.getClass().getClassLoader());
                            return null;
                        }
                    });
                    if (_tc.isDebugEnabled()) {
                        cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        Tr.debug(_tc, "Setting temporary ContextClassLoader: " + cl.toString());
                    }
                    this.de = new URLBasedAxisConfigurator(cfgFileURI, null);
                    if (_tc.isDebugEnabled()) {
                        WSLauncher.debug = true;
                        cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        Tr.debug(_tc, "About to call populateAxisConfiguration(), classloader=" + cl.toString());
                    }
                    axisCfg = this.de.populateAxisConfiguration(is);
                    PhasesInfo phasesinfo = axisCfg.getPhasesInfo();
                    axisCfg.setInPhasesUptoAndIncludingPostDispatch(phasesinfo.getGlobalInflow());
                    axisCfg.setInFaultPhases(phasesinfo.getIN_FaultPhases());
                    axisCfg.setGlobalOutPhase(phasesinfo.getGlobalOutPhaseList());
                    axisCfg.setOutFaultPhases(phasesinfo.getOUT_FaultPhases());
                    if (!_tc.isDebugEnabled()) break block25;
                    Tr.debug(_tc, "Created AxisConfiguration: " + axisCfg.toString());
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.loadAxisCfg", "359", this);
                    Object[] inserts = new Object[]{cfgFile, e};
                    String msg = NLSProvider.getNLS().getFormattedMessage("loadAxisGlobConfFail00", inserts, "Error occurred while attempting to load Axis2 global configuration file {0}: {1}");
                    Tr.error(_tc, "loadAxisGlobConfFail00", inserts);
                    throw new Exception(msg);
                }
            }
            Object var10_14 = null;
            ClassLoader finalOldCCL222 = oldCCL;
            AccessController.doPrivileged(new PrivilegedAction(finalOldCCL222){
                final /* synthetic */ ClassLoader val$finalOldCCL;
                {
                    this.val$finalOldCCL = classLoader;
                }

                public Object run() {
                    Thread.currentThread().setContextClassLoader(this.val$finalOldCCL);
                    return null;
                }
            });
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Restored ContextClassLoader: " + AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader().toString();
                    }
                }));
            }
            if (!_tc.isEntryEnabled()) return axisCfg;
            Tr.exit(_tc, "loadAxisCfg");
            return axisCfg;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            ClassLoader finalOldCCL222 = oldCCL;
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Restored ContextClassLoader: " + AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */));
            }
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "loadAxisCfg");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void discoverAxisModules(AxisConfiguration axisCfg, ArrayList moduleList, String epid) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "discoverAxisModules, epid=" + epid);
        }
        try {
            try {
                IExtension[] extensions = PluginUtils.getDeclaredExtensions(epid);
                if (extensions != null) {
                    QOSModuleConfig moduleConfig = null;
                    for (int i = 0; i < extensions.length; ++i) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Processing extension " + extensions[i].getUniqueIdentifier());
                        }
                        URL moduleFileURL = null;
                        String globalEngage = null;
                        IConfigurationElement[] extensionConfigs = extensions[i].getConfigurationElements();
                        for (int j = 0; j < extensionConfigs.length; ++j) {
                            if (extensionConfigs[j].getName().equals("filename")) {
                                final String resourceName = extensionConfigs[j].getValue();
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Extension specified filename: " + resourceName);
                                }
                                if (resourceName == null || resourceName.equals("")) continue;
                                final Bundle bundle = Platform.getBundle(extensions[i].getNamespace());
                                moduleFileURL = bundle != null ? (URL)AccessController.doPrivileged(new PrivilegedAction(){

                                    public Object run() {
                                        return bundle.getResource(resourceName);
                                    }
                                }) : (URL)AccessController.doPrivileged(new PrivilegedAction(){

                                    public Object run() {
                                        return Thread.currentThread().getContextClassLoader().getResource(resourceName);
                                    }
                                });
                                if (moduleFileURL == null) {
                                    if (!_tc.isDebugEnabled()) continue;
                                    Object[] inserts = new Object[]{resourceName};
                                    Tr.error(_tc, "modConfLoadFail00", inserts);
                                    continue;
                                }
                                if (!_tc.isDebugEnabled()) continue;
                                Tr.debug(_tc, "Module file URL: " + moduleFileURL.toString());
                                continue;
                            }
                            if (!extensionConfigs[j].getName().equals("global")) continue;
                            globalEngage = extensionConfigs[j].getValue();
                        }
                        moduleConfig = new QOSModuleConfig();
                        moduleConfig.setURL(moduleFileURL);
                        if (globalEngage == null || globalEngage.equalsIgnoreCase("true")) {
                            moduleConfig.setEngageGlobally(true);
                        } else {
                            moduleConfig.setEngageGlobally(false);
                        }
                        moduleConfig.setClassLoader(this.getClass().getClassLoader());
                        if ("com.ibm.wsfp.main.custom-handler-server".equals(epid) || "com.ibm.wsfp.main.custom-handler-client".equals(epid) || "com.ibm.wsfp.thinclient.custom-handler-thinclient".equals(epid)) {
                            moduleConfig.setIsCustomHandler(true);
                        }
                        moduleList.add(moduleConfig);
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.discoverAxisModules", "597", this);
                Object[] inserts = new Object[]{e};
                String msg = NLSProvider.getNLS().getFormattedMessage("searchModConfFail00", inserts, "Error occurred while attempting to discover the module configuration files: {0}");
                Tr.error(_tc, "searchModConfFail00", inserts);
                throw new Exception(msg);
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "discoverAxisModules");
            throw throwable;
        }
        Object var15_17 = null;
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "discoverAxisModules");
    }

    private static void setAxisModuleName(AxisModule axisModule, OMElement moduleElement) {
        OMAttribute nameAttribute = moduleElement.getAttribute(new QName("name"));
        if (nameAttribute != null) {
            axisModule.setName(nameAttribute.getAttributeValue());
        }
    }

    private void addModule(AxisModule axisModule, AxisConfiguration axisCfg, QOSModuleConfig moduleConfig) throws AxisFault {
        Flow inflow = axisModule.getInFlow();
        ClassLoader moduleClassLoader = axisModule.getModuleClassLoader();
        try {
            Flow faultOutFlow;
            Flow faultInFlow;
            Flow outFlow;
            if (inflow != null) {
                Utils.addFlowHandlers(inflow, moduleClassLoader);
            }
            if ((outFlow = axisModule.getOutFlow()) != null) {
                Utils.addFlowHandlers(outFlow, moduleClassLoader);
            }
            if ((faultInFlow = axisModule.getFaultInFlow()) != null) {
                Utils.addFlowHandlers(faultInFlow, moduleClassLoader);
            }
            if ((faultOutFlow = axisModule.getFaultOutFlow()) != null) {
                Utils.addFlowHandlers(faultOutFlow, moduleClassLoader);
            }
            axisCfg.addModule(axisModule);
            if (moduleConfig.isEngagedGlobally()) {
                axisCfg.engageModule(axisModule, axisCfg);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "QOS engaged globally: " + axisModule.getName().toString());
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "QOS found but not engaged globally: " + axisModule.getName().toString());
            }
        }
        catch (AxisFault af) {
            FFDCFilter.processException((Throwable)af, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.addModule", "588", this);
            Object[] inserts = new Object[]{af};
            Tr.error(_tc, "addAxisModFail00", inserts);
            throw af;
        }
    }

    private void engageModules(AxisConfiguration axisCfg) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "engageModules");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "About to engage global modules...");
        }
        this.de.engageModules();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "The following modules were engaged globally:");
            for (AxisModule module : axisCfg.getEngagedModules()) {
                Tr.debug(_tc, "   " + module.getName());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "engageModules");
        }
    }

    private void initModules(AxisConfiguration axisCfg, ConfigurationContext configContext) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initModules");
        }
        Object[] keys = axisCfg.getModules().keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            AxisModule axisModule = axisCfg.getModule(key);
            Module module = axisModule.getModule();
            if (module == null) continue;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "About to init module: " + axisModule.getName().toString());
            }
            module.init(configContext, axisModule);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initModules");
        }
    }

    private void loadAxisModules(ArrayList moduleFiles, AxisConfiguration axisCfg) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadAxisModules");
        }
        InputStream is = null;
        for (int i = 0; i < moduleFiles.size(); ++i) {
            QOSModuleConfig moduleConfig = (QOSModuleConfig)moduleFiles.get(i);
            URL moduleFileURL = moduleConfig.getURL();
            if (moduleFileURL != null) {
                try {
                    is = moduleFileURL.openStream();
                    AxisModule axisModule = new AxisModule();
                    axisModule.setModuleClassLoader(moduleConfig.getClassLoader());
                    ModuleBuilder tmpModuleBuilder = new ModuleBuilder(is, axisModule, axisCfg);
                    OMElement rootElement = tmpModuleBuilder.buildOM();
                    WASAxis2ConfigurationBuilder.setAxisModuleName(axisModule, rootElement);
                    if (moduleConfig.isCustomHandler()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Processing custom handler XML file: " + moduleConfig.getURL());
                        }
                        try {
                            this.checkPhaseConstraints(rootElement);
                        }
                        catch (DeploymentException e) {
                            Tr.error(_tc, e.getMessage());
                        }
                    }
                    tmpModuleBuilder = null;
                    is.close();
                    is = moduleFileURL.openStream();
                    ModuleBuilder moduleBuilder = new ModuleBuilder(is, axisModule, axisCfg);
                    moduleBuilder.populateModule();
                    this.addModule(axisModule, axisCfg, moduleConfig);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.loadAxisModules", "684", this);
                    Object[] inserts = new Object[]{e};
                    Tr.error(_tc, "loadModConfFileFail00", inserts);
                }
                continue;
            }
            Tr.warning(_tc, "badUrlModLoadFail00");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadAxisModules");
        }
    }

    void checkPhaseConstraints(OMElement rootElement) throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkPhaseConstraints");
        }
        Iterator elementIter = rootElement.getChildrenWithName(new QName("InFlow"));
        while (elementIter.hasNext()) {
            this.checkFlowElement((OMElement)elementIter.next(), "CustomHandlerInPhase");
        }
        elementIter = rootElement.getChildrenWithName(new QName("InFaultFlow"));
        while (elementIter.hasNext()) {
            this.checkFlowElement((OMElement)elementIter.next(), "CustomHandlerInFaultPhase");
        }
        elementIter = rootElement.getChildrenWithName(new QName("OutFlow"));
        while (elementIter.hasNext()) {
            this.checkFlowElement((OMElement)elementIter.next(), "CustomHandlerOutPhase");
        }
        elementIter = rootElement.getChildrenWithName(new QName("OutFaultFlow"));
        while (elementIter.hasNext()) {
            this.checkFlowElement((OMElement)elementIter.next(), "CustomHandlerOutFaultPhase");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkPhaseConstraints");
        }
    }

    void checkFlowElement(OMElement flowElement, String insertionPhase) throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkFlowElement");
        }
        Iterator handlerIter = flowElement.getChildrenWithName(new QName("handler"));
        while (handlerIter.hasNext()) {
            OMElement handlerElement = (OMElement)handlerIter.next();
            String name = handlerElement.getAttributeValue(new QName("name"));
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Processing custom handler: " + name);
            }
            Iterator orderIter = handlerElement.getChildrenWithName(new QName("order"));
            String msg = null;
            if (!orderIter.hasNext()) {
                msg = NLSProvider.getNLS().getFormattedMessage("customHandlerFail00", new Object[]{name}, "The {0} custom handler did not define a phase, or it defined a phase which is not allowed for custom handlers.");
                throw new DeploymentException(msg);
            }
            while (orderIter.hasNext()) {
                OMElement orderElement = (OMElement)orderIter.next();
                String phase = orderElement.getAttributeValue(new QName("phase"));
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Custom handler being added to phase: " + phase);
                }
                if (phase != null && phase.equals(insertionPhase)) continue;
                msg = NLSProvider.getNLS().getFormattedMessage("customHandlerFail00", new Object[]{name}, "The {0} custom handler did not define a phase, or it defined a phase which is not allowed for custom handlers.");
                throw new DeploymentException(msg);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkFlowElement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void discoverTCMPlugins(String epid, ArrayList pluginList) throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "discoverTCMPlugins, epid=" + epid);
        }
        try {
            try {
                IExtension[] extensions = PluginUtils.getDeclaredExtensions(epid);
                if (extensions != null) {
                    for (int i = 0; i < extensions.length; ++i) {
                        IConfigurationElement[] extensionConfigs = extensions[i].getConfigurationElements();
                        for (int j = 0; j < extensionConfigs.length; ++j) {
                            if (!extensionConfigs[j].getName().equals("plugin")) continue;
                            final IConfigurationElement extConfig = extensionConfigs[j];
                            Object configObject = AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    try {
                                        return extConfig.createExecutableExtension("class");
                                    }
                                    catch (Exception e) {
                                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.discoverTCMPlugins", "829", this);
                                        Object[] inserts = new Object[]{e};
                                        Tr.error(_tc, "threadContextMigratorFail00", inserts);
                                        return null;
                                    }
                                }
                            });
                            String id = extensionConfigs[j].getAttribute("id");
                            if (id == null || id.equals("")) {
                                String msg = NLSProvider.getNLS().getFormattedMessage("tcmExtNoValue00", new Object[0], "The [id] attribute of the plugin element for the ''ThreadContextMigrator'' extension has no value.");
                                throw new DeploymentException(msg);
                            }
                            if (!(configObject instanceof ThreadContextMigrator)) {
                                Object[] inserts = new Object[]{extensionConfigs[j].getAttribute("class")};
                                String msg = NLSProvider.getNLS().getFormattedMessage("invalidTCMInterface00", inserts, "Invalid class {0} did not implement the ThreadContextMigrator interface.");
                                throw new DeploymentException(msg);
                            }
                            ThreadContextMigrator migrator = (ThreadContextMigrator)configObject;
                            TCMPluginConfig pluginConfig = new TCMPluginConfig(migrator, id);
                            pluginList.add(pluginConfig);
                        }
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.discoverTCMPlugins", "872", this);
                Object[] inserts = new Object[]{e};
                Tr.error(_tc, "threadContextMigratorFail00", inserts);
                Object var13_15 = null;
                if (!_tc.isEntryEnabled()) return;
                Tr.exit(_tc, "discoverTCMPlugins, epid=" + epid);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "discoverTCMPlugins, epid=" + epid);
            throw throwable;
        }
        Object var13_14 = null;
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "discoverTCMPlugins, epid=" + epid);
    }

    private void registerTCMPlugins(ArrayList pluginList, ConfigurationContext configContext) throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "registerTCMPlugins");
        }
        try {
            if (!pluginList.isEmpty()) {
                for (TCMPluginConfig pluginConfig : pluginList) {
                    ThreadContextMigratorUtil.addThreadContextMigrator(configContext, pluginConfig.getPluginID(), pluginConfig.getMigrator());
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "The ThreadContextMigrator: " + pluginConfig.getMigrator().getClass() + " has been registered with the ConfigurationContext");
                }
            }
        }
        catch (AxisFault af) {
            throw new DeploymentException(af);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "registerTCMPlugins");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void discoverACMPlugins(String epid, ArrayList pluginList) throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "discoverACMPlugins, epid=" + epid);
        }
        try {
            try {
                IExtension[] extensions = PluginUtils.getDeclaredExtensions(epid);
                if (extensions != null) {
                    for (int i = 0; i < extensions.length; ++i) {
                        IConfigurationElement[] extensionConfigs = extensions[i].getConfigurationElements();
                        for (int j = 0; j < extensionConfigs.length; ++j) {
                            if (!extensionConfigs[j].getName().equals("plugin")) continue;
                            final IConfigurationElement extConfig = extensionConfigs[j];
                            Object configObject = AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    try {
                                        return extConfig.createExecutableExtension("class");
                                    }
                                    catch (Exception e) {
                                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.discoverACMPlugins", "941", this);
                                        Object[] inserts = new Object[]{e};
                                        Tr.error(_tc, "applicationContextMigratorFail00", inserts);
                                        return null;
                                    }
                                }
                            });
                            String id = extensionConfigs[j].getAttribute("id");
                            if (id == null || id.equals("")) {
                                String msg = NLSProvider.getNLS().getFormattedMessage("acmExtNoValue00", new Object[0], "The [id] attribute of the plugin element for the ''ApplicationContextMigrator'' extension has no value.");
                                throw new DeploymentException(msg);
                            }
                            if (!(configObject instanceof ApplicationContextMigrator)) {
                                Object[] inserts = new Object[]{extensionConfigs[j].getAttribute("class")};
                                String msg = NLSProvider.getNLS().getFormattedMessage("invalidACMInterface00", inserts, "Invalid class {0} did not implement the ApplicationContextMigrator interface.");
                                throw new DeploymentException(msg);
                            }
                            ApplicationContextMigrator migrator = (ApplicationContextMigrator)configObject;
                            ACMPluginConfig pluginConfig = new ACMPluginConfig(migrator, id);
                            pluginList.add(pluginConfig);
                        }
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder.discoverACMPlugins", "992", this);
                Object[] inserts = new Object[]{e};
                Tr.error(_tc, "applicationContextMigratorFail00", inserts);
                Object var13_15 = null;
                if (!_tc.isEntryEnabled()) return;
                Tr.exit(_tc, "discoverACMPlugins, epid=" + epid);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "discoverACMPlugins, epid=" + epid);
            throw throwable;
        }
        Object var13_14 = null;
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "discoverACMPlugins, epid=" + epid);
    }

    private void registerACMPlugins(ArrayList pluginList, ConfigurationContext configContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "registerACMPlugins");
        }
        if (!pluginList.isEmpty()) {
            for (ACMPluginConfig pluginConfig : pluginList) {
                ApplicationContextMigratorUtil.addApplicationContextMigrator(configContext, pluginConfig.getPluginID(), pluginConfig.getMigrator());
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "The ApplicationContextMigrator: " + pluginConfig.getMigrator().getClass() + " has been registered with the ConfigurationContext");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "registerACMPlugins");
        }
    }
}

