/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorerUtils;
import com.ibm.ws.websvcs.deployment.ModuleFileExplorer;
import com.ibm.ws.websvcs.deployment.ModuleFileLocator;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.webapplication.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WARFileExplorer
extends ModuleFileExplorer
implements FileExplorer {
    private static final TraceComponent _tc = Tr.register(WARFileExplorer.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private WARFile warFile;
    private boolean wasOpened = false;
    private List<Archive> archiveList;
    private List<String> classesFound;
    private String appName;
    private ClassLoader classLoader;

    public WARFileExplorer(WARFile wf) {
        this(wf, wf.getArchiveClassLoader());
    }

    public WARFileExplorer(WARFile wf, ClassLoader classLoader) {
        super(wf, classLoader);
        this.warFile = wf;
        this.classLoader = classLoader;
        this.archiveList = new ArrayList<Archive>();
        this.classesFound = new LinkedList<String>();
        this.appName = Axis2Utils.getApplicationName(wf);
    }

    @Override
    public List<FileLocator> explore() throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "explore(" + this.warFile.getName() + ")");
        }
        List<FileLocator> locators = new ArrayList<FileLocator>();
        if (this.shouldFilterArchive(this.warFile.getName())) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "WAR file " + this.warFile.getName() + " will be filtered from annotation scanning.");
            }
            return locators;
        }
        WebApp webApp = this.warFile.getDeploymentDescriptor(false);
        if (webApp.isMetadataComplete()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "WAR file " + this.warFile.getName() + " specifies metadata " + "complete. Annotation scanning for the module will begin from the " + "relevant deployment descriptors.");
            }
            locators = this.getClassesFromDDs(this.warFile, this.classLoader);
            return locators;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "WAR file " + this.warFile.getName() + " does not specify " + "metadata complete. \nThe module will be scanned for annotations, " + "subject to annotation scanning filtering.");
        }
        if (!FileExplorerUtils.isExtracted(this.warFile)) {
            WARFile tempFile = this.warFile;
            this.warFile = (WARFile)FileExplorerUtils.extractModuleFile(this.warFile, this);
            if (this.warFile == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "A null WARFile was returned after extracting... resetting to original WARFile object");
                }
                this.warFile = tempFile;
            } else {
                this.wasOpened = true;
            }
        }
        EList fileList = this.warFile.getFiles();
        for (File file : fileList) {
            if (file.isArchive() && file.getName().contains(".jar") && file.getDirectoryURI().contains("WEB-INF/lib")) {
                if (!this.shouldFilterArchive(file.getName())) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding archive " + file.getName() + " to our list of nested archives to be explored.");
                    }
                    this.archiveList.add((Archive)file);
                    continue;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Archive " + file.getName() + " will be filtered from annotation scanning.");
                continue;
            }
            this.classesFound.add(this.getQualifiedClassName(file.getURI()));
            super.queryFile(file, "WEB-INF/classes", locators);
        }
        for (Archive archive : this.archiveList) {
            this.exploreJar(archive, locators);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "explore(" + this.warFile.getName() + ")");
        }
        return locators;
    }

    private void exploreJar(Archive archive, List<FileLocator> locators) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Exploring archive " + archive.getName() + ".");
        }
        EList fileList = archive.getFiles();
        for (File file : fileList) {
            String fileName = file.getURI();
            if (fileName.length() <= 6 || !fileName.endsWith(".class")) continue;
            if (!this.shouldFilterJavaClassFileURI(fileName)) {
                if (!this.classesFound.contains(fileName)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding class file: " + fileName + " to list of locators.");
                    }
                    ModuleFileLocator locator = new ModuleFileLocator(file, fileName, this.warFile.getName());
                    locators.add(locator);
                    continue;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "The class file: " + fileName + " in the " + archive.getName() + " archive within the " + this.warFile.getName() + " WAR was already found " + "in the WEB-INF/classes directory and will not be read from the archive");
                continue;
            }
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "Class file: " + fileName + " will be filtered from annotation scanning.");
        }
    }

    String getQualifiedClassName(String uri) {
        if (uri.startsWith("WEB-INF/classes")) {
            int startIndex = "WEB-INF/classes".length() + 1;
            if (uri.length() > startIndex) {
                uri = uri.substring(startIndex, uri.length());
            }
        }
        return uri;
    }

    @Override
    public void cleanUp() {
        if (this.wasOpened) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Closing WAR file: " + this.warFile.getName());
            }
            this.warFile.close();
            for (Archive archive : this.archiveList) {
                if (!archive.isOpen()) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Closing nested archive: " + archive.getName());
                }
                archive.close();
            }
            Axis2Utils.deleteExtractedApp(this.appName, this.warFile.getName());
        }
    }

    public class WARSaveFilter
    implements SaveFilter {
        public boolean shouldSave(String uri, Archive warFile) {
            if (uri.endsWith(".class")) {
                return true;
            }
            if (uri.endsWith(".jar")) {
                return true;
            }
            return uri.endsWith(".xml");
        }
    }
}

