/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ArchiveMemberFileLocator;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.deployment.ArchiveFileLocator;
import com.ibm.ws.websvcs.deployment.WASAxis2DescriptionBuilder;
import java.io.InputStream;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;

public class ModuleFileLocator
implements ArchiveMemberFileLocator,
ArchiveFileLocator,
Constants {
    private File file;
    private String name;
    private String containerPath;
    private static final TraceComponent _tc = Tr.register(WASAxis2DescriptionBuilder.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public ModuleFileLocator(File file, String name, String containerPath) {
        this.file = file;
        this.name = name;
        this.containerPath = containerPath;
    }

    public InputStream getInputStream() {
        try {
            return this.file.getInputStream();
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.deployment.ModuleFileLocator.getInputStream", "53", this);
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getContainerPath() {
        return this.containerPath;
    }

    public String getArchiveRelativeName() {
        Container cc;
        String value = null;
        Container c = this.file.getLoadingContainer();
        if (c != null && c.isArchive() && (cc = c.getLoadingContainer()) != null) {
            value = c.getURI();
        }
        return value;
    }

    public InputStream getArchiveInputStream() {
        try {
            String archiveName = this.getArchiveRelativeName();
            if (archiveName == null) {
                return null;
            }
            Container c = this.file.getLoadingContainer();
            Container cc = c.getLoadingContainer();
            return cc.getInputStream(archiveName);
        }
        catch (Throwable t) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The input stream is not available because " + t.toString());
            }
            return null;
        }
    }

    public String getRelativeName() {
        return this.file.getURI();
    }
}

