/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.webservices.utils.ClassUtils;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.utils.WSAnnotationScanningFilter;
import com.ibm.ws.websvcs.deployment.DDFileLocator;
import com.ibm.ws.websvcs.deployment.ModuleFileLocator;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.webservices.models.WSModels;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jws.WebService;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleFileExplorer
implements Constants {
    private static final TraceComponent tc = Tr.register(ModuleFileExplorer.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    protected WSAnnotationScanningFilter asf = null;

    protected ModuleFileExplorer(Archive theArchive, ClassLoader classLoader) {
        if (theArchive != null) {
            this.asf = new WSAnnotationScanningFilter(theArchive, classLoader);
        }
    }

    protected boolean shouldFilterArchive(String archiveName) {
        return this.asf != null && this.asf.filterArchive(archiveName);
    }

    protected boolean shouldFilterPackage(String packageOrClassName) {
        return this.asf != null && this.asf.filterPackage(packageOrClassName);
    }

    protected boolean shouldFilterJavaClassFileURI(String classFileURI) {
        return this.shouldFilterPackage(this.getJavaClassNameFromClassFileURI(classFileURI));
    }

    protected void queryFile(File file, String rootDir, List<FileLocator> locators) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "queryFile() is considering " + file.getURI() + " with root dir " + (rootDir == null ? "<null>" : rootDir) + "");
        }
        if (file.getName().length() > 6 && file.getName().toLowerCase().endsWith(".class") && (rootDir == null || file.getDirectoryURI().contains(rootDir))) {
            String containerPath = Axis2Utils.getFileContainerPath(file);
            String classFileURI = file.getURI();
            if (rootDir != null) {
                classFileURI = classFileURI.substring(classFileURI.indexOf(rootDir) + rootDir.length() + 1);
            }
            if (!this.shouldFilterJavaClassFileURI(classFileURI)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding class file " + classFileURI + " to our locator list.");
                }
                ModuleFileLocator locator = new ModuleFileLocator(file, classFileURI, containerPath);
                locators.add(locator);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Class file " + classFileURI + " is filtered out from annotation scanning.");
            }
        }
    }

    protected String getJavaClassNameFromClassFileURI(String classFileURI) {
        return classFileURI.substring(0, classFileURI.indexOf(".class")).replace('/', '.');
    }

    protected List<FileLocator> getClassesFromDDs(ModuleFile moduleFile, ClassLoader classLoader) throws DeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassesFromDDs, moduleFile= " + moduleFile.getName());
        }
        LinkedList<FileLocator> locators = new LinkedList<FileLocator>();
        String xmlFileName = null;
        if (moduleFile.isWARFile()) {
            xmlFileName = "WEB-INF/webservices.xml";
        } else if (moduleFile.isEJBJarFile()) {
            xmlFileName = "META-INF/webservices.xml";
        } else {
            return locators;
        }
        WebServices webServices = WSModels.getWebServices(moduleFile.getLoadStrategy(), xmlFileName);
        if (webServices != null) {
            LinkedList<WebServiceDescription> wsdList = new LinkedList<WebServiceDescription>();
            for (WebServiceDescription wsd : webServices.getWebServiceDescriptions()) {
                Iterator pcIter = wsd.getPortComponents().iterator();
                if (!pcIter.hasNext()) continue;
                PortComponent pc = (PortComponent)pcIter.next();
                String seiName = pc.getServiceEndpointInterface();
                if (seiName == null || "".equals(seiName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The " + pc.getPortComponentName() + " port component is " + "a JAX-WS port component because it does not specify a service-" + "endpoint-interface.");
                    }
                    wsdList.add(wsd);
                    continue;
                }
                try {
                    Class clazz = ClassUtils.forName(seiName, false, classLoader);
                    if (clazz.getAnnotation(WebService.class) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The " + pc.getPortComponentName() + " port component is " + "a JAX-WS port component because the " + seiName + " service-" + "endpoint-interface class has an @WebService annotation.");
                        }
                        wsdList.add(wsd);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "The " + pc.getPortComponentName() + " port component is " + "a JAX-RPC port component because the " + seiName + " service-" + "endpoint-interface class does not have an @WebService annotation.");
                }
                catch (ClassNotFoundException e) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("locateClassFail01", new Object[]{seiName, moduleFile.getName()}, "The {0} service-endpoint-interface class specified by the webservices.xml in the {1} module cannot be located.");
                    throw new DeploymentException(msg);
                }
            }
            if (!wsdList.isEmpty()) {
                this.populateLocatorListFromServerDD(moduleFile, wsdList, locators, classLoader);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassesFromDDs, moduleFile= " + moduleFile.getName() + ", locator size= " + locators.size());
        }
        return locators;
    }

    void populateLocatorListFromServerDD(ModuleFile moduleFile, List<WebServiceDescription> wsdList, List<FileLocator> locators, ClassLoader classLoader) throws DeploymentException {
        try {
            for (WebServiceDescription wsd : wsdList) {
                for (PortComponent pc : wsd.getPortComponents()) {
                    String msg;
                    String linkString;
                    String seiName = pc.getServiceEndpointInterface();
                    if (seiName != null) {
                        FileLocator locator = this.getFileLocatorFromClassName(seiName, moduleFile.getName(), classLoader);
                        locators.add(locator);
                    }
                    if (moduleFile instanceof WARFile) {
                        linkString = pc.getServiceImplBean().getEServletLink() != null ? pc.getServiceImplBean().getEServletLink().getServletLink() : null;
                        WARFile warFile = (WARFile)moduleFile;
                        Servlet servlet = warFile.getDeploymentDescriptor().getServletNamed(linkString);
                        if (servlet == null) {
                            msg = NLSProvider.getNLS().getFormattedMessage("servletLinkFail00", new Object[]{linkString, pc.getPortComponentName(), warFile.getName()}, "The {0} servlet-link value was specified by the {1} port-component in the webservices.xml within the {2} module, but a servlet with that name was not found.");
                            throw new DeploymentException(msg);
                        }
                        String implClass = servlet.getServletClass().getQualifiedName();
                        FileLocator locator = this.getFileLocatorFromClassName(implClass, warFile.getName(), classLoader);
                        locators.add(locator);
                        continue;
                    }
                    if (!(moduleFile instanceof EJBJarFile)) continue;
                    linkString = pc.getServiceImplBean().getEEJBLink() != null ? pc.getServiceImplBean().getEEJBLink().getEjbLink() : null;
                    EJBJarFile ejbJar = (EJBJarFile)moduleFile;
                    EnterpriseBean bean = ejbJar.getDeploymentDescriptor().getEnterpriseBeanNamed(linkString);
                    if (bean == null) {
                        msg = NLSProvider.getNLS().getFormattedMessage("ejbLinkFail00", new Object[]{linkString, pc.getPortComponentName(), moduleFile.getName()}, "The {0} ejb-link value was specified by the {1} port-component in the webservices.xml within the {2} module, but an enterprise bean with that name was not found.");
                        throw new DeploymentException(msg);
                    }
                    FileLocator locator = this.getFileLocatorFromClassName(bean.getEjbClassName(), moduleFile.getName(), classLoader);
                    locators.add(locator);
                }
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DeploymentException(t.getMessage(), t);
        }
    }

    FileLocator getFileLocatorFromClassName(String className, String moduleName, ClassLoader classLoader) throws DeploymentException {
        URL url;
        String originalClassName = className;
        DDFileLocator fileLocator = null;
        if (className.indexOf(".") != -1) {
            className = className.replace(".", "/");
        }
        if (!className.endsWith(".class")) {
            className = className + ".class";
        }
        if ((url = classLoader.getResource(className)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Constructed FileLocator for class: " + className);
            }
        } else {
            String msg = NLSProvider.getNLS().getFormattedMessage("locateClassFail00", new Object[]{originalClassName, moduleName}, "Web service metadata for the JAX-WS Web service cannot be completed because the {0} class indicated by a deployment descriptor in the {1} module cannot be located.");
            throw new DeploymentException(msg);
        }
        fileLocator = new DDFileLocator(url, url.toString(), className);
        return fileLocator;
    }
}

