/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.shared.cache.CacheRootDirectoryTLS;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.deployment.ArchiveFileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.WARFileExplorer;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.io.File;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;

public class FileExplorerUtils {
    private static final TraceComponent _tc = Tr.register(FileExplorerUtils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public static CommonarchiveFactory getCommonArchiveFactory() {
        CommonarchiveFactory archiveFactory = null;
        try {
            archiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("commonarchive.xmi").getEFactoryInstance();
            return archiveFactory;
        }
        catch (Throwable t) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Could not get CommonarchiveFactory using registry due to the error: " + t.toString() + ". Using known archive factory");
            }
            archiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            return archiveFactory;
        }
    }

    public static boolean isExtracted(ModuleFile moduleFile) {
        if (moduleFile.getLoadStrategy().isDirectory()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The module file: " + moduleFile.getName() + " has been " + "extracted to the installed apps directory");
            }
            return true;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "The module file: " + moduleFile.getName() + " has not been " + "extracted to the installed apps directory");
        }
        return false;
    }

    public static synchronized ModuleFile extractModuleFile(ModuleFile moduleFile, FileExplorer explorer) {
        String tempExtractLoc = FileExplorerUtils.getExtractLocation(moduleFile);
        SaveFilter saveFilter = moduleFile.getSaveFilter();
        boolean isWar = false;
        if (tempExtractLoc != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Temporarily extracting module file: " + moduleFile.getName() + " to " + "location: " + tempExtractLoc + " to create FileLocators.");
            }
            try {
                if (explorer instanceof WARFileExplorer) {
                    WARFileExplorer wfe = (WARFileExplorer)explorer;
                    moduleFile.setSaveFilter(new WARFileExplorer.WARSaveFilter(wfe));
                    isWar = true;
                } else if (explorer instanceof ArchiveFileExplorer) {
                    ArchiveFileExplorer archiveFE = (ArchiveFileExplorer)explorer;
                    moduleFile.setSaveFilter(archiveFE.new ArchiveFileExplorer.ArchiveSaveFilter());
                }
                File extractDir = new File(tempExtractLoc);
                if (extractDir.isDirectory()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Module: " + moduleFile.getName() + " has already been " + "extracted to the temp workspace... opening from that location");
                    }
                    CommonarchiveFactory factory = FileExplorerUtils.getCommonArchiveFactory();
                    ArchiveOptions options = new ArchiveOptions();
                    options.setUseJavaReflection(true);
                    options.setIsReadOnly(false);
                    moduleFile.setSaveFilter(saveFilter);
                    if (isWar) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Opening WAR file: " + moduleFile.getName());
                        }
                        moduleFile = factory.openWARFile(options, tempExtractLoc);
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Opening EJB JAR file: " + moduleFile.getName());
                        }
                        moduleFile = factory.openEJBJarFile(options, tempExtractLoc);
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Module: " + moduleFile.getName() + " has not been " + "extracted to the temp workspace... extracting then opening " + "from that location");
                    }
                    moduleFile.extractTo(tempExtractLoc, 0);
                    CommonarchiveFactory factory = FileExplorerUtils.getCommonArchiveFactory();
                    ArchiveOptions options = new ArchiveOptions();
                    options.setUseJavaReflection(true);
                    options.setIsReadOnly(false);
                    moduleFile.setSaveFilter(saveFilter);
                    if (isWar) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Opening WAR file: " + moduleFile.getName());
                        }
                        moduleFile = factory.openWARFile(options, tempExtractLoc);
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Opening EBJ JAR file: " + moduleFile.getName());
                        }
                        moduleFile = factory.openEJBJarFile(options, tempExtractLoc);
                    }
                }
                return moduleFile;
            }
            catch (Throwable t) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Module file: " + moduleFile.getName() + " could not be extracted " + "to temporary location to create FileLocators: " + t.toString());
                }
                return null;
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Module file: " + moduleFile.getName() + " needed to be extracted " + "to temporary location but the temporary location could not be found");
        }
        return null;
    }

    private static String getExtractLocation(ModuleFile moduleFile) {
        String fileSep = File.separator;
        String extractLoc = null;
        extractLoc = CacheRootDirectoryTLS.get() == null ? Axis2Utils.getCacheDirectory() + WebServiceUtils.getApplicationName(moduleFile) + fileSep + moduleFile.getName() : CacheRootDirectoryTLS.get();
        extractLoc = extractLoc + fileSep + "installExtract" + fileSep;
        extractLoc = moduleFile.getContainer() != null ? extractLoc + moduleFile.getContainer().getName() + fileSep + moduleFile.getName() + fileSep : extractLoc + moduleFile.getName() + fileSep;
        return extractLoc;
    }
}

