/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deployment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.ModuleFileExplorer;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.ejb.EJBJar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveFileExplorer
extends ModuleFileExplorer
implements FileExplorer,
Constants {
    private static final TraceComponent _tc = Tr.register(ArchiveFileExplorer.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private Archive archive;
    private boolean wasOpened = false;
    private String appName;
    private ClassLoader classLoader;

    public ArchiveFileExplorer(Archive archive) {
        this(archive, archive.getArchiveClassLoader());
    }

    public ArchiveFileExplorer(Archive archive, ClassLoader classLoader) {
        super(archive, classLoader);
        this.archive = archive;
        this.classLoader = classLoader;
        this.appName = Axis2Utils.getApplicationName(archive);
    }

    @Override
    public List<FileLocator> explore() throws DeploymentException {
        EJBJar ejbJar;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "explore(" + this.archive.getName() + ")");
        }
        List<FileLocator> locators = new ArrayList<FileLocator>();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Exploring Archive file: " + this.archive.getName());
        }
        if (this.shouldFilterArchive(this.archive.getName())) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Archive file " + this.archive.getName() + " will be filtered from annotation scanning.");
            }
            return locators;
        }
        if (this.archive instanceof EJBJarFile && (ejbJar = ((EJBJarFile)this.archive).getDeploymentDescriptor()).isMetadataComplete()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The " + this.archive.getName() + " EJB module specifies metadata " + "complete. Annotation scanning for the module will begin from the " + "relevant deployment descriptors.");
            }
            locators = this.getClassesFromDDs((EJBJarFile)this.archive, this.classLoader);
            return locators;
        }
        EList fileList = this.archive.getFiles();
        for (File file : fileList) {
            if (file.isArchive()) continue;
            super.queryFile(file, null, locators);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "explore(" + this.archive.getName() + ")");
        }
        return locators;
    }

    @Override
    public void cleanUp() {
        if (this.wasOpened) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Closing Archive: " + this.archive.getName());
            }
            this.archive.close();
            Axis2Utils.deleteExtractedApp(this.appName, this.archive.getName());
        }
    }

    public class ArchiveSaveFilter
    implements SaveFilter {
        public boolean shouldSave(String uri, Archive warFile) {
            if (uri.endsWith(".class")) {
                return true;
            }
            return uri.endsWith(".xml");
        }
    }
}

