/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.ws.webservices.deploy.PluginCfgHelper;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilder;
import com.ibm.wsspi.websvcs.desc.WSDescriptionBuilderFactory;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class URLPatternHelper {
    private static final TraceComponent _tc = Tr.register(URLPatternHelper.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");

    public static List getWebServicesUrlPatterns(EARFile earFile, List deployedModules, Module m) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWebServicesUrlPatterns");
        }
        List urlPatterns = URLPatternHelper.getJAXWSWebServicesUrlPatterns(earFile, deployedModules, m);
        List jaxrpcPatterns = URLPatternHelper.getJAXRPCWebServicesUrlPatterns(earFile, deployedModules, m);
        if (jaxrpcPatterns != null) {
            urlPatterns.addAll(jaxrpcPatterns);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWebServicesUrlPatterns, urlPatterns=" + urlPatterns.toString());
        }
        return urlPatterns;
    }

    public static List getJAXWSWebServicesUrlPatterns(EARFile earFile, List unused, Module m) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getJAXWSWebServicesUrlPatterns");
        }
        LinkedList<String> urlPatterns = new LinkedList<String>();
        ModuleFile mf = earFile.getModuleRef(m).getModuleFile();
        if (_tc.isDebugEnabled()) {
            Application app = earFile.getDeploymentDescriptor();
            Tr.debug(_tc, "Application: " + app.getDisplayName() + "[" + earFile.getName() + "], module: " + mf.getName());
        }
        WSDescriptionBuilder descBuilder = WSDescriptionBuilderFactory.getBuilder();
        WSModuleDescriptor modDesc = descBuilder.getModuleDescriptor(mf);
        Iterator svcIter = modDesc.getJAXWSServices();
        while (svcIter.hasNext()) {
            WSServiceDescriptor svcDesc = (WSServiceDescriptor)svcIter.next();
            if (!svcDesc.isJAXWSService()) continue;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found JAX-WS Service: " + svcDesc.getQName().toString());
            }
            Iterator endptIter = svcDesc.getEndpoints();
            while (endptIter.hasNext()) {
                WSEndpointDescriptor endptDesc = (WSEndpointDescriptor)endptIter.next();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found JAX-WS endpoint(port): " + endptDesc.getName());
                }
                String pattern = endptDesc.getURLPattern();
                urlPatterns.add(pattern);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Added pattern: " + pattern);
                }
                if (!pattern.endsWith("/")) {
                    pattern = pattern + "/";
                }
                pattern = pattern + "*";
                urlPatterns.add(pattern);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Added pattern: " + pattern);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getJAXWSWebServicesUrlPatterns, urlPatterns=" + ((Object)urlPatterns).toString());
        }
        return urlPatterns;
    }

    public static List getJAXRPCWebServicesUrlPatterns(EARFile earFile, List deployedModules, Module m) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getJAXRPCWebServicesUrlPatterns");
        }
        List urlPatterns = PluginCfgHelper.getWebServicesUrlPatterns((EARFile)earFile, (List)deployedModules, (Module)m);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getJAXRPCWebServicesUrlPatterns, urlPatterns=" + urlPatterns.toString());
        }
        return urlPatterns;
    }
}

