/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.deploy.CacheDeployUtils;
import com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class PersistentStorageUninstallTask
extends AbstractTask
implements Constants {
    private static final TraceComponent tc = Tr.register(PersistentStorageUninstallTask.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        String rootDir = Axis2Utils.getCacheDirectory();
        String appName = this.scheduler.getAppName();
        if (rootDir != null) {
            String cacheDir = rootDir + this.scheduler.getAppName();
            File file = new File(cacheDir);
            if (file.exists() && file.isDirectory() && file.listFiles().length > 0) {
                CacheDeployUtils.removeDirectory(file.listFiles());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing web services cache file: " + file.getAbsolutePath());
            }
            file.delete();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removed cached objects for application: " + appName);
            }
        }
        EARFile earFile = null;
        try {
            earFile = CacheDeployUtils.getEARFile(this.getResourceBundle(), this.scheduler);
            if (earFile != null) {
                List mods;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got the EARFile from workspace: " + earFile.getName());
                }
                if ((mods = earFile.getModuleFiles()) != null && !mods.isEmpty()) {
                    for (ModuleFile moduleFile : mods) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Attempting to clear cache for module " + moduleFile.getName() + " in application " + earFile.getName() + " for update");
                        }
                        WSModuleDescriptorImpl.clearCache(moduleFile, appName);
                    }
                }
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                Tr.debug(tc, "Error occurred trying to clear web services cache for application update: \n" + sw.toString());
            }
        }
        finally {
            if (earFile != null && !(this.scheduler instanceof InstallScheduler)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Closing EARFile: " + earFile.getName());
                }
                earFile.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }
}

