/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.ws.webservices.shared.cache.CacheRootDirectoryTLS;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.deploy.CacheDeployUtils;
import com.ibm.ws.websvcs.deploy.WSCacheWriter;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.config.ConfigServiceFactory;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webservices.models.WSModels;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class PersistentStorageInstallSaveTask
extends AbstractAppSyncTask {
    private static final TraceComponent tc = Tr.register(PersistentStorageInstallSaveTask.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private ConfigService _configService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigService getConfigService() {
        block14: {
            if (this._configService != null) {
                return this._configService;
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getConfigService");
            }
            try {
                this._configService = WsServiceRegistry.getService((Object)this, ConfigService.class);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                if (this._configService == null) {
                    ConfigRepository repository = ConfigRepositoryFactory.getConfigRepository();
                    Properties repositoryConfig = repository.getConfig();
                    String rootDir = repositoryConfig.getProperty("was.repository.root");
                    this._configService = ConfigServiceFactory.createConfigService(rootDir, this._cellName, this._nodeName, null, null);
                }
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug(tc, "ConfigService: " + (this._configService == null ? "<null>" : this._configService.toString()));
            }
            catch (Throwable t) {
                block15: {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "There was an error trying to obtain the ConfigService: : " + t.toString());
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            t.printStackTrace(pw);
                            Tr.debug(tc, sw.toString());
                        }
                        if (!tc.isDebugEnabled()) break block15;
                        Tr.debug(tc, "ConfigService: " + (this._configService == null ? "<null>" : this._configService.toString()));
                    }
                    catch (Throwable throwable) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ConfigService: " + (this._configService == null ? "<null>" : this._configService.toString()));
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getConfigService");
                        }
                        throw throwable;
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConfigService");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigService");
        }
        return this._configService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performTask(AppData cachedAppData, AppData newAppData, Hashtable props) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        CacheRootDirectoryTLS.set(null);
        ConfigObject appDeployment = null;
        WSCacheWriter cacheWriter = null;
        appDeployment = this.getAppDeployment(newAppData);
        String appName = newAppData.getAppName();
        if (this.appIsDeployedOnNode(newAppData.getAppName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App deployed on node, using this EAR location: " + newAppData.getBinURL());
            }
            cacheWriter = new WSCacheWriter(newAppData.getBinURL(), appName);
        } else {
            String binPath = null;
            if (newAppData.getEAR() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting binaries path from ear file");
                }
                binPath = newAppData.getEAR().getBinariesPath();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting binaries path from app data");
                }
                binPath = newAppData.getBinURL();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "App not deployed on  node, using this EAR location: " + binPath);
            }
            cacheWriter = new WSCacheWriter(binPath, appName);
        }
        try {
            if (appDeployment != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "About to call WSModels.preInvoke()");
                }
                WSModels.preInvoke(appDeployment);
            }
            this.deleteExistingCacheFiles((EARFile)newAppData.getEAR(), appName);
            CacheRootDirectoryTLS.set(Axis2Utils.getCacheDirectory() + File.separator);
            cacheWriter.writeApplicationCache(true);
        }
        catch (Throwable t) {
            CacheDeployUtils.removeCacheDirectory(cachedAppData, newAppData);
        }
        finally {
            if (appDeployment != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "About to call WSModels.postInvoke()");
                }
                WSModels.postInvoke(appDeployment);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
        }
        return true;
    }

    void deleteExistingCacheFiles(EARFile earFile, String appName) {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "deleteExistingCacheFiles");
        }
        if (earFile != null) {
            String root = Axis2Utils.getCacheDirectory();
            if (root == null || earFile.getModuleFiles() == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Possible existing cache cannot be deleted before install");
                }
                return;
            }
            root = root + appName + File.separator;
            Iterator moduleFileIter = earFile.getModuleFiles().iterator();
            while (moduleFileIter.hasNext()) {
                File file;
                String moduleName = ((ModuleFile)moduleFileIter.next()).getName();
                String path = root + moduleName + File.separator + "wscache.xml";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking to see if the following cache file exists: " + path);
                }
                if (WebServiceUtils.fileExists(file = new File(path))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found existing cache file during install... the following file will be removed: " + path);
                    }
                    boolean success = WebServiceUtils.deleteFile(file);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Deleting the " + path + " file success: " + String.valueOf(success));
                    continue;
                }
                if (!tc.isDebugEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Did not find existing cache file during install");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteExistingCacheFiles");
        }
    }

    private ConfigObject getAppDeployment(AppData newAppData) {
        ConfigObject appDeployment;
        block5: {
            ConfigService configService = this.getConfigService();
            appDeployment = null;
            if (configService != null) {
                try {
                    ConfigObject d;
                    List r;
                    ConfigScope scope = configService.createScope(1);
                    scope.set(1, newAppData.getAppName() + ".ear/deployments/" + newAppData.getAppName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "About to load the application deployment information from: " + scope.getAbsolutePath("deployment.xml"));
                    }
                    if ((r = configService.getDocumentObjects(scope, "deployment.xml")) != null && (d = (ConfigObject)r.get(0)) != null) {
                        appDeployment = d.getObject("deployedObject");
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "There was an error trying to obtain the ConfigObject for the application's deployment.xml: " + e.toString());
                }
            }
        }
        return appDeployment;
    }
}

