/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.ws.webservices.deploy.ModuleData;
import com.ibm.ws.webservices.deploy.WebserviceDescriptionInfo;
import com.ibm.ws.websvcs.deploy.URLPrefixMapHelper;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class JAXWSModuleDataImpl
implements ModuleData {
    private static TraceComponent tc = Tr.register(JAXWSModuleDataImpl.class, "WebServices", "com.ibm.ws.webservices.deploy.resources.deployMessages");
    private String name;
    private String node;
    private String host;
    private String defaultPrefix;
    private String virtualHostName;
    private String contextRoot;
    private String applicationName;
    private String defaultJMSPrefix;
    private boolean hasHTTPRouter = false;
    private boolean hasJMSRouter = false;
    private String defaultEJBPrefix;
    private ModuleFile moduleFile = null;
    private HashMap<String, String> urlPrefixMap = new HashMap();
    private String dAppName = null;
    private List modulesWsdlFiles;
    private List modulesWsdlDefinitions;
    private String server;
    private List prefixList = new LinkedList();
    private Set virtualHostPorts = new HashSet();
    private boolean isWebModule;
    private List webservicesDescriptions = new ArrayList();
    private URLPrefixMapHelper urlPrefixHelper = null;

    public void setVirtualHost(VirtualHost virtualHost) {
        if (virtualHost != null) {
            this.virtualHostName = virtualHost.getName();
            EList aliases = virtualHost.getAliases();
            for (HostAlias ha : aliases) {
                this.virtualHostPorts.add(ha.getPort());
            }
        } else {
            this.virtualHostName = "";
        }
        if (tc.isDebugEnabled()) {
            String virtualHostName = "null";
            if (virtualHost != null) {
                virtualHostName = virtualHost.getName();
            }
            Tr.debug(tc, "setVirtualHost: for module \"" + this.name + "\" the virtualHost is \"" + virtualHostName + "\" and its ports are:");
            for (String port : this.virtualHostPorts) {
                Tr.debug(tc, port);
            }
            Tr.debug(tc, "\n");
        }
    }

    public void setVirtualHost(ConfigObject virtualHost) {
        if (virtualHost != null) {
            this.virtualHostName = virtualHost.getString("name", "__null__");
            List aliases = virtualHost.getObjectList("aliases");
            for (ConfigObject ha : aliases) {
                this.virtualHostPorts.add(ha.getString("port", "80"));
            }
        } else {
            this.virtualHostName = "";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setVirtualHost: for module \"" + this.name + "\" the virtualHost is \"" + (virtualHost == null ? "null" : this.virtualHostName) + "\" and its ports are:");
            for (String port : this.virtualHostPorts) {
                Tr.debug(tc, port);
            }
            Tr.debug(tc, "\n");
        }
    }

    public boolean addPrefix(String protocol, String port) {
        if (this.virtualHostPorts.contains(port)) {
            return this.prefixList.add(new Prefix(protocol, this.host, port));
        }
        return false;
    }

    public boolean addPrefix(String protocol, String host, String port) {
        return this.prefixList.add(new Prefix(protocol, host, port));
    }

    public List getPrefixList() {
        if (this.prefixList.size() == 0) {
            this.prefixList.add(new Prefix("", "", ""));
        }
        LinkedList<String> list = new LinkedList<String>();
        Iterator it = this.prefixList.iterator();
        while (it.hasNext()) {
            list.add(((Prefix)it.next()).toString());
        }
        return list;
    }

    public String getDefaultPrefix() {
        if (this.defaultPrefix == null) {
            this.defaultPrefix = "";
            if (this.prefixList != null) {
                for (Prefix prefix : this.prefixList) {
                    this.defaultPrefix = prefix.toString();
                    if (!prefix.protocol.equals("http")) continue;
                    break;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "default http prefix is: " + this.defaultPrefix);
        }
        return this.defaultPrefix;
    }

    public void setDefaultPrefix(String prefix) {
        this.defaultPrefix = prefix;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void addWebservicesDescription(WebserviceDescriptionInfo wsdInfo) {
        this.webservicesDescriptions.add(wsdInfo);
    }

    public List getWebservicesDescritions() {
        return this.webservicesDescriptions;
    }

    public Map getMergedQNameToUrlPatternMap(String primaryWsdName) {
        HashMap map = new HashMap();
        Map primaryMap = null;
        for (WebserviceDescriptionInfo wdi : this.webservicesDescriptions) {
            Map onemap = wdi.getQNameToUrlPatternMap();
            if (primaryWsdName != null && wdi.getWebserviceDescriptionName().equals(primaryWsdName)) {
                primaryMap = onemap;
            }
            map.putAll(onemap);
        }
        if (primaryMap != null) {
            map.putAll(primaryMap);
        }
        return map;
    }

    public Map getMergedQNameToPortComponentNameMap(String primaryWsdName) {
        HashMap map = new HashMap();
        Map primaryMap = null;
        for (WebserviceDescriptionInfo wdi : this.webservicesDescriptions) {
            Map onemap = wdi.getQnameToPortComponentNameMap();
            if (primaryWsdName != null && wdi.getWebserviceDescriptionName().equals(primaryWsdName)) {
                primaryMap = onemap;
            }
            map.putAll(onemap);
        }
        if (primaryMap != null) {
            map.putAll(primaryMap);
        }
        return map;
    }

    public Map getMergedQNameToEJBUrlPrefixMap(String primaryWsdName) {
        HashMap map = new HashMap();
        Map primaryMap = null;
        for (WebserviceDescriptionInfo wdi : this.webservicesDescriptions) {
            Map onemap = wdi.getQNameToEJBUrlPrefixMap();
            if (primaryWsdName != null && wdi.getWebserviceDescriptionName().equals(primaryWsdName)) {
                primaryMap = onemap;
            }
            map.putAll(onemap);
        }
        if (primaryMap != null) {
            map.putAll(primaryMap);
        }
        return map;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("\n");
        sb.append(this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + "\n");
        sb.append("applicationName=").append(this.applicationName).append("\n");
        sb.append("name=").append(this.name).append("\n");
        sb.append("node=").append(this.node).append("\n");
        sb.append("host=").append(this.host).append("\n");
        sb.append("defaultPrefix=").append(this.defaultPrefix).append("\n");
        sb.append("virtuaHostName=").append(this.virtualHostName).append("\n");
        sb.append("server=").append(this.server).append("\n");
        sb.append("contextRoot=").append(this.contextRoot).append("\n");
        sb.append("prefixList contains:\n");
        Iterator i = this.prefixList.iterator();
        while (i.hasNext()) {
            sb.append("\t").append(i.next()).append("\n");
        }
        sb.append("webServicesDescriptions contains:\n");
        for (WebserviceDescriptionInfo wsdInfo : this.webservicesDescriptions) {
            sb.append(wsdInfo.toString());
        }
        sb.append("virtualHostPorts contains:\n");
        i = this.virtualHostPorts.iterator();
        while (i.hasNext()) {
            sb.append(i.next()).append("\n");
        }
        sb.append("modulesWsdlFiles contains:\n");
        i = this.modulesWsdlFiles.iterator();
        while (i.hasNext()) {
            sb.append(i.next()).append("\n");
        }
        return sb.toString();
    }

    public void setIsWebModule(boolean isWebModule) {
        this.isWebModule = isWebModule;
    }

    public boolean isWebModule() {
        return this.isWebModule;
    }

    public List getModulesWsdlFiles() {
        return this.modulesWsdlFiles;
    }

    public void setModulesWsdlFiles(List modulesWsdlFiles) {
        this.modulesWsdlFiles = modulesWsdlFiles;
    }

    public List getModulesWsdlDefinitions() {
        return this.modulesWsdlDefinitions;
    }

    public void setModulesWsdlDefinitions(List modulesWsdlDefs) {
        this.modulesWsdlDefinitions = modulesWsdlDefs;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getDefaultJMSPrefix() {
        return this.defaultJMSPrefix;
    }

    public void setDefaultJMSPrefix(String string) {
        this.defaultJMSPrefix = string;
    }

    public boolean hasHTTPRouter() {
        return this.hasHTTPRouter;
    }

    public void setHasHTTPRouter(boolean b) {
        this.hasHTTPRouter = b;
    }

    public boolean hasJMSRouter() {
        return this.hasJMSRouter;
    }

    public void setHasJMSRouter(boolean b) {
        this.hasJMSRouter = b;
    }

    public String getDefaultEJBPrefix() {
        return this.defaultEJBPrefix;
    }

    public void setDefaultEJBPrefix(String string) {
        this.defaultEJBPrefix = string;
    }

    public HashMap getPersistentPrefixHashMap(Session session) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPersistentPrefixHashMap");
        }
        if (this.urlPrefixHelper == null) {
            this.urlPrefixHelper = new URLPrefixMapHelper(this.dAppName == null ? this.applicationName : this.dAppName, this.moduleFile, session);
        }
        this.urlPrefixMap = this.urlPrefixHelper.get();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPersistentPrefixHashMap");
        }
        return this.urlPrefixMap;
    }

    public void savePersistentPrefixHashMap() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "savePersistentPrefixHashMap");
        }
        if (this.urlPrefixHelper == null) {
            throw new IllegalStateException("Cannot save the URL prefix map before a call to 'getPersistentPrefixHashMap'.");
        }
        this.urlPrefixHelper.save(this.urlPrefixMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "savePersistentPrefixHashMap");
        }
    }

    public String getDisplayApplicationName() {
        return this.dAppName;
    }

    public void setDisplayApplicationName(String applicationName) {
        this.dAppName = applicationName;
    }

    public ModuleFile getModuleFile() {
        return this.moduleFile;
    }

    public void setModuleFile(ModuleFile modFile) {
        this.moduleFile = modFile;
    }

    public boolean isJAXRPC() {
        return false;
    }

    public boolean isJAXWS() {
        return true;
    }

    private class Prefix {
        String protocol;
        String host;
        String port;

        Prefix(String p, String h, String port) {
            this.protocol = p;
            this.host = h;
            this.port = port;
        }

        public String toString() {
            return this.protocol + "://" + this.host + ":" + this.port;
        }
    }
}

