/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.io.File;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class CacheDeployUtils {
    private static final TraceComponent tc = Tr.register(CacheDeployUtils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public static void removeDirectory(File[] files) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDirectory");
        }
        for (File file : files) {
            if (file.isDirectory() && file.listFiles().length > 0) {
                CacheDeployUtils.removeDirectory(file.listFiles());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing web services cache file: " + file.getAbsolutePath());
            }
            file.delete();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDirectory");
        }
    }

    public static void removeCacheDirectory(AppData cachedAppData, AppData newAppData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeCacheDirectory");
        }
        String rootDir = Axis2Utils.getCacheDirectory();
        String appName = cachedAppData.getAppName();
        if (rootDir != null) {
            String cacheDir = rootDir + appName;
            File file = new File(cacheDir);
            if (!file.exists()) {
                appName = newAppData.getAppName();
                file = new File(rootDir + appName);
            }
            if (file.exists() && file.isDirectory() && file.listFiles().length > 0) {
                CacheDeployUtils.removeDirectory(file.listFiles());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing web services cache file: " + file.getAbsolutePath());
            }
            file.delete();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removed cached objects for application: " + appName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeCacheDirectory");
        }
    }

    public static org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile getEARFile(ResourceBundle resourceBundle, Scheduler scheduler) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEARFile, scheduler= " + scheduler);
        }
        RepositoryContext rc = AppUtils.findAppContextFromConfig((String)scheduler.getAppName(), (WorkSpace)scheduler.getWorkSpace(), (Hashtable)scheduler.getProperties());
        EARFile earFile = null;
        if (scheduler instanceof InstallScheduler) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting to retrieve application with InstallScheduler");
            }
            earFile = ((InstallScheduler)scheduler).getEarFile(false, true);
        } else {
            boolean zeroEarCopy;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempting to retrieve application with ConfigRepoHelper");
            }
            earFile = !(zeroEarCopy = ConfigRepoHelper.getAppDeploymentForApp((RepositoryContext)rc).isZeroEarCopy()) ? ConfigRepoHelper.getEarFileFromBinaries((RepositoryContext)rc, (WorkSpace)scheduler.getWorkSpace(), (ResourceBundle)resourceBundle, (boolean)true) : ConfigRepoHelper.getEarFileFromDeployment((WorkSpace)scheduler.getWorkSpace(), (RepositoryContext)rc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEARFile, scheduler= " + scheduler + ", earFile= " + (earFile != null ? earFile.getName() : null));
        }
        return earFile;
    }
}

