/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.websphere.csi.EJBComponentInitializationCollaborator;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webcontainer.WebContainerService;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppCollaborator;
import com.ibm.ws.webservices.WebServicesService;
import com.ibm.ws.webservices.engine.handlers.jaxws.HandlerPostInvokerFactoryImpl;
import com.ibm.ws.webservices.engine.handlers.jaxws.HandlerPreInvokerFactoryImpl;
import com.ibm.ws.webservices.management.Endpoint;
import com.ibm.ws.webservices.management.EndpointManagerMBeanFactory;
import com.ibm.ws.webservices.management.EndpointManagerMBeanImpl;
import com.ibm.ws.webservices.utils.ServiceRefPartialInfo;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector;
import com.ibm.ws.websvcs.annotations.generator.WASAnnotationInputBuilder;
import com.ibm.ws.websvcs.annotations.injection.ServiceRefPostProcessor;
import com.ibm.ws.websvcs.annotations.injection.WSInjectionMetaDataListener;
import com.ibm.ws.websvcs.binding.WASParsedEntityReaderImpl;
import com.ibm.ws.websvcs.binding.WSClassFinder;
import com.ibm.ws.websvcs.client.ClientConfigurationContextStore;
import com.ibm.ws.websvcs.client.WSClientConfigurationFactory;
import com.ibm.ws.websvcs.collaborators.EjbCollaborator;
import com.ibm.ws.websvcs.collaborators.WebCollaborator;
import com.ibm.ws.websvcs.component.WASAxis2ClientImpl;
import com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager;
import com.ibm.ws.websvcs.deployment.FileExplorer;
import com.ibm.ws.websvcs.deployment.FileExplorerFactory;
import com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder;
import com.ibm.ws.websvcs.deployment.WASAxis2MetaDataProcessor;
import com.ibm.ws.websvcs.deployment.WASAxis2PolicySetConfigurator;
import com.ibm.ws.websvcs.deployment.WASAxis2URISecurityConstrainer;
import com.ibm.ws.websvcs.deployment.WASWSDLReaderConfigurator;
import com.ibm.ws.websvcs.deployment.WSRefInfoBuilder;
import com.ibm.ws.websvcs.deployment.WSServerMetadataMerger;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.extension.AsyncServletExtensionFactory;
import com.ibm.ws.websvcs.extension.WASAxis2ExtensionFactory;
import com.ibm.ws.websvcs.handler.lifecycle.factory.WSHandlerLifecycleManagerFactory;
import com.ibm.ws.websvcs.metadata.ClientMetaData;
import com.ibm.ws.websvcs.metadata.ClientServiceRefs;
import com.ibm.ws.websvcs.metadata.MetaDataHolder;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.metadata.WASAxis2MetaDataImpl;
import com.ibm.ws.websvcs.metadata.WSApplicationMetaDataHolder;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.server.WSEndpointLifecycleManagerFactory;
import com.ibm.ws.websvcs.server.WSInvocationListenerFactory;
import com.ibm.ws.websvcs.server.WSServiceInstanceFactory;
import com.ibm.ws.websvcs.server.dispatcher.factory.WASEndpointDispatcherFactory;
import com.ibm.ws.websvcs.server.handlers.JAXWSEJBHandlerResolver;
import com.ibm.ws.websvcs.trace.ConfigTrace;
import com.ibm.ws.websvcs.transport.channel.WSChannelManager;
import com.ibm.ws.websvcs.transport.http.AsyncResponseServlet;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.utils.WASAxis2ExecutorFactory;
import com.ibm.ws.websvcs.utils.WSResourceFinder;
import com.ibm.wsspi.ejbcontainer.WSEJBHandlerResolver;
import com.ibm.wsspi.injectionengine.InjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.InjectionMetaDataListener;
import com.ibm.wsspi.runtime.component.TransportMap;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import com.ibm.wsspi.webservices.management.EndpointManagerMBean;
import com.ibm.wsspi.webservices.models.WSModels;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import com.ibm.wsspi.websvcs.policyset.PolicySetLoader;
import com.ibm.wsspi.websvcs.policyset.PolicySetLoaderMgr;
import com.ibm.wsspi.websvcs.runtime.JAXWSMetaDataListener;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.handler.factory.HandlerPostInvokerFactory;
import org.apache.axis2.jaxws.handler.factory.HandlerPreInvokerFactory;
import org.apache.axis2.jaxws.handler.lifecycle.factory.HandlerLifecycleManagerFactory;
import org.apache.axis2.jaxws.message.factory.ClassFinderFactory;
import org.apache.axis2.jaxws.message.factory.ParsedEntityReaderFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.registry.InvocationListenerRegistry;
import org.apache.axis2.jaxws.server.ServiceInstanceFactory;
import org.apache.axis2.jaxws.server.dispatcher.factory.EndpointDispatcherFactory;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.factory.EndpointLifecycleManagerFactory;
import org.apache.axis2.jaxws.utility.ExecutorFactory;
import org.apache.axis2.jaxws.wsdl.WSDLReaderConfigurator;
import org.apache.axis2.metadata.factory.ResourceFinderFactory;
import org.apache.axis2.metadata.registry.MetadataFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAxis2ComponentImpl
extends WsComponentImpl
implements MetaDataListener,
Constants,
WASAxis2Service,
DeployedObjectListener {
    private static final TraceComponent _tc = Tr.register(WASAxis2ComponentImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static TraceComponent tcConfigTrace = Tr.register(ConfigTrace.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private WASAxis2MetaDataImpl metadata = null;
    private Object compImplServiceKey = null;
    private ArrayList serverModuleFiles = new ArrayList();
    private ArrayList clientModuleFiles = new ArrayList();
    private ArrayList serverTCMPlugins = new ArrayList();
    private ArrayList clientTCMPlugins = new ArrayList();
    private ArrayList clientACMPlugins = new ArrayList();
    private ArrayList serverACMPlugins = new ArrayList();
    private ArrayList JAXWSMetaDataListeners = new ArrayList();
    private Set<String> applicationsProcessed = new HashSet<String>(50);
    private Axis2ServiceConfigPluginManager configManager;
    private VariableMap vmap = null;
    private Repository repository = null;
    private ClientConfigurationContextStore clientCCStore = null;
    private boolean initialized = false;
    private WebContainerService webContainerService = null;
    private EJBContainer ejbContainerService = null;
    private boolean componentStarted = false;
    private WebServicesService webServicesService = null;

    public WASAxis2ComponentImpl() {
        this.setName("WASAxis2ComponentImpl");
    }

    @Override
    public void initialize(Object obj) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        super.initialize(obj);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initialize");
        }
        try {
            if (PlatformHelperFactory.getPlatformHelper().isCRAJvm()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "WebServices Server disabled in z/OS CRA.");
                }
                throw new ComponentDisabledException("WebServices Server disabled in z/OS CRA.");
            }
            this.compImplServiceKey = WsServiceRegistry.addService(this, WASAxis2Service.class);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Registered WASAxis2Service object.");
            }
        }
        catch (ComponentDisabledException cde) {
            throw cde;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.initialize", "161", this);
            Object[] inserts = new Object[]{this.getName(), e};
            String msg = NLSProvider.getNLS().getFormattedMessage("compInitFail00", inserts, "Error occurred while attempting to initialize component {0}: {1}");
            Tr.error(_tc, "compInitFail00", inserts);
            throw new ComponentDisabledException(msg, e);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "initialize");
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroy");
        }
        WsServiceRegistry.unregisterService(this.compImplServiceKey);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Unregistered WASAxis2Service object.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroy");
        }
    }

    private void listChannelTransports() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "listChannelTransports");
        }
        TransportMap transportMap = this.getTransportMapService();
        Map httpPortsList = transportMap.getHttpVirtualHostPortMapping();
        Map sslPortsList = transportMap.getHttpsVirtualHostPortMapping();
        if (httpPortsList != null && !httpPortsList.isEmpty()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "httpPortsList: " + httpPortsList);
            }
            AsyncResponseServlet.setHttpHostandPorts(httpPortsList);
        }
        if (sslPortsList != null && !sslPortsList.isEmpty()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "sslPortsList: " + sslPortsList);
            }
            AsyncResponseServlet.setHttpsHostandPorts(sslPortsList);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "listChannelTransports");
        }
    }

    @Override
    public void start() throws RuntimeError, RuntimeWarning {
        super.start();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start");
        }
        try {
            this.componentStarted = true;
            MetaDataService metaDataService = this.getMetaDataService();
            this.metadata = new WASAxis2MetaDataImpl(metaDataService);
            metaDataService.addMetaDataListener(this);
            if (this.webContainerService != null) {
                this.registerWebCollaborator(this.webContainerService);
            }
            if (this.ejbContainerService != null) {
                this.registerEJBCollaborator(this.ejbContainerService);
            }
            WASAxis2ExtensionFactory factory = new WASAxis2ExtensionFactory();
            WebContainer.registerExtensionFactory(factory);
            AsyncServletExtensionFactory factory2 = new AsyncServletExtensionFactory();
            WebContainer.registerExtensionFactory(factory2);
            WASAnnotationCollector.registerAnnotationAdapters();
            InjectionEngineAccessor.getInstance().registerInjectionMetaDataListener((InjectionMetaDataListener)new WSInjectionMetaDataListener());
            InvocationListenerRegistry.addFactory(new WSInvocationListenerFactory());
            ApplicationMgr mgr = WsServiceRegistry.getService(this, ApplicationMgr.class);
            if (mgr != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Registering WASAxis2ComponentImpl as DeployedObjectListener");
                }
                mgr.addDeployedObjectListener(this);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ApplicationMgr service not available in WASAxis2ComponentImpl");
            }
            Tr.info(_tc, "wasAxis2ServiceStarted");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.start", "232", this);
            throw new RuntimeWarning(e);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "start");
            }
        }
    }

    private void initComponent() {
        if (!this.initialized) {
            this.initialized = true;
            this.configManager = new Axis2ServiceConfigPluginManager();
            this.configManager.discoverAxis2ServiceConfigPlugins(true);
            WSChannelManager.getInstance().setManagedRuntime(true);
            this.clientCCStore = new ClientConfigurationContextStore();
            this.displaySVNInfo();
            this.listChannelTransports();
            ClassFinderFactory cff = new ClassFinderFactory();
            cff.setClassFinder(new WSClassFinder());
            FactoryRegistry.setFactory(ClassFinderFactory.class, cff);
            ParsedEntityReaderFactory perf = new ParsedEntityReaderFactory();
            perf.setParsetEntityReader(new WASParsedEntityReaderImpl());
            FactoryRegistry.setFactory(ParsedEntityReaderFactory.class, perf);
            ResourceFinderFactory rff = new ResourceFinderFactory();
            rff.setResourceFinder(new WSResourceFinder());
            FactoryRegistry.setFactory(EndpointDispatcherFactory.class, new WASEndpointDispatcherFactory());
            FactoryRegistry.setFactory(ServiceInstanceFactory.class, new WSServiceInstanceFactory());
            MetadataFactoryRegistry.setFactory(ResourceFinderFactory.class, rff);
            FactoryRegistry.setFactory(HandlerPreInvokerFactory.class, new HandlerPreInvokerFactoryImpl());
            FactoryRegistry.setFactory(HandlerPostInvokerFactory.class, new HandlerPostInvokerFactoryImpl());
            ClientConfigurationFactory fac = WSClientConfigurationFactory.newInstance();
            MetadataFactoryRegistry.setFactory(ClientConfigurationFactory.class, fac);
            WASAxis2ExecutorFactory myEF = WASAxis2ExecutorFactory.newInstance();
            FactoryRegistry.setFactory(ExecutorFactory.class, myEF);
            FactoryRegistry.setFactory(EndpointLifecycleManagerFactory.class, new WSEndpointLifecycleManagerFactory());
            WASWSDLReaderConfigurator wsdlConfig = new WASWSDLReaderConfigurator();
            MetadataFactoryRegistry.setFactory(WSDLReaderConfigurator.class, wsdlConfig);
            FactoryRegistry.setFactory(HandlerLifecycleManagerFactory.class, new WSHandlerLifecycleManagerFactory());
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "stop");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "stop");
        }
    }

    public void setWebContainer(WebContainerService wcSvc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setWebContainer");
        }
        this.webContainerService = wcSvc;
        if (this.componentStarted) {
            this.registerWebCollaborator(this.webContainerService);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setWebContainer");
        }
    }

    public void setWebServicesService(WebServicesService webServicesService) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setWebServicesService");
        }
        this.webServicesService = webServicesService;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setWebServicesService");
        }
    }

    private void registerWebCollaborator(WebContainerService wcSvc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "registerWebCollaborator");
        }
        wcSvc.addWebAppCollaborator((WebAppCollaborator)new WebCollaborator());
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Registered our WebCollaborator with the WebContainer service...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "registerWebCollaborator");
        }
    }

    public void setEJBContainer(EJBContainer ecSvc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setEJBContainer");
        }
        this.ejbContainerService = ecSvc;
        this.ejbContainerService.setWebServiceHandlerResolver((WSEJBHandlerResolver)new JAXWSEJBHandlerResolver());
        if (this.componentStarted) {
            this.registerEJBCollaborator(this.ejbContainerService);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setEJBContainer");
        }
    }

    private void registerEJBCollaborator(EJBContainer ecSvc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "registerEJBCollaborator");
        }
        ecSvc.addCollaborator((EJBComponentInitializationCollaborator)new EjbCollaborator(this.metadata));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Registered our EjbCollaborator with the EjbContainer service...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "registerEJBCollaborator");
        }
    }

    @Override
    public void stateChanged(DeployedObjectEvent doe) throws RuntimeError, RuntimeWarning {
        if (tcConfigTrace.isDebugEnabled() && doe.getDeployedObject().getModuleFile() != null && doe.getDeployedObject().getMetaData() instanceof ModuleMetaData && doe.getNewValue().equals("STARTED")) {
            ServerModuleMetaData smmd;
            ModuleMetaData mmd = (ModuleMetaData)doe.getDeployedObject().getMetaData();
            MetaDataHolder mdh = (MetaDataHolder)mmd.getMetaData(this.metadata.getMetaDataSlot());
            ServerModuleMetaData serverModuleMetaData = smmd = mdh != null ? mdh.getServerModuleMetaData() : null;
            if (smmd != null && smmd.getConfigurationContext() != null) {
                ConfigTrace.log(smmd.getConfigurationContext());
                smmd.setDBCs(null);
            }
        }
    }

    private Map<String, ServiceRefPartialInfo> getServiceRefInfo(ModuleMetaData mmd) throws RuntimeError {
        ServerModuleMetaData smmd;
        MetaDataHolder mdh = (MetaDataHolder)mmd.getMetaData(this.metadata.getMetaDataSlot());
        ServerModuleMetaData serverModuleMetaData = smmd = mdh != null ? mdh.getServerModuleMetaData() : null;
        if (smmd == null || smmd.getServiceRefInfo() == null || smmd.getServiceRefInfo().isEmpty()) {
            throw new RuntimeError("The " + mmd.getName() + " has incomplete Web service " + "reference  metadata. Make sure that all Web service references in this module " + "are fully defined by annotations, deployment descriptors, or both");
        }
        return smmd.getServiceRefInfo();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void metaDataCreated(MetaDataEvent mde) throws RuntimeWarning, RuntimeError {
        if (WASAxis2ComponentImpl._tc.isEntryEnabled()) {
            Tr.entry(WASAxis2ComponentImpl._tc, "metaDataCreated= " + mde.getDeployedObject().getModuleFile().getName());
        }
        this.initComponent();
        earFile = mde.getDeployedObject().getModuleFile().getEARFile();
        if (earFile != null && earFile.getEJBJarFiles().size() > 0 && !this.applicationsProcessed.contains(earFile.getName())) {
            if (WASAxis2ComponentImpl._tc.isDebugEnabled()) {
                Tr.debug(WASAxis2ComponentImpl._tc, "Initializing router module to EJBJar module map for application: " + earFile.getName());
            }
            this.initializeRouterModuleMap(mde);
            this.applicationsProcessed.add(earFile.getName());
        }
        if (mde.getMetaData() instanceof ModuleMetaData) {
            try {
                moduleFile = mde.getDeployedObject().getModuleFile();
                if (moduleFile.isWARFile() && (clientURLInfo = WASAxis2ClientImpl.loadClientURLInfo(moduleFile, xmiFilePath = "WEB-INF/ibm-webservicesclient-bnd.xmi")) != null && !clientURLInfo.isEmpty()) {
                    cmd = (ClientMetaData)this.getClientModuleMetaData((ModuleMetaData)mde.getMetaData());
                    if (cmd == null) {
                        cmd = new ClientMetaData();
                    }
                    cmd.setClientURLInfo(clientURLInfo);
                    if (WASAxis2ComponentImpl._tc.isDebugEnabled()) {
                        Tr.debug(WASAxis2ComponentImpl._tc, "Setting client endpoint URL info on ClientMetaData instance: " + cmd.hashCode());
                    }
                    this.setClientModuleMetaData(cmd, (ModuleMetaData)mde.getMetaData());
                }
                ejbJarName = this.getEJBJarModuleName(moduleFile.getName(), this.getApplicationMetaData(mde), true);
                scanModule = true;
                if (ejbJarName != null && !"".equals(ejbJarName)) {
                    if (earFile.getFile(ejbJarName) instanceof EJBJarFile) {
                        if (WASAxis2ComponentImpl._tc.isDebugEnabled()) {
                            Tr.debug(WASAxis2ComponentImpl._tc, "Metadata event fired for the " + moduleFile.getName() + " router " + "module... checking to see if the EJB should be scanned for annotations");
                        }
                        if (!Axis2Utils.scanModule(ejbJar = (EJBJarFile)earFile.getFile(ejbJarName))) {
                            if (WASAxis2ComponentImpl._tc.isDebugEnabled()) {
                                Tr.debug(WASAxis2ComponentImpl._tc, "The module metadata for the " + moduleFile.getName() + " module will not be processed because annotation scanning is " + "not enabled for the module.");
                            }
                            scanModule = false;
                        }
                    }
                } else if (!Axis2Utils.scanModule(moduleFile)) {
                    if (WASAxis2ComponentImpl._tc.isDebugEnabled()) {
                        Tr.debug(WASAxis2ComponentImpl._tc, "The module metadata for the " + moduleFile.getName() + " module will not be processed because annotation scanning is " + "not enabled for the module.");
                    }
                    scanModule = false;
                }
                if (!scanModule) ** GOTO lbl63
                this.moduleMetaDataCreated(mde);
            }
            catch (Exception e) {
                throw new RuntimeError(e);
            }
        } else if (mde.getMetaData() instanceof ComponentMetaData) {
            moduleFile = mde.getDeployedObject().getModuleFile();
            if (WASAxis2ComponentImpl._tc.isDebugEnabled()) {
                Tr.debug(WASAxis2ComponentImpl._tc, "ComponentMetaData event created for module: " + moduleFile.getName());
            }
            if (moduleFile.isEJBJarFile() && (clientURLInfo = WASAxis2ClientImpl.loadClientURLInfo(moduleFile, xmiFilePath = "META-INF/ibm-webservicesclient-bnd.xmi")) != null && !clientURLInfo.isEmpty()) {
                cmd = (ClientMetaData)this.getClientComponentMetaData((ComponentMetaData)mde.getMetaData());
                if (cmd == null) {
                    cmd = new ClientMetaData();
                }
                if (WASAxis2ComponentImpl._tc.isDebugEnabled()) {
                    Tr.debug(WASAxis2ComponentImpl._tc, "Setting client endpoint URL info on ClientMetaData instance: " + cmd.hashCode());
                }
                cmd.setClientURLInfo(clientURLInfo);
                this.setClientComponentMetaData(cmd, (ComponentMetaData)mde.getMetaData());
            }
            if (!Axis2Utils.scanModule(moduleFile)) {
                if (WASAxis2ComponentImpl._tc.isDebugEnabled()) {
                    Tr.debug(WASAxis2ComponentImpl._tc, "The client component metadata for the " + moduleFile.getName() + " module will not be processed because annotation scanning is not enabled " + "for the module.");
                }
            } else {
                this.completeClientComponentMetaData(mde);
            }
        }
lbl63:
        // 6 sources

        if (WASAxis2ComponentImpl._tc.isEntryEnabled()) {
            Tr.exit(WASAxis2ComponentImpl._tc, "metaDataCreated= " + mde.getDeployedObject().getModuleFile().getName());
        }
    }

    @Override
    public void metaDataDestroyed(MetaDataEvent mde) {
        EARFile earFile;
        ModuleFile mf;
        String appName;
        if (mde.getMetaData() instanceof ModuleMetaData) {
            DeployedObject dObj = mde.getDeployedObject();
            ModuleFile mFile = dObj.getModuleFile();
            appName = mde.getDeployedObject().getModuleFile().getEARFile() == null ? null : mde.getDeployedObject().getModuleFile().getEARFile().getName();
            String moduleName = mde.getDeployedObject().getName();
            EndpointManagerMBeanFactory.unregisterMBean(appName, moduleName);
            if (mFile.isWARFile() || mFile.isEJBJarFile()) {
                try {
                    this.moduleMetaDataDestroyed(mde);
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.metaDataDestroyed", "293", this);
                    Object[] inserts = new Object[]{dObj.getName(), t};
                    Tr.error(_tc, "unloadModuleFail00", inserts);
                }
            }
        }
        if ((mf = mde.getDeployedObject().getModuleFile()).isWARFile() || mf.isEJBJarFile()) {
            List<ConfigurationContext> ccList;
            String modName = mf.getName();
            appName = this.getApplicationName(mf);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Looking for client ConfigurationContext objects for module: " + modName + " and app name: " + appName);
            }
            if ((ccList = this.getClientConfigurationContexts(appName, modName)) != null && !ccList.isEmpty()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "For module: " + modName + " and application: " + appName + ", " + ccList.size() + " client ConfigurationContext objects " + "were found.");
                }
                this.terminateClientConfigurationContexts(ccList);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No client ConfigurationContext objects found for module: " + modName + " and app name: " + appName);
            }
        }
        if ((earFile = mf.getEARFile()) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Removing EARFile: " + earFile.getName() + " from set of " + "processed applications");
            }
            this.applicationsProcessed.remove(earFile.getName());
        }
    }

    @Override
    public ConfigurationContext loadAxis2ConfigurationContext(String appName, String modName) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadAxisConfigTemplate");
        }
        AxisConfiguration axisCfg = null;
        ConfigurationContext configContext = null;
        WASAxis2ConfigurationBuilder cfgBuilder = new WASAxis2ConfigurationBuilder(this.serverModuleFiles, this.clientModuleFiles, this.serverTCMPlugins, this.clientTCMPlugins, this.serverACMPlugins, this.clientACMPlugins);
        try {
            axisCfg = cfgBuilder.loadAxisServerConfiguration();
            configContext = ConfigurationContextFactory.createEmptyConfigurationContext();
            configContext.setAxisConfiguration(axisCfg);
            this.setConfigParams(axisCfg, appName, modName);
            if (axisCfg == null) {
                Object[] inserts = new Object[]{modName};
                String msg = NLSProvider.getNLS().getFormattedMessage("axisCfgNull00", inserts, "''Axis Configuration'' for the application module {0} is null.");
                throw new Exception(msg);
            }
            cfgBuilder.loadAxisServerModules(axisCfg, configContext);
            cfgBuilder.loadAxisServerTCMPlugins(configContext);
            cfgBuilder.loadAxisServerACMPlugins(configContext);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.loadAxis2ConfigurationContext", "329", this);
            Object[] inserts = new Object[]{modName, t};
            String msg = NLSProvider.getNLS().getFormattedMessage("axisConfFail00", inserts, "Error occurred while attempting to create the ''AxisConfiguration'' for application module {0}: {1}");
            Tr.error(_tc, "axisConfFail00", inserts);
            throw new Exception(msg, t);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "loadAxisConfigTemplate");
            }
        }
        return configContext;
    }

    private void moduleMetaDataDestroyed(MetaDataEvent mde) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "moduleMetaDataDestroyed");
        }
        Object md = this.metadata.getServerModuleMetaData((ModuleMetaData)mde.getMetaData());
        ServerModuleMetaData smmd = null;
        if (md != null && md instanceof ServerModuleMetaData) {
            smmd = (ServerModuleMetaData)md;
        }
        if (md != null && md instanceof MetaDataHolder) {
            smmd = ((MetaDataHolder)md).getServerModuleMetaData();
        }
        if (smmd != null) {
            if (_tc.isDebugEnabled() && mde.getDeployedObject() != null) {
                Tr.debug(_tc, "Shutting down module metadata for module " + mde.getDeployedObject().getName());
            }
            ConfigurationContext cc = smmd.getConfigurationContext();
            this.shutdownModules(cc);
            this.driveJAXWSMetaDataListeners(false, mde, cc);
            smmd.setConfigurationContext(null);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "moduleMetaDataDestroyed");
        }
    }

    private MetaDataService getMetaDataService() {
        try {
            return WsServiceRegistry.getService(this, MetaDataService.class);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.getMetaDataService", "471", this);
            Object[] inserts = new Object[]{this.getName(), e};
            Tr.error(_tc, "metaDataSvcFail00", inserts);
            return null;
        }
    }

    @Override
    public Object getModuleMetaData() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getModuleMetaData");
        }
        Object smmd = this.metadata.getServerModuleMetaData();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getModuleMetaData");
        }
        return smmd;
    }

    public Object getModuleMetaData(ModuleMetaData mmd) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getModuleMetaData");
        }
        Object smmd = null;
        smmd = mmd.getMetaData((MetaDataSlot)this.getModuleMetaDataSlot());
        if (smmd == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Looking for metadata in application's metadata slot for module: " + mmd.getName());
            }
            smmd = this.metadata.getServerModuleMetaData(mmd);
            if (_tc.isDebugEnabled() && smmd != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found metadata in application's metadata slot for module: " + mmd.getName());
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Found metadata in module's metadata slot for module: " + mmd.getName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getModuleMetaData");
        }
        return smmd;
    }

    public Object getModuleMetaData(MetaDataEvent mde) {
        ModuleMetaData mmd;
        MetaData obj;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getModuleMetaData");
        }
        Object smmd = null;
        if (mde.getDeployedObject() != null && (obj = mde.getMetaData()) != null && obj instanceof ModuleMetaData && (smmd = (mmd = (ModuleMetaData)obj).getMetaData(this.metadata.getMetaDataSlot())) == null) {
            smmd = this.metadata.getServerModuleMetaData(mmd);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getModuleMetaData");
        }
        return smmd;
    }

    public MetaDataSlot getApplicationMetaDataSlot() {
        return this.metadata.getApplicationMetaDataSlot();
    }

    @Override
    public Object getModuleMetaDataSlot() {
        return this.metadata.getMetaDataSlot();
    }

    public WebContainerService getWebContainerService() {
        try {
            return WsServiceRegistry.getService(this, WebContainerService.class);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.getWebContainerService", "514", this);
            Object[] inserts = new Object[]{this.getName()};
            Tr.error(_tc, "noWebCntrSvc00", inserts);
            return null;
        }
    }

    public VariableMap getVariableMapService() {
        try {
            if (this.vmap == null) {
                this.vmap = WsServiceRegistry.getService(this, VariableMap.class);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.getVariableMapService", "534", this);
            Object[] inserts = new Object[]{this.getName()};
            Tr.error(_tc, "noVarMapSvc00", inserts);
        }
        return this.vmap;
    }

    public Repository getRepositoryService() {
        try {
            if (this.repository == null) {
                this.repository = WsServiceRegistry.getService(this, Repository.class);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.getRepositoryService", "554", this);
            Object[] inserts = new Object[]{this.getName()};
            Tr.error(_tc, "noRepoSvc00", inserts);
        }
        return this.repository;
    }

    public TransportMap getTransportMapService() {
        try {
            return WsServiceRegistry.getService(this, TransportMap.class);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.getTransportMapService", "1152", this);
            Object[] inserts = new Object[]{this.getName()};
            Tr.error(_tc, "noTransMapSvc00", inserts);
            return null;
        }
    }

    private void setConfigParams(AxisConfiguration axisCfg, String appName, String modName) throws AxisFault {
        Axis2Utils.setApplicationName(axisCfg, appName);
        Axis2Utils.setModuleName(axisCfg, modName);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Application name parameter added to AxisConfiguration: " + appName);
            Tr.debug(_tc, "Module name parameter added to AxisConfiguration: " + modName);
        }
    }

    @Override
    public ConfigurationContext loadAxis2ConfigurationContext(MetaDataEvent mde) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadAxis2ConfigurationContext");
        }
        DeployedObject dObj = mde.getDeployedObject();
        ModuleMetaData moduleMetaData = (ModuleMetaData)dObj.getMetaData();
        String appName = moduleMetaData.getApplicationMetaData().getName();
        String modName = dObj.getName();
        ConfigurationContext configCtx = this.loadAxis2ConfigurationContext(appName, modName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadAxis2ConfigurationContext");
        }
        return configCtx;
    }

    @Override
    public void completeAxis2Configuration(ConfigurationContext configContext, MetaDataEvent mde) throws Exception {
        this.completeAxis2Configuration(configContext, mde, null, null);
    }

    public void completeAxis2Configuration(ConfigurationContext configContext, MetaDataEvent mde, Map<String, ServiceRefPartialInfo> partialInfoMap, Map<String, DescriptionBuilderComposite> dbcMap) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "completeAxis2Configuration");
        }
        DeployedObject dObj = mde.getDeployedObject();
        PolicySetLoader psLoader = PolicySetLoaderMgr.getContextPolicySetLoader();
        if (psLoader instanceof WASAxis2PolicySetConfigurator) {
            ((WASAxis2PolicySetConfigurator)psLoader).setAppClassLoader(dObj.getClassLoader());
        }
        psLoader.associatePolicySets(configContext, this.configManager);
        this.storeModuleMetaData(mde, configContext, partialInfoMap, dbcMap);
        if (dObj.getDeploymentDescriptor() instanceof WebApp) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Constraining URIs for module: " + dObj.getName());
            }
            WebApp webapp = (WebApp)dObj.getDeploymentDescriptor();
            WASAxis2URISecurityConstrainer sc = new WASAxis2URISecurityConstrainer(configContext, webapp);
            sc.constrainURIs();
        }
        if (configContext != null && Axis2Utils.getEndpointManagerMBean(configContext) == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "EndpointManagerMBean not yet set on ConfigurationContext...  attempting to create in completeAxis2Configuration");
            }
            String appName = this.getAppName(mde);
            String moduleName = mde.getDeployedObject().getName();
            String contextRoot = Axis2Utils.getContextRoot(mde.getDeployedObject().getModuleFile());
            EndpointManagerMBean mbean = EndpointManagerMBeanFactory.locateOrGenerateMBean(appName, moduleName);
            if (contextRoot != null) {
                ((EndpointManagerMBeanImpl)mbean).setContextRoot(contextRoot);
            }
            List<Endpoint> endpoints = Axis2Utils.generateEndpoints(configContext);
            mbean.initializeEndpoints(endpoints);
            Axis2Utils.setEndpointManagerMBean(configContext, mbean);
        }
        Axis2Utils.setContextRoot(configContext, Axis2Utils.getContextRoot(mde.getDeployedObject().getModuleFile()));
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "completeAxis2Configuration");
        }
    }

    @Override
    public void driveJAXWSMetaDataListeners(boolean callCreated, MetaDataEvent mde, ConfigurationContext cc) throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "driveJAXWSMetaDataListeners");
        }
        for (int i = 0; i < this.JAXWSMetaDataListeners.size(); ++i) {
            JAXWSMetaDataListener listener = (JAXWSMetaDataListener)this.JAXWSMetaDataListeners.get(i);
            if (callCreated) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Metadata created for JAXWSMetaDataListener: " + listener.toString());
                }
                listener.metaDataCreated(mde, cc);
                continue;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Metadata destroyed for JAXWSMetaDataListener: " + listener.toString());
            }
            listener.metaDataDestroyed(mde, cc);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "driveJAXWSMetaDataListeners");
        }
    }

    @Override
    public void addJAXWSMetaDataListener(JAXWSMetaDataListener mdl) {
        int index;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addJAXWSMetaDataListener");
        }
        if ((index = this.getJAXWSMDLIndex(mdl)) == -1) {
            this.JAXWSMetaDataListeners.add(mdl);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JAXWSMetaDataListener already exists. This listener will not be registered.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addJAXWSMetaDataListener");
        }
    }

    @Override
    public void removeJAXWSMetaDataListener(JAXWSMetaDataListener mdl) {
        int index;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "removeJAXWSMetaDataListener");
        }
        if ((index = this.getJAXWSMDLIndex(mdl)) >= 0) {
            this.JAXWSMetaDataListeners.remove(index);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JAXWSMetaDataListener does not exist. No listener was unregistered.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "removeJAXWSMetaDataListener");
        }
    }

    private int getJAXWSMDLIndex(JAXWSMetaDataListener mdl) {
        for (int i = 0; i < this.JAXWSMetaDataListeners.size(); ++i) {
            JAXWSMetaDataListener listener = (JAXWSMetaDataListener)this.JAXWSMetaDataListeners.get(i);
            if (mdl != listener) continue;
            return i;
        }
        return -1;
    }

    private void shutdownModules(ConfigurationContext cc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "shutdownModules");
        }
        if (cc != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Trying to stop Axis2 modules");
            }
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Configuration Context: " + cc.toString());
                }
                cc.terminate();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Successfully stopped Axis2 modules");
                }
            }
            catch (AxisFault af) {
                FFDCFilter.processException((Throwable)af, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.shutdownModules", "790", this);
                Tr.warning(_tc, "Error occurred during shutdown of Axis2 modules: " + af.toString());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "shutdownModules");
        }
    }

    private void displaySVNInfo() {
        try {
            if (_tc.isDebugEnabled()) {
                String contents;
                byte[] bytes;
                ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                InputStream is = cl.getResourceAsStream("info/axis2_apache_svn_info.txt");
                if (is != null) {
                    bytes = new byte[is.available()];
                    is.read(bytes);
                    contents = new String(bytes);
                    Tr.debug(_tc, "*** Begin contents of axis2_apache_svn_info ***");
                    Tr.debug(_tc, contents);
                    Tr.debug(_tc, "*** End contents of axis2_apache_svn_info ***");
                    is.close();
                }
                if ((is = cl.getResourceAsStream("info/axis2_svn_info.txt")) != null) {
                    bytes = new byte[is.available()];
                    is.read(bytes);
                    contents = new String(bytes);
                    Tr.debug(_tc, "*** Begin contents of axis2_svn_info ***");
                    Tr.debug(_tc, contents);
                    Tr.debug(_tc, "*** End contents of axis2_svn_info ***");
                    is.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public void addClientConfigurationContext(ConfigurationContext cc) {
        if (this.clientCCStore == null) {
            this.clientCCStore = new ClientConfigurationContextStore();
        }
        this.clientCCStore.addConfigurationContext(cc);
    }

    @Override
    public List<ConfigurationContext> getClientConfigurationContexts(String appName, String modName) {
        if (this.clientCCStore != null) {
            return this.clientCCStore.getConfigurationContexts(appName, modName);
        }
        return null;
    }

    private void terminateClientConfigurationContexts(List<ConfigurationContext> ccList) {
        for (int i = ccList.size() - 1; i > -1; --i) {
            try {
                ConfigurationContext cc = ccList.get(i);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Configuration Context: " + cc.toString());
                    Tr.debug(_tc, "Removing configContext from async servlet's rsp context...");
                }
                AsyncResponseServlet.getInstance().removeCCFromRspMap(cc);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Shutting down client ConfigurationContext: " + cc.toString());
                }
                cc.terminate();
                ccList.remove(i);
                continue;
            }
            catch (AxisFault af) {
                Tr.warning(_tc, "A problem occurred shutting down a client ConfigurationContext instance: " + af.toString());
            }
        }
    }

    private String getApplicationName(ModuleFile mf) {
        return mf.getContainer() != null ? mf.getContainer().getName() : null;
    }

    private void initializeRouterModuleMap(MetaDataEvent mde) throws RuntimeError {
        EARFile earFile = mde.getDeployedObject().getModuleFile().getEARFile();
        if (earFile != null && mde.getMetaData() instanceof ModuleMetaData) {
            ModuleMetaData mmd;
            ApplicationMetaData amd;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Building map of EJBJar files to router modules for application: " + earFile.getName());
            }
            if ((amd = (mmd = (ModuleMetaData)mde.getMetaData()).getApplicationMetaData()) != null) {
                WSApplicationMetaDataHolder holder = (WSApplicationMetaDataHolder)amd.getMetaData(this.getApplicationMetaDataSlot());
                if (holder == null) {
                    holder = new WSApplicationMetaDataHolder();
                }
                for (EJBJarFile ejbJar : earFile.getEJBJarFiles()) {
                    WSBinding wsb = this.loadWSBinding(ejbJar.getLoadStrategy(), "META-INF/ibm-webservices-bnd.xmi");
                    if (wsb == null) continue;
                    for (RouterModule routerModule : wsb.getRouterModules()) {
                        String key = routerModule.getName();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Adding router module to EJB module mapping: " + key + "-->" + ejbJar.getName());
                        }
                        holder.addRouterModuleToEJBJarMapping(key, ejbJar.getName());
                    }
                }
                amd.setMetaData(this.getApplicationMetaDataSlot(), holder);
            }
        }
    }

    private WSBinding loadWSBinding(LoadStrategy loadStrategy, String bindingFileName) {
        try {
            return WSModels.getWSBinding(loadStrategy, bindingFileName);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private String getEJBJarModuleName(String moduleName, ApplicationMetaData amd) {
        return this.getEJBJarModuleName(moduleName, amd, false);
    }

    private String getEJBJarModuleName(String moduleName, ApplicationMetaData amd, boolean preserveMapping) {
        String ejbName = null;
        WSApplicationMetaDataHolder holder = (WSApplicationMetaDataHolder)amd.getMetaData(this.getApplicationMetaDataSlot());
        if (holder != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Looking for EJBJar module mapping to module: " + moduleName);
            }
            ejbName = holder.getAndRemoveEJBJarNameFromRouterModule(moduleName);
            if (preserveMapping) {
                holder.addRouterModuleToEJBJarMapping(moduleName, ejbName);
            }
        }
        return ejbName;
    }

    private ConfigurationContext getModuleConfigContext(String key, MetaDataEvent mde) {
        ServerModuleMetaData smmd;
        ApplicationMetaData amd = this.getApplicationMetaData(mde);
        if (amd != null && (smmd = (ServerModuleMetaData)this.metadata.getServerModuleMetaData(key, amd)) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Returning ConfigurationContext for the module stored by key: " + key);
            }
            return smmd.getConfigurationContext();
        }
        return null;
    }

    private ApplicationMetaData getApplicationMetaData(MetaDataEvent mde) {
        if (mde.getMetaData() instanceof ModuleMetaData) {
            return ((ModuleMetaData)mde.getMetaData()).getApplicationMetaData();
        }
        return null;
    }

    private void storeModuleMetaData(MetaDataEvent mde, ConfigurationContext configContext, Map<String, ServiceRefPartialInfo> partialInfoMap, Map<String, DescriptionBuilderComposite> dbcMap) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "storeModuleMetaData, module= " + mde.getDeployedObject().getName() + " configContext= " + configContext);
        }
        ModuleMetaData mmd = (ModuleMetaData)mde.getDeployedObject().getMetaData();
        String appName = mmd.getApplicationMetaData().getName();
        String modName = mde.getDeployedObject().getName();
        ServerModuleMetaData smmd = new ServerModuleMetaData(appName, modName);
        smmd.setConfigurationContext(configContext);
        smmd.setServiceRefInfo(partialInfoMap);
        smmd.setDBCs(dbcMap);
        this.metadata.setServerModuleMetaData(mmd, smmd);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "storeModuleMetaData, module= " + mde.getDeployedObject().getName() + " configContext= " + configContext);
        }
    }

    private void moduleMetaDataCreated(MetaDataEvent mde) throws Exception {
        DeployedObject dObj = mde.getDeployedObject();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "moduleMetaDataCreated, module = " + dObj.getModuleFile().getName());
        }
        WebAppConfig webAppConfig = null;
        if (mde.getDeployedObject().getModuleFile().isWARFile()) {
            webAppConfig = mde.getMetaData() != null ? ((WebModuleMetaData)((Object)mde.getMetaData())).getConfiguration() : null;
        }
        String moduleName = mde.getDeployedObject().getName();
        String appName = null;
        appName = this.getAppName(mde);
        String key = moduleName;
        String ejbModuleName = this.getEJBJarModuleName(key, this.getApplicationMetaData(mde));
        String contextRoot = Axis2Utils.getContextRoot(mde.getDeployedObject().getModuleFile());
        ConfigurationContext configContext = null;
        try {
            if (ejbModuleName != null) {
                EARFile earFile;
                key = ejbModuleName;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Processing router module: " + moduleName + " for EJBModule: " + ejbModuleName);
                }
                if ((configContext = this.getModuleConfigContext(key, mde)) != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found ConfigContext stored in application's metadata slot for router module: " + moduleName);
                    }
                    if (contextRoot != null) {
                        EndpointManagerMBeanImpl mbean = (EndpointManagerMBeanImpl)Axis2Utils.getEndpointManagerMBean(configContext);
                        mbean.setContextRoot(contextRoot);
                    }
                    this.storeModuleMetaData(mde, configContext, null, null);
                } else if (configContext == null && (earFile = mde.getDeployedObject().getModuleFile().getEARFile()) != null) {
                    File file;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Loading metadata for router module: " + moduleName + " from EJBJar: " + ejbModuleName);
                    }
                    if ((file = earFile.getFile(ejbModuleName)) instanceof EJBJarFile) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Found EJBJar module: " + ejbModuleName);
                        }
                        Map<String, ServiceRefPartialInfo> partialInfoMap = null;
                        WASAxis2MetaDataProcessor mdp = new WASAxis2MetaDataProcessor((ModuleFile)file, dObj.getClassLoader(), webAppConfig, mde);
                        configContext = mdp.processApplicationMetaData();
                        WSRefInfoBuilder builder = new WSRefInfoBuilder(mdp.getDBCs());
                        partialInfoMap = builder.buildInfo();
                        if (partialInfoMap != null && !partialInfoMap.isEmpty()) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Built service ref partial metadata for module: " + moduleName);
                            }
                            this.setRefInfoForJAXRPC(partialInfoMap, (ModuleMetaData)mde.getMetaData());
                        }
                        if (configContext != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Loaded metadata for router module: " + moduleName + " from EJBJar module: " + ejbModuleName);
                            }
                            EndpointManagerMBean mbean = EndpointManagerMBeanFactory.locateOrGenerateMBean(appName, ejbModuleName);
                            if (contextRoot != null) {
                                ((EndpointManagerMBeanImpl)mbean).setContextRoot(contextRoot);
                            }
                            List<Endpoint> endpoints = Axis2Utils.generateEndpoints(configContext);
                            mbean.initializeEndpoints(endpoints);
                            Axis2Utils.setEndpointManagerMBean(configContext, mbean);
                            this.completeAxis2Configuration(configContext, mde);
                            this.driveJAXWSMetaDataListeners(true, mde, configContext);
                            this.storeMetaDataInApplication(mde, key, appName, moduleName, configContext, partialInfoMap);
                        } else if (partialInfoMap != null && !partialInfoMap.isEmpty()) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "The module: " + moduleName + " did not have web service " + "implementation classes, but did have DBCs... storing away in " + "for client metadata completion");
                            }
                            this.storeModuleMetaData(mde, null, partialInfoMap, mdp.getDBCs());
                        }
                    }
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Processing module: " + moduleName);
                }
                if ((configContext = this.getModuleConfigContext(key = moduleName, mde)) == null) {
                    WSRefInfoBuilder builder;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Loading metadata from module for: " + moduleName);
                    }
                    WASAxis2MetaDataProcessor metaDataProcessor = new WASAxis2MetaDataProcessor(dObj.getModuleFile(), dObj.getClassLoader(), webAppConfig, mde);
                    configContext = metaDataProcessor.processApplicationMetaData();
                    Map<String, DescriptionBuilderComposite> dbcMap = metaDataProcessor.getDBCs();
                    Map<String, ServiceRefPartialInfo> partialInfoMap = null;
                    if (dObj.getModuleFile() instanceof EJBJarFile && (partialInfoMap = (builder = new WSRefInfoBuilder(dbcMap)).buildInfo()) != null && !partialInfoMap.isEmpty()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Built service ref partial metadata for module: " + moduleName);
                        }
                        this.setRefInfoForJAXRPC(partialInfoMap, (ModuleMetaData)mde.getMetaData());
                    }
                    if (configContext != null) {
                        EndpointManagerMBean mbean = EndpointManagerMBeanFactory.locateOrGenerateMBean(appName, moduleName);
                        if (contextRoot != null) {
                            ((EndpointManagerMBeanImpl)mbean).setContextRoot(contextRoot);
                        }
                        List<Endpoint> endpoints = Axis2Utils.generateEndpoints(configContext);
                        mbean.initializeEndpoints(endpoints);
                        Axis2Utils.setEndpointManagerMBean(configContext, mbean);
                        this.completeAxis2Configuration(configContext, mde, partialInfoMap, metaDataProcessor.getDBCs());
                        this.driveJAXWSMetaDataListeners(true, mde, configContext);
                        if (dObj.getModuleFile().isEJBJarFile()) {
                            this.storeMetaDataInApplication(mde, key, appName, moduleName, configContext, partialInfoMap);
                        }
                    } else if (dbcMap != null && !dbcMap.isEmpty()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "The module: " + moduleName + " did not have web service " + "implementation classes, but did have DBCs... storing away in " + "for client metadata completion");
                        }
                        this.storeModuleMetaData(mde, null, partialInfoMap, dbcMap);
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "For module: " + moduleName + " the Configuration" + "Context has been stored in the application's metadata " + "slot");
                    }
                    this.storeModuleMetaData(mde, configContext, null, null);
                }
            }
            if (configContext == null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "No webservice annotations  or deployment descriptors were found within the module: " + dObj.getName());
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.component.WASAxis2ComponentImpl.moduleJarMetaDataCreated", "1733", this);
            Object[] inserts = new Object[]{dObj.getName(), e};
            Tr.error(_tc, "loadModuleFail00", inserts);
            throw e;
        }
    }

    private void storeMetaDataInApplication(MetaDataEvent mde, String key, String appName, String moduleName, ConfigurationContext configContext, Map<String, ServiceRefPartialInfo> partialInfoMap) {
        ServerModuleMetaData smmd = new ServerModuleMetaData(appName, moduleName);
        smmd.setConfigurationContext(configContext);
        smmd.setServiceRefInfo(partialInfoMap);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "For module: " + moduleName + " in application name: " + appName + " storing metadata in application slot by key: " + key);
        }
        smmd.setModuleKeyName(key);
        this.metadata.addServerModuleMetaData(this.getApplicationMetaData(mde), smmd);
    }

    @Override
    public Object getClientComponentMetaData() {
        return this.metadata.getClientComponentMetaData();
    }

    @Override
    public Object getClientComponentMetaData(ComponentMetaData cmd) {
        return this.metadata.getClientComponentMetaData(cmd);
    }

    @Override
    public Object getClientModuleMetaData(ModuleMetaData mmd) {
        return this.metadata.getClientModuleMetaData(mmd);
    }

    @Override
    public Object getClientModuleMetaData() {
        return this.metadata.getClientModuleMetaData();
    }

    public Object getClientMetaData(MetaData metaData) {
        if (metaData instanceof ModuleMetaData) {
            return this.metadata.getClientModuleMetaData((ModuleMetaData)metaData);
        }
        if (metaData instanceof ComponentMetaData) {
            return this.metadata.getClientComponentMetaData((ComponentMetaData)metaData);
        }
        return null;
    }

    @Override
    public void setClientModuleMetaData(ClientMetaData clientMetaData, ModuleMetaData mmd) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setClientModuleMetaData, clientMetaData= " + clientMetaData + ", moduleMetaData= " + mmd);
        }
        this.metadata.setClientModuleMetaData(clientMetaData, mmd);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setClientModuleMetaData");
        }
    }

    @Override
    public void setClientComponentMetaData(ClientMetaData clientMetaData, ComponentMetaData cmd) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setClientComponentMetaData, clientMetaData= " + clientMetaData + ", componentMetaData= " + cmd);
        }
        this.metadata.setClientComponentMetaData(clientMetaData, cmd);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setClientComponentMetaData");
        }
    }

    private void completeClientComponentMetaData(MetaDataEvent mde) throws RuntimeError {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "completeClientComponentMetaData");
        }
        try {
            ClientMetaData clientMetaData;
            ModuleFile moduleFile = mde.getDeployedObject().getModuleFile();
            ComponentMetaData cmd = (ComponentMetaData)mde.getMetaData();
            ModuleMetaData mmd = cmd.getModuleMetaData();
            if (moduleFile.isEJBJarFile() && (clientMetaData = (ClientMetaData)this.metadata.getClientComponentMetaData(cmd)) != null && clientMetaData.getClientServiceRefs() != null && clientMetaData.getClientServiceRefs().hasIncompleteRefs()) {
                Map<String, ServiceRefPartialInfo> partialInfoMap;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found incomplete client metadata for EJB module: " + moduleFile.getName());
                }
                ClientServiceRefs clientServiceRefs = clientMetaData.getClientServiceRefs();
                ServerModuleMetaData smmd = (ServerModuleMetaData)this.metadata.getServerModuleMetaData(mmd);
                Map<String, ServiceRefPartialInfo> map = partialInfoMap = smmd != null ? smmd.getServiceRefInfo() : null;
                if (partialInfoMap == null) {
                    partialInfoMap = new HashMap<String, ServiceRefPartialInfo>();
                }
                this.completeServiceRefMetaData(partialInfoMap, clientServiceRefs, cmd.getModuleMetaData());
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Web service reference metadata has been completed for the " + moduleFile.getName() + " EJB module.");
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeError(t);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "completeClientComponentMetaData");
            }
        }
    }

    void completeServiceRefMetaData(Map<String, ServiceRefPartialInfo> partialInfoMap, ClientServiceRefs clientServiceRefs, ModuleMetaData mmd) throws DeploymentException {
        if (clientServiceRefs.hasIncompleteRefs()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Incomplete web service reference metadata was found in the  module.");
            }
            ServiceRefPostProcessor postProcessor = new ServiceRefPostProcessor(clientServiceRefs, partialInfoMap, mmd);
            postProcessor.completeClientMetadata();
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No incomplete web service reference metadata was found in the  module.");
        }
    }

    protected static Map<String, DescriptionBuilderComposite> getDBCs(Archive moduleFile, ClassLoader classLoader) throws Exception {
        List<FileLocator> fileLocators;
        HashMap<String, DescriptionBuilderComposite> dbcMap = null;
        FileExplorer fileExplorer = FileExplorerFactory.getFileExplorer(moduleFile, classLoader);
        if (fileExplorer != null && (fileLocators = fileExplorer.explore()) != null) {
            WASAnnotationCollector collector = new WASAnnotationCollector();
            collector.setClassLoader(classLoader);
            List<ClassDataObject> cdoList = collector.collect(fileLocators);
            if (cdoList != null) {
                WASAnnotationInputBuilder inputBuilder = new WASAnnotationInputBuilder(cdoList, classLoader, moduleFile);
                dbcMap = inputBuilder.buildInputs();
                String xmlFileName = moduleFile.isWARFile() ? "WEB-INF/webservices.xml" : "META-INF/webservices.xml";
                WebServices webServices = WSModels.getWebServices(moduleFile.getLoadStrategy(), xmlFileName);
                WSServerMetadataMerger merger = new WSServerMetadataMerger(dbcMap, webServices, moduleFile.getLoadStrategy(), moduleFile.getName());
                dbcMap.putAll(merger.mergeMetadata());
            }
        }
        return dbcMap;
    }

    @Override
    public ServiceRefPartialInfo getServiceRefInfo(String portComponentName, ModuleMetaData moduleMetaData) throws Exception {
        ServiceRefPartialInfo info = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getServiceRefInfo, portComponentName= " + portComponentName);
        }
        Map<String, ServiceRefPartialInfo> partialInfoMap = this.getServiceRefInfo(moduleMetaData);
        info = partialInfoMap.get(portComponentName);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getServiceRefInfo, portComponentName= " + portComponentName + ", ServiceRefPartialInfo= " + info);
        }
        return info;
    }

    private void setRefInfoForJAXRPC(Map<String, ServiceRefPartialInfo> partialInfoMap, ModuleMetaData mmd) {
        if (this.webServicesService != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Registering service ref info with JAX-RPC service");
            }
            this.webServicesService.setServiceRefInfo(partialInfoMap, mmd);
        }
    }

    @Override
    public boolean isServerEnv() {
        return true;
    }

    String getAppName(MetaDataEvent mde) {
        ModuleMetaData mmd;
        String appName = null;
        if (mde.getMetaData() instanceof ModuleMetaData && (mmd = (ModuleMetaData)mde.getMetaData()).getApplicationMetaData() != null) {
            appName = mmd.getApplicationMetaData().getName();
        }
        if (appName == null) {
            appName = mde.getDeployedObject().getModuleFile().getEARFile() != null ? mde.getDeployedObject().getModuleFile().getEARFile().getName() : null;
        }
        return appName;
    }
}

