/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.websvcs.command.WSCommandUtils;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.Hashtable;
import javax.management.ObjectName;

public class WSUpdateARSTask
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(WSUpdateARSTask.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public WSUpdateARSTask(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public WSUpdateARSTask(TaskCommandMetadata commandMetadata) throws CommandNotFoundException {
        super(commandMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl thisCmdResult = new CommandResultImpl();
        this.setCommandResult(thisCmdResult);
        thisCmdResult.reset();
        try {
            String cellName = Axis2Utils.getCellName();
            String nodeName = (String)this.getParameter("nodeName");
            ConfigService configService = this.getConfigService();
            Session session = this.getConfigSession();
            if (nodeName == null || "".equals(nodeName)) {
                ObjectName query;
                ObjectName[] nodes;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node name not specified to upgradeARSConfig, so the entire configuration for the " + cellName + " will be inspected");
                }
                if ((nodes = configService.queryConfigObjects(session, null, query = ConfigServiceHelper.createObjectName(null, "Node"), null)) != null) {
                    for (ObjectName node : nodes) {
                        this.processNode(cellName, node, configService, session);
                    }
                }
            } else {
                ObjectName node = configService.resolve(session, "Node=" + nodeName)[0];
                if (node != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The " + nodeName + " node in the " + cellName + " cell will be examined " + "by the updateARSConfig command");
                    }
                    this.processNode(cellName, node, configService, session);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The " + nodeName + " node in the " + cellName + " cell will not be " + "examined because an ObjectName could not be found");
                }
            }
            thisCmdResult.setResult("IBM Asynchronous Response Servlet properly configured");
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.commandWSUpdateARSTask.execute", "119", this);
            thisCmdResult.setException(t);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "execute");
            }
        }
    }

    void processNode(String cellName, ObjectName node, ConfigService configService, Session session) throws Exception {
        ObjectName svrQuery;
        ObjectName[] servers;
        WSCommandUtils utils = new WSCommandUtils();
        String nodeName = (String)configService.getAttribute(session, node, "name");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing node: " + nodeName + " in cell: " + cellName);
        }
        if ((servers = configService.queryConfigObjects(session, node, svrQuery = ConfigServiceHelper.createObjectName(null, "Server"), null)) != null) {
            for (ObjectName server : servers) {
                String svrName = (String)configService.getAttribute(session, server, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing server: " + svrName);
                }
                String clusterName = (String)configService.getAttribute(session, server, "clusterName");
                boolean isNodeAgentOrDmgr = this.isNodeAgentOrDmgr(configService, server, session);
                if (isNodeAgentOrDmgr) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The " + svrName + " is not a DeploymentManager or " + "NodeAgent server");
                }
                Hashtable<String, Object> prefs = new Hashtable<String, Object>();
                prefs.put("server.name", svrName);
                prefs.put("node.name", nodeName);
                prefs.put("cell.name", cellName);
                if (clusterName != null) {
                    if (!utils.installARSToCluster(clusterName, configService, session, null)) continue;
                    utils.removeInvalidTarget(configService, session, prefs);
                    prefs.put("cluster.name", clusterName);
                    utils.installApplication(prefs, configService, session, this.isLocalMode());
                    continue;
                }
                if (!utils.installARSToServer(nodeName, session)) continue;
                ManagedObjectMetadataHelper helper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
                String baseVersion = helper.getNodeBaseProductVersion(nodeName);
                if (Utils.compareVersions((String)baseVersion, (String)"6.1.0.19") < 0 && Utils.compareVersions((String)baseVersion, (String)"6.1.0") > 0) {
                    prefs.put("com.ibm.ws.websvcs.ARS_USE_OLD_CONFIG", Boolean.TRUE);
                }
                utils.installApplication(prefs, configService, session, this.isLocalMode());
            }
        }
    }

    boolean isNodeAgentOrDmgr(ConfigService configService, ObjectName server, Session session) throws Exception {
        ObjectName dmQuery;
        ObjectName[] dMgrs;
        boolean isNodeAgentOrDmgr = false;
        ObjectName naQuery = ConfigServiceHelper.createObjectName(null, "NodeAgent");
        ObjectName[] nodeAgents = configService.queryConfigObjects(session, server, naQuery, null);
        if (nodeAgents != null && nodeAgents.length > 0) {
            isNodeAgentOrDmgr = true;
        }
        if (!isNodeAgentOrDmgr && (dMgrs = configService.queryConfigObjects(session, server, dmQuery = ConfigServiceHelper.createObjectName(null, "CellManager"), null)) != null && dMgrs.length > 0) {
            isNodeAgentOrDmgr = true;
        }
        return isNodeAgentOrDmgr;
    }
}

