/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.ws.websvcs.command.WSCreateServerExt;
import com.ibm.ws.websvcs.command.WSDeleteClusterMemberExt;
import com.ibm.ws.websvcs.command.WSImportCommandExt;
import com.ibm.ws.websvcs.command.WSUpdateARSTask;

public class WSCommandExtProvider
extends SimpleCommandProvider {
    private static final TraceComponent _tc = Tr.register(WSCommandExtProvider.class, null, null);

    public AbstractAdminCommand createCommand(CommandMetadata metadata) throws CommandNotFoundException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createCommand");
        }
        try {
            String cmdName = metadata.getName();
            if (cmdName.equals("updateARSConfig")) {
                WSUpdateARSTask wSUpdateARSTask = new WSUpdateARSTask((TaskCommandMetadata)metadata);
                return wSUpdateARSTask;
            }
            throw new CommandNotFoundException(cmdName);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createCommand");
            }
        }
    }

    public AbstractAdminCommand loadCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadCommand");
        }
        try {
            String cmdName = commandData.getName();
            if (cmdName.equals("updateARSConfig")) {
                WSUpdateARSTask wSUpdateARSTask = new WSUpdateARSTask(commandData);
                return wSUpdateARSTask;
            }
            throw new CommandNotFoundException(cmdName);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "loadCommand");
            }
        }
    }

    public AbstractCommandStep createCommandStep(AbstractTaskCommand taskCmd, String stepName) throws CommandNotFoundException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createCommandStep");
        }
        if (taskCmd.getName().equals("createApplicationServer") && stepName.equals("WebsvcsConfigCoreGroup")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found integration extension for createApplicationServer command.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createCommandStep");
            }
            return new WSCreateServerExt(taskCmd, this.getStepMetadata(taskCmd, stepName));
        }
        if (taskCmd.getName().equals("importNode") && stepName.equals("WebsvcsConfigCoreGroup")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found integration extension for importNode command.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createCommandStep");
            }
            return new WSImportCommandExt(taskCmd, this.getStepMetadata(taskCmd, stepName));
        }
        if (taskCmd.getName().equals("deleteClusterMember") && stepName.equals("WebsvcsConfigCoreGroup")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found integration extension for deleteClusterMember command.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createCommandStep");
            }
            return new WSDeleteClusterMemberExt(taskCmd, this.getStepMetadata(taskCmd, stepName));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createCommandStep");
        }
        throw new CommandNotFoundException(taskCmd.getName(), stepName);
    }

    public AbstractCommandStep loadCommandStep(AbstractTaskCommand taskCmd, CommandStepData stepData) throws CommandNotFoundException, CommandLoadException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadCommandStep");
        }
        if (taskCmd.getName().equals("createApplicationServer") && stepData.getName().equals("WebsvcsConfigCoreGroup")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found integration extension for createApplicationServer command.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "loadCommandStep");
            }
            return new WSCreateServerExt(taskCmd, stepData);
        }
        if (taskCmd.getName().equals("importNode") && stepData.getName().equals("WebsvcsConfigCoreGroup")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found integration extension for importNode command.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createCommandStep");
            }
            return new WSImportCommandExt(taskCmd, stepData);
        }
        if (taskCmd.getName().equals("deleteClusterMember") && stepData.getName().equals("WebsvcsConfigCoreGroup")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found integration extension for deleteClusterMember command.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createCommandStep");
            }
            return new WSDeleteClusterMemberExt(taskCmd, stepData);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadCommandStep");
        }
        throw new CommandNotFoundException(taskCmd.getName(), stepData.getName());
    }
}

