/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.websvcs.client.ClientCCPostProcessor;
import com.ibm.ws.websvcs.client.WSClientMetaDataNameHolder;
import com.ibm.ws.websvcs.deployment.Axis2ServiceConfigPluginManager;
import com.ibm.ws.websvcs.deployment.WASAxis2ConfigurationBuilder;
import com.ibm.ws.websvcs.deployment.WASWSDLReaderConfigurator;
import com.ibm.ws.websvcs.exception.DeploymentException;
import com.ibm.ws.websvcs.metadata.ClientMetaData;
import com.ibm.ws.websvcs.metadata.WASAxis2MetaDataImpl;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.utils.WASAxis2ExecutorFactory;
import com.ibm.ws.websvcs.utils.WSResourceFinder;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import com.ibm.wsspi.websvcs.policyset.PolicySetLoader;
import com.ibm.wsspi.websvcs.policyset.PolicySetLoaderMgr;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.utility.ExecutorFactory;
import org.apache.axis2.jaxws.wsdl.WSDLReaderConfigurator;
import org.apache.axis2.metadata.factory.ResourceFinderFactory;
import org.apache.axis2.metadata.registry.MetadataFactoryRegistry;

public class WSClientConfigurationFactory
extends ClientConfigurationFactory {
    private static final TraceComponent _tc = Tr.register(WSClientConfigurationFactory.class, null, null);
    private static WSClientConfigurationFactory instance = new WSClientConfigurationFactory();
    private Axis2ServiceConfigPluginManager configManager = null;
    private static ConfigurationContext tcConfigContext = null;
    private static ThreadLocal<WSClientMetaDataNameHolder> tlMDNH = new ThreadLocal();

    public static ClientConfigurationFactory newInstance() {
        return instance;
    }

    public synchronized ConfigurationContext getClientConfigurationContext() {
        ConfigurationContext configContext = null;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Loading client configuration context.");
        }
        try {
            List<ConfigurationContext> configContextList;
            this.init();
            String appName = null;
            String moduleName = null;
            try {
                if (!Axis2Utils.isThinClientEnv()) {
                    WASAxis2MetaDataImpl mdi = new WASAxis2MetaDataImpl(null);
                    if (mdi.getComponentMetaData() != null && mdi.getComponentMetaData().getJ2EEName() != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Getting app/module name from ComponentMetaData's J2EEName member.");
                        }
                        J2EEName jName = mdi.getComponentMetaData().getJ2EEName();
                        appName = jName.getApplication();
                        moduleName = jName.getModule();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Application name " + appName + " and module name " + moduleName + " set on client Axis configuration.");
                        }
                    } else {
                        WSClientMetaDataNameHolder mdnh = WSClientConfigurationFactory.getClientMetaDataNameHolder();
                        if (mdnh != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Getting app/module name from WSClientMetaDataNameHolder instance.");
                            }
                            appName = mdnh.getApplicationName();
                            moduleName = mdnh.getModuleName();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Application name " + appName + " and module name " + moduleName + " set on client Axis configuration.");
                            }
                        } else if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Not a server client, cannot retrieve application and module name.");
                        }
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Running in thin-client environment, not retrieving appName.");
                }
            }
            catch (Throwable t) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Couldn't retrieve Metadata: " + t.toString());
                }
                appName = null;
                moduleName = null;
            }
            WASAxis2Service service = WSClientConfigurationFactory.getWASAxis2Service();
            if (service != null && (configContextList = service.getClientConfigurationContexts(appName, moduleName)) != null && !configContextList.isEmpty()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Returning cached ConfigurationContext for module: " + moduleName + " in application: " + appName + ": " + configContextList.get(0).toString());
                }
                return configContextList.get(0);
            }
            if (Axis2Utils.isThinClientEnv()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Retrieving ConfigurationContext in thinclient");
                }
                if (tcConfigContext == null) {
                    tcConfigContext = this.getConfigContext(null, null);
                    ClientCCPostProcessor.processClientConfiguration(tcConfigContext);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Returning newly loaded ConfigurationContext for thinclient: " + tcConfigContext.toString());
                    }
                    return tcConfigContext;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Returning already loaded ConfigurationContext for thinclient: " + tcConfigContext.toString());
                }
                return tcConfigContext;
            }
            configContext = this.getConfigContext(appName, moduleName);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Built new ConfigurationContext for managed client: " + configContext.toString());
            }
            ClientCCPostProcessor.processClientConfiguration(configContext);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Finished loading client configuration context.");
            }
        }
        catch (Exception e) {
            configContext = null;
            Tr.error(_tc, "An unexpected error occurred while loading the client configuration context: " + e.toString(), e);
        }
        return configContext;
    }

    private ConfigurationContext getConfigContext(String appName, String moduleName) throws Exception {
        ConfigurationContext configContext;
        AxisConfiguration axisCfg = null;
        WASAxis2ConfigurationBuilder cfgBuilder = (WASAxis2ConfigurationBuilder)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new WASAxis2ConfigurationBuilder();
            }
        });
        axisCfg = cfgBuilder.loadAxisClientConfiguration();
        Axis2Utils.setApplicationName(axisCfg, appName);
        Axis2Utils.setModuleName(axisCfg, moduleName);
        try {
            configContext = (ConfigurationContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ConfigurationContextFactory.createEmptyConfigurationContext();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = new Exception(e.getCause());
            throw ex;
        }
        configContext.setAxisConfiguration(axisCfg);
        cfgBuilder.loadAxisClientModules(axisCfg, configContext);
        cfgBuilder.loadAxisClientTCMPlugins(configContext);
        cfgBuilder.loadAxisClientACMPlugins(configContext);
        this.loadClientBindingInfo(axisCfg);
        return configContext;
    }

    void loadClientBindingInfo(AxisConfiguration axisCfg) throws DeploymentException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadClientBindings");
        }
        try {
            WASAxis2Service service = WSClientConfigurationFactory.getWASAxis2Service();
            if (service != null) {
                ClientMetaData clientMetaData;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found WASAxis2Service in service registry");
                }
                if ((clientMetaData = (ClientMetaData)service.getClientModuleMetaData()) != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found client module metadata");
                    }
                } else {
                    clientMetaData = (ClientMetaData)service.getClientComponentMetaData();
                    if (clientMetaData != null && _tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found client component metadata");
                    }
                }
                if (clientMetaData != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Looking for client endpoint URL info on ClientMetaData instance:" + clientMetaData.hashCode());
                    }
                    Map<String, String> endpointURLMap = clientMetaData.getClientURLInfo();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found overridden client endpoint URL info");
                    }
                    Axis2Utils.createAndSetAxisParameter(axisCfg, "com.ibm.ws.websvcs.OVERRIDDEN_ENDPOINT_URL_INFO", endpointURLMap);
                }
            }
        }
        catch (Exception e) {
            String appName = Axis2Utils.getApplicationName(axisCfg);
            String moduleName = Axis2Utils.getModuleName(axisCfg);
            String msg = NLSProvider.getNLS().getFormattedMessage("processClientBindingFail00", new Object[]{moduleName, appName, e}, "Client binding information for the {0} module  in the {1} application could not be processed due to the following error: {2}.");
            throw new DeploymentException(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadClientBindings");
        }
    }

    public synchronized void completeAxis2Configuration(AxisService service) throws org.apache.axis2.deployment.DeploymentException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "completeAxis2Configuration");
        }
        if (service == null) {
            Tr.error(_tc, "Null Service, cannot complete configuration. Returning.");
            throw new org.apache.axis2.deployment.DeploymentException("Null service.");
        }
        if (this.configManager == null) {
            this.configManager = new Axis2ServiceConfigPluginManager();
            this.configManager.discoverAxis2ServiceConfigPlugins(false);
        }
        EndpointDescription endpointDesc = (EndpointDescription)Axis2Utils.getParameterValue(service, "org.apache.axis2.jaxws.description.EndpointDescription");
        AxisConfiguration axisCfg = service.getAxisConfiguration();
        Map clientURLInfo = (Map)Axis2Utils.getParameterValue(service, "com.ibm.ws.websvcs.OVERRIDDEN_ENDPOINT_URL_INFO");
        if (endpointDesc != null && clientURLInfo != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found EndpointDescription and client endpoint URL info");
            }
            if (endpointDesc.getProperty("com.ibm.ws.websvcs.OVERRIDDEN_ENDPOINT_URL_VALUE") == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Overridden endpoint URL not set on EndpointDescription");
                }
                QName sqName = endpointDesc.getServiceQName();
                QName pqName = endpointDesc.getPortQName();
                String key = sqName.toString() + ":" + pqName.toString();
                String url = (String)clientURLInfo.get(key);
                if (url != null && !"".equals(url)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "On EndpointDescription: " + endpointDesc.getName() + ":" + endpointDesc.hashCode() + " setting endpoint address value to: " + url);
                    }
                    endpointDesc.setEndpointAddress(url);
                    endpointDesc.setProperty("com.ibm.ws.websvcs.OVERRIDDEN_ENDPOINT_URL_VALUE", url);
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Overridden endpoint URL already set on EndpointDescription: " + endpointDesc.getName() + ":" + endpointDesc.hashCode());
            }
        }
        PolicySetLoader psLoader = PolicySetLoaderMgr.getContextPolicySetLoader();
        psLoader.associatePolicySets(service, this.configManager);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "completeAxis2Configuration");
        }
    }

    private void init() {
        SSLConfigManager.getInstance().initializeClientSSL();
        Protocols.init();
        ResourceFinderFactory rff = new ResourceFinderFactory();
        rff.setResourceFinder(new WSResourceFinder());
        MetadataFactoryRegistry.setFactory(ResourceFinderFactory.class, rff);
        WASAxis2ExecutorFactory myEF = WASAxis2ExecutorFactory.newInstance();
        FactoryRegistry.setFactory(ExecutorFactory.class, myEF);
        WASWSDLReaderConfigurator wsdlConfig = new WASWSDLReaderConfigurator();
        MetadataFactoryRegistry.setFactory(WSDLReaderConfigurator.class, wsdlConfig);
    }

    public static WSClientMetaDataNameHolder getClientMetaDataNameHolder() {
        return tlMDNH.get();
    }

    public static WSClientMetaDataNameHolder setClientMetaDataNameHolder(WSClientMetaDataNameHolder mdnh) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setClientMetaDataNameHolder", mdnh == null ? "<null>" : mdnh.toString());
        }
        WSClientMetaDataNameHolder previousValue = WSClientConfigurationFactory.getClientMetaDataNameHolder();
        tlMDNH.set(mdnh);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setClientMetaDataNameHolder");
        }
        return previousValue;
    }

    static WASAxis2Service getWASAxis2Service() {
        return (WASAxis2Service)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return WsServiceRegistry.getService(ClientCCPostProcessor.class, WASAxis2Service.class);
                }
                catch (Throwable t) {
                    return null;
                }
            }
        });
    }
}

