/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.HashSet;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.jaxws.description.EndpointDescription;

public class ClientEndpointHandler
extends AbstractHandler {
    private static final TraceComponent tc = Tr.register(ClientEndpointHandler.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        String finalTo;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke");
        }
        if (messageContext.getAxisService() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AxisService not found on MessageContext... nothing to do");
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        if (messageContext.isServerSide()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ClientEndpointHandler takes no action on server side");
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        EndpointDescription endpointDesc = (EndpointDescription)Axis2Utils.getParameterValue(messageContext.getAxisService(), "org.apache.axis2.jaxws.description.EndpointDescription");
        if (endpointDesc == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EndpointDescription not found on MessageContext... nothing to do");
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        EndpointReference reference = messageContext.getTo();
        if (reference == null) {
            reference = new EndpointReference();
        }
        if ((finalTo = (String)endpointDesc.getProperty("com.ibm.ws.websvcs.OVERRIDDEN_ENDPOINT_URL_VALUE")) != null && !"".equals(finalTo) && !finalTo.equals(reference.getAddress())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Endpoint address set as property on EndpointDescription: . The port: " + endpointDesc.getPortQName() + " in the service: " + endpointDesc.getServiceQName() + " will have the following to: " + finalTo);
            }
            reference.setAddress(finalTo);
        }
        messageContext.setTo(reference);
        if (reference.getAddress() != null) {
            AxisService service = messageContext.getAxisService();
            Parameter parameter = service.getParameter("com.ibm.ws.websvcs.CLIENT_URL_SET");
            Set<String> urlSet = null;
            if (parameter == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating URL set for AxisService " + service.getName());
                }
                urlSet = new HashSet();
                parameter = new Parameter("com.ibm.ws.websvcs.CLIENT_URL_SET", urlSet);
                service.addParameter(parameter);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "URL set already found on AxisService " + service.getName());
                }
                urlSet = (Set)parameter.getValue();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting URL " + reference.getAddress() + " in service URL set");
            }
            urlSet.add(reference.getAddress());
            parameter.setValue(urlSet);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

