/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.amm.scan.context.AnnotationScanningFilterHelper;
import com.ibm.ws.websvcs.Constants;
import java.util.HashSet;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;

public class WSAnnotationScanningFilter
implements Constants {
    private static final TraceComponent _tc = Tr.register(WSAnnotationScanningFilter.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    public static final String ARCHIVE_FILTERS_PROPERTY_NAME = "Ignore-Scanning-Archives";
    public static final String PACKAGE_FILTERS_PROPERTY_NAME = "Ignore-Scanning-Packages";
    private HashSet archivesToFilterDuringScan = null;
    private HashSet packagesToFilterDuringScan = null;

    public WSAnnotationScanningFilter(Archive archive, ClassLoader classLoader) {
        this.loadFilterInformation(archive, classLoader);
    }

    public synchronized boolean filterArchive(String archiveName) {
        return this.archivesToFilterDuringScan != null && this.archivesToFilterDuringScan.contains(archiveName);
    }

    public synchronized boolean filterPackage(String pkgClassName) {
        if (!this.packagesToFilterDuringScan.isEmpty()) {
            for (String filteredPackage : this.packagesToFilterDuringScan) {
                if (!pkgClassName.startsWith(filteredPackage)) continue;
                return true;
            }
        }
        return false;
    }

    protected void loadFilterInformation(Archive archive, ClassLoader classLoader) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "loadFilterInformation");
        }
        this.archivesToFilterDuringScan = new HashSet();
        this.packagesToFilterDuringScan = new HashSet();
        if (archive == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "loadFilterInformation, no archive");
            }
            return;
        }
        AnnotationScanningFilterHelper annotationScanningFilterHelper = AnnotationScanningFilterHelper.getInstance();
        annotationScanningFilterHelper.load(classLoader);
        for (String archiveValue : annotationScanningFilterHelper.getFilteredArchives()) {
            this.archivesToFilterDuringScan.add(archiveValue);
        }
        for (String packageValue : annotationScanningFilterHelper.getFilteredPackages()) {
            this.packagesToFilterDuringScan.add(packageValue);
        }
        if (archive.getContainer() != null && archive.getContainer().isEARFile()) {
            String earName;
            try {
                earName = archive.getContainer().getName();
            }
            catch (Exception ex) {
                earName = "unknown";
            }
            this.processManifest(((Archive)archive.getContainer()).getManifest(), earName);
        }
        String archiveName = "";
        try {
            archiveName = archive.getName();
        }
        catch (Exception ex) {
            archiveName = "<unknown>";
        }
        this.processManifest(archive.getManifest(), archiveName);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Filtered archives: " + this.archivesToFilterDuringScan.toString());
            Tr.debug(_tc, "Filtered packages: " + this.packagesToFilterDuringScan.toString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadFilterInformation");
        }
    }

    private void processManifest(ArchiveManifest manifest, String archiveName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processManifest, archive=" + archiveName);
        }
        if (manifest != null) {
            String filteredPackages;
            String filteredArchives = manifest.getMainAttributes().getValue(ARCHIVE_FILTERS_PROPERTY_NAME);
            if (filteredArchives != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Retrieved filtered archives: " + filteredArchives);
                }
                this.loadManifestElements(this.archivesToFilterDuringScan, filteredArchives, ARCHIVE_FILTERS_PROPERTY_NAME, archiveName);
            }
            if ((filteredPackages = manifest.getMainAttributes().getValue(PACKAGE_FILTERS_PROPERTY_NAME)) != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Retrieved filtered packages: " + filteredPackages);
                }
                this.loadManifestElements(this.packagesToFilterDuringScan, filteredPackages, PACKAGE_FILTERS_PROPERTY_NAME, archiveName);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processManifest, archive=" + archiveName);
        }
    }

    private void loadManifestElements(HashSet ignorableContainer, String ignorablesCSV, String propertyName, String archiveName) {
        for (String filterableElement : ignorablesCSV.split(",")) {
            ignorableContainer.add(filterableElement.trim());
        }
    }
}

