/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.injection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.WebServicesService;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.annotations.injection.InjectionHelper;
import com.ibm.ws.websvcs.annotations.injection.ResourceServiceRefBinding;
import com.ibm.ws.websvcs.annotations.injection.ServiceRefObjectFactory;
import com.ibm.ws.websvcs.annotations.injection.WSRBindingBuilder;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefBinding;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefMetadata;
import com.ibm.ws.websvcs.metadata.ClientMetaData;
import com.ibm.ws.websvcs.metadata.ClientServiceRefs;
import com.ibm.ws.websvcs.naming.WSComponentRefAddr;
import com.ibm.ws.websvcs.naming.WSModuleRefAddr;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.wsdl.JaxWSCatalogAccessor;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionProcessor;
import com.ibm.wsspi.injectionengine.OverrideInjectionProcessor;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.HandlerChain;
import javax.naming.Context;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.xml.rpc.Service;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceRefProcessor
extends InjectionProcessor<WebServiceRef, WebServiceRefs>
implements OverrideInjectionProcessor<Resource> {
    private static final TraceComponent tc = Tr.register(WebServiceRefProcessor.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static List<Integer> processedModules = new ArrayList<Integer>();
    private static Object semaphore = new Object();

    public WebServiceRefProcessor() {
        this.ivAnnotationClass = WebServiceRef.class;
        this.ivAnnotationsClass = WebServiceRefs.class;
    }

    public void initProcessor(ComponentNameSpaceConfiguration compNSConfig, HashMap<Class<? extends Annotation>, InjectionProcessor<? extends Annotation, ? extends Annotation>> overrideProcessorMap) throws InjectionException {
        super.initProcessor(compNSConfig, overrideProcessorMap);
        this.ivAnnotationClass = WebServiceRef.class;
        this.ivAnnotationsClass = WebServiceRefs.class;
        this.overrideProcessor(Resource.class, this);
    }

    public InjectionBinding<WebServiceRef> createInjectionBinding(WebServiceRef webServiceRef, ComponentNameSpaceConfiguration cnsConfig) throws InjectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createInjectionBinding");
        }
        WebServiceRefBinding binding = new WebServiceRefBinding(webServiceRef, cnsConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createInjectionBinding");
        }
        return binding;
    }

    public String getJndiName(WebServiceRef webServiceRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJndiName");
        }
        String name = webServiceRef.name();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJndiName, name= " + name);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXML() throws InjectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processXML, module= " + this.ivNameSpaceConfig.getModuleName());
        }
        if (this.ivNameSpaceConfig.getWebServiceRefs() == null || this.ivNameSpaceConfig.getWebServiceRefs().isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No service-refs in XML for module: " + this.ivNameSpaceConfig.getModuleName());
            }
            return;
        }
        boolean alreadyProcessed = false;
        Object object = semaphore;
        synchronized (object) {
            if (processedModules.contains(this.ivNameSpaceConfig.getJavaColonContext().hashCode())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Already processed service refs in XML for context: " + this.ivNameSpaceConfig.getJavaColonContext().hashCode() + " associated with module: " + this.ivNameSpaceConfig.getModuleName());
                }
                alreadyProcessed = true;
            } else {
                processedModules.add(this.ivNameSpaceConfig.getJavaColonContext().hashCode());
            }
        }
        try {
            List<ServiceRef> jaxrpcServiceRefs;
            WSRBindingBuilder builder = new WSRBindingBuilder();
            List<ServiceRef> jaxwsServiceRefs = WebServiceUtils.getJAXWSServiceRefs(this.ivNameSpaceConfig.getWebServiceRefs(), this.ivNameSpaceConfig.getClassLoader());
            if (jaxwsServiceRefs != null && !jaxwsServiceRefs.isEmpty()) {
                List<InjectionBinding<WebServiceRef>> bindingList;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found JAX-WS service refs in XML for module: " + this.ivNameSpaceConfig.getModuleName());
                }
                if ((bindingList = builder.buildJAXWSBindings(jaxwsServiceRefs, this.ivNameSpaceConfig)) != null && !bindingList.isEmpty()) {
                    for (InjectionBinding<WebServiceRef> binding : bindingList) {
                        this.storeInMetadataSlot(((WebServiceRefBinding)binding).getMetadata());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding binding for JAX-WS service-ref: " + binding.getJndiName() + " hashCode: " + ((Object)((Object)this)).hashCode());
                        }
                        this.addInjectionBinding(binding);
                    }
                }
            }
            if ((jaxrpcServiceRefs = WebServiceUtils.getJAXRPCServiceRefs(this.ivNameSpaceConfig.getWebServiceRefs(), this.ivNameSpaceConfig.getClassLoader())) != null && !jaxrpcServiceRefs.isEmpty()) {
                List<InjectionBinding<WebServiceRef>> bindingList;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found JAX-RPC service refs in XML for module: " + this.ivNameSpaceConfig.getModuleName());
                }
                WebServicesService webServicesService = WsServiceRegistry.getService((Object)this, WebServicesService.class);
                if (!alreadyProcessed) {
                    Context context = (Context)this.ivNameSpaceConfig.getJavaColonContext().lookup("comp/env");
                    webServicesService.bindServiceRef(this.ivNameSpaceConfig.getJ2EEName(), this.ivNameSpaceConfig.getClassLoader(), this.ivNameSpaceConfig.getModuleLoadStrategy(), this.ivNameSpaceConfig.getModuleMetaData(), context, jaxrpcServiceRefs);
                }
                if ((bindingList = builder.buildJAXRPCBindings(jaxrpcServiceRefs, this.ivNameSpaceConfig)) != null && !bindingList.isEmpty()) {
                    for (InjectionBinding<WebServiceRef> binding : bindingList) {
                        this.addInjectionBinding(binding);
                    }
                }
            }
        }
        catch (InjectionException ie) {
            throw ie;
        }
        catch (Exception e) {
            String msg = NLSProvider.getNLS().getFormattedMessage("processXMLFail", new Object[]{this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), e}, "Web service references specified in the {0} module in the {1} application could not be correctly processed due to the following error {2}.");
            Tr.error(tc, msg);
            throw new InjectionException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processXML, module= " + this.ivNameSpaceConfig.getModuleName());
        }
    }

    public InjectionBinding<WebServiceRef> resolve(InjectionBinding<WebServiceRef> binding) throws InjectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve, binding= " + binding);
        }
        if (!(binding instanceof ResourceServiceRefBinding)) {
            Reference ref = new Reference(WebServiceRefProcessor.class.getName(), ServiceRefObjectFactory.class.getName(), null);
            StringRefAddr stringRefAddr = new StringRefAddr("REF_NAME", binding.getJndiName());
            RefAddr metadataRefAddr = null;
            if (this.ivNameSpaceConfig.getComponentMetaData() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For module: " + this.ivNameSpaceConfig.getModuleName() + " storing " + "component metadata reference address");
                }
                metadataRefAddr = new WSComponentRefAddr("METADATA_REFADDR", this.ivNameSpaceConfig.getComponentMetaData().getName());
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For module: " + this.ivNameSpaceConfig.getModuleName() + " storing " + "module metadata reference address");
                }
                metadataRefAddr = new WSModuleRefAddr("METADATA_REFADDR", this.ivNameSpaceConfig.getModuleName());
            }
            this.storeInMetadataSlot(((WebServiceRefBinding)binding).getMetadata());
            ref.add(stringRefAddr);
            ref.add(metadataRefAddr);
            binding.setObjects(null, ref);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve, binding= " + binding);
        }
        return binding;
    }

    public static void registerSelf() throws InjectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSelf");
        }
        InjectionEngineAccessor.getInstance().registerInjectionProcessor(WebServiceRefProcessor.class, WebServiceRef.class);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSelf");
        }
    }

    private void storeInMetadataSlot(WebServiceRefMetadata wsrMetadata) throws InjectionException {
        try {
            WASAxis2Service service = WsServiceRegistry.getService((Object)this, WASAxis2Service.class);
            ClientMetaData clientMetaData = null;
            clientMetaData = this.ivNameSpaceConfig.getComponentMetaData() != null ? (ClientMetaData)service.getClientComponentMetaData(this.ivNameSpaceConfig.getComponentMetaData()) : (ClientMetaData)service.getClientModuleMetaData(this.ivNameSpaceConfig.getModuleMetaData());
            if (clientMetaData == null) {
                clientMetaData = new ClientMetaData();
            }
            ClientServiceRefs clientServiceRefs = clientMetaData.getClientServiceRefs();
            clientServiceRefs.setClassLoader(this.ivNameSpaceConfig.getClassLoader());
            clientServiceRefs.setJ2EEName(this.ivNameSpaceConfig.getJ2EEName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding web service ref metadata to ClientServiceRefs: " + wsrMetadata.getJndiName());
            }
            clientServiceRefs.addServiceRefMetadata(wsrMetadata);
            if (clientServiceRefs.getCatalogAccessor() == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding JaxWSCatalogAccessor to client metadata");
                }
                JaxWSCatalogAccessor catalogAccessor = new JaxWSCatalogAccessor(this.ivNameSpaceConfig.getClassLoader());
                clientServiceRefs.setCatalogAccessor(catalogAccessor);
            }
            if (this.ivNameSpaceConfig.getComponentMetaData() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Storing client metadata in component metadata: " + this.ivNameSpaceConfig.getComponentMetaData());
                }
                service.setClientComponentMetaData(clientMetaData, this.ivNameSpaceConfig.getComponentMetaData());
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Storing client metadata in module metadata: " + this.ivNameSpaceConfig.getModuleMetaData());
                }
                service.setClientModuleMetaData(clientMetaData, this.ivNameSpaceConfig.getModuleMetaData());
            }
        }
        catch (Exception e) {
            String msg = NLSProvider.getNLS().getFormattedMessage("loadClientMetaDataFail01", new Object[]{this.ivNameSpaceConfig.getModuleName(), this.ivNameSpaceConfig.getApplicationName(), e}, "The web service metadata for the {0} module in the {1} application could not be processed correctly due to the following error {2}");
            Tr.error(tc, msg);
            throw new InjectionException(msg);
        }
    }

    public void processAllAnnotations(Class<?> instanceClass) throws InjectionException {
        this.handleClassTargets(instanceClass);
        this.handleMethodTargets(this.getAllDeclaredMethods(instanceClass));
        this.handleFieldTargets(this.getAllDeclaredFields(instanceClass));
    }

    private void handleClassTargets(Class<?> instanceClass) throws InjectionException {
        WebServiceRefs webServiceRefs = instanceClass.getAnnotation(WebServiceRefs.class);
        if (webServiceRefs != null) {
            WebServiceRef[] wsrArray;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "For class: " + instanceClass.getName() + " found @WebServiceRefs" + "/@Resources");
            }
            if ((wsrArray = webServiceRefs.value()) != null && wsrArray.length > 0) {
                for (WebServiceRef webServiceRef : wsrArray) {
                    this.processClassLevelWSR(webServiceRef, instanceClass);
                }
            }
        } else {
            WebServiceRef webServiceRef = instanceClass.getAnnotation(WebServiceRef.class);
            if (webServiceRef != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "For class: " + instanceClass.getName() + " found @WebServiceRef/" + "@Resource");
                }
                this.processClassLevelWSR(webServiceRef, instanceClass);
            }
        }
    }

    private void processClassLevelWSR(WebServiceRef webServiceRef, Class<?> instanceClass) throws InjectionException {
        String jndiName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processClassLevelWSR");
        }
        if ((jndiName = this.getJndiName(webServiceRef)) == null || "".equals(jndiName)) {
            String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail00", new Object[]{instanceClass.getName()}, "The @WebServiceRef or @Resource annotation on the {0} class does not specify a value for the 'name' or 'type' attribute. For @WebServiceRef or @Resource annotations found at the class level, the 'name' and 'type' attributes must be specified.");
            Tr.error(tc, msg);
            throw new InjectionException(msg);
        }
        InjectionBinding binding = (InjectionBinding)this.ivAllAnnotationsCollection.get(jndiName);
        if (binding == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating new injection binding for @WebServiceRef annotation found on the " + instanceClass.getName() + " class.");
            }
            Class typeClass = webServiceRef.type();
            Class valueClass = webServiceRef.value();
            WebServiceRefMetadata wsrMetadata = new WebServiceRefMetadata(webServiceRef, this.ivNameSpaceConfig.getClassLoader());
            if (typeClass == null || typeClass.getName().equals(Object.class.getName())) {
                String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail00", new Object[]{instanceClass.getName()}, "The @WebServiceRef annotation on the {0} class does not specify a value for the 'name' or 'type' attribute. For @WebServiceRef annotations found at the class level, the 'name' and 'type' attributes must be specified.");
                Tr.error(tc, msg);
                throw new InjectionException(msg);
            }
            if (javax.xml.ws.Service.class.isAssignableFrom(typeClass)) {
                if (!valueClass.getName().equals(Object.class.getName()) && !valueClass.getName().equals(typeClass.getName())) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail01", new Object[]{instanceClass.getName()}, "The @WebServiceRef annotation was found on the {0} class, but the 'type' attribute and the 'value' attribute do not specify the same class. If the @WebServiceRef annotation indicates a service type injection, and the 'value' attribute does not specify the java.lang.Object class, the class specified by the 'type' and 'value' attributes must be the same");
                    Tr.error(tc, msg);
                    throw new InjectionException(msg);
                }
                wsrMetadata.setServiceClassName(typeClass.getName());
                wsrMetadata.setType(typeClass);
            } else if (!javax.xml.ws.Service.class.isAssignableFrom(typeClass)) {
                if (!javax.xml.ws.Service.class.isAssignableFrom(valueClass)) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail08", new Object[]{instanceClass.getName(), valueClass.getName()}, "The @WebServiceRef annotation was found in the {0} class, but the {1} class specified by the 'value' attribute was not a subclass of javax.xml.ws.Service. If the @WebServiceRef 'type' attribute specifies an SEI class, the 'value' attribute must specify a subclass of javax.xml.ws.Service.");
                    Tr.error(tc, msg);
                    throw new InjectionException(msg);
                }
                wsrMetadata.setServiceClassName(valueClass.getName());
                wsrMetadata.setValue(valueClass);
                wsrMetadata.setServiceSEIClassName(typeClass.getName());
                wsrMetadata.setType(typeClass);
            }
            HandlerChain hc = instanceClass.getAnnotation(HandlerChain.class);
            if (hc != null) {
                wsrMetadata.setCurrentHandlerChain(hc);
                wsrMetadata.setHandlerChainDeclaringClassName(instanceClass.getName());
            }
            wsrMetadata.setWsdlLocation(webServiceRef.wsdlLocation());
            wsrMetadata.setJndiName(this.getJndiName(webServiceRef));
            binding = new WebServiceRefBinding(wsrMetadata, this.ivNameSpaceConfig);
            this.addInjectionBinding(binding);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "An injection binding was successfully created for the @WebServiceRef annotation on the " + instanceClass.getName() + " class.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Merging @WebServiceRef annotation found on the class: " + instanceClass.getName());
            }
            if (((WebServiceRefBinding)binding).isResourceType()) {
                WebServiceRefMetadata wsrMetadata = ((WebServiceRefBinding)binding).getMetadata();
                HandlerChain hc = instanceClass.getAnnotation(HandlerChain.class);
                if (hc != null) {
                    wsrMetadata.setCurrentHandlerChain(hc);
                    wsrMetadata.setHandlerChainDeclaringClassName(instanceClass.getName());
                }
            }
            binding.merge((Annotation)webServiceRef, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processClassLevelWSR");
        }
    }

    private void handleMethodTargets(Method[] allMethods) throws InjectionException {
        if (allMethods == null) {
            return;
        }
        for (Method method : allMethods) {
            HandlerChain hc;
            WebServiceRefMetadata wsrMetadata;
            String jndiName;
            InjectionBinding binding;
            WebServiceRef webServiceRef = method.getAnnotation(WebServiceRef.class);
            if (webServiceRef == null || webServiceRef == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found @WebServiceRef annotation on method: " + method.getName() + " within class: " + method.getDeclaringClass().getName());
            }
            if ((binding = (InjectionBinding)this.ivAllAnnotationsCollection.get(jndiName = this.getMemberLevelJndiName(webServiceRef, method))) == null) {
                if (method.getParameterTypes() == null || method.getParameterTypes().length != 1) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail02", new Object[]{method.getName(), method.getDeclaringClass().getName()}, "An @WebServiceRef or @Resource annotation was found on the {0} method in the {1} class, but the method does not follow the standard JavaBeans convention.");
                    Tr.error(tc, msg);
                    throw new InjectionException(msg);
                }
                wsrMetadata = new WebServiceRefMetadata(webServiceRef, this.ivNameSpaceConfig.getClassLoader());
                wsrMetadata.setJndiName(jndiName);
                hc = method.getAnnotation(HandlerChain.class);
                if (hc != null) {
                    wsrMetadata.setCurrentHandlerChain(hc);
                    wsrMetadata.setHandlerChainDeclaringClassName(method.getDeclaringClass().getName());
                }
                wsrMetadata.setWsdlLocation(webServiceRef.wsdlLocation());
                this.validateAndSetInjectionType(webServiceRef, method, method.getParameterTypes()[0], wsrMetadata);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating new injection binding for  @WebServiceRef annotation on the " + method.getName() + " method in the " + method.getDeclaringClass().getName() + " class.");
                }
                binding = new WebServiceRefBinding(wsrMetadata, this.ivNameSpaceConfig);
                binding.setJndiName(jndiName);
                this.addInjectionBinding(binding);
                binding.addInjectionTarget((Member)method);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "An injection binding was successfully created for the @WebServiceRef annotation on the " + method.getName() + " method " + " within the " + method.getDeclaringClass().getName() + " class.");
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Merging @WebServiceRef or @Resource annotation on the " + method.getName() + " method, in the " + method.getDeclaringClass().getName() + " class.");
            }
            if (((WebServiceRefBinding)binding).isResourceType()) {
                binding.addInjectionTarget((Member)method);
                wsrMetadata = ((WebServiceRefBinding)binding).getMetadata();
                hc = method.getAnnotation(HandlerChain.class);
                if (hc != null) {
                    wsrMetadata.setCurrentHandlerChain(hc);
                    wsrMetadata.setHandlerChainDeclaringClassName(method.getDeclaringClass().getName());
                }
            }
            binding.merge((Annotation)webServiceRef, (Member)method);
        }
    }

    private void handleFieldTargets(Field[] allFields) throws InjectionException {
        if (allFields == null) {
            return;
        }
        for (Field field : allFields) {
            HandlerChain hc;
            WebServiceRefMetadata wsrMetadata;
            String jndiName;
            InjectionBinding binding;
            WebServiceRef webServiceRef = field.getAnnotation(WebServiceRef.class);
            if (webServiceRef == null || webServiceRef == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found @WebServiceRef or @Resource annotation on field: " + field.getName() + " within class: " + field.getDeclaringClass().getName());
            }
            if ((binding = (InjectionBinding)this.ivAllAnnotationsCollection.get(jndiName = this.getMemberLevelJndiName(webServiceRef, field))) == null) {
                wsrMetadata = new WebServiceRefMetadata(webServiceRef, this.ivNameSpaceConfig.getClassLoader());
                wsrMetadata.setJndiName(jndiName);
                hc = field.getAnnotation(HandlerChain.class);
                if (hc != null) {
                    wsrMetadata.setCurrentHandlerChain(hc);
                    wsrMetadata.setHandlerChainDeclaringClassName(field.getDeclaringClass().getName());
                }
                wsrMetadata.setWsdlLocation(webServiceRef.wsdlLocation());
                this.validateAndSetInjectionType(webServiceRef, field, field.getType(), wsrMetadata);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating new injection binding for  @WebServiceRef annotation on the " + field.getName() + " field in the " + field.getDeclaringClass().getName() + " class.");
                }
                binding = new WebServiceRefBinding(wsrMetadata, this.ivNameSpaceConfig);
                this.addInjectionBinding(binding);
                binding.setJndiName(jndiName);
                binding.addInjectionTarget((Member)field);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "An injection binding was successfully created for the @WebServiceRef annotation on the " + field.getName() + " field " + " within the " + field.getDeclaringClass().getName() + " class. hashCode= " + ((Object)((Object)this)).hashCode());
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Merging @WebServiceRef or @Resource annotation on the " + field.getName() + " field, in the " + field.getDeclaringClass().getName() + " class.");
            }
            if (((WebServiceRefBinding)binding).isResourceType()) {
                binding.addInjectionTarget((Member)field);
                wsrMetadata = ((WebServiceRefBinding)binding).getMetadata();
                hc = field.getAnnotation(HandlerChain.class);
                if (hc != null) {
                    wsrMetadata.setCurrentHandlerChain(hc);
                    wsrMetadata.setHandlerChainDeclaringClassName(field.getDeclaringClass().getName());
                }
            }
            binding.merge((Annotation)webServiceRef, (Member)field);
        }
    }

    private String getMemberLevelJndiName(WebServiceRef webServiceRef, Member member) {
        String jndiName = this.getJndiName(webServiceRef);
        if (jndiName == null || "".equals(jndiName)) {
            jndiName = this.getDefaultJndiName(member);
        }
        return jndiName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateAndSetInjectionType(WebServiceRef webServiceRef, Member member, Class<?> inferredType, WebServiceRefMetadata wsrMetadata) throws InjectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateAndSetInjectionType");
        }
        try {
            Class typeClass = webServiceRef.type();
            Class valueClass = webServiceRef.value();
            if (typeClass.getName().equals(Object.class.getName())) {
                if (inferredType.getName().equals(Object.class.getName())) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail03", new Object[]{member.getName(), member.getDeclaringClass().getName()}, "The @WebServiceRef or @Resource annotation was found on the {0} member in the {1} class but the type of injection could not be inferred from either the 'type' attribute or the member type.");
                    Tr.error(tc, msg);
                    throw new InjectionException(msg);
                }
                if (!javax.xml.ws.Service.class.isAssignableFrom(inferredType) && !javax.xml.ws.Service.class.isAssignableFrom(valueClass)) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail04", new Object[]{member.getName(), member.getDeclaringClass().getName(), valueClass.getName()}, "The @WebServiceRef annotation was found on the {0} member in the {1} class, but the {2} class specified by the 'value' attribute was not a subclass of javax.xml.ws.Service. If an @WebServiceRef annotation is being used for injection of a port, the 'value' attribute must specify a class that is a subclass of javax.xml.ws.Service.");
                    Tr.error(tc, msg);
                    throw new InjectionException(msg);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting WebServiceRefMetadata.type: " + inferredType.getName());
                    Tr.debug(tc, "Setting WebServiceRefMetadata.value: " + valueClass.getName());
                }
                if (!javax.xml.ws.Service.class.isAssignableFrom(inferredType)) {
                    wsrMetadata.setServiceSEIClassName(inferredType.getName());
                    wsrMetadata.setType(inferredType);
                    wsrMetadata.setServiceClassName(valueClass.getName());
                    wsrMetadata.setValue(valueClass);
                } else {
                    wsrMetadata.setType(inferredType);
                    wsrMetadata.setServiceClassName(inferredType.getName());
                }
            } else if (javax.xml.ws.Service.class.isAssignableFrom(typeClass)) {
                if (!javax.xml.ws.Service.class.isAssignableFrom(inferredType) && !inferredType.isAssignableFrom(javax.xml.ws.Service.class)) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail05", new Object[]{member.getName(), member.getDeclaringClass().getName(), typeClass.getName(), inferredType.getName()}, "The @WebServiceRef or @Resource annotation was found on the {0} member in the {1} class, but the 'type' attribute specifies the {2} class which is not compatible with the {3} class of the annotated member.");
                    Tr.error(tc, msg);
                    throw new InjectionException(msg);
                }
                if (!valueClass.getName().equals(Object.class.getName()) && !valueClass.getName().equals(typeClass.getName())) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail06", new Object[]{member.getName(), member.getDeclaringClass().getName()}, "The @WebServiceRef annotation was found on the {0} member in the {1} class, but the 'type' attribute and the 'value' attribute do not specify the same class. If the @WebServiceRef annotation indicates a service type injection, and the 'value' attribute does not specify the java.lang.Object class, the class specified by the 'type' and 'value' attributes must be the same");
                    Tr.error(tc, msg);
                    throw new InjectionException(msg);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting WebServiceRefMetadata.type: " + typeClass.getName());
                    Tr.debug(tc, "Setting WebServiceRefMetadata.value: " + typeClass.getName());
                }
                wsrMetadata.setServiceClassName(typeClass.getName());
                wsrMetadata.setType(typeClass);
                wsrMetadata.setValue(typeClass);
            } else {
                if (!inferredType.isAssignableFrom(typeClass)) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail05", new Object[]{member.getName(), member.getDeclaringClass().getName(), typeClass.getName(), inferredType.getName()}, "The @WebServiceRef annotation was found on the {0} member in the {1} class, but the 'type' attribute specifies the {2} class which is not compatible with the {3} class of the annotated member.");
                    Tr.error(tc, msg);
                    throw new InjectionException(msg);
                }
                if (!javax.xml.ws.Service.class.isAssignableFrom(valueClass)) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail07", new Object[]{member.getName(), member.getDeclaringClass()}, "The @WebServiceRef annotation was found on the {0} member in the {1} class, but the 'value' attribute did not specify a class that is a subclass of the javax.xml.ws.Service class. If the @WebServiceRef annotation is being used to indicate port injection, the 'value' attribute must specify a class that is a subclass of the javax.xml.ws.Service class.");
                    Tr.error(tc, msg);
                    throw new InjectionException(msg);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting WebServiceRefMetadata.type: " + typeClass.getName());
                    Tr.debug(tc, "Setting WebServiceRefMetadata.value: " + valueClass.getName());
                }
                wsrMetadata.setServiceSEIClassName(typeClass.getName());
                wsrMetadata.setType(typeClass);
                wsrMetadata.setServiceClassName(valueClass.getName());
                wsrMetadata.setValue(valueClass);
            }
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validateAndSetInjectionType");
            }
        }
    }

    WebServiceRefBinding getWebServiceRefBindingWithName(String jndiName) {
        return (WebServiceRefBinding)((Object)this.ivAllAnnotationsCollection.get(jndiName));
    }

    public void addOverrideInjectionBinding(InjectionBinding binding) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addOverrideInjectionBinding, binding= " + binding + ", jndiName= " + binding.getJndiName());
        }
        this.ivAllAnnotationsCollection.put(binding.getJndiName(), binding);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addOverrideInjectionBinding, binding= " + binding + ", jndiName= " + binding.getJndiName());
        }
    }

    public InjectionBinding<? extends Annotation> createOverrideInjectionBinding(Resource resource, ComponentNameSpaceConfiguration cnsConfig, Member member) throws InjectionException {
        String jndiName;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOverrideInjectionBinding");
        }
        if ((jndiName = resource.name()) == null || "".equals(jndiName)) {
            jndiName = this.getDefaultJndiName(member);
        }
        Class<?> typeClass = resource.type();
        InjectionBinding<WebServiceRef> binding = (InjectionBinding<WebServiceRef>)this.ivAllAnnotationsCollection.get(jndiName);
        if (typeClass.getName().equals(Object.class.getName())) {
            typeClass = InjectionHelper.getTypeFromMember(member);
        }
        if (binding != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found existing binding with JNDI name: " + resource.name() + "... calling merge");
            }
            WebServiceRef wsRef = InjectionHelper.createWebServiceRefFromResource(resource, typeClass, jndiName);
            binding.merge((Annotation)wsRef, member);
        }
        if (Service.class.isAssignableFrom(typeClass)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The @Resource annotation found on the " + member.getName() + " member in the " + member.getDeclaringClass().getName() + " has " + "type= " + typeClass.getName() + " and is referring to a JAX-RPC " + " service reference");
            }
            binding = InjectionHelper.createResourceServiceRefBinding(resource, cnsConfig, typeClass, jndiName);
            this.addOverrideInjectionBinding(binding);
        } else if (javax.xml.ws.Service.class.isAssignableFrom(typeClass)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The @Resource annotation found on the " + member.getName() + " member in the " + member.getDeclaringClass().getName() + " has " + "type= " + typeClass.getName() + " and is referring to a JAX-WS " + " service reference");
            }
            binding = InjectionHelper.createWebServiceRefBindingFromResource(resource, cnsConfig, typeClass, jndiName);
            this.addOverrideInjectionBinding(binding);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The @Resource annotation found on the " + member.getName() + " member in the " + member.getDeclaringClass().getName() + " did not " + "refer to a web service reference type.");
            }
            binding = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createOverrideInjectionBinding, binding= " + binding);
        }
        return binding;
    }

    public InjectionBinding<? extends Annotation> createOverrideInjectionBinding(Resource resource, ComponentNameSpaceConfiguration cnsConfig, Class<?> clazz) throws InjectionException {
        InjectionBinding<WebServiceRef> binding;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOverrideInjectionBinding, resource= " + resource.type());
        }
        if ((binding = (InjectionBinding<WebServiceRef>)this.ivAllAnnotationsCollection.get(resource.name())) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found existing binding with JNDI name: " + resource.name() + "... calling merge");
            }
            WebServiceRef wsRef = InjectionHelper.createWebServiceRefFromResource(resource, resource.type(), resource.name());
            binding.merge((Annotation)wsRef, null);
        }
        if (javax.xml.ws.Service.class.isAssignableFrom(resource.type())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found @Resource annotation on the " + clazz.getName() + " indicating a JAX-WS web service reference type");
            }
            binding = InjectionHelper.createWebServiceRefBindingFromResource(resource, cnsConfig, resource.type(), resource.name());
            this.addOverrideInjectionBinding(binding);
        } else if (Service.class.isAssignableFrom(resource.type())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found @Resource annotation on the " + clazz.getName() + " indicating a JAX-WS web service reference type");
            }
            binding = InjectionHelper.createResourceServiceRefBinding(resource, cnsConfig, resource.type(), resource.name());
            this.addOverrideInjectionBinding(binding);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The @Resource annotation found on the " + clazz.getName() + " did not refer to a web service reference type.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createOverrideInjectionBinding");
        }
        return binding;
    }
}

