/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.injection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefMetadata;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefProcessor;
import com.ibm.ws.websvcs.metadata.ClientMetaData;
import com.ibm.ws.websvcs.metadata.ClientServiceRefs;
import com.ibm.ws.websvcs.naming.WSComponentRefAddr;
import com.ibm.ws.websvcs.naming.WSModuleRefAddr;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.wsdl.JaxWSCatalogAccessor;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.ws.Service;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.HandlerChainAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceClientAnnot;
import org.apache.axis2.jaxws.spi.ServiceDelegate;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRefObjectFactory
implements ObjectFactory {
    private static final TraceComponent tc = Tr.register(ServiceRefObjectFactory.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    public static final String REF_NAME = "REF_NAME";
    public static final String METADATA_REFADDR = "METADATA_REFADDR";

    @Override
    public Object getObjectInstance(Object obj, Name name, Context context, Hashtable<?, ?> environment) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance");
        }
        Object instance = null;
        try {
            WASAxis2Service service = AccessController.doPrivileged(new PrivilegedExceptionAction<WASAxis2Service>(){

                @Override
                public WASAxis2Service run() throws Exception {
                    return WsServiceRegistry.getService(this, WASAxis2Service.class);
                }
            });
            Reference ref = (Reference)obj;
            if (ref.getClassName().equals(WebServiceRefProcessor.class.getName())) {
                StringRefAddr refAddr;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating instance for JAX-WS service ref");
                }
                if ((refAddr = (StringRefAddr)ref.get(REF_NAME)) == null) {
                    throw new Exception("Internal error. Service-ref name not available for instance creation");
                }
                String refName = (String)refAddr.getContent();
                RefAddr metadataRefAddr = ref.get(METADATA_REFADDR);
                ClientMetaData clientMetaData = null;
                if (metadataRefAddr == null) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("noClientMetaData", new Object[]{refName}, "Internal Error: Metadata could not be found for the {0} service reference");
                    Tr.error(tc, msg);
                    throw new Exception(msg);
                }
                if (metadataRefAddr.getClass().getName().equals(WSComponentRefAddr.class.getName())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting metadata for component reference");
                    }
                    clientMetaData = (ClientMetaData)service.getClientComponentMetaData();
                } else if (metadataRefAddr.getClass().getName().equals(WSModuleRefAddr.class.getName())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Getting metadata for module reference");
                    }
                    clientMetaData = (ClientMetaData)service.getClientModuleMetaData();
                }
                if (clientMetaData == null) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("noClientMetaData", new Object[]{refName}, "Internal Error: Metadata could not be found for the {0} service reference");
                    Tr.error(tc, msg);
                    throw new Exception(msg);
                }
                instance = this.getInstance(clientMetaData, refName);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.annotations.injection.ServiceRefObjectFactory", "171", this);
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance= " + instance);
        }
        return instance;
    }

    private Object getInstance(ClientMetaData clientMetaData, String refName) throws Exception {
        ClientServiceRefs clientServiceRefs;
        WebServiceRefMetadata wsrMetadata;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if ((wsrMetadata = (clientServiceRefs = clientMetaData.getClientServiceRefs()).getServiceRefMetadata(refName)) == null) {
            String msg = NLSProvider.getNLS().getFormattedMessage("noClientMetaData", new Object[]{refName}, "Internal Error: Metadata could not be found for the {0} service reference");
            Tr.error(tc, msg);
            throw new Exception(msg);
        }
        Object instance = null;
        Service svc = this.getServiceInstance(wsrMetadata, clientServiceRefs, clientMetaData.getComponentName());
        if (wsrMetadata.getType() != null && !Service.class.isAssignableFrom(wsrMetadata.getType())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating a port instance based on class: " + wsrMetadata.getType().getName());
            }
            ServiceDelegate.setPortMetadata(this.getSEIDBCFromWSRMetadata(wsrMetadata));
            instance = svc.getPort(wsrMetadata.getType());
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Service instance created based on class: " + svc.getClass().getName());
            }
            instance = svc;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance, instance= " + instance);
        }
        return instance;
    }

    private Service getServiceInstance(WebServiceRefMetadata wsrMetadata, ClientServiceRefs clientServiceRefs, String componentName) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceInstance, serviceRefName= " + wsrMetadata.getJndiName());
        }
        ServiceDelegate.setServiceMetadata(this.getSCDBCFromWSRMetadata(wsrMetadata, clientServiceRefs, componentName));
        Class<?> svcSubClass = null;
        Service instance = null;
        if (wsrMetadata.getType() != null && Service.class.getName().equals(wsrMetadata.getType().getName())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating service instance using generic Service.create(QName)");
            }
            return Service.create((QName)wsrMetadata.getServiceQName());
        }
        svcSubClass = wsrMetadata.getType() != null && Service.class.isAssignableFrom(wsrMetadata.getType()) ? wsrMetadata.getType() : wsrMetadata.getValue();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Attempting to create instance of service sub-class: " + svcSubClass.getName());
        }
        final Class<?> finalSvcSubClass = svcSubClass;
        Constructor constructor = null;
        try {
            Constructor finalConstructor;
            constructor = finalConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    return finalSvcSubClass.getDeclaredConstructor(URL.class, QName.class);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() != null) {
                throw e.getException();
            }
            throw e;
        }
        final URL url = this.getWSDLURL(wsrMetadata.getWsdlLocation(), wsrMetadata.getClassLoader());
        if (url != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating service with URL:" + url + " and QName: " + wsrMetadata.getServiceQName() + " for class: " + svcSubClass.getName());
        }
        try {
            final Constructor finalConstructor = constructor;
            final QName serviceQName = wsrMetadata.getServiceQName();
            instance = (Service)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstantiationException, IllegalAccessException, InvocationTargetException {
                    finalConstructor.setAccessible(true);
                    return (Service)finalConstructor.newInstance(url, serviceQName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() != null) {
                throw e.getException();
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceInstance, serviceRefName= " + wsrMetadata.getJndiName() + ", instance= " + instance);
        }
        return instance;
    }

    private URL getWSDLURL(final String wsdlLocation, final ClassLoader classLoader) throws IOException, MalformedURLException {
        URL url;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWSDLURL");
            }
            url = null;
            if (wsdlLocation != null) {
                block13: {
                    block12: {
                        try {
                            url = new URL(wsdlLocation);
                        }
                        catch (Exception e) {
                            if (!tc.isDebugEnabled()) break block12;
                            Tr.debug(tc, "Did not get WSDL URL for document: " + wsdlLocation + " using WSDL location string");
                        }
                    }
                    if (url == null) {
                        try {
                            url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                                @Override
                                public URL run() {
                                    return classLoader.getResource(wsdlLocation);
                                }
                            });
                        }
                        catch (Throwable t) {
                            if (!tc.isDebugEnabled()) break block13;
                            Tr.debug(tc, "Did not get WSDL URL for document: " + wsdlLocation + " using reference classloader");
                        }
                    }
                }
                if (url == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trying to get WSDL URL for: " + wsdlLocation + " using file reference");
                    }
                    final File file = new File(wsdlLocation);
                    try {
                        url = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                            @Override
                            public URL run() throws MalformedURLException {
                                return file.toURI() != null ? file.toURI().toURL() : null;
                            }
                        });
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, "Did not get WSDL URL for document: " + wsdlLocation + " using file reference");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSDLURL, url= " + url);
        }
        return url;
    }

    Map<String, Map<String, Object>> getServiceRefBindingInfo(WebServiceRefMetadata wsrMetadata, String currentCompName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServiceRefBindingInfo");
        }
        HashMap<String, Map<String, Object>> portInfoMap = new HashMap<String, Map<String, Object>>();
        LoadStrategy ls = wsrMetadata.getLoadStrategy();
        ClassLoader cl = wsrMetadata.getClassLoader();
        if (ls != null || cl != null) {
            InputStream is = null;
            try {
                if (ls != null) {
                    if (this.contains(ls, "WEB-INF/ibm-serviceref.xml")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found service-ref binding file: WEB-INF/ibm-serviceref.xml");
                        }
                        is = ls.getInputStream("WEB-INF/ibm-serviceref.xml");
                    } else if (this.contains(ls, "META-INF/ibm-serviceref.xml")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found service-ref binding file: META-INF/ibm-serviceref.xml");
                        }
                        is = ls.getInputStream("META-INF/ibm-serviceref.xml");
                    }
                } else {
                    is = cl.getResourceAsStream("META-INF/ibm-serviceref.xml");
                }
                if (is != null) {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document doc = builder.parse(is);
                    Element element = doc.getDocumentElement();
                    NodeList serviceRefsList = element.getElementsByTagName("service-refs");
                    for (int i = 0; i < serviceRefsList.getLength(); ++i) {
                        String componentName;
                        Node serviceRefs = serviceRefsList.item(i);
                        Node componentNameNode = serviceRefs.getAttributes().getNamedItem("componentName");
                        String string = componentName = componentNameNode != null ? componentNameNode.getNodeValue() : null;
                        if (currentCompName != null && !"".equals(currentCompName) && !currentCompName.equals(componentName)) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "The service-refs indicate the component name: " + componentName + " but that does not match the current " + "component name of context: " + currentCompName);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Starting to process service-refs for component: " + componentName);
                        }
                        this.processServiceRefNodes(((Element)serviceRefs).getElementsByTagName("service-ref"), portInfoMap, wsrMetadata.getJndiName());
                    }
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error processing service-ref binding info: " + e.toString());
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.annotations.injection.ServiceRefObjectFactory", "415", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServiceRefBindingInfo");
        }
        return portInfoMap;
    }

    boolean contains(final LoadStrategy ls, final String filePath) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return ls.contains(filePath);
            }
        });
    }

    void processServiceRefNodes(NodeList serviceRefList, Map<String, Map<String, Object>> portInfoMap, String serviceRefName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processServiceRefNodes");
        }
        for (int i = 0; i < serviceRefList.getLength(); ++i) {
            Node serviceRefNode = serviceRefList.item(i);
            Node serviceRefNameNode = ((Element)serviceRefNode).getElementsByTagName("service-ref-name").item(0);
            if (serviceRefName.equals(serviceRefNameNode.getTextContent())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing bindings for service-ref: " + serviceRefName);
                }
                NodeList portInfoNodes = ((Element)serviceRefNode).getElementsByTagName("port-info");
                for (int j = 0; j < portInfoNodes.getLength(); ++j) {
                    Node portInfoNode = portInfoNodes.item(j);
                    this.processPortInfoNode(portInfoNode, portInfoMap);
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Service ref being injected: " + serviceRefName + " does not match " + "the current service-ref in the binding file: " + serviceRefNameNode.getTextContent());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processServiceRefNodes");
        }
    }

    void processPortInfoNode(Node portInfoNode, Map<String, Map<String, Object>> portInfoMap) {
        Node wsdlPortNode;
        Node seiNode;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processPortInfofNode");
        }
        String seiName = null;
        String wsdlPortName = null;
        HashMap<String, String> stubProps = new HashMap<String, String>();
        Element portInfoElement = (Element)portInfoNode;
        if (portInfoElement.getElementsByTagName("service-endpoint-interface") != null && portInfoElement.getElementsByTagName("service-endpoint-interface").getLength() == 1 && (seiNode = portInfoElement.getElementsByTagName("service-endpoint-interface").item(0)) != null) {
            seiName = seiNode.getTextContent();
        }
        if (portInfoElement.getElementsByTagName("wsdl-port") != null && portInfoElement.getElementsByTagName("wsdl-port").getLength() == 1 && (wsdlPortNode = portInfoElement.getElementsByTagName("wsdl-port").item(0)) != null) {
            Node nsNode = wsdlPortNode.getAttributes().getNamedItem("namespaceURI");
            Node lpNode = wsdlPortNode.getAttributes().getNamedItem("localpart");
            if (lpNode != null) {
                QName portQName = new QName(nsNode.getNodeValue(), lpNode.getNodeValue());
                wsdlPortName = portQName.toString();
            }
        }
        if (portInfoElement.getElementsByTagName("stub-property") != null && portInfoElement.getElementsByTagName("stub-property").getLength() > 0) {
            NodeList stubProperties = portInfoElement.getElementsByTagName("stub-property");
            for (int i = 0; i < stubProperties.getLength(); ++i) {
                String value;
                Node stubProperty = stubProperties.item(i);
                Node nameNode = stubProperty.getAttributes().getNamedItem("name");
                Node valueNode = stubProperty.getAttributes().getNamedItem("value");
                String name = nameNode != null ? nameNode.getNodeValue() : null;
                String string = value = valueNode != null ? valueNode.getNodeValue() : null;
                if (name == null || value == null) continue;
                stubProps.put(name, value);
            }
            if (stubProps != null) {
                String key = seiName + ":" + wsdlPortName;
                portInfoMap.put(key, stubProps);
                if (!tc.isDebugEnabled()) {
                    // empty if block
                }
                Tr.debug(tc, "BindingProvider properties being set by key: " + key);
                for (String iterKey : stubProps.keySet()) {
                    Tr.debug(tc, "BindingProvider key: " + iterKey);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processPortInfoNode");
        }
    }

    private DescriptionBuilderComposite getSCDBCFromWSRMetadata(WebServiceRefMetadata wsrMetadata, ClientServiceRefs clientServiceRefs, String componentName) throws IOException {
        DescriptionBuilderComposite dbc = new DescriptionBuilderComposite();
        dbc.setClassName(wsrMetadata.getServiceClassName());
        String seiClassName = wsrMetadata.getServiceSEIClassName();
        if (seiClassName == null || "".equals(seiClassName) || wsrMetadata.getServiceClassName().equals(seiClassName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating service class DBC: " + dbc.getClassName() + " with handler-chains " + (wsrMetadata.getHandlerChains() == null ? "null" : "specified"));
            }
            dbc.setHandlerChainsType(wsrMetadata.getHandlerChains());
            if (wsrMetadata.getCurrentHandlerChain() != null) {
                HandlerChainAnnot hcAnnot = HandlerChainAnnot.createHandlerChainAnnotImpl();
                HandlerChain hc = wsrMetadata.getCurrentHandlerChain();
                hcAnnot.setFile(hc.file());
                hcAnnot.setName(hc.name());
                dbc.setHandlerChainAnnot(hcAnnot);
                HashMap<String, Object> dbcProps = new HashMap<String, Object>();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting handler chain declaring class: " + wsrMetadata.getHandlerChainDeclaringClassName());
                }
                dbcProps.put("HANDLER_CHAIN_DECLARING_CLASS", wsrMetadata.getHandlerChainDeclaringClassName());
                dbc.setProperties(dbcProps);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating service class DBC: " + dbc.getClassName() + " with @HandlerChain " + hcAnnot.toString());
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No @HandlerChain found when building DBC for serviceclass: " + dbc.getClassName());
            }
        }
        WebServiceClientAnnot wscAnnot = WebServiceClientAnnot.createWebServiceClientAnnotImpl();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating service class DBC: " + dbc.getClassName() + " with service QName local part " + (wsrMetadata.getServiceQName() == null ? "null" : wsrMetadata.getServiceQName().getLocalPart()));
        }
        wscAnnot.setName(wsrMetadata.getServiceQName() != null ? wsrMetadata.getServiceQName().getLocalPart() : null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating service class DBC: " + dbc.getClassName() + " with service QName targetNamespace " + (wsrMetadata.getServiceQName() == null ? "null" : wsrMetadata.getServiceQName().getNamespaceURI()));
        }
        wscAnnot.setTargetNamespace(wsrMetadata.getServiceQName() != null ? wsrMetadata.getServiceQName().getNamespaceURI() : null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating service class DBC: " + dbc.getClassName() + " with WSDL location " + (wsrMetadata.getWsdlLocation() == null ? "null" : wsrMetadata.getWsdlLocation()));
        }
        if (wsrMetadata.getWsdlLocation() != null) {
            JaxWSCatalogAccessor catalogAccessor = clientServiceRefs.getCatalogAccessor();
            if (catalogAccessor != null) {
                String wsdlLocation = catalogAccessor.resolveLocation(wsrMetadata.getWsdlLocation());
                wsrMetadata.setWsdlLocation(wsdlLocation);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating service class DBC: " + dbc.getClassName() + " with WSDL location " + wsdlLocation);
                }
                wscAnnot.setWsdlLocation(wsdlLocation);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating service class DBC: " + dbc.getClassName() + " with WSDL location " + wsrMetadata.getWsdlLocation());
                }
                wscAnnot.setWsdlLocation(wsrMetadata.getWsdlLocation());
            }
        }
        dbc.setWebServiceClientAnnot(wscAnnot);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting preferred port for service class : " + dbc.getClassName() + " with port QName: " + wsrMetadata.getPortQName());
        }
        dbc.setPreferredPort(wsrMetadata.getPortQName());
        dbc.getProperties().put("org.apache.axis2.jaxws.description.builder.SEI_MTOM_ENABLEMENT_MAP", wsrMetadata.getEnableMTOM());
        Map<String, Map<String, Object>> portInfoMap = this.getServiceRefBindingInfo(wsrMetadata, componentName);
        dbc.getProperties().put("org.apache.axis2.jaxws.description.builder.BINDING_PROPS_MAP", portInfoMap);
        return dbc;
    }

    private DescriptionBuilderComposite getSEIDBCFromWSRMetadata(WebServiceRefMetadata wsrMetadata) {
        DescriptionBuilderComposite dbc = new DescriptionBuilderComposite();
        dbc.setClassName(wsrMetadata.getServiceSEIClassName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating SEI DBC: " + dbc.getClassName() + " with handler-chains " + (wsrMetadata.getHandlerChains() == null ? "null" : "specified"));
        }
        dbc.setHandlerChainsType(wsrMetadata.getHandlerChains());
        if (wsrMetadata.getCurrentHandlerChain() != null) {
            HandlerChainAnnot hcAnnot = HandlerChainAnnot.createHandlerChainAnnotImpl();
            HandlerChain hc = wsrMetadata.getCurrentHandlerChain();
            hcAnnot.setFile(hc.file());
            hcAnnot.setName(hc.name());
            dbc.setHandlerChainAnnot(hcAnnot);
            HashMap<String, Object> dbcProps = new HashMap<String, Object>();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting handler chain declaring class: " + wsrMetadata.getHandlerChainDeclaringClassName());
            }
            dbcProps.put("HANDLER_CHAIN_DECLARING_CLASS", wsrMetadata.getHandlerChainDeclaringClassName());
            dbc.setProperties(dbcProps);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating SEI DBC: " + dbc.getClassName() + " with @HandlerChain " + hcAnnot.toString());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No @HandlerChain found when building DBC for service SEI class: " + dbc.getClassName());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating SEI DBC: " + dbc.getClassName() + " with enable-mtom: " + String.valueOf(wsrMetadata.isEnableMTOM(dbc.getClassName())));
        }
        dbc.setIsMTOMEnabled(wsrMetadata.isEnableMTOM(dbc.getClassName()));
        return dbc;
    }
}

