/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.injection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.annotations.injection.InjectionHelper;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefBinding;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefMetadata;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.lang.reflect.Member;
import javax.xml.ws.WebServiceRef;

public class ResourceServiceRefBinding
extends WebServiceRefBinding {
    private static final TraceComponent tc = Tr.register(ResourceServiceRefBinding.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public ResourceServiceRefBinding(WebServiceRef annotation, ComponentNameSpaceConfiguration nameSpaceConfig, WebServiceRefMetadata wsrMetadata) throws InjectionException {
        super(annotation, nameSpaceConfig);
        this.setJndiName(wsrMetadata.getJndiName());
        this.setResourceType(true);
        this.wsrMetadata = wsrMetadata;
    }

    public void merge(WebServiceRef annotation, Member member) throws InjectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "merge");
        }
        Class<?> typeClass = this.wsrMetadata.getType();
        Class<?> newTypeClass = annotation.type();
        if ((newTypeClass == null || newTypeClass.getName().equals(Object.class.getName())) && member != null) {
            newTypeClass = InjectionHelper.getTypeFromMember(member);
        }
        if (!newTypeClass.getName().equals(typeClass.getName())) {
            String msg = null;
            msg = member != null ? NLSProvider.getNLS().getFormattedMessage("mergeServiceRefFail01", new Object[]{this.wsrMetadata.getJndiName(), member.getName(), member.getDeclaringClass().getName(), newTypeClass.getName(), typeClass.getName()}, "The {0} service reference on the {1} member in the {2} class specifies the {3} service-interface class but other metadata was found for this service reference which specifies the {4} service-interface class.") : NLSProvider.getNLS().getFormattedMessage("mergeServiceRefFail05", new Object[]{this.wsrMetadata.getJndiName(), newTypeClass.getName(), typeClass.getName()}, "A {0} class-level service reference was found which specifies the {1} service-interface class but another service reference was found which specifies the {2} service-interface class.");
            Tr.error(tc, msg);
            throw new InjectionException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "merge");
        }
    }
}

