/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.custom.processors;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.annotations.custom.StatelessInstance;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.builder.CustomAnnotationInstance;
import org.apache.axis2.jaxws.description.builder.CustomAnnotationProcessor;

public class StatelessInstanceProcessor
implements CustomAnnotationProcessor {
    private static final TraceComponent _tc = Tr.register(StatelessInstanceProcessor.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private String annotationInstanceClassName = StatelessInstance.class.getName();

    public void processTypeLevelAnnotation(EndpointDescription ed, CustomAnnotationInstance annotation) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processTypeLevelAnnotation");
        }
        if (annotation == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Null CustomAnnotationInstance passed to processTypeLevelAnnotation");
            }
            String msg = NLSProvider.getNLS().getFormattedMessage("customAnnotationFail00", new Object[]{this.getClass().getName()}, "Internal Error:  A null argument was passed to the {0} annotation processor.");
            throw ExceptionFactory.makeWebServiceException(msg);
        }
        if (ed == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Null EndpointDescription passed to processTypeLevelAnnotation");
            }
            String msg = NLSProvider.getNLS().getFormattedMessage("customAnnotationFail00", new Object[]{this.getClass().getName()}, "Internal Error:  A null argument was passed to the {0} annotation processor.");
            throw ExceptionFactory.makeWebServiceException(msg);
        }
        AxisService axisService = ed.getAxisService();
        if (axisService == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Could not retrieve AxisService from EndpointDescription");
            }
            String msg = NLSProvider.getNLS().getFormattedMessage("customAnnotationFail01", new Object[]{this.getClass().getName()}, "Internal Error: The runtime configuration could not be retrieved for the {0} annotation processor.");
            throw ExceptionFactory.makeWebServiceException(msg);
        }
        try {
            Parameter param = new Parameter();
            param.setName("STATELESS_NAME");
            String name = (String)annotation.getParameterData("name");
            if (name == null || "".equals(name)) {
                name = Axis2Utils.getSimpleName(Axis2Utils.getServiceImplClass(axisService));
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting @Stateless.name value: " + name);
            }
            param.setValue(name);
            axisService.addParameter(param);
        }
        catch (AxisFault af) {
            throw ExceptionFactory.makeWebServiceException(af);
        }
        catch (IllegalArgumentException iae) {
            throw ExceptionFactory.makeWebServiceException(iae);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processTypeLevelAnnotation");
        }
    }

    public String getAnnotationInstanceClassName() {
        return this.annotationInstanceClassName;
    }

    public void setAnnotationInstanceClassName(String annotationInstanceClassName) {
        this.annotationInstanceClassName = annotationInstanceClassName;
    }
}

