/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.custom;

import com.ibm.ws.websvcs.resources.NLSProvider;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.jaxws.description.builder.CustomAnnotationInstance;

public class StatelessInstance
implements CustomAnnotationInstance {
    private List<String> knownParameters = new ArrayList<String>();
    private Map<String, Object> parameterData = new HashMap<String, Object>();
    private ElementType elementType;
    private String annotationClassName;

    public StatelessInstance(ElementType elementType, String annotationClassName) {
        this.elementType = elementType;
        this.annotationClassName = annotationClassName;
        this.initKnownParams();
    }

    public void addParameterData(String paramName, Object paramValue) throws IllegalArgumentException {
        if (!this.knownParameters.contains(paramName)) {
            String msg = NLSProvider.getNLS().getFormattedMessage("unknownParam00", new Object[]{paramName, this.getClass().getName()}, "The {0} parameter cannot be added to the {1} annotation instance because it is not a known parameter.");
            throw new IllegalArgumentException(msg);
        }
        this.parameterData.put(paramName, paramValue);
    }

    public Object getParameterData(String paramName) throws IllegalArgumentException {
        if (!this.knownParameters.contains(paramName)) {
            String msg = NLSProvider.getNLS().getFormattedMessage("unknownParam01", new Object[]{paramName, this.getClass().getName()}, "The {0} parameter cannot be obtained from the {1} annotation instance because it is not a known parameter.");
            throw new IllegalArgumentException(msg);
        }
        return this.parameterData.get(paramName);
    }

    public void setTarget(ElementType elementType) {
        this.elementType = elementType;
    }

    public ElementType getTarget() {
        return this.elementType;
    }

    public void setAnnotationClassName(String annotationClassName) {
        this.annotationClassName = annotationClassName;
    }

    public String getAnnotationClassName() {
        return this.annotationClassName;
    }

    private void initKnownParams() {
        this.knownParameters.add("name");
        this.knownParameters.add("mappedName");
    }
}

