/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.collector;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ClassDataObjectFields;
import com.ibm.ws.metadata.ClassRefObject;
import com.ibm.ws.metadata.ConfigReader;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.metadata.MetaDataOrchestrator;
import com.ibm.ws.metadata.MetaDataSources;
import com.ibm.ws.metadata.MetaDataSubObject;
import com.ibm.ws.metadata.ModuleDataObject;
import com.ibm.ws.metadata.annotations.AnnotationConfigReader;
import com.ibm.ws.metadata.annotations.MethodRefObject;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.annotations.adapters.ActionAdapter;
import com.ibm.ws.websvcs.annotations.adapters.AddressingAdapter;
import com.ibm.ws.websvcs.annotations.adapters.BindingTypeAdapter;
import com.ibm.ws.websvcs.annotations.adapters.HandlerChainAdapter;
import com.ibm.ws.websvcs.annotations.adapters.MTOMAdapter;
import com.ibm.ws.websvcs.annotations.adapters.OneWayAdapter;
import com.ibm.ws.websvcs.annotations.adapters.RequestWrapperAdapter;
import com.ibm.ws.websvcs.annotations.adapters.RespectBindingAdapter;
import com.ibm.ws.websvcs.annotations.adapters.ResponseWrapperAdapter;
import com.ibm.ws.websvcs.annotations.adapters.SOAPBindingAdapter;
import com.ibm.ws.websvcs.annotations.adapters.ServiceModeAdapter;
import com.ibm.ws.websvcs.annotations.adapters.WebEndpointAdapter;
import com.ibm.ws.websvcs.annotations.adapters.WebFaultAdapter;
import com.ibm.ws.websvcs.annotations.adapters.WebMethodAdapter;
import com.ibm.ws.websvcs.annotations.adapters.WebParamAdapter;
import com.ibm.ws.websvcs.annotations.adapters.WebResultAdapter;
import com.ibm.ws.websvcs.annotations.adapters.WebServiceAdapter;
import com.ibm.ws.websvcs.annotations.adapters.WebServiceClientAdapter;
import com.ibm.ws.websvcs.annotations.adapters.WebServiceProviderAdapter;
import com.ibm.ws.websvcs.annotations.adapters.WebServiceRefAdapter;
import com.ibm.ws.websvcs.annotations.adapters.WebServiceRefsAdapter;
import com.ibm.ws.websvcs.annotations.utils.Utils;
import com.ibm.ws.websvcs.deployment.HierarchyFileLocator;
import com.ibm.ws.websvcs.resources.NLSProvider;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.axis2.jaxws.description.builder.WebServiceAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceRefAnnot;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAnnotationCollector
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAnnotationCollector.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private HashMap<String, ClassDataObject> cdoMap;
    private HashMap<String, ClassDataObject> checkedDependentClasses;
    private HashMap<String, ClassDataObject> checkedSuperInterfaces;
    private LinkedList<ClassDataObject> cdoList = new LinkedList();
    private ClassLoader classLoader;
    private LoadStrategy loadStrategy;
    private static boolean adaptersRegistered = false;

    public WASAnnotationCollector() {
        this.cdoMap = new HashMap();
        this.checkedDependentClasses = new HashMap();
        this.checkedSuperInterfaces = new HashMap();
    }

    public List<ClassDataObject> collect(List<FileLocator> fileLocators) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "collect");
        }
        if (!fileLocators.isEmpty()) {
            ModuleDataObject mdo = this.getMDO(fileLocators);
            if (mdo != null) {
                Collection cdoColl = mdo.getAllClassDataObjects();
                if (cdoColl != null && cdoColl.size() > 0) {
                    for (ClassDataObject cdo : cdoColl) {
                        String className = (String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME);
                        Integer integer = (Integer)cdo.getEntry(ClassDataObjectFields.CLASS_ACCESS);
                        if (!this.collectClass(cdo) && !this.checkLocator(fileLocators.get(0)) || this.cdoMap.get(className) != null || !Utils.isPublicType(integer)) continue;
                        this.cdoMap.put(className, cdo);
                        this.cdoList.add(cdo);
                    }
                    List<FileLocator> exceptionLocators = this.getExceptionLocators();
                    this.addExceptionCDOS(exceptionLocators);
                    List<FileLocator> inheritanceLocators = this.resolveInheritance(mdo);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Making recursive ASM call with " + inheritanceLocators.size() + " inheritance derived file locators");
                    }
                    return this.collect(inheritanceLocators);
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "collect");
                }
                return this.cdoList;
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "collect");
            }
            return this.cdoList;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "collect");
        }
        return this.cdoList;
    }

    public List<ClassDataObject> collectCachedList(List<FileLocator> cachedLocators) {
        Collection cdoColl;
        ModuleDataObject mdo;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "collectCachedList");
        }
        if ((mdo = this.getMDO(cachedLocators)) != null && (cdoColl = mdo.getAllClassDataObjects()) != null && cdoColl.size() > 0) {
            for (ClassDataObject cdo : cdoColl) {
                this.cdoList.add(cdo);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "collectCachedList");
        }
        return this.cdoList;
    }

    private ModuleDataObject getMDO(List<FileLocator> fileLocators) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getMDO");
        }
        MetaDataOrchestrator mdOrch = new MetaDataOrchestrator();
        MetaDataSources source = new MetaDataSources();
        WASAnnotationCollector.registerAnnotationAdapters();
        source.iv_Sources[MetaDataSources.sv_FileLocatorIndex] = fileLocators.iterator();
        ConfigReader[] reader = new ConfigReader[]{new AnnotationConfigReader("WSClassAdapter")};
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Calling into ASM with FileLocator size: " + fileLocators.size());
        }
        ModuleDataObject mdo = null;
        try {
            mdo = mdOrch.getModuleData(reader, source, "", "");
        }
        catch (EJBConfigurationException ejbex) {
            throw new RuntimeException(ejbex);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getMDO");
        }
        return mdo;
    }

    private boolean collectClass(ClassDataObject cdo) {
        Object annotation = cdo.getEntry(ClassDataObjectFields.WEBSERVICE);
        if (annotation != null) {
            return true;
        }
        annotation = cdo.getEntry(ClassDataObjectFields.WEBSERVICEPROVIDER);
        if (annotation != null) {
            return true;
        }
        annotation = cdo.getEntry(ClassDataObjectFields.WEBSERVICECLIENT);
        if (annotation != null) {
            return true;
        }
        annotation = cdo.getEntry(ClassDataObjectFields.WEBFAULT);
        if (annotation != null) {
            return true;
        }
        if (cdo.getEntry(ClassDataObjectFields.WEBSERVICEREF) != null) {
            return true;
        }
        return cdo.getEntry(ClassDataObjectFields.WEBSERVICEREFNONTYPE) != null;
    }

    private List<FileLocator> resolveInheritance(ModuleDataObject mdo) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "resolveInheritance");
        }
        LinkedList<FileLocator> inheritanceLocators = new LinkedList<FileLocator>();
        HashMap<String, FileLocator> locatorMap = new HashMap<String, FileLocator>();
        LinkedList<ClassDataObject> superClassList = new LinkedList<ClassDataObject>();
        LinkedList<ClassDataObject> superInterfaceList = new LinkedList<ClassDataObject>();
        this.resolveDependentClasses(superClassList, mdo, inheritanceLocators, locatorMap);
        this.resolveImplementedInterfaces(superInterfaceList, mdo, inheritanceLocators, locatorMap);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "resolveInheritance");
        }
        return inheritanceLocators;
    }

    private void resolveDependentClasses(List<ClassDataObject> dependentClassList, ModuleDataObject mdo, LinkedList<FileLocator> dependentLocators, HashMap<String, FileLocator> locatorMap) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "resolveDependentClasses");
        }
        for (ClassDataObject cdo : this.cdoList) {
            String cdoKey = (String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME);
            if (this.checkedDependentClasses.get(cdoKey) != null) continue;
            this.checkedDependentClasses.put(cdoKey, cdo);
            ClassRefObject classRef = (ClassRefObject)cdo.getEntry(ClassDataObjectFields.CLASS_INFO);
            if (classRef != null) {
                String superClass = classRef.getSuperName();
                this.addDependentClass(dependentClassList, mdo, superClass, dependentLocators, locatorMap);
            }
            this.addDependentClass(dependentClassList, mdo, this.getSEIFromWebServiceAnnotation(cdo), dependentLocators, locatorMap);
            this.handleWebServiceRefAnnotations(cdo, dependentClassList, dependentLocators, locatorMap, mdo);
        }
        for (ClassDataObject cdo : dependentClassList) {
            this.cdoMap.put((String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME), cdo);
            this.cdoList.add(cdo);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "resolveDependentClasses");
        }
    }

    protected String getSEIFromWebServiceAnnotation(ClassDataObject cdo) {
        String seiName = null;
        WebServiceAnnot annot = (WebServiceAnnot)cdo.getEntry(ClassDataObjectFields.WEBSERVICE);
        if (annot != null && annot.endpointInterface() != null && !"".equals(annot.endpointInterface())) {
            seiName = annot.endpointInterface();
            seiName = seiName.replace(".", "/");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found @WebService.endpointInterface value: " + seiName);
            }
        }
        return seiName;
    }

    protected void handleWebServiceRefAnnotations(ClassDataObject cdo, List<ClassDataObject> dependentClassList, LinkedList<FileLocator> dependentLocators, HashMap<String, FileLocator> locatorMap, ModuleDataObject mdo) {
        List mdsoList;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "handleWebServiceRefAnnotations");
        }
        String type = null;
        String value = null;
        LinkedList<WebServiceRefAnnot> wsrAnnotList = null;
        Object obj = cdo.getEntry(ClassDataObjectFields.WEBSERVICEREF);
        if (obj != null) {
            if (obj instanceof List) {
                wsrAnnotList = (LinkedList<WebServiceRefAnnot>)obj;
            } else {
                wsrAnnotList = new LinkedList<WebServiceRefAnnot>();
                wsrAnnotList.add((WebServiceRefAnnot)obj);
            }
            for (WebServiceRefAnnot refAnnot : wsrAnnotList) {
                if (refAnnot == null) continue;
                type = refAnnot.getTypeString();
                if (type != null) {
                    this.addDependentClass(dependentClassList, mdo, type, dependentLocators, locatorMap);
                }
                if ((value = refAnnot.getValueString()) == null) continue;
                this.addDependentClass(dependentClassList, mdo, value, dependentLocators, locatorMap);
            }
        }
        if ((mdsoList = (List)cdo.getEntry(ClassDataObjectFields.WEBSERVICEREFNONTYPE)) != null) {
            for (MetaDataSubObject mdso : mdsoList) {
                WebServiceRefAnnot refAnnot = (WebServiceRefAnnot)mdso.getValue();
                type = refAnnot.getTypeString();
                if ((type == null || "".equals(type) || type.equals(Object.class.getName())) && mdso != null) {
                    type = mdso.getSignature();
                }
                if (type != null) {
                    if ((type = type.replace(".", "/")).startsWith("L") && type.endsWith(";")) {
                        type = type.substring(1, type.length() - 1);
                    }
                    this.addDependentClass(dependentClassList, mdo, type, dependentLocators, locatorMap);
                }
                if ((value = refAnnot.getValueString()) == null) continue;
                if ((value = value.replace(".", "/")).startsWith("L") && value.endsWith(";")) {
                    value = value.substring(1, value.length() - 1);
                }
                this.addDependentClass(dependentClassList, mdo, value, dependentLocators, locatorMap);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "handleWebServiceRefAnnotations");
        }
    }

    private void addDependentClass(List<ClassDataObject> dependentClassList, ModuleDataObject mdo, String dependentClass, LinkedList<FileLocator> dependentLocators, HashMap<String, FileLocator> locatorMap) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addDependentClass");
        }
        if (dependentClass != null && !dependentClass.equals("java/lang/Object")) {
            ClassDataObject cdo = mdo.getClassDataObject(dependentClass);
            if (cdo != null) {
                if (this.cdoMap.get(dependentClass) == null) {
                    dependentClassList.add(cdo);
                }
                ClassRefObject classRef = (ClassRefObject)cdo.getEntry(ClassDataObjectFields.CLASS_INFO);
                String extendedClass = classRef.getSuperName();
                this.addDependentClass(dependentClassList, mdo, extendedClass, dependentLocators, locatorMap);
            } else {
                String filePath = dependentClass + ".class";
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for dependent class: " + filePath + " on application " + "unit classpath");
                }
                try {
                    URL url = this.classLoader.getResource(filePath);
                    if (url != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Found dependent class: " + filePath + " on application " + "unit classpath using classloader \n: " + this.classLoader);
                        }
                        if (locatorMap.get(dependentClass) == null && this.cdoMap.get(dependentClass) == null) {
                            HierarchyFileLocator locator = new HierarchyFileLocator(url, filePath, url.toString());
                            locatorMap.put(dependentClass, locator);
                            dependentLocators.add(locator);
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Did not find dependent class: " + filePath + " on application " + "unit classpath using classloader \n: " + this.classLoader);
                    }
                }
                catch (Throwable t) {
                    FFDCFilter.processException(t, "com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector.addSuperClass", "304", this);
                    Object[] inserts = new Object[]{filePath, t};
                    String msg = NLSProvider.getNLS().getFormattedMessage("loadSuperClassFail00", inserts, "Error occurred while attempting to load URL for class file {0}: {1}");
                    Tr.error(_tc, msg);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addDependentClass");
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private boolean checkLocator(FileLocator locator) {
        return locator != null && locator instanceof HierarchyFileLocator;
    }

    private void resolveImplementedInterfaces(List<ClassDataObject> superInterfaceList, ModuleDataObject mdo, LinkedList<FileLocator> inheritanceLocators, HashMap<String, FileLocator> locatorMap) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "resolveImplementedInterfaces");
        }
        for (ClassDataObject cdo : this.cdoList) {
            String[] interfaces;
            String cdoKey = (String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME);
            if (this.checkedSuperInterfaces.get(cdoKey) != null) continue;
            this.checkedSuperInterfaces.put(cdoKey, cdo);
            ClassRefObject classRef = (ClassRefObject)cdo.getEntry(ClassDataObjectFields.CLASS_INFO);
            if (classRef == null || (interfaces = classRef.getInterfaces()) == null || interfaces.length <= 0) continue;
            this.addImplementedInterfaces(superInterfaceList, mdo, interfaces, inheritanceLocators, locatorMap);
        }
        for (ClassDataObject cdo : superInterfaceList) {
            this.cdoMap.put((String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME), cdo);
            this.cdoList.add(cdo);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "resolveImplementedInterfaces");
        }
    }

    private void addImplementedInterfaces(List<ClassDataObject> superInterfaceList, ModuleDataObject mdo, String[] interfaces, List<FileLocator> inheritanceLocators, HashMap<String, FileLocator> locatorMap) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addImplementedInterfaces");
        }
        for (int i = 0; i < interfaces.length; ++i) {
            String interfaceName = interfaces[i];
            ClassDataObject cdo = mdo.getClassDataObject(interfaceName);
            if (cdo != null) {
                if (this.cdoMap.get(interfaceName) != null) continue;
                superInterfaceList.add(cdo);
                ClassRefObject cRef = (ClassRefObject)cdo.getEntry(ClassDataObjectFields.CLASS_INFO);
                String[] recInterfaces = cRef.getInterfaces();
                if (recInterfaces == null || recInterfaces.length <= 0) continue;
                this.addImplementedInterfaces(superInterfaceList, mdo, recInterfaces, inheritanceLocators, locatorMap);
                continue;
            }
            String filePath = interfaceName + ".class";
            try {
                URL url = this.classLoader.getResource(filePath);
                if (url == null || locatorMap.get(interfaceName) != null || this.cdoMap.get(interfaceName) != null) continue;
                HierarchyFileLocator locator = new HierarchyFileLocator(url, filePath, url.toString());
                locatorMap.put(interfaceName, locator);
                inheritanceLocators.add(locator);
                continue;
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector.addImplementedInterfaces", "539", this);
                Object[] inserts = new Object[]{filePath, t};
                String msg = NLSProvider.getNLS().getFormattedMessage("loadSuperClassFail00", inserts, "Error occurred while attempting to load URL for class file {0}: {1}");
                Tr.error(_tc, msg);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addImplementedInterfaces");
        }
    }

    private List<FileLocator> getExceptionLocators() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getExceptionLocators");
        }
        LinkedList<FileLocator> locators = new LinkedList<FileLocator>();
        HashMap<String, HierarchyFileLocator> locatorMap = new HashMap<String, HierarchyFileLocator>();
        for (ClassDataObject cdo : this.cdoList) {
            ClassRefObject cRef = (ClassRefObject)cdo.getEntry(ClassDataObjectFields.CLASS_INFO);
            ArrayList mRefs = cRef.getMethodRefs();
            if (mRefs == null) continue;
            for (MethodRefObject mRef : mRefs) {
                String[] exceptions = mRef.getExceptions();
                if (exceptions == null) continue;
                for (String exception : exceptions) {
                    String fileName = exception + ".class";
                    try {
                        URL url = this.classLoader.getResource(fileName);
                        if (url == null || locatorMap.get(exception) != null || this.cdoMap.get(exception) != null) continue;
                        HierarchyFileLocator locator = new HierarchyFileLocator(url, fileName, url.toString());
                        locatorMap.put(exception, locator);
                        locators.add(locator);
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException(t, "com.ibm.ws.websvcs.annotations.collector.WASAnnotationCollector.addImplementedInterfaces", "429", this);
                        Object[] inserts = new Object[]{fileName, t};
                        String msg = NLSProvider.getNLS().getFormattedMessage("loadSuperClassFail00", inserts, "Error occurred while attempting to load URL for class file {0}: {1}");
                        Tr.error(_tc, msg);
                    }
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getExceptionLocators");
        }
        return locators;
    }

    private void addExceptionCDOS(List<FileLocator> locators) {
        Collection cdoColl;
        ModuleDataObject mdo;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "addExceptionCDOS");
        }
        if ((mdo = this.getMDO(locators)) != null && (cdoColl = mdo.getAllClassDataObjects()) != null && cdoColl.size() > 0) {
            for (ClassDataObject cdo : cdoColl) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Adding exception ClassDataObject: " + cdo.getEntry(ClassDataObjectFields.CLASS_NAME));
                }
                if (this.cdoMap.get(cdo.getEntry(ClassDataObjectFields.CLASS_NAME)) != null) continue;
                this.cdoMap.put((String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME), cdo);
                this.cdoList.add(cdo);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "addExceptionCDOS");
        }
    }

    public static void registerAnnotationAdapters() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "registerAnnotationAdapters");
        }
        if (!adaptersRegistered) {
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/BindingType;", BindingTypeAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/jws/HandlerChain;", HandlerChainAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/jws/Oneway;", OneWayAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/RequestWrapper;", RequestWrapperAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/ResponseWrapper;", ResponseWrapperAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/ServiceMode;", ServiceModeAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/jws/soap/SOAPBinding;", SOAPBindingAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/WebEndpoint;", WebEndpointAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/WebFault;", WebFaultAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/jws/WebMethod;", WebMethodAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/jws/WebParam;", WebParamAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/jws/WebResult;", WebResultAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/jws/WebService;", WebServiceAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/WebServiceClient;", WebServiceClientAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/WebServiceProvider;", WebServiceProviderAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/WebServiceRef;", WebServiceRefAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/WebServiceRefs;", WebServiceRefsAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/soap/Addressing;", AddressingAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/soap/MTOM;", MTOMAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/RespectBinding;", RespectBindingAdapter.class);
            AnnotationConfigReader.addAnnotationAdapterClass((String)"Ljavax/xml/ws/Action;", ActionAdapter.class);
            adaptersRegistered = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "registerAnnotationAdapters");
        }
    }
}

