/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.annotations.amm.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.annotations.amm.client.WSAmmUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.amm.scan.AnnotationTarget;
import com.ibm.wsspi.amm.scan.ClassAnnotationTarget;
import com.ibm.wsspi.amm.scan.FieldAnnotationTarget;
import com.ibm.wsspi.amm.scan.MethodAnnotationTarget;
import com.ibm.wsspi.amm.scan.util.info.AnnotationInfo;
import com.ibm.wsspi.amm.scan.util.info.AnnotationValue;
import com.ibm.wsspi.amm.scan.util.info.ClassInfo;
import com.ibm.wsspi.amm.scan.util.info.FieldInfo;
import com.ibm.wsspi.amm.scan.util.info.Info;
import com.ibm.wsspi.amm.scan.util.info.MethodInfo;
import com.ibm.wsspi.amm.validate.AnnotationValidator;
import com.ibm.wsspi.amm.validate.ValidationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.Resource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.MergeData;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceValidator
implements AnnotationValidator {
    private static TraceComponent tc = Tr.register(ResourceValidator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public Class<? extends Annotation> getAnnotationClass() {
        return Resource.class;
    }

    public void validate(MergeData mergeData, AnnotationTarget annotationTarget) throws ValidationException {
        this.validate(mergeData, annotationTarget, null);
    }

    public void validate(MergeData mergeData, AnnotationTarget annotationTarget, AnnotationInfo annotationInfo) throws ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        EObject eObject = mergeData.getDeploymentDescriptor();
        if (annotationTarget instanceof ClassAnnotationTarget) {
            ClassInfo info = ((ClassAnnotationTarget)annotationTarget).getApplicableClass();
            if (annotationInfo == null) {
                annotationInfo = ((ClassAnnotationTarget)annotationTarget).getApplicableClass().getAnnotation(annotationTarget.getAnnotationClass());
            }
            this.validateClassLevelAnnotation((ClassAnnotationTarget)annotationTarget, eObject, annotationInfo);
            this.validateWithDD(eObject, annotationTarget, (Info)info, annotationInfo);
        } else if (annotationTarget instanceof MethodAnnotationTarget) {
            MethodInfo info = ((MethodAnnotationTarget)annotationTarget).getApplicableMethod();
            this.validateMethodLevelAnnotation((MethodAnnotationTarget)annotationTarget);
            this.validateWithDD(eObject, annotationTarget, (Info)info, info.getAnnotation(annotationTarget.getAnnotationClass()));
        } else if (annotationTarget instanceof FieldAnnotationTarget) {
            FieldInfo info = ((FieldAnnotationTarget)annotationTarget).getApplicableField();
            this.validateFieldLevelAnnotation((FieldAnnotationTarget)annotationTarget);
            this.validateWithDD(eObject, annotationTarget, (Info)info, info.getAnnotation(annotationTarget.getAnnotationClass()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    public void validateWithDD(EObject eObject, AnnotationTarget annotationTarget, Info info, AnnotationInfo annotationInfo) throws ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateWithDD");
        }
        try {
            String name;
            String className = annotationTarget.getApplicableClass().getName();
            String string = name = annotationInfo.getValue("name") != null ? annotationInfo.getValue("name").getStringValue() : null;
            if (WSAmmUtils.isJAXRPCServiceResource(annotationTarget, annotationInfo, info)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found @Resource annotation that indicates a JAX-RPC service reference in class: " + className);
                }
                ServiceRef ddServiceRef = null;
                List serviceRefs = WSAmmUtils.getServiceRefs(eObject);
                if (serviceRefs != null && !serviceRefs.isEmpty() && name != null) {
                    for (ServiceRef serviceRef : serviceRefs) {
                        if (!serviceRef.getServiceRefName().equals(name)) continue;
                        ddServiceRef = serviceRef;
                        break;
                    }
                }
                if (ddServiceRef == null) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("mergeValidateFail00", new Object[]{annotationTarget.getApplicableClass().getName(), name}, "An @Resource annotation was found in the {0} class that specified a JAX-RPC service reference but a service-ref with the {1} service-ref-name value was not defined in the deployment descriptor.");
                    Tr.error(tc, msg);
                    throw new ValidationException(msg);
                }
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = NLSProvider.getNLS().getFormattedMessage("mergeValidateFail01", new Object[]{annotationTarget.getApplicableClass().getName(), e}, "Validation of the @Resource or @WebServiceRef annotation in the {0} class failed due to the following error: {1}");
            Tr.error(tc, msg);
            throw new ValidationException(msg);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateWithDD");
            }
        }
    }

    protected void validateClassLevelAnnotation(ClassAnnotationTarget cat, EObject eObject, AnnotationInfo annotationInfo) throws ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateClassLevelAnnotation");
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found @Resource annotation that indicates a service reference on class: " + cat.getApplicableClass().getName());
            }
            String annotationTypeName = cat.getAnnotationClass().getName();
            ClassInfo classInfo = cat.getApplicableClass();
            AnnotationValue value = annotationInfo.getValue("name");
            if (value == null || "".equals(value.getStringValue())) {
                String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail00", new Object[]{classInfo.getName()}, "The @WebServiceRef or @Resource annotation on the {0} class does not specify a value for the ''name'' or ''type'' attribute. For @WebServiceRef or @Resource annotations found at the class level, the ''name'' and ''type'' attributes must be specified.");
                Tr.error(tc, msg);
                throw new ValidationException(msg);
            }
            value = annotationInfo.getValue("type");
            if (value == null) {
                String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail00", new Object[]{classInfo.getName()}, "The @WebServiceRef or @Resource annotation on the {0} class does not specify a value for the ''name'' or ''type'' attribute. For @WebServiceRef or @Resource annotations found at the class level, the ''name'' and ''type'' attributes must be specified.");
                Tr.error(tc, msg);
                throw new ValidationException(msg);
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = NLSProvider.getNLS().getFormattedMessage("mergeValidateFail01", new Object[]{cat.getApplicableClass().getName(), e}, "Validation of the @Resource or @WebServiceRef annotation in the {0} class failed due to the following error: {1}");
            Tr.error(tc, msg);
            throw new ValidationException(msg);
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateClassLevelAnnotation");
            }
        }
    }

    protected void validateMethodLevelAnnotation(MethodAnnotationTarget mat) throws ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateMethodLevelAnnotation");
        }
        MethodInfo methodInfo = mat.getApplicableMethod();
        List paramTypes = methodInfo.getParameterTypes();
        ClassInfo returnTypeInfo = methodInfo.getReturnType();
        if (paramTypes == null || paramTypes.size() != 1 || !methodInfo.getName().startsWith("set") || !returnTypeInfo.getName().equals("void")) {
            String msg = NLSProvider.getNLS().getFormattedMessage("webServiceRefFail02", new Object[]{methodInfo.getName(), mat.getApplicableClass().getName()}, "An @WebServiceRef or @Resource annotation was found on the {0} method in the {1} class, but the method does not follow the standard JavaBeans convention.");
            Tr.error(tc, msg);
            throw new ValidationException(msg);
        }
        ClassInfo paramInfo = (ClassInfo)paramTypes.get(0);
        AnnotationInfo info = methodInfo.getAnnotation(mat.getAnnotationClass());
        AnnotationValue annotationValue = info.getValue("type");
        if (annotationValue != null) {
            ClassInfo typeInfo = annotationValue.getClassValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Determining if type specified in annotation: " + typeInfo.getName() + " is compatible with the method parameter " + "type: " + paramInfo.getName());
            }
            if (!WSAmmUtils.isAssignableFrom(typeInfo, paramInfo.getName())) {
                String msg = NLSProvider.getNLS().getFormattedMessage("mergeValidateFail03", new Object[]{methodInfo.getName(), mat.getApplicableClass().getName(), typeInfo.getName(), paramInfo.getName()}, "An @Resource or @WebServiceRef annotation on the {0} member in the {1} class specifies the {2} type which is not compatible with the {3} type targetted for injection.");
                Tr.error(tc, msg);
                throw new ValidationException(msg);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateMethodLevelAnnotation");
        }
    }

    protected void validateFieldLevelAnnotation(FieldAnnotationTarget fat) throws ValidationException {
        ClassInfo typeInfo;
        FieldInfo fieldInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFieldLevelAnnotation");
        }
        if (Modifier.isFinal((fieldInfo = fat.getApplicableField()).getModifiers())) {
            String msg = NLSProvider.getNLS().getFormattedMessage("mergeValidateFail04", new Object[]{fieldInfo.getName(), fieldInfo.getDeclaringClass().getName()}, "An @Resource or @WebServiceRef annotation was found on the {0} field in the {1} class, but the field is declared as final. This is not allowed by the Java Enterpise Editon 5 Platform Specification.");
            Tr.error(tc, msg);
            throw new ValidationException(msg);
        }
        AnnotationInfo annotationInfo = fieldInfo.getAnnotation(fat.getAnnotationClass());
        AnnotationValue typeValue = annotationInfo.getValue("type");
        if (typeValue != null && (typeInfo = typeValue.getClassValue()) != null && !typeInfo.getName().equals(Object.class.getName()) && !WSAmmUtils.isAssignableFrom(typeInfo, fieldInfo.getType().getName())) {
            String msg = NLSProvider.getNLS().getFormattedMessage("mergeValidateFail03", new Object[]{fieldInfo.getName(), fieldInfo.getDeclaringClass().getName(), typeInfo.getName(), fieldInfo.getType().getName()}, "An @Resource or @WebServiceRef annotation on the {0} member in the {1} class specifies the {2} type which is not compatible with the {3} type targetted for injection.");
            Tr.error(tc, msg);
            throw new ValidationException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFieldLevelAnnotation");
        }
    }
}

