/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.utils.BAIS;
import com.ibm.ws.webservices.utils.BufferedWriter;
import com.ibm.ws.webservices.utils.LowFlushFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;

public final class WebServicesInputSource
extends InputSource {
    protected boolean copyIfNotResettable = false;
    protected static Log log = LogFactory.getLog(WebServicesInputSource.class.getName());
    private String _stringContent = null;
    private byte[] _byteArrayContent = null;
    private BAIS _baisContent = null;
    private Boolean _isPossiblyFault = null;

    public static WebServicesInputSource create(InputStream is) {
        return new WebServicesInputSource(is);
    }

    public static WebServicesInputSource create(Source s) {
        InputSource is = XMLUtils.sourceToInputSource(s);
        return WebServicesInputSource.create(is);
    }

    public static WebServicesInputSource create(InputSource is) {
        if (is instanceof WebServicesInputSource) {
            return (WebServicesInputSource)is;
        }
        WebServicesInputSource wsis = new WebServicesInputSource();
        wsis.setPublicId(is.getPublicId());
        wsis.setSystemId(is.getSystemId());
        wsis.setEncoding(is.getEncoding());
        wsis.setByteStream(is.getByteStream());
        wsis.setCharacterStream(is.getCharacterStream());
        return wsis;
    }

    public static WebServicesInputSource create(byte[] bytes) {
        WebServicesInputSource wsis = new WebServicesInputSource();
        wsis.setByteArrayContent(bytes);
        return wsis;
    }

    public static WebServicesInputSource create(String text) {
        WebServicesInputSource wsis = new WebServicesInputSource();
        wsis.setStringContent(text);
        return wsis;
    }

    private WebServicesInputSource() {
    }

    private WebServicesInputSource(String s) {
        super(s);
    }

    private WebServicesInputSource(InputStream inputstream) {
        super(inputstream);
    }

    private WebServicesInputSource(Reader reader) {
        super(reader);
    }

    public boolean getCopyIfNotResettable() {
        return this.copyIfNotResettable;
    }

    public void setCopyIfNotResettable(boolean value) {
        this.copyIfNotResettable = value;
    }

    public void setEncoding(String s) {
        if (log.isDebugEnabled()) {
            log.debug("Enter::setEncoding() with parameter " + s);
        }
        if (this.getEncoding() != null && !this.getEncoding().equalsIgnoreCase(s)) {
            boolean allowChange = false;
            if (s != null && (s.equalsIgnoreCase("utf-8") || s.equalsIgnoreCase("utf-16") || s.equalsIgnoreCase("ISO-8859-1"))) {
                allowChange = true;
            }
            if (!allowChange) {
                throw new InternalException(Messages.getMessage("cantChangeEncoding", this.getEncoding(), s));
            }
            if (log.isDebugEnabled()) {
                log.debug("Allowing character encoding to be changed; this encoding will also be cached.");
            }
            String currentText = this.getStringContent();
            this._byteArrayContent = null;
            this._baisContent = null;
            byte[] newBytes = JavaUtils.convertStringToBytes(currentText, s);
            this.setByteArrayContent(newBytes);
        }
        super.setEncoding(s);
    }

    public String getEncoding() {
        return super.getEncoding();
    }

    public void setCharacterStream(Reader reader) {
        this.clearCache();
        super.setCharacterStream(reader);
    }

    public Reader getCharacterStream() {
        return super.getCharacterStream();
    }

    public void setByteStream(InputStream inputstream) {
        this.clearCache();
        super.setByteStream(inputstream);
    }

    public InputStream getByteStream() {
        InputStream is;
        if (log.isDebugEnabled()) {
            log.debug("Enter getByteStream()");
        }
        if ((is = super.getByteStream()) == null || !is.markSupported() && this.copyIfNotResettable) {
            if (log.isDebugEnabled()) {
                log.debug("get BAISContent");
            }
            is = this.getBAISContent();
        } else if (!(is instanceof FilterIS)) {
            if (log.isDebugEnabled()) {
                log.debug("Create FilterIS");
            }
            is = new FilterIS(is);
        }
        this.autoReset(is);
        super.setByteStream(is);
        if (log.isDebugEnabled()) {
            log.debug(this.dumpStats());
            log.debug("Exit getByteStream()");
        }
        return is;
    }

    private void autoReset(InputStream is) {
        block6: {
            if (is instanceof BAIS || is instanceof FilterIS && ((FilterIS)is).isFilteringBAIS()) {
                try {
                    if (is.available() == 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("The InputStream " + is + " for " + this + " appears to be consumed.  Attempting to reset.");
                        }
                        is.reset();
                        if (log.isDebugEnabled()) {
                            log.debug("Successfully reset.  There are " + is.available() + " bytes available.");
                        }
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.utils.WebServicesInputSource.autoReset", "%C", this);
                    if (!log.isDebugEnabled()) break block6;
                    log.debug("Could not attempt auto reset due to error: " + e + " Processing continues.");
                }
            }
        }
    }

    public int getContentLength() {
        int contentLength = 0;
        if (this.hasBAISContent()) {
            BAIS bais = this.getBAISContent();
            contentLength = bais.getContentLength();
        } else {
            InputStream is = this.getByteStream();
            if (is instanceof FilterIS) {
                contentLength = (int)((FilterIS)is).getLength();
            } else if (is != null && is.markSupported()) {
                try {
                    is.reset();
                    int avail = is.available();
                    is.skip(avail);
                    contentLength = avail;
                }
                catch (IOException io) {
                    FFDCFilter.processException((Throwable)io, "com.ibm.ws.webservices.utils.WebServicesInputSource.getContentLength", "271", this);
                    throw new InternalException(io);
                }
            } else {
                BAIS bais = this.getBAISContent();
                contentLength = bais.getContentLength();
            }
        }
        return contentLength;
    }

    public byte[] getBytes() {
        return this.getByteArrayContent();
    }

    public String getString() {
        return this.getStringContent();
    }

    public void reset() {
        try {
            InputStream _is = this.getByteStream();
            if (_is.markSupported()) {
                _is.reset();
            }
        }
        catch (IOException ioe) {
            log.error(Messages.getMessage("exception00"), ioe);
        }
    }

    public boolean isPossiblyFault() {
        boolean found = false;
        if (this._isPossiblyFault != null) {
            found = this._isPossiblyFault;
        } else if (this.hasStringContent()) {
            String text = this.getStringContent();
            int index = text.lastIndexOf(62);
            found = index >= 0 && text.lastIndexOf("Fault", index) >= 0;
        } else if (this.hasByteArrayContent()) {
            byte[] bytes = this.getByteArrayContent();
            int start = 0;
            int end = bytes.length - 1;
            found = this.isPossiblyFault(bytes, start, end, this.getEncoding());
        } else if (this.hasBAISContent()) {
            BAIS bais = this.getBAISContent();
            byte[] bytes = bais.getBuff();
            int start = bais.getMark();
            int end = bais.getCount() - 1;
            found = this.isPossiblyFault(bytes, start, end, this.getEncoding());
        } else {
            InputStream is = super.getByteStream();
            if (is == null || !is.markSupported()) {
                BAIS bais = this.getBAISContent();
                byte[] bytes = bais.getBuff();
                int start = bais.getMark();
                int end = bais.getCount() - 1;
                found = this.isPossiblyFault(bytes, start, end, this.getEncoding());
            } else {
                try {
                    is.reset();
                    int avail = is.available();
                    int LEN = 4096;
                    byte[] bytes = new byte[LEN];
                    for (int start = avail - LEN; start > 0 && !found; start -= LEN / 2) {
                        is.skip(start);
                        is.read(bytes, 0, LEN);
                        is.reset();
                        if (!this.isPossiblyFault(bytes, 0, LEN - 1, this.getEncoding())) continue;
                        found = true;
                    }
                    if (!found) {
                        is.reset();
                        int readLen = avail > LEN ? LEN : avail;
                        is.read(bytes, 0, readLen);
                        is.reset();
                        found = this.isPossiblyFault(bytes, 0, readLen - 1, this.getEncoding());
                    }
                }
                catch (IOException io) {
                    FFDCFilter.processException((Throwable)io, "com.ibm.ws.webservices.utils.WebServicesInputSource.isPossiblyFault", "381", this);
                    throw new InternalException(io);
                }
            }
        }
        this._isPossiblyFault = new Boolean(found);
        return found;
    }

    private boolean isPossiblyFault(byte[] bytes, int start, int end, String encoding) {
        byte[] fault;
        byte[] gt;
        if (encoding == null || encoding.length() == 0) {
            gt = new String(">").getBytes();
            fault = new String("Fault").getBytes();
        } else {
            try {
                gt = new String(">").getBytes(encoding);
                fault = new String("Fault").getBytes(encoding);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.utils.WebServicesInputSource.isPossiblyFault", "411", this);
                return true;
            }
        }
        int index = JavaUtils.find(gt, bytes, start, end, false);
        return index >= 0 && JavaUtils.find(fault, bytes, start, index, false) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream os, String characterEncoding) throws IOException {
        if (this.hasByteArrayContent() && this.getEncoding().equalsIgnoreCase(characterEncoding)) {
            byte[] bytes = this.getByteArrayContent();
            if (bytes.length == 0) {
                throw new IOException(Messages.getMessage("wsisWriteError"));
            }
            os.write(this.getByteArrayContent());
        } else {
            os = new LowFlushFilter(os);
            Writer writer = null;
            writer = characterEncoding != null ? new OutputStreamWriter(os, characterEncoding) : new OutputStreamWriter(os);
            writer = new BufferedWriter(writer, os, characterEncoding);
            try {
                this.writeTo(writer);
            }
            finally {
                writer.flush();
            }
        }
    }

    public void writeTo(Writer writer) throws IOException {
        String value = this.getStringContent();
        if (value == null || value.length() == 0) {
            throw new IOException(Messages.getMessage("wsisWriteError"));
        }
        writer.write(value);
    }

    public Source createTransformSource() {
        BAIS bais = this.getBAISContent();
        bais.reset();
        return new StreamSource(bais);
    }

    public String dumpStats() {
        return "WebServicesInputSource Stats: " + this + " hasStringContent()?" + this.hasStringContent() + " hasByteArrayContent()?" + this.hasByteArrayContent() + " hasBAISContent()?" + this.hasBAISContent() + " BAIS available =" + (this.hasBAISContent() ? String.valueOf(this.getBAISContent().available()) : "n/a") + " BAIS mark =" + (this.hasBAISContent() ? String.valueOf(this.getBAISContent().getMark()) : "n/a") + " BAIS count =" + (this.hasBAISContent() ? String.valueOf(this.getBAISContent().getCount()) : "n/a") + " character encoding = " + this.getEncoding() + " StringContent = " + (this.hasStringContent() ? this.getStringContent() : "n/a");
    }

    private void clearCache() {
        this._stringContent = null;
        this._byteArrayContent = null;
        this._baisContent = null;
        this._isPossiblyFault = null;
    }

    private boolean hasStringContent() {
        return this._stringContent != null;
    }

    private String getStringContent() {
        if (!this.hasStringContent()) {
            byte[] bytes = this.getByteArrayContent();
            String value = JavaUtils.convertBytesToString(bytes, this.getEncoding());
            this.setStringContent(value);
        }
        return this._stringContent;
    }

    private void setStringContent(String value) {
        this._stringContent = value;
    }

    private boolean hasByteArrayContent() {
        return this._byteArrayContent != null;
    }

    private byte[] getByteArrayContent() {
        if (!this.hasByteArrayContent()) {
            if (this.hasBAISContent()) {
                BAIS bais = this.getBAISContent();
                byte[] bytes = bais.getBuff();
                if (bais.getContentLength() != bytes.length) {
                    bytes = new byte[bais.getContentLength()];
                    System.arraycopy(bais.getBuff(), bais.getMark(), bytes, 0, bais.getContentLength());
                }
                this.setByteArrayContent(bytes);
            } else if (this.hasStringContent()) {
                String value = this.getStringContent();
                byte[] bytes = JavaUtils.convertStringToBytes(value, this.getEncoding());
                this.setByteArrayContent(bytes);
            } else {
                BAIS bais = this.getBAISContent();
                byte[] bytes = bais.getBuff();
                if (bais.getContentLength() != bytes.length) {
                    bytes = new byte[bais.getContentLength()];
                    System.arraycopy(bais.getBuff(), bais.getMark(), bytes, 0, bais.getContentLength());
                }
                this.setByteArrayContent(bytes);
            }
        }
        return this._byteArrayContent;
    }

    private void setByteArrayContent(byte[] value) {
        this._byteArrayContent = value;
    }

    private boolean hasBAISContent() {
        return this._baisContent != null;
    }

    private BAIS getBAISContent() {
        if (!this.hasBAISContent()) {
            if (this.hasByteArrayContent() || this.hasStringContent()) {
                byte[] bytes = this.getByteArrayContent();
                BAIS bais = BAIS.create(bytes);
                this.setBAISContent(bais);
            } else if (super.getByteStream() != null) {
                try {
                    InputStream is = super.getByteStream();
                    BAIS bais = BAIS.create(is);
                    this.setBAISContent(bais);
                }
                catch (IOException io) {
                    FFDCFilter.processException((Throwable)io, "com.ibm.ws.webservices.utils.WebServicesInputSource.getBAISContent", "450", this);
                    throw new InternalException(io);
                }
            } else if (this.getCharacterStream() != null) {
                try {
                    BAIS bais = BAIS.create(this.getCharacterStream(), this.getEncoding());
                    this.setCharacterStream(null);
                    this.setBAISContent(bais);
                }
                catch (IOException io) {
                    FFDCFilter.processException((Throwable)io, "com.ibm.ws.webservices.utils.WebServicesInputSource.getBAISContent", "453", this);
                    throw new InternalException(io);
                }
            } else {
                throw new InternalException(Messages.getMessage("wsisInternal", "getBAISContent"));
            }
        }
        return this._baisContent;
    }

    private void setBAISContent(BAIS value) {
        this._baisContent = value;
        super.setByteStream(value);
    }

    private static class FilterIS
    extends FilterInputStream {
        private long length = 0L;
        private boolean isBAIS;

        FilterIS(InputStream is) {
            super(is);
            this.isBAIS = is instanceof BAIS;
        }

        public final int read() throws IOException {
            int bite = super.read();
            if (bite != -1) {
                ++this.length;
            }
            return bite;
        }

        public final int read(byte[] buffer) throws IOException {
            int bytes = super.read(buffer);
            if (bytes != -1) {
                this.length += (long)bytes;
            }
            return bytes;
        }

        public final int read(byte[] b, int off, int len) throws IOException {
            int bytes = super.read(b, off, len);
            if (bytes != -1) {
                this.length += (long)bytes;
            }
            return bytes;
        }

        public final void close() throws IOException {
            super.close();
        }

        long getLength() {
            return this.length;
        }

        public final void reset() throws IOException {
            this.length = 0L;
            super.reset();
        }

        public boolean isFilteringBAIS() {
            return this.isBAIS;
        }
    }
}

