/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.resources.NLSProvider;
import com.ibm.wsspi.management.profile.ProfileUtility;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.rpc.Service;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceUtils {
    private static final TraceComponent tc = Tr.register(WebServiceUtils.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");

    public static List<ServiceRef> getJAXRPCServiceRefs(List<ServiceRef> allRefs, ClassLoader classLoader) {
        return WebServiceUtils.getServiceRefsByType(allRefs, classLoader, Service.class);
    }

    public static List<ServiceRef> getJAXWSServiceRefs(List<ServiceRef> allRefs, ClassLoader classLoader) {
        return WebServiceUtils.getServiceRefsByType(allRefs, classLoader, javax.xml.ws.Service.class);
    }

    private static List<ServiceRef> getServiceRefsByType(List<ServiceRef> allRefs, ClassLoader classLoader, Class serviceRefType) {
        ArrayList<ServiceRef> refs = new ArrayList<ServiceRef>();
        for (ServiceRef sr : allRefs) {
            try {
                Class<?> srClass = Class.forName(sr.getServiceInterface().getQualifiedName(), false, classLoader);
                if (!serviceRefType.isAssignableFrom(srClass)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The service ref: " + sr.getServiceRefName() + " refers " + " to the service type: " + serviceRefType.getName());
                }
                refs.add(sr);
            }
            catch (ClassNotFoundException e) {
                Tr.warning(tc, "serviceRefFail00", new Object[]{sr.getServiceRefName(), sr.getServiceInterface().getQualifiedName()});
            }
        }
        return refs;
    }

    public static void removeDirectory(File directory) {
        File[] files;
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                WebServiceUtils.removeDirectory(file);
                continue;
            }
            WebServiceUtils.deleteFile(file);
        }
        WebServiceUtils.deleteFile(directory);
    }

    public static String getApplicationDisplayName(ModuleFile mf) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationDisplayName, archive= " + mf.getName());
        }
        String displayName = null;
        if (mf.getEARFile().getDeploymentDescriptor() != null) {
            displayName = mf.getEARFile().getDeploymentDescriptor().getDisplayName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationDisplayName, applicationDisplayName= " + displayName);
        }
        return displayName;
    }

    public static String getApplicationName(Archive archive) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationName, archive= " + archive.getName());
        }
        String applicationName = null;
        if (archive instanceof ModuleFile) {
            ModuleFile mf = (ModuleFile)archive;
            if (mf.getEARFile() != null && ((applicationName = mf.getEARFile().getName()) == null || applicationName.equals(""))) {
                applicationName = WebServiceUtils.getApplicationDisplayName(mf);
            }
        } else {
            applicationName = archive.getName();
        }
        if (applicationName == null || applicationName.equals("")) {
            applicationName = "unknown_ws_app_name";
        } else if (applicationName.endsWith(".ear")) {
            applicationName = applicationName.substring(0, applicationName.length() - 4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removing suffix to get appName = " + applicationName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationName, archive= " + archive.getName() + ", applicationName= " + applicationName);
        }
        return applicationName;
    }

    public static File doFileCopy(File sourceFile, String newFileName) {
        try {
            File newFile = new File(newFileName);
            WebServiceUtils.createFile(newFile);
            FileReader reader = new FileReader(sourceFile);
            FileWriter writer = new FileWriter(newFile);
            int i = reader.read();
            while (i != -1) {
                writer.write(i);
                i = reader.read();
            }
            reader.close();
            writer.close();
            return newFile;
        }
        catch (Throwable t) {
            if (tc.isWarningEnabled()) {
                String msg = NLSProvider.getNLS().getFormattedMessage("fileCopyFail", new Object[0], "The {0} file could not be copied to the new location {1} because of the following error: {2}");
                Tr.warning(tc, msg);
            }
            return null;
        }
    }

    public static boolean fileExists(File checkFile) {
        final File file = checkFile;
        boolean exists = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return file.exists();
            }
        });
        return exists;
    }

    public static boolean fileIsFile(File checkFile) {
        final File file = checkFile;
        boolean isFile = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return file.isFile();
            }
        });
        return isFile;
    }

    public static boolean fileIsDirectory(File checkFile) {
        final File file = checkFile;
        boolean isDirectory = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return file.isDirectory();
            }
        });
        return isDirectory;
    }

    public static File[] listFiles(File directory) {
        final File file = directory;
        File[] files = (File[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return file.listFiles();
            }
        });
        return files;
    }

    public static boolean createFile(File newFile) throws IOException {
        final File file = newFile;
        boolean success = false;
        try {
            success = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    return file.createNewFile();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() != null && e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            if (e.getException() != null) {
                throw new IOException(e.getException().getMessage());
            }
            throw new IOException(e.getMessage());
        }
        return success;
    }

    public static boolean deleteFile(File deleteFile) {
        final File file = deleteFile;
        boolean deleted = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return file.delete();
            }
        });
        return deleted;
    }

    public static String fileGetAbsolutePath(File sourceFile) {
        final File file = sourceFile;
        String path = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return file.getAbsolutePath();
            }
        });
        return path;
    }

    public static boolean fileMkDirs(File newFile) {
        final File file = newFile;
        boolean success = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return file.mkdirs();
            }
        });
        return success;
    }

    public static long fileGetLength(File sourceFile) {
        final File file = sourceFile;
        long length = (Long)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return file.length();
            }
        });
        return length;
    }

    public static StringBuffer getProfileRoot() {
        String profileRoot = null;
        StringBuffer sb = null;
        profileRoot = ProfileUtility.getProfilePath();
        if (profileRoot != null && !profileRoot.endsWith(File.separator)) {
            profileRoot = profileRoot + File.separator;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Retrieved this profile root: " + profileRoot);
        }
        if (profileRoot != null) {
            sb = new StringBuffer(profileRoot);
        }
        return sb;
    }

    public static String getPackageName(String className) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPackageName, class= " + className);
        }
        String packageName = null;
        int lastSepIndex = className.lastIndexOf(".");
        if (lastSepIndex > 0) {
            packageName = className.substring(0, lastSepIndex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPackageName, class= " + className + ", packageName= " + packageName);
        }
        return packageName;
    }

    public static String getNamespaceFromPackageName(String packageName, String protocol) {
        String NO_PACKAGE_HOST_NAME = "DefaultNamespace";
        if (protocol == null) {
            protocol = "http";
        }
        if (packageName == null) {
            return protocol + "://" + "DefaultNamespace";
        }
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuffer sb = new StringBuffer(80);
        for (int i = words.length - 1; i >= 0; --i) {
            String word = words[i];
            if (i != words.length - 1) {
                sb.append('.');
            }
            sb.append(word);
        }
        return protocol + "://" + sb.toString() + "/";
    }
}

