/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.utils.ClassUtils;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.security.PrivilegedAction;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

public class PluginUtils {
    private static final TraceComponent _tc = Tr.register(PluginUtils.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discoverExtensions(String pluginName, String epid, List implementationList) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "discoverExtensions", "pluginName=" + pluginName + ", epid=" + epid);
        }
        try {
            IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
            Class pluginClass = ClassUtils.forName(pluginName);
            if (registry != null) {
                final String name = pluginName;
                IExtensionPoint extensionPoint = registry.getExtensionPoint(epid);
                if (extensionPoint != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Looking for " + pluginName + " implementations " + "using the following extension point: " + epid);
                    }
                    IExtension[] extensions = extensionPoint.getExtensions();
                    for (int i = 0; i < extensions.length; ++i) {
                        IConfigurationElement[] extensionConfigs = extensions[i].getConfigurationElements();
                        for (int j = 0; j < extensionConfigs.length; ++j) {
                            if (!extensionConfigs[j].getName().equals("plugin")) continue;
                            final IConfigurationElement extConfig = extensionConfigs[j];
                            Object configObject = AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    try {
                                        return extConfig.createExecutableExtension("class");
                                    }
                                    catch (Exception e) {
                                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.utils.PluginsUtils.run", "88", this);
                                        Object[] inserts = new Object[]{name, e};
                                        Tr.error(_tc, "implConfigPluginFail01", inserts);
                                        return null;
                                    }
                                }
                            });
                            if (configObject != null && pluginClass.isAssignableFrom(configObject.getClass())) {
                                implementationList.add(configObject);
                                if (!_tc.isDebugEnabled()) continue;
                                Tr.debug(_tc, "A " + pluginName + " implementation " + "class has been found: " + extensionConfigs[j].getAttribute("class"));
                                continue;
                            }
                            if (configObject == null) continue;
                            Object[] inserts = new Object[]{extensionConfigs[j].getAttribute("class"), pluginName};
                            Tr.error(_tc, "implConfigPluginFail00", inserts);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.utils.PluginsUtils.discoverExtensions", "119");
            Object[] inserts = new Object[]{pluginName, e};
            Tr.error(_tc, "implConfigPluginFail01", inserts);
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "discoverExtensions");
            }
        }
    }

    public static IExtension[] getDeclaredExtensions(String epid) throws Exception {
        IExtensionPoint extensionPoint;
        IExtensionRegistry registry;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getDeclaredExtensions= " + epid);
        }
        if ((registry = ExtensionRegistryFactory.instance().getExtensionRegistry()) != null && (extensionPoint = registry.getExtensionPoint(epid)) != null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getDeclaredExtensions extensions found= " + epid);
            }
            return extensionPoint.getExtensions();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getDeclaredExtensions extensions not found= " + epid);
        }
        return null;
    }
}

