/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.metadata.ClassDataObject;
import com.ibm.ws.metadata.ClassDataObjectFields;
import com.ibm.ws.metadata.ConfigReader;
import com.ibm.ws.metadata.FileLocator;
import com.ibm.ws.metadata.MetaDataOrchestrator;
import com.ibm.ws.metadata.MetaDataSources;
import com.ibm.ws.metadata.annotations.AnnotationConfigReader;
import com.ibm.ws.webservices.resources.NLSProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRPCArtifactLocator {
    private static final TraceComponent _tc = Tr.register(JAXRPCArtifactLocator.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");
    private Archive archive;
    private WebServices webServices;
    private Set<String> jaxwsClasses;
    private List<String> jaxrpcPortComponents;
    private ClassLoader classLoader = null;

    public JAXRPCArtifactLocator(Archive archive, WebServices webServices) {
        this.archive = archive;
        this.webServices = webServices;
        this.jaxrpcPortComponents = new ArrayList<String>();
    }

    public List<String> locateJAXRPCPortComponents() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "locateJAXRPCPortComponents");
        }
        this.getJAXRPCPortComponents();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "locateJAXRPCPortComponents size= " + (this.jaxrpcPortComponents == null ? 0 : this.jaxrpcPortComponents.size()));
        }
        return this.jaxrpcPortComponents;
    }

    private void getJAXRPCPortComponents() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getJAXRPCPortComponents= " + this.archive.getName());
        }
        ArrayList<Integer> removeIndexList = new ArrayList<Integer>();
        if (this.webServices != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Getting JAX-RPC port components from webservices.xml: " + this.webServices.hashCode());
            }
            for (WebServiceDescription wsd : this.webServices.getWebServiceDescriptions()) {
                String seiName = null;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The WebServiceDescription: " + wsd.getWebServiceDescriptionName() + " contains " + wsd.getPortComponents().size() + " port components.");
                }
                if (wsd.getPortComponents() != null && !wsd.getPortComponents().isEmpty()) {
                    PortComponent pc = (PortComponent)wsd.getPortComponents().get(0);
                    seiName = pc.getServiceEndpointInterface();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Attempting to determine if Port Component: " + pc.getPortComponentName() + " with SEI class: " + seiName + " is a JAX-RPC Port Component");
                    }
                    if (seiName == null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "The webservice description: " + wsd.getWebServiceDescriptionName() + " within the module: " + this.archive.getName() + " contains " + "JAX-WS port components");
                        }
                        break;
                    }
                    if (this.jaxwsClasses != null) {
                        if (this.jaxwsClasses.contains(seiName)) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "The webservice description: " + wsd.getWebServiceDescriptionName() + " within the module: " + this.archive.getName() + " contains " + "JAX-WS port components");
                            }
                            break;
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "The webservice description: " + wsd.getWebServiceDescriptionName() + " within the module: " + this.archive.getName() + " contains " + "JAX-RPC port components");
                        }
                        for (PortComponent pcToAdd : wsd.getPortComponents()) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Found JAX-RPC port component: " + pcToAdd.getPortComponentName() + " for module: " + this.archive.getName());
                            }
                            this.jaxrpcPortComponents.add(pcToAdd.getPortComponentName());
                            seiName = null;
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The SEI: " + seiName + " will be checked for annotations.");
                    }
                }
                if (seiName == null) continue;
                this.readAnnotationMetaData(seiName, removeIndexList, wsd);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No JAX-RPC Port Components were found for the module: " + this.archive.getName() + ". The cache could not be located for the " + "module, and there was no supplied deployment descriptor data");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getJAXRPCPortComponents= " + this.archive.getName());
        }
    }

    private void readAnnotationMetaData(String seiName, List<Integer> removeIndexList, WebServiceDescription wsd) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "readAnnotationMetaData");
        }
        boolean hasAnnotatedSEI = false;
        if (this.classLoader == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting classloader to module's archive classloader since one was not supplied");
            }
            this.classLoader = this.archive.getArchiveClassLoader();
        }
        Object annotatedSEIClasses = null;
        if (this.classLoader != null) {
            List<FileLocator> fileLocators;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found classloader to construct SEIFileLocator objects. ASM will be used to determine annotated SEI classes");
            }
            if (!(fileLocators = this.buildLocator(seiName, this.classLoader)).isEmpty()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Sending SEIFileLocator objects to ASM for scan, size: " + fileLocators.size());
                }
                hasAnnotatedSEI = this.hasAnnotatedSEIFromASM(fileLocators, seiName);
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Did not find classloader to construct SEIFileLocator objects. Reflection will be used to determine annotated SEI classes");
            }
            hasAnnotatedSEI = this.hasAnnotatedSEIFromReflection(seiName, this.classLoader);
        }
        if (hasAnnotatedSEI) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The webservice description: " + wsd.getWebServiceDescriptionName() + " within the module: " + this.archive.getName() + " contains JAX-WS port components");
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The webservice description: " + wsd.getWebServiceDescriptionName() + " within the module: " + this.archive.getName() + " contains JAX-RPC port components");
            }
            for (PortComponent pc : wsd.getPortComponents()) {
                this.jaxrpcPortComponents.add(pc.getPortComponentName());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "readAnnotationMetaData");
        }
    }

    private List<FileLocator> buildLocator(String seiClassName, ClassLoader classLoader) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "buildLocatorList");
        }
        ArrayList<FileLocator> fileLocators = new ArrayList<FileLocator>();
        String fileName = seiClassName.replace(".", "/");
        URL url = classLoader.getResource(fileName = fileName + ".class");
        if (url != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Successfully built FileLocator for SEI: " + fileName);
            }
            fileLocators.add(new SEIFileLocator(url, fileName));
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Could not build FileLocator for SEI: " + fileName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "buildLocatorList");
        }
        return fileLocators;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAnnotatedSEIFromASM(List<FileLocator> fileLocators, String seiName) throws Exception {
        if (JAXRPCArtifactLocator._tc.isEntryEnabled()) {
            Tr.entry(JAXRPCArtifactLocator._tc, "getAnnotatedSEIClassesFromASM");
        }
        try {
            mdOrch = new MetaDataOrchestrator();
            source = new MetaDataSources();
            source.iv_Sources[MetaDataSources.sv_FileLocatorIndex] = fileLocators.iterator();
            reader = new ConfigReader[]{new AnnotationConfigReader("WSClassAdapter")};
            mdo = mdOrch.getModuleData(reader, source, "", "");
            if (mdo == null) ** GOTO lbl-1000
            if (JAXRPCArtifactLocator._tc.isDebugEnabled()) {
                Tr.debug(JAXRPCArtifactLocator._tc, "Found ModuleDataObject for SEI classes");
            }
            cdoColl = mdo.getAllClassDataObjects();
            i$ = cdoColl.iterator();
            ** GOTO lbl18
lbl-1000:
            // 1 sources

            {
                msg = NLSProvider.getNLS().getFormattedMessage("seiScanFail", new Object[]{seiName}, "Internal Error: The {0} Service Endpoint Interface class could not be properly examined for annotations.");
                throw new Exception(msg);
lbl18:
                // 2 sources

                while (i$.hasNext()) {
                    cdo = (ClassDataObject)i$.next();
                    qualifiedClassName = (String)cdo.getEntry(ClassDataObjectFields.CLASS_NAME);
                    if (seiName.equals(qualifiedClassName = qualifiedClassName.replaceAll("/", ".")) && cdo.getEntry(ClassDataObjectFields.WEBSERVICE) != null) {
                        if (JAXRPCArtifactLocator._tc.isDebugEnabled()) {
                            Tr.debug(JAXRPCArtifactLocator._tc, "Found annotated SEI class: " + qualifiedClassName);
                        }
                        var11_13 = true;
                        return var11_13;
                    }
                    if (seiName.equals(qualifiedClassName) && cdo.getEntry(ClassDataObjectFields.WEBSERVICE) == null) {
                        if (JAXRPCArtifactLocator._tc.isDebugEnabled()) {
                            Tr.debug(JAXRPCArtifactLocator._tc, "SEI class: " + qualifiedClassName + " was not an annotated JAX-WS SEI");
                        }
                        var11_14 = false;
                        return var11_14;
                    }
                    ** try [egrp 3[TRYBLOCK] [2 : 330->393)] { 
lbl32:
                    // 1 sources

                }
                msg = NLSProvider.getNLS().getFormattedMessage("seiScanFail", new Object[]{seiName}, "Internal Error: The {0} Service Endpoint Interface class could not be properly examined for annotations.");
                throw new Exception(msg);
            }
        }
lbl35:
        // 2 sources

        catch (Exception e) {
            Tr.error(JAXRPCArtifactLocator._tc, "annotation.asm.fail", new Object[]{this.archive.getName(), e});
            throw new RuntimeException(e);
        }
        finally {
            if (JAXRPCArtifactLocator._tc.isEntryEnabled()) {
                Tr.entry(JAXRPCArtifactLocator._tc, "getAnnotatedSEIClassesFromASM");
            }
        }
    }

    private boolean hasAnnotatedSEIFromReflection(String seiClassName, ClassLoader classLoader) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getAnnotatedSEIClassesFromReflection");
        }
        try {
            final String finalClassName = seiClassName;
            final ClassLoader finalClassLoader = classLoader;
            Class seiClass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return finalClassLoader.loadClass(finalClassName);
                }
            });
            if (seiClass != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Loaded class for SEI: " + seiClassName);
                }
                if (seiClass.getAnnotation(WebService.class) != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found @WebService annotated SEI class using relection: " + seiClassName);
                    }
                    boolean bl = true;
                    return bl;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "The SEI: " + seiClassName + " did not contain annotations.");
                }
                boolean bl = false;
                return bl;
            }
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Could not load class for SEI: " + seiClassName);
                }
                String msg = NLSProvider.getNLS().getFormattedMessage("seiScanFail", new Object[]{seiClassName}, "Internal Error: The {0} Service Endpoint Interface class could not be properly examined for annotations.");
                throw new Exception(msg);
            }
            catch (Exception e) {
                Tr.error(_tc, "annotation.reflect.fail", new Object[]{seiClassName, this.archive.getName(), e});
                throw new RuntimeException(e);
            }
        }
        finally {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getAnnotatedSEIClassesFromReflection");
            }
        }
    }

    public void setJAXWSClasses(Set<String> jaxwsClasses) {
        this.jaxwsClasses = jaxwsClasses;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public class SEIFileLocator
    implements FileLocator {
        private URL url;
        private String name;

        public SEIFileLocator(URL url, String name) {
            this.url = url;
            this.name = name;
        }

        public InputStream getInputStream() {
            try {
                return this.url.openStream();
            }
            catch (IOException ioe) {
                Tr.info(_tc, "fileStreamFail", new Object[]{this.name});
                return null;
            }
        }

        public String getName() {
            return this.name;
        }
    }
}

