/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.utils.BAAOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;

public class BufferUtils {
    private static final TraceComponent tc = Tr.register(BufferUtils.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");
    public static final int BUFFER_LEN = 4096;
    static boolean ENABLE_FILE_CHANNEL = true;
    static boolean ENABLE_BAAOS_OPT = true;
    private static byte[] _cacheBuffer = new byte[4096];
    private static boolean _cacheBufferInUse = false;
    private static ByteBuffer _cacheByteBuffer = ByteBuffer.allocate(4096);
    private static boolean _cacheByteBufferInUse = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inputStream2OutputStream(InputStream is, OutputStream os) throws IOException {
        if (ENABLE_FILE_CHANNEL && os instanceof FileOutputStream && BufferUtils.inputStream2FileOutputStream(is, (FileOutputStream)os)) {
            return;
        }
        if (ENABLE_BAAOS_OPT && os instanceof BAAOutputStream) {
            BufferUtils.inputStream2BAAOutputStream(is, (BAAOutputStream)os, Long.MAX_VALUE);
            return;
        }
        byte[] buffer = BufferUtils.getTempBuffer();
        try {
            int bytesRead = is.read(buffer);
            while (bytesRead > 0 || is.available() > 0) {
                if (bytesRead > 0) {
                    os.write(buffer, 0, bytesRead);
                }
                bytesRead = is.read(buffer);
            }
        }
        finally {
            BufferUtils.releaseTempBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int inputStream2OutputStream(InputStream is, OutputStream os, int limit) throws IOException {
        if (ENABLE_BAAOS_OPT && os instanceof BAAOutputStream) {
            return (int)BufferUtils.inputStream2BAAOutputStream(is, (BAAOutputStream)os, limit);
        }
        byte[] buffer = BufferUtils.getTempBuffer();
        int totalWritten = 0;
        int bytesRead = 0;
        try {
            do {
                int len;
                if ((bytesRead = is.read(buffer, 0, len = limit - totalWritten > 4096 ? 4096 : limit - totalWritten)) <= 0) continue;
                os.write(buffer, 0, bytesRead);
                if (bytesRead <= 0) continue;
                totalWritten += bytesRead;
            } while (totalWritten < limit && (bytesRead > 0 || is.available() > 0));
            int n = totalWritten;
            return n;
        }
        finally {
            BufferUtils.releaseTempBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean inputStream2FileOutputStream(InputStream is, FileOutputStream fos) throws IOException {
        FileChannel channel = null;
        FileLock lock = null;
        ByteBuffer bb = null;
        try {
            channel = fos.getChannel();
            if (channel != null) {
                lock = channel.tryLock();
            }
            bb = BufferUtils.getTempByteBuffer();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (lock == null || bb == null || !bb.hasArray()) {
            BufferUtils.releaseTempByteBuffer(bb);
            return false;
        }
        try {
            int bytesRead = is.read(bb.array());
            while (bytesRead > 0 || is.available() > 0) {
                if (bytesRead > 0) {
                    int written = 0;
                    if (bytesRead < 4096) {
                        ByteBuffer temp = ByteBuffer.allocate(bytesRead);
                        temp.put(bb.array(), 0, bytesRead);
                        temp.position(0);
                        written = channel.write(temp);
                    } else {
                        bb.position(0);
                        written = channel.write(bb);
                        bb.clear();
                    }
                }
                bytesRead = is.read(bb.array());
            }
        }
        finally {
            lock.release();
            BufferUtils.releaseTempByteBuffer(bb);
        }
        return true;
    }

    public static long inputStream2BAAOutputStream(InputStream is, BAAOutputStream baaos, long limit) throws IOException {
        return baaos.receive(is, limit);
    }

    public static int doesDataHandlerExceedLimit(DataHandler dh, int limit) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "start isEligibleForOptimization");
        }
        if (limit == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "optimizedThreshold not set");
            }
            return -1;
        }
        InputStream in = null;
        int totalRead = 0;
        try {
            int bytesRead;
            in = BufferUtils.getInputStream(dh);
            if (in.markSupported()) {
                in.mark(limit);
            }
            if (in == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Input Stream is null");
                }
                return -1;
            }
            do {
                byte[] buffer = BufferUtils.getTempBuffer();
                bytesRead = in.read(buffer, 0, 4096);
                BufferUtils.releaseTempBuffer(buffer);
            } while (limit > (totalRead += bytesRead) && in.available() > 0);
            if (in.markSupported()) {
                in.reset();
            }
            if (totalRead > limit) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attachment size greater than limit");
                }
                return 1;
            }
        }
        catch (Exception e) {
            Tr.warning(tc, e.getMessage());
            return -1;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Attachment Size smaller than limit");
        }
        return 0;
    }

    private static InputStream getInputStream(DataHandler dataHandlerObject) throws Exception {
        InputStream inStream = null;
        DataHandler dataHandler = dataHandlerObject;
        try {
            DataSource ds2 = dataHandler.getDataSource();
            if (ds2 instanceof FileDataSource) {
                inStream = ds2.getInputStream();
            } else {
                inStream = dataHandler.getDataSource().getInputStream();
                if (!inStream.markSupported()) {
                    throw new Exception("Stream does not support mark, Cannot read the stream as DataSource will be consumed.");
                }
            }
        }
        catch (IOException e) {
            throw new Exception("Cannot get InputStream from DataHandler." + e);
        }
        return inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized byte[] getTempBuffer() {
        byte[] byArray = _cacheBuffer;
        synchronized (_cacheBuffer) {
            if (!_cacheBufferInUse) {
                _cacheBufferInUse = true;
                // ** MonitorExit[var0] (shouldn't be in output)
                return _cacheBuffer;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return new byte[4096];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseTempBuffer(byte[] buffer) {
        byte[] byArray = _cacheBuffer;
        synchronized (_cacheBuffer) {
            if (buffer == _cacheBuffer) {
                _cacheBufferInUse = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized ByteBuffer getTempByteBuffer() {
        ByteBuffer byteBuffer = _cacheByteBuffer;
        synchronized (byteBuffer) {
            if (!_cacheByteBufferInUse) {
                _cacheByteBufferInUse = true;
                return _cacheByteBuffer;
            }
        }
        return ByteBuffer.allocate(4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseTempByteBuffer(ByteBuffer buffer) {
        ByteBuffer byteBuffer = _cacheByteBuffer;
        synchronized (byteBuffer) {
            if (buffer == _cacheByteBuffer) {
                _cacheByteBufferInUse = false;
            }
        }
    }
}

