/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.trace;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.trace.BinaryFormatter;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class BaseMessageTrace {
    private static final String irq = "inboundRequest00";
    private static final String orq = "outboundRequest00";
    private static final String irs = "inboundResponse00";
    private static final String ors = "outboundResponse00";
    private static final String HTTP = "HTTP";
    private static final String JMS = "JMS";
    private static final String SOAP = "SOAP";
    public static final TraceContext INBOUND_HTTP_REQUEST = new TraceContext("inboundRequest00", "HTTP");
    public static final TraceContext OUTBOUND_HTTP_REQUEST = new TraceContext("outboundRequest00", "HTTP");
    public static final TraceContext INBOUND_HTTP_RESPONSE = new TraceContext("inboundResponse00", "HTTP");
    public static final TraceContext OUTBOUND_HTTP_RESPONSE = new TraceContext("outboundResponse00", "HTTP");
    public static final TraceContext INBOUND_JMS_REQUEST = new TraceContext("inboundRequest00", "JMS");
    public static final TraceContext OUTBOUND_JMS_REQUEST = new TraceContext("outboundRequest00", "JMS");
    public static final TraceContext INBOUND_JMS_RESPONSE = new TraceContext("inboundResponse00", "JMS");
    public static final TraceContext OUTBOUND_JMS_RESPONSE = new TraceContext("outboundResponse00", "JMS");
    public static final int MAX_TRACE_BUFFER_SIZE = 10240;

    public static void log(TraceContext context, String contentType, byte[] messageBytes, TraceComponent tc) {
        try {
            String bytesAsString = "";
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(messageBytes);
            bytesAsString = BaseMessageTrace.convertBytesToString(contentType, baos);
            BaseMessageTrace.log(context, contentType, bytesAsString, tc);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.BaseMessageTrace.log", "86", null);
        }
    }

    public static void log(TraceContext context, String contentType, String message, TraceComponent tc) {
        if (context != null && message != null) {
            StringBuffer msgbuf = new StringBuffer();
            msgbuf.append(context.toString(contentType));
            if (contentType != null && contentType.startsWith("text/xml")) {
                msgbuf.append(message);
            } else {
                BinaryFormatter bf = new BinaryFormatter(message.getBytes());
                String formatted = bf.trace(10240);
                msgbuf.append(formatted);
            }
            Tr.debug(tc, msgbuf.toString());
        }
    }

    private static String convertBytesToString(String contentType, ByteArrayOutputStream baos) {
        String bytesAsString;
        if (contentType != null && contentType.startsWith("text/xml")) {
            String encoding = BaseMessageTrace.getEncoding(contentType);
            try {
                bytesAsString = baos.toString(encoding);
            }
            catch (UnsupportedEncodingException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.BaseMessageTrace.convertBytesToString", "121", null);
                bytesAsString = baos.toString();
            }
        } else {
            bytesAsString = baos.toString();
        }
        return bytesAsString;
    }

    private static String getEncoding(String contentType) {
        String lc;
        String utf8 = "utf-8";
        String utf16 = "utf-16";
        if (contentType != null && (lc = contentType.toLowerCase()).indexOf("charset=") > 0 && lc.indexOf("utf-16") > 0) {
            return "utf-16";
        }
        return "utf-8";
    }

    protected static class TraceContext {
        String messageKey;
        String transport;

        public String toString(String contentType) {
            String ct = contentType == null ? "" : contentType;
            return Messages.getMessage(this.messageKey, this.transport, BaseMessageTrace.SOAP, ct);
        }

        TraceContext(String key, String tp) {
            this.messageKey = key;
            this.transport = tp;
        }
    }
}

