/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.shared.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.shared.cache.CacheRootDirectoryTLS;
import com.ibm.ws.webservices.shared.cache.WebServicesModuleCache;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import java.io.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class WebServicesModuleCacheMgr {
    private static final TraceComponent _tc = Tr.register(WebServicesModuleCacheMgr.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");

    public static WebServicesModuleCache getModuleCache(Archive archive) {
        String appName = WebServicesModuleCacheMgr.getApplicationName(archive);
        String modName = archive.getName();
        String rootDir = WebServicesModuleCacheMgr.getCacheDirectory();
        if (rootDir != null) {
            String cacheDirectory = rootDir + appName + File.separator + modName + File.separator;
            return new WebServicesModuleCache(cacheDirectory, "wscache.xml");
        }
        return new WebServicesModuleCache(null, "wscache.xml");
    }

    public static WebServicesModuleCache getModuleCache(String cacheDirectory) {
        String rootDir = CacheRootDirectoryTLS.get();
        if (rootDir == null) {
            rootDir = WebServicesModuleCacheMgr.getCacheDirectory();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Using this web services cache root directory in cache manager: " + rootDir);
        }
        if (rootDir != null) {
            cacheDirectory = cacheDirectory == null ? rootDir : WebServicesModuleCacheMgr.getCacheDirectory(rootDir, cacheDirectory);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Parent directory of web services metadata cache: " + cacheDirectory);
            }
            return new WebServicesModuleCache(cacheDirectory, "wscache.xml");
        }
        return new WebServicesModuleCache(null, "wscache.xml");
    }

    private static String getCacheDirectory(String rootDir, String cacheDirectory) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCacheDirectory, rootDir= " + rootDir + " cacheDirectory= " + cacheDirectory);
        }
        String finalLocation = null;
        while (cacheDirectory.endsWith(File.separator)) {
            cacheDirectory = cacheDirectory.substring(0, cacheDirectory.length() - 1);
        }
        while (rootDir.endsWith(File.separator)) {
            rootDir = rootDir.substring(0, rootDir.length() - 1);
        }
        if (!rootDir.endsWith(cacheDirectory)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Root directory: " + rootDir + " does not end with cache " + "directory: " + cacheDirectory);
            }
            finalLocation = rootDir + File.separator + cacheDirectory + File.separator;
        } else {
            finalLocation = rootDir + File.separator;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCacheDirectory, cacheDirectory= " + finalLocation);
        }
        return finalLocation;
    }

    public static String getCacheDirectory() {
        StringBuffer path = WebServicesModuleCacheMgr.getProfileRoot();
        if (path != null) {
            path = path.append("temp").append(File.separator).append("wscache").append(File.separator);
            return path.toString();
        }
        return null;
    }

    private static StringBuffer getProfileRoot() {
        return WebServiceUtils.getProfileRoot();
    }

    private static String getApplicationName(Archive archive) {
        String applicationName = null;
        if (archive instanceof ModuleFile) {
            ModuleFile mf = (ModuleFile)archive;
            if (mf.getEARFile() != null) {
                applicationName = mf.getEARFile().getName();
            }
        } else {
            applicationName = archive.getName();
        }
        return applicationName;
    }
}

