/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.shared.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.resources.NLSProvider;
import com.ibm.ws.webservices.shared.cache.WebServicesModuleCacheMgr;
import com.ibm.ws.webservices.shared.cache.jaxb.ObjectFactory;
import com.ibm.ws.webservices.shared.cache.jaxb.WebServiceClientInfo;
import com.ibm.ws.webservices.shared.cache.jaxb.WsCacheInfo;
import com.ibm.ws.webservices.shared.cache.jaxb.WsClientType;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class WebServicesModuleCache {
    private static final TraceComponent tc = Tr.register(WebServicesModuleCache.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");
    private WsCacheInfo cacheInfo;
    private ObjectFactory factory = new ObjectFactory();
    private String disableCache;
    private ClassLoader classLoader;
    private String rootDirectory = null;
    private String fileName = null;
    private String fileFullPath = null;
    private File fileObj = null;
    private boolean loadError;
    private static JAXBContext jaxbContext = null;

    public WebServicesModuleCache(String rootDirectory, String fileName) {
        this.rootDirectory = rootDirectory;
        this.fileName = fileName;
        if (rootDirectory != null) {
            this.fileFullPath = this.rootDirectory + this.fileName;
            this.fileObj = new File(this.fileFullPath);
        }
        this.cacheInfo = this.factory.createWsCacheInfo();
        this.disableCache = null;
        this.loadError = false;
    }

    public boolean exists() {
        return this.exists(false);
    }

    public boolean exists(boolean lookForBackup) {
        if (lookForBackup) {
            String backupPath;
            File backupFile;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Looking for backup web services cache file");
            }
            if (WebServiceUtils.fileExists(backupFile = new File(backupPath = this.rootDirectory + this.fileName + ".bak"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found backup web services cache file: " + backupPath);
                }
                WebServiceUtils.doFileCopy(backupFile, this.rootDirectory + this.fileName);
                WebServiceUtils.deleteFile(backupFile);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find backup web services cache file: " + backupPath);
            }
        }
        if (this.rootDirectory == null || !this.cachingEnabled() || this.loadError) {
            return false;
        }
        File file = new File(this.rootDirectory);
        if (WebServiceUtils.fileIsDirectory(file)) {
            if (WebServiceUtils.fileIsFile(this.fileObj)) {
                File tempExtractApp = new File(this.rootDirectory + "installExtract");
                if (WebServiceUtils.fileIsDirectory(tempExtractApp)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Attempting to delete application extraction location: " + tempExtractApp.getAbsolutePath());
                    }
                    WebServiceUtils.removeDirectory(tempExtractApp);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean displayNameCacheExists(String appDisplayName, String applicationName, String moduleName) {
        if (appDisplayName != null && !appDisplayName.equals("") && !appDisplayName.equals(applicationName)) {
            String displayNameCachePath = WebServicesModuleCacheMgr.getCacheDirectory() + appDisplayName + File.separator + moduleName + File.separator;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "looking for old displayName cache at location: " + displayNameCachePath);
            }
            File displayNameCacheDir = new File(displayNameCachePath);
            return WebServiceUtils.fileIsDirectory(displayNameCacheDir);
        }
        return false;
    }

    public boolean oldCacheExists() {
        String oldCacheFilePath = this.rootDirectory + "WSModule.cache";
        File oldCacheFile = new File(oldCacheFilePath);
        return WebServiceUtils.fileIsFile(oldCacheFile);
    }

    private void create() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create");
        }
        if (this.rootDirectory != null) {
            File file = new File(this.rootDirectory);
            if (!WebServiceUtils.fileIsDirectory(file)) {
                WebServiceUtils.fileMkDirs(file);
            }
            if (WebServiceUtils.fileIsFile(this.fileObj)) {
                try {
                    WebServiceUtils.createFile(this.fileObj);
                }
                catch (IOException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.create", "120", this);
                    Object[] inserts = new Object[]{this.fileFullPath, e};
                    String msg = NLSProvider.getNLS().getFormattedMessage("processCacheFileFail00", inserts, "The {0} cache file cannot be processed correctly because of the following error: {1}");
                    Tr.error(tc, msg);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cache file not created since profile root not located.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "load");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "load");
        }
        if (this.exists() && WebServiceUtils.fileGetLength(this.fileObj) != 0L) {
            try {
                FileInputStream fis = new FileInputStream(this.fileObj);
                if (fis.available() > 0) {
                    if (this.fileName.equals("wscache.xml")) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Writing web services metadata cache");
                        }
                        this.cacheInfo = this.loadXMLCache(fis);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The " + this.fileName + " file name given to the web services " + "cache is not recognized. Caching will not continue.");
                    }
                }
                fis.close();
            }
            catch (FileNotFoundException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.load", "177", this);
                Object[] inserts = new Object[]{this.fileFullPath, e};
                String msg = NLSProvider.getNLS().getFormattedMessage("processCacheFileFail00", inserts, "The {0} cache file cannot be processed correctly because of the following error: {1}");
                Tr.error(tc, msg);
                this.loadError = true;
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.load", "184", this);
                Object[] inserts = new Object[]{this.fileFullPath, e};
                String msg = NLSProvider.getNLS().getFormattedMessage("processCacheFileFail00", inserts, "The {0} cache file cannot be processed correctly because of the following error: {1}");
                Tr.error(tc, msg);
                this.loadError = true;
            }
            catch (ClassNotFoundException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.load", "191", this);
                Object[] inserts = new Object[]{this.fileFullPath, e};
                String msg = NLSProvider.getNLS().getFormattedMessage("processCacheFileFail00", inserts, "The {0} cache file cannot be processed correctly because of the following error: {1}");
                Tr.error(tc, msg);
                this.loadError = true;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.load", "191", this);
                Object[] inserts = new Object[]{this.fileFullPath, e};
                String msg = NLSProvider.getNLS().getFormattedMessage("processCacheFileFail00", inserts, "The {0} cache file cannot be processed correctly because of the following error: {1}");
                Tr.error(tc, msg);
                this.loadError = true;
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "load");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save");
        }
        if (this.rootDirectory != null && this.cachingEnabled()) {
            try {
                this.create();
                FileOutputStream fos = new FileOutputStream(this.fileObj);
                if (this.fileName.equals("wscache.xml")) {
                    this.writeXMLCache(fos);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The " + this.fileName + " file name given to the web services " + "cache is not recognized. Caching will not continue.");
                }
                fos.close();
            }
            catch (FileNotFoundException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.save", "254", this);
                Object[] inserts = new Object[]{this.fileFullPath, e};
                String msg = NLSProvider.getNLS().getFormattedMessage("processCacheFileFail00", inserts, "The {0} cache file cannot be processed correctly because of the following error: {1}");
                Tr.error(tc, msg);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.save", "261", this);
                Object[] inserts = new Object[]{this.fileFullPath, e};
                String msg = NLSProvider.getNLS().getFormattedMessage("processCacheFileFail00", inserts, "The {0} cache file cannot be processed correctly because of the following error: {1}");
                Tr.error(tc, msg);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.utils.WebServicesModuleCache.save", "261", this);
                Object[] inserts = new Object[]{this.fileFullPath, e};
                String msg = NLSProvider.getNLS().getFormattedMessage("processCacheFileFail00", inserts, "The {0} cache file cannot be processed correctly because of the following error: {1}");
                Tr.error(tc, msg);
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "save");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not saving cache file since profile root not located");
        }
    }

    private boolean cachingEnabled() {
        if (this.disableCache == null) {
            this.disableCache = System.getProperty("WSFP_DISABLE_CACHE");
            if (this.disableCache == null) {
                this.disableCache = Boolean.FALSE.toString();
            }
        }
        if (this.disableCache.equalsIgnoreCase(Boolean.TRUE.toString())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Metadata caching disabled via system property. Annotation metadata will not be written to, or loaded from cache.");
            }
            return false;
        }
        return true;
    }

    private WsCacheInfo loadXMLCache(FileInputStream fis) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadXMLCache");
        }
        WsCacheInfo loadedCache = null;
        if (this.classLoader == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Could not load XML cache located at: " + this.fileFullPath + " because there was not a supplied classloader.");
        }
        this.createJAXBContext();
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        if (fis != null) {
            StreamSource source = new StreamSource(fis);
            JAXBElement jaxbCacheInfo = unmarshaller.unmarshal((Source)source, WsCacheInfo.class);
            if (jaxbCacheInfo != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Successfully unmarshalled web services cached data from location: " + this.fileFullPath);
                }
                loadedCache = (WsCacheInfo)jaxbCacheInfo.getValue();
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not unmarshall web services cached data from location: " + this.fileFullPath);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Could not obtain stream to webservices cache file: " + this.fileFullPath);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadXMLCache");
        }
        return loadedCache;
    }

    private void writeXMLCache(FileOutputStream fos) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeXMLCache");
        }
        if ((this.classLoader == null || this.cacheInfo == null) && tc.isDebugEnabled()) {
            Tr.debug(tc, "The webservices XML cache data will not be written because there was no supplied classloader or no supplied data to be written.");
        }
        if (fos != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Preparing to marshall webservices cache data to file: " + this.fileFullPath);
            }
            this.createJAXBContext();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)this.cacheInfo, (OutputStream)fos);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Could not obtain stream to webservices cache file: " + this.fileFullPath);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeXMLCache");
        }
    }

    private void createJAXBContext() throws Exception {
        if (jaxbContext == null) {
            try {
                jaxbContext = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return JAXBContext.newInstance((String)"com.ibm.ws.webservices.shared.cache.jaxb");
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public WsCacheInfo getWsCacheInfo() {
        return this.cacheInfo;
    }

    public boolean jaxrpcCacheExists() {
        return this.cacheInfo != null && this.cacheInfo.getJaxrpcServices() != null && !this.cacheInfo.getJaxrpcServices().isEmpty();
    }

    public boolean jaxwsCacheExists() {
        return this.cacheInfo != null && this.cacheInfo.getJaxwsServices() != null && !this.cacheInfo.getJaxwsServices().isEmpty();
    }

    public boolean wsClientCacheExists() {
        return this.cacheInfo != null && this.cacheInfo.getWebServiceClient() != null && !this.cacheInfo.getWebServiceClient().isEmpty();
    }

    public boolean jaxwsClientCacheExists() {
        if (!this.wsClientCacheExists()) {
            return false;
        }
        List<WebServiceClientInfo> clientInfos = this.cacheInfo.getWebServiceClient();
        for (WebServiceClientInfo clientInfo : clientInfos) {
            if (clientInfo.getClientType() != null && !clientInfo.getClientType().equals((Object)WsClientType.JAX_WS)) continue;
            return true;
        }
        return false;
    }
}

