/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.builders;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.IgnoreSoapBodyException;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.encoding.DefaultDeserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.enumtype.MessageType;
import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.MCUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.builders.RequestResponseProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPFaultBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.engine.xmlsoap.ext.XMLInputSourceAlternateContent;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPBodyBuilder
extends SOAPBuilder {
    protected static Log log = LogFactory.getLog(SOAPBodyBuilder.class.getName());
    private boolean streaming = false;

    public void startElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        super.startElement(namespace, localName, prefixedName, attributes, mappingScope, context);
        MessageContext msgContext = context.getMessageContext();
        if (msgContext != null) {
            QName qName;
            Boolean flag = (Boolean)msgContext.getProperty("IGNORE_SOAPBODY");
            if (flag != null && flag.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("Throwing IgnoreSoapBodyException to bypass parse of SOAP body.");
                }
                throw new IgnoreSoapBodyException();
            }
            List list = MCUtils.getLazyParseQNames(msgContext);
            if (list != null && list.contains(qName = QNameTable.createQName(namespace, localName))) {
                try {
                    InputStream inputStream = context.getLazyParse();
                    if (inputStream != null) {
                        WebServicesInputSource wsis = WebServicesInputSource.create(inputStream);
                        if (msgContext.getCurrentMessage() != null) {
                            String encoding = msgContext.getCurrentMessage().getCharacterEncoding();
                            wsis.setEncoding(encoding);
                        }
                        this.myElement.setAlternateContent(XMLInputSourceAlternateContent.createContentOnly(wsis));
                    }
                }
                catch (SOAPException se) {
                    FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder.startElement", "178", this);
                    throw new SAXException((Exception)((Object)se));
                }
            }
        }
        context.setSimpleEventOptimization(false);
    }

    public DEventProcessor onStartChild(String namespace, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        boolean noDataBindingOp;
        QName faultQName;
        this.myChildElement = null;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SOAPBodyBuilder::onStartChild() " + namespace + " " + localPart);
        }
        QName qname = QNameTable.createQName(namespace, localPart);
        MessageContext msgContext = context.getMessageContext();
        Message msg = null;
        if (msgContext != null) {
            msg = msgContext.getCurrentMessage();
        }
        boolean isResponse = msgContext != null && msgContext.getPastPivot() || msg != null && MessageType.RESPONSE == msg.getMessageType();
        boolean isRoot = true;
        QName rootQName = this.myElement.getSOAPFactory().getSOAPConstants().getEncodingRootQName();
        String root = attributes.getValue(rootQName.getNamespaceURI(), rootQName.getLocalPart());
        if (root != null && root.equals("0")) {
            isRoot = false;
        }
        boolean isFault = localPart.equals((faultQName = this.myElement.getSOAPFactory().getSOAPConstants().getFaultQName()).getLocalPart()) && namespace.equals(faultQName.getNamespaceURI());
        boolean tryStreaming = this.streaming || msgContext != null && !msgContext.isHighFidelity() && !isFault && (msgContext.isClient() && isResponse || msgContext.isServer() && !isResponse);
        boolean disableSOAPElementLazyParse = false;
        if (msgContext != null) {
            disableSOAPElementLazyParse = msgContext.isDisableSOAPElementLazyParse();
        }
        if (msgContext != null && msgContext.getMessage() != null) {
            boolean bl = tryStreaming = tryStreaming && msgContext.getMessage().countAttachments() == 0;
        }
        if (log.isDebugEnabled()) {
            log.debug("HighFidelity is:" + (msgContext != null && msgContext.isHighFidelity()));
            log.debug("tryStreaming is:" + tryStreaming);
        }
        OperationDesc[] operations = null;
        try {
            if (msgContext != null && msgContext.getOperation() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Operation found in MessageContext:" + msgContext.getOperation().toString());
                }
                operations = new OperationDesc[]{msgContext.getOperation()};
            }
            if (tryStreaming && operations == null && (operations = RequestResponse.getPossibleOperationsByQName(qname, msgContext)) != null && operations.length == 1) {
                msgContext.setOperation(operations[0]);
            }
        }
        catch (WebServicesFault e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder.onStartChild", "262", this);
            throw new SAXException(e);
        }
        boolean bl = noDataBindingOp = operations != null && operations.length == 1 && RequestResponse.isNoDataBindingOperation(operations[0]);
        if (tryStreaming) {
            boolean onlyBodyParams;
            boolean bl2 = onlyBodyParams = operations != null && operations.length == 1 && operations[0].getName() != null && (!isResponse && operations[0].getNumInParams(false) == 0 || isResponse && operations[0].getNumOutParams(false) == 0);
            if (!onlyBodyParams) {
                tryStreaming = false;
                if (log.isDebugEnabled()) {
                    log.debug("tryStreaming is change to:" + tryStreaming);
                }
            }
        }
        try {
            if (isRoot && ((SOAPBody)this.myElement).getRequestResponse() == null && !noDataBindingOp && !this.myElement.isInAsSOAPElement() && tryStreaming) {
                this.streaming = true;
                RequestResponse reqResp = new RequestResponse(namespace, localPart, (SOAPBody)this.myElement, isResponse, operations, context);
                reqResp.setNeedDeser(false);
                RequestResponseProcessor processor = new RequestResponseProcessor(reqResp, isResponse);
                processor.setOperation(operations[0]);
                msgContext.setOperation(operations[0]);
                Style style = operations[0].getStyle();
                if (style != Style.DOCUMENT) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exit: SOAPBodyBuilder::onStartChild() case: normal streaming");
                    }
                    return processor;
                }
                context.getEventConverter().popDEventProcessor();
                context.getEventConverter().pushDEventProcessor(processor);
                if (log.isDebugEnabled()) {
                    log.debug("Exit: SOAPBodyBuilder::onStartChild() case: pure doc/lit streaming");
                }
                return processor.onStartChild(namespace, localPart, prefixedName, attributes, mappingScope, context);
            }
            if (this.streaming) {
                Deserializer dser;
                context.setSimpleEventOptimization(true);
                String id = AttributeUtils.getID(attributes);
                if (id != null && (dser = context.getHrefTable().unregisterFixupByID(id)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exit: SOAPBodyBuilder::onStartChild() case: streaming multi-ref");
                    }
                    return dser;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Exit: SOAPBodyBuilder::onStartChild() case: streaming multi-ref possible error");
                }
                return new DefaultDeserializer();
            }
            SOAPBuilder builder = null;
            if (isFault) {
                builder = new SOAPFaultBuilder();
                this.myChildElement = this.myElement.getSOAPFactory().createSOAPFault(prefixedName, attributes, mappingScope, context, (SOAPBody)this.myElement);
            } else {
                builder = new SOAPBuilder();
                this.myChildElement = this.myElement.getSOAPFactory().createSOAPBodyElement(namespace, localPart, prefixedName, attributes, mappingScope, context, (SOAPBody)this.myElement);
            }
            if (isRoot && ((SOAPBody)this.myElement).getRequestResponse() == null) {
                RequestResponse reqResp = new RequestResponse(namespace, localPart, (SOAPBody)this.myElement, isResponse, operations, context);
            }
            builder.setMyElement(this.myChildElement);
            if (noDataBindingOp && !isFault && !disableSOAPElementLazyParse) {
                int level = operations == null || operations[0].getStyle() == Style.DOCUMENT ? 1 : 2;
                builder.setLazyParseLevel(level);
                if (log.isDebugEnabled()) {
                    log.debug("lazyParseLevel set to " + level);
                }
            } else {
                context.setSimpleEventOptimization(true);
            }
            if (log.isDebugEnabled()) {
                if (isFault) {
                    log.debug("Exit: SOAPBodyBuilder::onStartChild() case: normal nonstreaming fault path");
                } else {
                    log.debug("Exit: SOAPBodyBuilder::onStartChild() case: normal nonstreaming path");
                }
            }
            return builder;
        }
        catch (SOAPException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder.onStartChild", "418", this);
            throw new SAXException((Exception)((Object)e));
        }
    }

    public void endElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (this.myElement.getAlternateContent() != null || ((SOAPBody)this.myElement).getRequestResponse() != null) {
            return;
        }
        MessageContext msgContext = context.getMessageContext();
        Message msg = null;
        SOAPPort port = null;
        SOAPBody body = (SOAPBody)this.myElement;
        RequestResponse request = null;
        if (msgContext != null) {
            port = msgContext.getPort();
            msg = msgContext.getCurrentMessage();
            try {
                if (body.getRequestResponse() == null && !this.containsChild) {
                    OperationDesc opDesc;
                    boolean isResponse = msgContext != null && msgContext.getPastPivot() || msg != null && MessageType.RESPONSE == msg.getMessageType();
                    String namespaceURI = "";
                    String localPart = "empty";
                    OperationDesc[] operations = null;
                    if (msgContext != null && msgContext.getOperation() != null && (opDesc = msgContext.getOperation()) != null) {
                        operations = new OperationDesc[]{opDesc};
                        namespaceURI = opDesc.getElementQName().getNamespaceURI();
                        localPart = opDesc.getElementQName().getLocalPart();
                    }
                    request = new RequestResponse(namespaceURI, localPart, (SOAPBody)this.myElement, isResponse, operations, context);
                }
            }
            catch (SOAPException se) {
                FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder.endElement", "520", this);
                throw new SAXException((Exception)((Object)se));
            }
        }
    }

    public void characters(String value) throws SAXException {
        if (XMLUtils.isXMLWhitespace(value)) {
            if (this.streaming) {
                if (log.isDebugEnabled()) {
                    log.debug("Enter: SOAPBodyBuilder::characters() discarding whitespace (" + value + ")");
                }
            } else {
                super.characters(value);
            }
        } else {
            throw new SAXException(Messages.getMessage("nonWSDetected00", value, this.myElement.getQName().toString()));
        }
    }
}

