/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPHeaderElement;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;

public final class SOAPHeaderElement
extends SOAPElement
implements IBMSOAPHeaderElement {
    protected boolean processed = false;

    SOAPHeaderElement(String namespace, String localPart, SOAPFactory soapFactory) {
        super(namespace, localPart, soapFactory);
    }

    public void setParentElement(javax.xml.soap.SOAPElement parent) throws SOAPException {
        if (parent == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        if (!(parent instanceof SOAPHeader)) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException00"));
        }
        try {
            super.setParentElement((SOAPHeader)parent);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement.setParentElement", "117", this);
            throw new SOAPException(t);
        }
    }

    public boolean getMustUnderstand() {
        QName muQName = this.soapFactory.getSOAPConstants().getMustUnderstandAttributeQName();
        String mu = this.getAttributeValue(muQName.getNamespaceURI(), muQName.getLocalPart());
        return mu != null && mu.equals(this.soapFactory.getSOAPConstants().getMustUnderstandAttributeValue(true));
    }

    public void setMustUnderstand(boolean b) {
        QName muQName = this.soapFactory.getSOAPConstants().getMustUnderstandAttributeQName();
        SOAPConstants sc = this.soapFactory.getSOAPConstants();
        String trueValue = sc.getMustUnderstandAttributeValue(true);
        String falseValue = sc.getMustUnderstandAttributeValue(false);
        String mu = b ? trueValue : falseValue;
        this.setAttribute(muQName.getNamespaceURI(), muQName.getLocalPart(), mu);
    }

    public String getActor() {
        SOAPConstants soapConstants = this.soapFactory.getSOAPConstants();
        QName roleQName = soapConstants.getRoleOrActorAttributeQName();
        return this.getAttributeValue(roleQName.getNamespaceURI(), roleQName.getLocalPart());
    }

    public void setActor(String actor) {
        SOAPConstants soapConstants = this.soapFactory.getSOAPConstants();
        QName roleQName = soapConstants.getRoleOrActorAttributeQName();
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        String prefix = mappingScope.getOrCreatePrefix(roleQName.getNamespaceURI(), null, true);
        String qualifiedName = null;
        qualifiedName = prefix != null && prefix.length() != 0 ? prefix + ":" + roleQName.getLocalPart() : roleQName.getLocalPart();
        if (actor != null) {
            this.setAttributeNS(roleQName.getNamespaceURI(), qualifiedName, actor);
        } else {
            this.removeAttribute(roleQName);
        }
    }

    public void setProcessed(boolean value) {
        this.processed = value;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setRole(String uri) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setRole(String)", "javax.xml.soap.SOAPHeaderElement"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "setRole(String)", "javax.xml.soap.SOAPHeaderElement", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        SOAPConstants soapConstants = this.soapFactory.getSOAPConstants();
        QName roleQName = soapConstants.getRoleAttributeQName();
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        String prefix = mappingScope.getOrCreatePrefix(roleQName.getNamespaceURI(), null, true);
        String qualifiedName = null;
        qualifiedName = prefix != null && prefix.length() != 0 ? prefix + ":" + roleQName.getLocalPart() : roleQName.getLocalPart();
        if (uri != null) {
            this.setAttributeNS(roleQName.getNamespaceURI(), qualifiedName, uri);
        } else {
            this.removeAttribute(roleQName);
        }
    }

    public String getRole() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getRole()", "javax.xml.soap.SOAPHeaderElement"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getRole()", "javax.xml.soap.SOAPHeaderElement", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        SOAPConstants soapConstants = this.soapFactory.getSOAPConstants();
        if (!soapConstants.getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            return null;
        }
        QName roleQName = soapConstants.getRoleAttributeQName();
        return this.getAttributeValue(roleQName.getNamespaceURI(), roleQName.getLocalPart());
    }

    public void setRelay(boolean relay) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "setRelay(String)", "javax.xml.soap.SOAPHeaderElement"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "setRelay(String)", "javax.xml.soap.SOAPHeaderElement", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        SOAPConstants soapConstants = this.soapFactory.getSOAPConstants();
        QName relayQName = soapConstants.getRelayAttributeQName();
        Utils.addImplicitNamespaceDeclarations(this);
        MappingScope mappingScope = this._getMappingScope();
        String prefix = mappingScope.getOrCreatePrefix(relayQName.getNamespaceURI(), null, true);
        String qualifiedName = null;
        qualifiedName = prefix != null && prefix.length() != 0 ? prefix + ":" + relayQName.getLocalPart() : relayQName.getLocalPart();
        String relayText = relay ? "1" : "0";
        this.setAttributeNS(relayQName.getNamespaceURI(), qualifiedName, relayText);
    }

    public boolean getRelay() {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "getRelay()", "javax.xml.soap.SOAPHeaderElement"));
        }
        if (!this.isSOAP12()) {
            throw new UnsupportedOperationException(Messages.getMessage("SOAP12ProtocolRequiredMethod", "getRelay()", "javax.xml.soap.SOAPHeaderElement", this.soapFactory.getSOAPConstants().getSOAPProtocol()));
        }
        SOAPConstants soapConstants = this.soapFactory.getSOAPConstants();
        if (!soapConstants.getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            return false;
        }
        QName relayQName = soapConstants.getRelayAttributeQName();
        String relayText = this.getAttributeValue(relayQName.getNamespaceURI(), relayQName.getLocalPart());
        boolean relay = relayText.equals("1") || relayText.equals("false");
        return relay;
    }
}

