/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.client.ClientEngineFactory;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.NullEngineConfigurationProvider;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.DeserializationContextImpl;
import com.ibm.ws.webservices.engine.enumtype.MessageType;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.Detail;
import com.ibm.ws.webservices.engine.xmlsoap.DetailEntry;
import com.ibm.ws.webservices.engine.xmlsoap.Name;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPDocument;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFaultElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.Utils;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ElementAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.XMLInputSourceAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.XMLStringAlternateContent;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SOAPFactory
extends IBMSOAPFactory
implements Serializable {
    protected static Log log = LogFactory.getLog(SOAPFactory.class.getName());
    protected SOAPEnvelope envelope;
    protected SOAPConstants soapConstants;
    protected MessageType messageType;
    protected boolean protectState;
    protected boolean protectionViolation = false;
    private transient DeserializationContext context = null;
    private transient MessageContext msgContext = null;
    private SOAPDocument ownerDocument = new SOAPDocument();
    private static EngineConfiguration nullEngineConfig = null;

    public SOAPFactory(SOAPConstants soapConstants) {
        this.setSOAPConstants(soapConstants);
    }

    public SOAPFactory() {
        this.setSOAPConstants(SOAPConstants.SOAP11_CONSTANTS);
    }

    public SOAPFactory(String protocol) throws SOAPException {
        this.setSOAPConstants(Utils.getSOAPConstants(protocol));
    }

    public static javax.xml.soap.SOAPFactory newInstance() {
        return new SOAPFactory();
    }

    public SOAPConstants getSOAPConstants() {
        return this.soapConstants;
    }

    public void setSOAPConstants(SOAPConstants soapConstants) {
        if (!soapConstants.getSOAPProtocol().equals(SOAPConstants.SOAP11_CONSTANTS.getSOAPProtocol()) && !Utils._isSAAJ13Enabled()) {
            throw new UnsupportedOperationException(Messages.getMessage("unsupportedSOAPProtocol", soapConstants.getSOAPProtocol()));
        }
        this.soapConstants = soapConstants;
    }

    public SOAPDocument getOwnerDocument() {
        return this.ownerDocument;
    }

    public javax.xml.soap.SOAPElement createElement(javax.xml.soap.Name name) throws SOAPException {
        Class cls = this.getSOAPElementClass(name.getURI(), name.getLocalName());
        javax.xml.soap.SOAPElement se = this.createElement(name.getURI(), name.getLocalName(), cls);
        se.setPrefix(name.getPrefix());
        return se;
    }

    public javax.xml.soap.SOAPElement createElement(String localName) throws SOAPException {
        return this.createElement(localName, "", "");
    }

    public javax.xml.soap.SOAPElement createElement(String localName, String prefix, String uri) throws SOAPException {
        Class cls = this.getSOAPElementClass(uri, localName);
        javax.xml.soap.SOAPElement se = this.createElement(uri, localName, cls);
        se.setPrefix(prefix);
        return se;
    }

    public javax.xml.soap.SOAPElement createElementFromXMLString(String xmlString) throws SOAPException {
        SOAPElement element = this.createSOAPElement("", "elem");
        element.setAlternateContent(XMLStringAlternateContent.create(xmlString));
        return element;
    }

    public javax.xml.soap.SOAPElement createElementFromXMLString(String xmlString, Class cls) throws SOAPException {
        SOAPElement element = (SOAPElement)this.createElement("", "elem", cls);
        if (element != null) {
            element.removeContents();
            element.setAlternateContent(XMLStringAlternateContent.create(xmlString));
        }
        return element;
    }

    public javax.xml.soap.SOAPElement createElementFromInputSource(InputSource is) throws SOAPException {
        SOAPElement element = this.createSOAPElement("", "elem");
        element.setAlternateContent(XMLInputSourceAlternateContent.create(is));
        return element;
    }

    public javax.xml.soap.SOAPElement createElementFromInputSource(InputSource is, Class cls) throws SOAPException {
        SOAPElement element = (SOAPElement)this.createElement("", "elem", cls);
        if (element != null) {
            element.removeContents();
            element.setAlternateContent(XMLInputSourceAlternateContent.create(is));
        }
        return element;
    }

    public javax.xml.soap.SOAPElement createElementFromDOMElement(Element dom, Class cls) throws SOAPException {
        String localPart;
        String namespace = dom.getNamespaceURI();
        SOAPElement element = (SOAPElement)this.createElement(namespace, localPart = (localPart = dom.getLocalName()) == null || localPart.length() == 0 ? dom.getNodeName() : localPart, cls);
        if (element != null) {
            element.removeContents();
            element.setPrefix(dom.getPrefix());
            element.setAlternateContent(ElementAlternateContent.create(dom));
        }
        return element;
    }

    public javax.xml.soap.SOAPElement createElement(QName qname) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "createElement(QName)", "javax.xml.soap.SOAPFactory"));
        }
        Class cls = this.getSOAPElementClass(qname.getNamespaceURI(), qname.getLocalPart());
        javax.xml.soap.SOAPElement se = this.createElement(qname.getNamespaceURI(), qname.getLocalPart(), cls);
        if (qname.getPrefix().length() > 0) {
            se.setPrefix(qname.getPrefix());
        }
        return se;
    }

    javax.xml.soap.SOAPElement createElement(String namespace, String localPart, Class cls) throws SOAPException {
        if (cls.equals(javax.xml.soap.SOAPEnvelope.class) || cls.equals(SOAPEnvelope.class)) {
            if (this.envelope != null) {
                throw new SOAPException(Messages.getMessage("oneEnvelopePerFactory00"));
            }
            this.adjustProtocol(namespace);
            this.envelope = this.createDynamicSOAPEnvelope();
            return this.envelope;
        }
        if (cls.equals(javax.xml.soap.SOAPBody.class) || cls.equals(SOAPBody.class)) {
            this.adjustProtocol(namespace);
            return new SOAPBody(this);
        }
        if (cls.equals(javax.xml.soap.SOAPHeader.class) || cls.equals(SOAPHeader.class)) {
            this.adjustProtocol(namespace);
            return new SOAPHeader(this);
        }
        if (cls.equals(javax.xml.soap.SOAPFault.class) || cls.equals(SOAPFault.class)) {
            this.adjustProtocol(namespace);
            return new SOAPFault(this);
        }
        if (cls.equals(javax.xml.soap.Detail.class) || cls.equals(Detail.class)) {
            return new Detail(this);
        }
        if (cls.equals(javax.xml.soap.SOAPBodyElement.class) || cls.equals(SOAPBodyElement.class)) {
            return new SOAPBodyElement(namespace, localPart, this);
        }
        if (cls.equals(javax.xml.soap.SOAPHeaderElement.class) || cls.equals(SOAPHeaderElement.class)) {
            return new SOAPHeaderElement(namespace, localPart, this);
        }
        if (cls.equals(javax.xml.soap.DetailEntry.class) || cls.equals(DetailEntry.class)) {
            return new DetailEntry(namespace, localPart, this);
        }
        if (cls.equals(javax.xml.soap.SOAPFaultElement.class) || cls.equals(SOAPFaultElement.class)) {
            return new SOAPFaultElement(namespace, localPart, this);
        }
        if (cls.equals(javax.xml.soap.SOAPElement.class) || cls.equals(SOAPElement.class)) {
            return new SOAPElement(namespace, localPart, this);
        }
        return null;
    }

    public javax.xml.soap.SOAPElement createElement(Element domElement) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "createElement(Element)", "javax.xml.soap.SOAPFactory"));
        }
        if (domElement instanceof SOAPElement) {
            return (SOAPElement)((Object)domElement);
        }
        Class cls = this.getSOAPElementClass(domElement.getNamespaceURI(), domElement.getLocalName());
        return this.createElementFromDOMElement(domElement, cls);
    }

    public javax.xml.soap.Detail createDetail() throws SOAPException {
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            throw new UnsupportedOperationException(Messages.getMessage("unavailableMethodWithSOAPDynamicProtocol", "javax.xml.soap.SOAPFactory.createDetail()"));
        }
        return new Detail(this);
    }

    public javax.xml.soap.SOAPFault createFault() throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "createFault()", "javax.xml.soap.SOAPFactory"));
        }
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            throw new UnsupportedOperationException(Messages.getMessage("unavailableMethodWithSOAPDynamicProtocol", "javax.xml.soap.SOAPFactory.createDetail()"));
        }
        return new SOAPFault(this);
    }

    public javax.xml.soap.SOAPFault createFault(String reasonText, QName faultCode) throws SOAPException {
        if (!Utils._isSAAJ13Enabled()) {
            throw new IllegalArgumentException(Messages.getMessage("saaj13Disabled", "createFault(String, QName)", "javax.xml.soap.SOAPFactory"));
        }
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            throw new UnsupportedOperationException(Messages.getMessage("unavailableMethodWithSOAPDynamicProtocol", "javax.xml.soap.SOAPFactory.createDetail()"));
        }
        SOAPFault fault = new SOAPFault(this);
        fault.setFaultCode(faultCode);
        fault.setFaultString(reasonText);
        return fault;
    }

    public javax.xml.soap.Name createName(String localName, String prefix, String uri) throws SOAPException {
        return new Name(uri, localName, prefix);
    }

    public javax.xml.soap.Name createName(String localName) throws SOAPException {
        return new Name("", localName, "");
    }

    public SOAPEnvelope createSOAPEnvelope() throws SOAPException {
        return this.createSOAPEnvelope(false);
    }

    public SOAPEnvelope createSOAPEnvelope(boolean bootstrap2) throws SOAPException {
        if (this.envelope != null) {
            throw new SOAPException(Messages.getMessage("oneEnvelopePerFactory00"));
        }
        this.envelope = new SOAPEnvelope(bootstrap2, this);
        return this.envelope;
    }

    public SOAPEnvelope createSOAPEnvelope(InputStream input) throws SOAPException {
        if (this.envelope != null) {
            throw new SOAPException(Messages.getMessage("oneEnvelopePerFactory00"));
        }
        this.envelope = this.createDynamicSOAPEnvelope();
        InputSource is = new InputSource(input);
        ClientEngine tmpEngine = ClientEngineFactory.getEngine(SOAPFactory.getNullEngineConfig());
        MessageContext msgContext = new MessageContext(tmpEngine);
        this.setMessageContext(msgContext);
        DeserializationContextImpl dser = new DeserializationContextImpl(is, msgContext, MessageType.REQUEST, this.envelope);
        try {
            dser.parse();
        }
        catch (SAXException se) {
            FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory.createSOAPEnvelope", "214", this);
            throw new SOAPException(Messages.getMessage("parseError00", se.toString()));
        }
        return this.envelope;
    }

    SOAPEnvelope getSOAPEnvelope() {
        return this.envelope;
    }

    public SOAPElement createSOAPElement(String uri, String localName) throws SOAPException {
        SOAPElement se = uri == null || uri.length() == 0 ? new SOAPElement(null, localName, this) : new SOAPElement(uri, localName, this);
        return se;
    }

    public SOAPElement createSOAPElement(String namespaceURI, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context, SOAPElement parent) throws SOAPException {
        namespaceURI = namespaceURI == null ? "" : namespaceURI;
        SOAPElement se = this.createSOAPElement(namespaceURI, localPart);
        this.elementInit(se, prefixedName, attributes, mappingScope, context, parent);
        return se;
    }

    public SOAPBody createSOAPBody(String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context, SOAPEnvelope parent) throws SOAPException {
        SOAPBody se = new SOAPBody(this);
        this.elementInit(se, prefixedName, attributes, mappingScope, context, parent);
        return se;
    }

    public SOAPBodyElement createSOAPBodyElement(String namespace, String localPart) throws SOAPException {
        return new SOAPBodyElement(namespace, localPart, this);
    }

    public SOAPBodyElement createSOAPBodyElement(String namespaceURI, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context, SOAPBody parent) throws SOAPException {
        namespaceURI = namespaceURI == null ? "" : namespaceURI;
        SOAPBodyElement se = new SOAPBodyElement(namespaceURI, localPart, this);
        this.elementInit(se, prefixedName, attributes, mappingScope, context, parent);
        return se;
    }

    public SOAPHeader createSOAPHeader(String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context, SOAPEnvelope parent) throws SOAPException {
        SOAPHeader se = new SOAPHeader(this);
        this.elementInit(se, prefixedName, attributes, mappingScope, context, parent);
        return se;
    }

    public SOAPHeaderElement createSOAPHeaderElement(String namespace, String localPart) throws SOAPException {
        return new SOAPHeaderElement(namespace, localPart, this);
    }

    public SOAPHeaderElement createSOAPHeaderElement(String namespaceURI, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context, SOAPHeader parent) throws SOAPException {
        namespaceURI = namespaceURI == null ? "" : namespaceURI;
        SOAPHeaderElement se = new SOAPHeaderElement(namespaceURI, localPart, this);
        this.elementInit(se, prefixedName, attributes, mappingScope, context, parent);
        return se;
    }

    public SOAPFault createSOAPFault() throws SOAPException {
        SOAPFault soapFault = new SOAPFault(this);
        if (this.envelope != null) {
            soapFault.setPrefix(this.envelope.getPrefix());
        } else {
            soapFault.setPrefix(this.getSOAPConstants().getEnvelopePrefix());
        }
        return soapFault;
    }

    public SOAPFault createSOAPFault(String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context, SOAPBody parent) throws SOAPException {
        SOAPFault se = new SOAPFault(this);
        this.elementInit(se, prefixedName, attributes, mappingScope, context, parent);
        return se;
    }

    public DetailEntry createDetailEntry(String namespace, String localPart) throws SOAPException {
        return new DetailEntry(namespace, localPart, this);
    }

    public DetailEntry createDetailEntry(String namespaceURI, String localPart, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context, SOAPElement parent) throws SOAPException {
        namespaceURI = namespaceURI == null ? "" : namespaceURI;
        DetailEntry se = new DetailEntry(namespaceURI, localPart, this);
        this.elementInit(se, prefixedName, attributes, mappingScope, context, parent);
        return se;
    }

    public Detail createDetail(Attributes attributes, MappingScope mappingScope, DeserializationContext context, SOAPElement parent) throws SOAPException {
        Detail se = new Detail(this);
        this.elementInit(se, "", attributes, mappingScope, context, parent);
        return se;
    }

    private void elementInit(SOAPElement se, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context, SOAPElement parent) throws SOAPException {
        se.setMappingScope(mappingScope);
        String prefix = "";
        int idx = prefixedName.indexOf(58);
        if (idx > 0) {
            prefix = prefixedName.substring(0, idx);
        }
        se.setPrefix(prefix);
        if (parent != null) {
            se.setParentElement(parent);
        }
        if (attributes != null && attributes.getLength() > 0) {
            se.setAttributes(attributes);
        }
        this.context = context;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public boolean getProtectState() {
        return this.protectState;
    }

    public void setProtectState(boolean state) {
        this.protectState = state;
    }

    void setProtectionViolation(boolean state) {
        this.protectionViolation = state;
    }

    public boolean getProtectionViolation() {
        return this.protectionViolation;
    }

    DeserializationContext getDeserializationContext() {
        if (this.context == null) {
            SOAPEnvelope anEnvelope = this.envelope;
            if (anEnvelope == null) {
                try {
                    anEnvelope = this.createDynamicSOAPEnvelope();
                }
                catch (SOAPException se) {
                    FFDCFilter.processException((Throwable)se, "com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory.getDeserializationContext", "593", this);
                    throw new InternalException((Exception)((Object)se));
                }
            }
            this.context = new DeserializationContextImpl(null, this.getMessageContext(), this.getMessageType(), anEnvelope);
        }
        return this.context;
    }

    public void setMessageContext(MessageContext msgContext) {
        this.msgContext = msgContext;
    }

    public MessageContext getMessageContext() {
        if (this.msgContext == null) {
            if (this.context != null) {
                this.setMessageContext(this.context.getMessageContext());
            } else {
                this.setMessageContext(MessageContext.getCurrentThreadsContext());
            }
        }
        return this.msgContext;
    }

    private void adjustProtocol(String namespace) throws SOAPException {
        if (namespace.length() == 0) {
            return;
        }
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            if (SOAPConstants.SOAP11_CONSTANTS.getEnvelopeURI().equals(namespace)) {
                this.soapConstants = SOAPConstants.SOAP11_CONSTANTS;
                return;
            }
            if (SOAPConstants.SOAP12_CONSTANTS.getEnvelopeURI().equals(namespace)) {
                this.soapConstants = SOAPConstants.SOAP12_CONSTANTS;
                return;
            }
            throw new SOAPException(Messages.getMessage("namespaceDoesNotMatchProtocol", namespace, this.soapConstants.getSOAPProtocol()));
        }
        if (!this.soapConstants.getEnvelopeURI().equals(namespace)) {
            throw new SOAPException(Messages.getMessage("namespaceDoesNotMatchProtocol", namespace, this.soapConstants.getSOAPProtocol()));
        }
    }

    private Class getSOAPElementClass(String namespace, String localPart) {
        Class cls;
        Class clazz = cls = SOAPElement.class;
        if ("http://www.w3.org/2003/05/soap-envelope".equals(namespace)) {
            SOAPConstants sc = SOAPConstants.SOAP12_CONSTANTS;
            if (sc.getEnvelopeQName().getLocalPart().equals(localPart)) {
                cls = SOAPEnvelope.class;
            } else if (sc.getHeaderQName().getLocalPart().equals(localPart)) {
                cls = SOAPHeader.class;
            } else if (sc.getBodyQName().getLocalPart().equals(localPart)) {
                cls = SOAPBody.class;
            } else if (sc.getFaultQName().getLocalPart().equals(localPart)) {
                cls = SOAPFault.class;
            } else if (sc.getFaultDetailQName().getLocalPart().equals(localPart)) {
                cls = Detail.class;
            } else if (sc.getFaultCodeQName().getLocalPart().equals(localPart) || sc.getFaultStringOrReasonQName().getLocalPart().equals(localPart) || sc.getFaultNodeQName().getLocalPart().equals(localPart) || sc.getFaultActorOrRoleQName().getLocalPart().equals(localPart)) {
                cls = SOAPFaultElement.class;
            }
        } else if ("http://schemas.xmlsoap.org/soap/envelope/".equals(namespace)) {
            SOAPConstants sc = SOAPConstants.SOAP11_CONSTANTS;
            if (sc.getEnvelopeQName().getLocalPart().equals(localPart)) {
                cls = SOAPEnvelope.class;
            } else if (sc.getHeaderQName().getLocalPart().equals(localPart)) {
                cls = SOAPHeader.class;
            } else if (sc.getBodyQName().getLocalPart().equals(localPart)) {
                cls = SOAPBody.class;
            } else if (sc.getFaultQName().getLocalPart().equals(localPart)) {
                cls = SOAPFault.class;
            }
        } else if (namespace.length() == 0) {
            SOAPConstants sc = SOAPConstants.SOAP11_CONSTANTS;
            if (sc.getFaultDetailQName().getLocalPart().equals(localPart)) {
                cls = Detail.class;
            } else if (sc.getFaultCodeQName().getLocalPart().equals(localPart) || sc.getFaultStringOrReasonQName().getLocalPart().equals(localPart) || sc.getFaultActorOrRoleQName().getLocalPart().equals(localPart)) {
                cls = SOAPFaultElement.class;
            }
        }
        return cls;
    }

    private SOAPEnvelope createDynamicSOAPEnvelope() throws SOAPException {
        SOAPConstants orig = this.soapConstants;
        if (this.soapConstants.getSOAPProtocol().equals("Dynamic Protocol")) {
            this.soapConstants = SOAPConstants.SOAP11_CONSTANTS;
        }
        SOAPEnvelope envelope = new SOAPEnvelope(false, this);
        this.soapConstants = orig;
        return envelope;
    }

    private static EngineConfiguration getNullEngineConfig() {
        if (nullEngineConfig == null) {
            nullEngineConfig = new NullEngineConfigurationProvider();
        }
        return nullEngineConfig;
    }
}

