/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.events.PEventProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.ext.BusinessObjectAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ElementAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.InputStreamAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValueAlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponseAlternateContent;
import java.io.InputStream;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AlternateContentBase {
    private static Log log = LogFactory.getLog(AlternateContentBase.class.getName());
    protected SOAPElement owner;
    protected Object content;
    protected short contentFlag;
    public static short CONTENT_ONLY = 0;
    public static short CONTENT_PLUS_ATTRS = 1;
    public static short CONTENT_PLUS_TAG = (short)2;

    static AlternateContentBase create(Object content) {
        if (content instanceof AlternateContentBase) {
            return (AlternateContentBase)content;
        }
        if (content instanceof RequestResponse) {
            return RequestResponseAlternateContent.create((RequestResponse)content);
        }
        if (content instanceof ParamValue) {
            return ParamValueAlternateContent.create((ParamValue)content);
        }
        if (content instanceof InputStream) {
            return InputStreamAlternateContent.create((InputStream)content);
        }
        if (content instanceof Element) {
            return ElementAlternateContent.create((Element)content);
        }
        return BusinessObjectAlternateContent.create(content);
    }

    protected AlternateContentBase(Object content, short contentFlag) {
        this.content = content;
        this.contentFlag = contentFlag;
    }

    protected void attach(SOAPElement owner) throws SOAPException {
        if (this.hasContent() && owner.getNumChildren() > 0) {
            SOAPException exc = new SOAPException(Messages.getMessage("childPresent"));
            log.error(Messages.getMessage("childPresent"), exc);
            throw exc;
        }
        if (owner.altContent != null) {
            SOAPException exc = new SOAPException(Messages.getMessage("altContentAlreadySet00"));
            throw exc;
        }
        this.owner = owner;
        owner.altContent = this;
    }

    protected void detach() {
        if (this.owner != null) {
            this.owner.altContent = null;
            this.owner = null;
        }
    }

    protected final boolean affectsTagQName() {
        return this.contentFlag == CONTENT_PLUS_TAG;
    }

    protected final boolean affectsTagAttributes() {
        return this.contentFlag != CONTENT_ONLY;
    }

    protected void removeChildNodes() {
        if (this.contentFlag == CONTENT_ONLY) {
            this.detach();
        } else {
            SOAPElement _owner = this.owner;
            Element eContent = this.getDOMElement();
            if (eContent != null) {
                NamedNodeMap attrs = eContent.getAttributes();
                this.detach();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Attr attr = (Attr)attrs.item(i);
                    _owner.setAttribute(attr.getName(), attr.getValue());
                }
                if (this.contentFlag == CONTENT_PLUS_TAG) {
                    String namespace = eContent.getNamespaceURI();
                    namespace = namespace == null ? "" : namespace;
                    String localName = eContent.getLocalName();
                    String prefix = eContent.getPrefix();
                    _owner.setQName(namespace, localName);
                    _owner.setPrefix(prefix);
                }
            } else {
                _owner.asSOAPElement(SOAPElement.CONTEXT_CONTENT);
                _owner.removeContents();
            }
        }
    }

    protected boolean hasContent() {
        return true;
    }

    protected Object getContent() {
        return this.hasContent() ? this.content : null;
    }

    protected Element getDOMElement() {
        return null;
    }

    protected String getXMLString() throws Exception {
        return null;
    }

    protected InputSource getXMLInputSource() throws Exception {
        return null;
    }

    protected RequestResponse asRequestResponse() {
        SOAPElement savedOwner = this.owner;
        this.owner.asSOAPElement(SOAPElement.CONTEXT_CONTENT);
        if (savedOwner.altContent != null && savedOwner.altContent != this) {
            return savedOwner.altContent.asRequestResponse();
        }
        return null;
    }

    protected boolean isBusinessObject() {
        return false;
    }

    protected abstract void serialize(SerializationContext var1, boolean var2) throws Exception;

    protected final MappingScope _getMappingScope(SOAPElement se) {
        return se._getMappingScope();
    }

    protected final MappingScope _getMappingScopeForAncestorsNotWritten(SerializationContext context) {
        MappingScope ms = null;
        ms = this.owner != null ? this.owner.getMappingScopeForAncestorsNotWritten(context) : new MappingScope();
        return ms;
    }

    public boolean hasToEvents() {
        return false;
    }

    public void toEvents(PEventProcessor processor) throws SAXException {
    }
}

