/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.components.image.ImageIO;
import com.ibm.ws.webservices.engine.components.image.ImageIOFactory;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.types.HexBinary;
import com.ibm.ws.webservices.engine.types.URI;
import com.ibm.ws.webservices.engine.utils.CharSetUtils;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import java.awt.Image;
import java.beans.Introspector;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.xml.rpc.holders.Holder;
import javax.xml.rpc.holders.StringHolder;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;

public class JavaUtils {
    protected static Log log = LogFactory.getLog(JavaUtils.class.getName());
    public static final char NL = '\n';
    public static final char CR = '\r';
    public static final String NO_PACKAGE_HOST_NAME = "DefaultNamespace";
    public static final String LS = System.getProperty("line.separator", new Character('\n').toString());
    static final String[] keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static final char keywordPrefix = '_';
    private static HashMap loadableMap = new HashMap();
    private static boolean checkForAttachmentSupport;
    private static boolean attachmentSupportEnabled;
    static /* synthetic */ Class class$javax$xml$rpc$holders$Holder;

    public static Class getWrapperClass(Class primitive) {
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        return null;
    }

    public static String getWrapper(String primitive) {
        if (primitive.equals("int")) {
            return "java.lang.Integer";
        }
        if (primitive.equals("short")) {
            return "java.lang.Short";
        }
        if (primitive.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (primitive.equals("byte")) {
            return "java.lang.Byte";
        }
        if (primitive.equals("long")) {
            return "java.lang.Long";
        }
        if (primitive.equals("double")) {
            return "java.lang.Double";
        }
        if (primitive.equals("float")) {
            return "java.lang.Float";
        }
        if (primitive.equals("char")) {
            return "java.lang.Character";
        }
        return null;
    }

    public static Class getPrimitiveClass(Class wrapper) {
        if (wrapper == Integer.class) {
            return Integer.TYPE;
        }
        if (wrapper == Short.class) {
            return Short.TYPE;
        }
        if (wrapper == Boolean.class) {
            return Boolean.TYPE;
        }
        if (wrapper == Byte.class) {
            return Byte.TYPE;
        }
        if (wrapper == Long.class) {
            return Long.TYPE;
        }
        if (wrapper == Double.class) {
            return Double.TYPE;
        }
        if (wrapper == Float.class) {
            return Float.TYPE;
        }
        if (wrapper == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    public static Object convert(Object arg, Class destClass) {
        Class hintClass;
        Object newArg;
        if (destClass == null) {
            return arg;
        }
        Class argHeldType = null;
        if (arg != null) {
            argHeldType = JavaUtils.getHolderValueType(arg.getClass());
        }
        if (arg != null && argHeldType == null && destClass.isAssignableFrom(arg.getClass())) {
            return arg;
        }
        if (log.isDebugEnabled()) {
            String clsName = "null";
            if (arg != null) {
                clsName = arg.getClass().getName();
            }
            log.debug(Messages.getMessage("convert00", clsName, destClass.getName()));
        }
        Object destValue = null;
        if (arg instanceof ConvertCache && (destValue = ((ConvertCache)arg).getConvertedValue(destClass)) != null) {
            return destValue;
        }
        Class destHeldType = JavaUtils.getHolderValueType(destClass);
        if (arg instanceof HexBinary && destClass == [B.class) {
            return ((HexBinary)arg).getBytes();
        }
        if (arg instanceof byte[] && destClass == HexBinary.class) {
            return new HexBinary((byte[])arg);
        }
        if (arg instanceof Calendar && destClass == Date.class) {
            return ((Calendar)arg).getTime();
        }
        if (arg instanceof java.net.URI && destClass == URI.class) {
            try {
                return new URI(((java.net.URI)arg).toString());
            }
            catch (URI.MalformedURIException e) {
                return arg;
            }
        }
        if (arg instanceof URI && destClass == java.net.URI.class) {
            try {
                return new java.net.URI(((URI)arg).toString());
            }
            catch (URISyntaxException e) {
                return arg;
            }
        }
        if (arg instanceof HashMap && destClass == Hashtable.class) {
            return new Hashtable((HashMap)arg);
        }
        if (JavaUtils.isAttachmentSupported() && (arg instanceof AttachmentPart || arg instanceof DataHandler)) {
            try {
                String destName = destClass.getName();
                if (DataHandler.class.isAssignableFrom(destClass)) {
                    if (arg instanceof AttachmentPart) {
                        return ((AttachmentPart)arg).getDataHandler();
                    }
                } else if (destClass == String.class || destClass == Image.class || destClass == Source.class || destName.equals("javax.mail.internet.MimeMultipart")) {
                    DataHandler handler = arg instanceof AttachmentPart ? ((AttachmentPart)arg).getDataHandler() : (DataHandler)arg;
                    if (destClass == Image.class) {
                        InputStream is = (InputStream)handler.getContent();
                        if (is.available() == 0) {
                            return null;
                        }
                        ImageIO imageIO = ImageIOFactory.getImageIO();
                        if (imageIO != null) {
                            return JavaUtils.getImageFromStream(is);
                        }
                        log.info(Messages.getMessage("needImageIO"));
                        return arg;
                    }
                    if (destClass == Source.class) {
                        return new StreamSource(new StringReader((String)handler.getContent()));
                    }
                    return handler.getContent();
                }
            }
            catch (IOException ioe) {
            }
            catch (SOAPException se) {
                // empty catch block
            }
        }
        if (arg != null && destClass.isArray() && !destClass.getComponentType().equals(Object.class) && destClass.getComponentType().isAssignableFrom(arg.getClass())) {
            Object array = Array.newInstance(destClass.getComponentType(), 1);
            Array.set(array, 0, arg);
            return array;
        }
        if (!(arg instanceof Collection) && (arg == null || !arg.getClass().isArray()) && (destHeldType == null && argHeldType == null || destHeldType != null && argHeldType != null)) {
            return arg;
        }
        if (destHeldType != null) {
            newArg = JavaUtils.convert(arg, destHeldType);
            Object argHolder = null;
            try {
                argHolder = destClass.newInstance();
                JavaUtils.setHolderValue(argHolder, newArg);
                return argHolder;
            }
            catch (Exception e) {
                return arg;
            }
        }
        if (argHeldType != null) {
            try {
                newArg = JavaUtils.getHolderValue(arg);
                return JavaUtils.convert(newArg, destClass);
            }
            catch (HolderException e) {
                return arg;
            }
        }
        if (arg instanceof ConvertCache && ((ConvertCache)arg).getDestClass() != destClass && (hintClass = ((ConvertCache)arg).getDestClass()) != null && hintClass.isArray() && destClass.isArray() && destClass.isAssignableFrom(hintClass) && (destValue = ((ConvertCache)arg).getConvertedValue(destClass = hintClass)) != null) {
            return destValue;
        }
        if (arg == null) {
            return arg;
        }
        int length = 0;
        length = arg.getClass().isArray() ? Array.getLength(arg) : ((Collection)arg).size();
        if (destClass.isArray()) {
            if (destClass.getComponentType().isPrimitive()) {
                Object array = Array.newInstance(destClass.getComponentType(), length);
                if (arg.getClass().isArray()) {
                    for (int i = 0; i < length; ++i) {
                        Array.set(array, i, Array.get(arg, i));
                    }
                } else {
                    int idx = 0;
                    Iterator i = ((Collection)arg).iterator();
                    while (i.hasNext()) {
                        Array.set(array, idx++, i.next());
                    }
                }
                destValue = array;
            } else {
                Object[] array;
                try {
                    array = (Object[])Array.newInstance(destClass.getComponentType(), length);
                }
                catch (Exception e) {
                    return arg;
                }
                if (arg.getClass().isArray()) {
                    for (int i = 0; i < length; ++i) {
                        array[i] = JavaUtils.convert(Array.get(arg, i), destClass.getComponentType());
                    }
                } else {
                    int idx = 0;
                    Iterator i = ((Collection)arg).iterator();
                    while (i.hasNext()) {
                        array[idx++] = JavaUtils.convert(i.next(), destClass.getComponentType());
                    }
                }
                destValue = array;
            }
        } else if (Collection.class.isAssignableFrom(destClass)) {
            Collection newList = null;
            try {
                newList = destClass == Collection.class || destClass == List.class ? new ArrayList() : (destClass == Set.class ? new HashSet() : (Collection)destClass.newInstance());
            }
            catch (Exception e) {
                return arg;
            }
            if (arg.getClass().isArray()) {
                for (int j = 0; j < length; ++j) {
                    newList.add(Array.get(arg, j));
                }
            } else {
                Iterator j = ((Collection)arg).iterator();
                while (j.hasNext()) {
                    newList.add(j.next());
                }
            }
            destValue = newList;
        } else {
            destValue = arg;
        }
        if (arg instanceof ConvertCache) {
            ((ConvertCache)arg).setConvertedValue(destClass, destValue);
        }
        return destValue;
    }

    public static boolean isConvertable(Object obj, Class dest) {
        Class<?> src = null;
        if (obj != null) {
            src = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        }
        if (dest == null) {
            return false;
        }
        if (src != null) {
            if (dest.isAssignableFrom(src)) {
                return true;
            }
            if (JavaUtils.getWrapperClass(src) == dest) {
                return true;
            }
            if (JavaUtils.getWrapperClass(dest) == src) {
                return true;
            }
            if ((Collection.class.isAssignableFrom(src) || src.isArray()) && (Collection.class.isAssignableFrom(dest) || dest.isArray())) {
                return true;
            }
            if (dest.isArray() && !dest.getComponentType().equals(Object.class) && (dest.getComponentType().isAssignableFrom(src) || JavaUtils.getWrapperClass(dest.getComponentType()) == src || dest.getComponentType() == JavaUtils.getWrapperClass(src))) {
                return true;
            }
            if (src == HexBinary.class && dest == [B.class || src == [B.class && dest == HexBinary.class) {
                return true;
            }
            if (src == HashMap.class && dest == Hashtable.class) {
                return true;
            }
            if (Calendar.class.isAssignableFrom(src) && dest == Date.class) {
                return true;
            }
            if (src == java.net.URI.class && dest == URI.class) {
                return true;
            }
            if (src == URI.class && dest == java.net.URI.class) {
                return true;
            }
        }
        Class destHeld = JavaUtils.getHolderValueType(dest);
        if (src == null) {
            return destHeld != null;
        }
        if (destHeld != null && (destHeld.isAssignableFrom(src) || JavaUtils.isConvertable(src, destHeld))) {
            return true;
        }
        Class srcHeld = JavaUtils.getHolderValueType(src);
        if (srcHeld != null && (dest.isAssignableFrom(srcHeld) || JavaUtils.isConvertable(srcHeld, dest))) {
            return true;
        }
        if (dest.getName().equals("javax.activation.DataHandler")) {
            String name = src.getName();
            if (src == String.class || src == Image.class || name.equals("javax.mail.internet.MimeMultipart") || name.equals("javax.xml.transform.Source")) {
                return true;
            }
        }
        if (src.isPrimitive()) {
            return JavaUtils.isConvertable(JavaUtils.getWrapperClass(src), dest);
        }
        return false;
    }

    public static Image getImageFromStream(InputStream is) {
        try {
            return ImageIOFactory.getImageIO().loadImage(is);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean isJavaId(String id) {
        if (id == null || id.equals("") || JavaUtils.isJavaKeyword(id)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaKeyword(String keyword) {
        return Arrays.binarySearch(keywords, keyword) >= 0;
    }

    public static String makeNonJavaKeyword(String keyword) {
        return '_' + keyword;
    }

    public static String getLoadableClassName(String text) {
        String loadClass;
        int bracket = text.indexOf("[");
        if (text == null || bracket < 0 || bracket == 0) {
            return text;
        }
        String className = text;
        if (bracket > 0) {
            className = className.substring(0, bracket);
        }
        if ((loadClass = (String)loadableMap.get(className)) == null) {
            loadClass = "L" + className + ";";
        }
        if (bracket > 0) {
            int i = text.indexOf("]");
            while (i > 0) {
                loadClass = "[" + loadClass;
                i = text.indexOf("]", i + 1);
            }
        }
        return loadClass;
    }

    public static String getTextClassName(String text) {
        int index;
        if (text == null || text.indexOf("[") != 0) {
            return text;
        }
        String className = "";
        for (index = 0; index < text.length() && text.charAt(index) == '['; ++index) {
            className = className + "[]";
        }
        if (index < text.length()) {
            className = text.charAt(index) == 'B' ? "byte" + className : (text.charAt(index) == 'C' ? "char" + className : (text.charAt(index) == 'D' ? "double" + className : (text.charAt(index) == 'F' ? "float" + className : (text.charAt(index) == 'I' ? "int" + className : (text.charAt(index) == 'J' ? "long" + className : (text.charAt(index) == 'S' ? "short" + className : (text.charAt(index) == 'Z' ? "boolean" + className : (text.equals("void") ? "void" : text.substring(index + 1, text.indexOf(";")) + className))))))));
        }
        return className;
    }

    public static String java2NCName(String javaName) {
        return CharSetUtils.java2NCName(javaName);
    }

    public static String xmlNameToJava(String name) {
        int i;
        if (name == null || name.equals("")) {
            return name;
        }
        name = CharSetUtils.NCName2Java(name);
        char[] nameArray = name.toCharArray();
        int nameLen = name.length();
        StringBuffer result = new StringBuffer(nameLen);
        boolean wordStart = false;
        for (i = 0; i < nameLen && (JavaUtils.isPunctuation(nameArray[i]) || !Character.isJavaIdentifierStart(nameArray[i])); ++i) {
        }
        if (i < nameLen) {
            result.append(nameArray[i]);
            wordStart = !Character.isLetter(nameArray[i]) && !Character.isJavaIdentifierStart(nameArray[i]);
        } else if (Character.isJavaIdentifierPart(nameArray[0])) {
            result.append("_" + nameArray[0]);
        } else {
            result.append("_" + nameArray.length);
        }
        ++i;
        while (i < nameLen) {
            char c = nameArray[i];
            if (JavaUtils.isPunctuation(c) || !Character.isJavaIdentifierPart(c)) {
                wordStart = true;
            } else {
                if (wordStart && Character.isLowerCase(c)) {
                    result.append(Character.toUpperCase(c));
                } else {
                    result.append(c);
                }
                wordStart = Character.isDigit(c) || c == '\u2160';
            }
            ++i;
        }
        String newName = result.toString();
        if (Character.isUpperCase(newName.charAt(0))) {
            newName = Introspector.decapitalize(newName);
        }
        if (JavaUtils.isJavaKeyword(newName)) {
            newName = JavaUtils.makeNonJavaKeyword(newName);
        }
        return newName;
    }

    public static String xmlNameToJava51(String name) {
        int i;
        if (name == null || name.equals("")) {
            return name;
        }
        name = CharSetUtils.NCName2Java(name);
        char[] nameArray = name.toCharArray();
        int nameLen = name.length();
        StringBuffer result = new StringBuffer(nameLen);
        boolean wordStart = false;
        for (i = 0; i < nameLen && (JavaUtils.isPunctuation(nameArray[i]) || !Character.isJavaIdentifierStart(nameArray[i])); ++i) {
        }
        if (i < nameLen) {
            result.append(nameArray[i]);
            wordStart = !Character.isLetter(nameArray[i]);
        } else if (Character.isJavaIdentifierPart(nameArray[0])) {
            result.append("_" + nameArray[0]);
        } else {
            result.append("_" + nameArray.length);
        }
        ++i;
        while (i < nameLen) {
            char c = nameArray[i];
            if (JavaUtils.isPunctuation(c) || !Character.isJavaIdentifierPart(c)) {
                wordStart = true;
            } else {
                if (wordStart && Character.isLowerCase(c)) {
                    result.append(Character.toUpperCase(c));
                } else {
                    result.append(c);
                }
                wordStart = Character.isLetter(c);
            }
            ++i;
        }
        String newName = result.toString();
        if (Character.isUpperCase(newName.charAt(0))) {
            newName = Introspector.decapitalize(newName);
        }
        if (JavaUtils.isJavaKeyword(newName)) {
            newName = JavaUtils.makeNonJavaKeyword(newName);
        }
        return newName;
    }

    public static String xmlNameToJavaClass(String name) {
        return JavaUtils.capitalizeFirstChar(JavaUtils.xmlNameToJava(name));
    }

    public static String xmlNameToJavaClass51(String name) {
        return JavaUtils.capitalizeFirstChar(JavaUtils.xmlNameToJava51(name));
    }

    public static String capitalizeFirstChar(String name) {
        if (name == null || name.equals("")) {
            return name;
        }
        char start = name.charAt(0);
        if (Character.isLowerCase(start)) {
            start = Character.toUpperCase(start);
            return start + name.substring(1);
        }
        return name;
    }

    public static String makePackageName(String namespace) {
        String hostname = null;
        try {
            hostname = new URL(namespace).getHost();
        }
        catch (MalformedURLException e) {
            if (namespace.indexOf("://") > -1) {
                hostname = namespace.substring(namespace.indexOf("://") + 3);
                if (hostname.indexOf("/") > -1) {
                    hostname = hostname.substring(0, hostname.indexOf("/"));
                }
            }
            if (namespace.indexOf(":") > -1) {
                hostname = namespace.substring(namespace.indexOf(":") + 1);
                if (hostname.indexOf("/") > -1) {
                    hostname = hostname.substring(0, hostname.indexOf("/"));
                }
            }
            hostname = namespace;
        }
        if (hostname == null) {
            return null;
        }
        if (hostname.equals(NO_PACKAGE_HOST_NAME)) {
            return "";
        }
        hostname = hostname.replace('-', '_');
        StringTokenizer st = new StringTokenizer(hostname, ".");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuffer sb = new StringBuffer(80);
        for (int i = words.length - 1; i >= 0; --i) {
            String word = words[i];
            if (JavaUtils.isJavaKeyword(word)) {
                word = JavaUtils.makeNonJavaKeyword(word);
            }
            if (i != words.length - 1) {
                sb.append('.');
            }
            if (Character.isDigit(word.charAt(0))) {
                sb.append('_');
            }
            sb.append(word);
        }
        return sb.toString();
    }

    public static String makePackageName2(String namespace) {
        String hostname = null;
        try {
            hostname = new URL(namespace).getHost();
        }
        catch (MalformedURLException e) {
            if (namespace.indexOf(":") > -1) {
                hostname = namespace.substring(namespace.indexOf(":") + 1);
                if (hostname.indexOf("/") > -1) {
                    hostname = hostname.substring(0, hostname.indexOf("/"));
                }
            }
            hostname = namespace;
        }
        if (hostname != null || hostname.length() == 0) {
            int index = namespace.indexOf(hostname) + hostname.length();
            String theRest = namespace.substring(index);
            theRest = theRest.replace('-', '_');
            StringTokenizer st = new StringTokenizer(theRest, "./\\:");
            String[] words = new String[st.countTokens()];
            for (int i = 0; i < words.length; ++i) {
                words[i] = st.nextToken();
            }
            StringBuffer sb = new StringBuffer(80);
            for (int i = 0; i < words.length; ++i) {
                String word = words[i];
                if (JavaUtils.isJavaKeyword(word)) {
                    word = JavaUtils.makeNonJavaKeyword(word);
                }
                sb.append('.');
                if (Character.isDigit(word.charAt(0))) {
                    sb.append('_');
                }
                sb.append(word);
            }
            String pkgSuffix = sb.toString();
            String pkgPrefix = JavaUtils.makePackageName(namespace);
            if (pkgPrefix == null || pkgPrefix.length() == 0) {
                return pkgSuffix;
            }
            if (pkgSuffix == null || pkgSuffix.length() == 0) {
                return pkgPrefix;
            }
            return pkgPrefix + pkgSuffix;
        }
        return JavaUtils.makePackageName(namespace);
    }

    private static boolean isPunctuation(char c) {
        return '-' == c || '.' == c || ':' == c || '\u00b7' == c || '\u0387' == c || '\u06dd' == c || '\u06de' == c;
    }

    public static final String replace(String name, String oldT, String newT) {
        if (name == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(name.length() * 2);
        int len = oldT.length();
        try {
            int start = 0;
            int i = name.indexOf(oldT, start);
            while (i >= 0) {
                sb.append(name.substring(start, i));
                sb.append(newT);
                start = i + len;
                i = name.indexOf(oldT, start);
            }
            if (start < name.length()) {
                sb.append(name.substring(start));
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return new String(sb);
    }

    public static Class getHolderValueType(Class type) {
        if (type != null) {
            Field field;
            Class<?>[] intf = type.getInterfaces();
            boolean isHolder = false;
            for (int i = 0; i < intf.length; ++i) {
                if (intf[i] != (class$javax$xml$rpc$holders$Holder == null ? JavaUtils.class$("javax.xml.rpc.holders.Holder") : class$javax$xml$rpc$holders$Holder)) continue;
                isHolder = true;
            }
            if (!isHolder) {
                return null;
            }
            try {
                field = type.getField("value");
            }
            catch (Exception e) {
                field = null;
            }
            if (field != null) {
                return field.getType();
            }
        }
        return null;
    }

    public static Object getHolderValue(Object holder) throws HolderException {
        if (!(holder instanceof Holder)) {
            throw new HolderException(Messages.getMessage("badHolder00", holder.toString()));
        }
        try {
            Field valueField = holder.getClass().getField("value");
            return valueField.get(holder);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.JavaUtils.getHolderValue", "995");
            throw new HolderException(Messages.getMessage("exception01", e.getMessage()));
        }
    }

    public static void setHolderValue(Object holder, Object value) throws HolderException {
        if (!(holder instanceof Holder)) {
            throw new HolderException(Messages.getMessage("badHolder00", holder.toString()));
        }
        try {
            Field valueField = holder.getClass().getField("value");
            if (valueField.getType().isPrimitive()) {
                if (value != null) {
                    valueField.set(holder, value);
                }
            } else {
                valueField.set(holder, value);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.utils.JavaUtils.setHolderValue", "1020");
            throw new HolderException(Messages.getMessage("exception01", e.getMessage()));
        }
    }

    public static boolean isEnumClass(Class cls) {
        block6: {
            if (JavaUtils._getValueMethod(cls) == null) {
                return false;
            }
            Method m = cls.getMethod("getValue", null);
            Method m2 = cls.getMethod("toString", null);
            Method m3 = cls.getMethod("fromString", String.class);
            if (m == null || m2 == null || m3 == null || cls.getMethod("fromValue", m.getReturnType()) == null) break block6;
            try {
                return cls.getMethod("setValue", m.getReturnType()) == null;
            }
            catch (NoSuchMethodException e) {
                try {
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private static Method _getValueMethod(Class cls) {
        Method getValueMethod = null;
        try {
            Method[] methods = cls.getDeclaredMethods();
            for (int i = 0; i < methods.length && getValueMethod == null; ++i) {
                if (!"getValue".equals(methods[i].getName())) continue;
                getValueMethod = methods[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return getValueMethod;
    }

    public static Object getDetail(Exception userException) {
        if (userException == null) {
            return null;
        }
        try {
            Class helper = ClassUtils.forName(userException.getClass().getName() + "_Helper");
            Method method = helper.getMethod("getDetail", Exception.class);
            return method.invoke(null, userException);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return userException;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        return sw.getBuffer().toString();
    }

    public static final boolean isTrue(String value) {
        return !JavaUtils.isFalseExplicitly(value);
    }

    public static final boolean isTrueExplicitly(String value) {
        if (value == null) {
            return false;
        }
        if (value == "true" || value == "1") {
            return true;
        }
        if (value == "false" || value == "0") {
            return false;
        }
        return value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("yes");
    }

    public static final boolean isTrueExplicitly(Object value, boolean defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Integer) {
            return (Integer)value != 0;
        }
        if (value instanceof String) {
            return JavaUtils.isTrueExplicitly((String)value);
        }
        return true;
    }

    public static final boolean isTrueExplicitly(Object value) {
        return JavaUtils.isTrueExplicitly(value, false);
    }

    public static final boolean isTrue(Object value, boolean defaultVal) {
        return !JavaUtils.isFalseExplicitly(value, !defaultVal);
    }

    public static final boolean isTrue(Object value) {
        return JavaUtils.isTrue(value, false);
    }

    public static final boolean isFalse(String value) {
        return JavaUtils.isFalseExplicitly(value);
    }

    public static final boolean isFalseExplicitly(String value) {
        return value == null || value.equalsIgnoreCase("false") || value.equals("0") || value.equalsIgnoreCase("no");
    }

    public static final boolean isFalseExplicitly(Object value, boolean defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Integer) {
            return (Integer)value == 0;
        }
        if (value instanceof String) {
            return JavaUtils.isFalseExplicitly((String)value);
        }
        return false;
    }

    public static final boolean isFalseExplicitly(Object value) {
        return JavaUtils.isFalseExplicitly(value, true);
    }

    public static final boolean isFalse(Object value, boolean defaultVal) {
        return JavaUtils.isFalseExplicitly(value, defaultVal);
    }

    public static final boolean isFalse(Object value) {
        return JavaUtils.isFalse(value, true);
    }

    public static String mimeToJava(String mime) {
        if ("image/gif".equals(mime) || "image/jpeg".equals(mime)) {
            return "java.awt.Image";
        }
        if ("text/plain".equals(mime)) {
            return "java.lang.String";
        }
        if ("text/xml".equals(mime) || "application/xml".equals(mime)) {
            return "javax.xml.transform.Source";
        }
        if (mime != null && mime.startsWith("multipart/")) {
            return "javax.mail.internet.MimeMultipart";
        }
        return "javax.activation.DataHandler";
    }

    public static synchronized boolean isAttachmentSupported() {
        if (checkForAttachmentSupport) {
            checkForAttachmentSupport = false;
            try {
                ClassUtils.forName("javax.activation.DataHandler");
                ClassUtils.forName("javax.mail.internet.MimeMultipart");
                attachmentSupportEnabled = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("attachEnabled") + "  " + attachmentSupportEnabled);
            }
        }
        return attachmentSupportEnabled;
    }

    public static boolean hasValue(String str) {
        return str != null && str.length() > 0;
    }

    public static String createNonJAXRPCName(String xmlName) {
        StringBuffer newName = new StringBuffer();
        block9: for (int i = 0; i < xmlName.length(); ++i) {
            char chr = xmlName.charAt(i);
            switch (chr) {
                case '-': {
                    newName.append("_hyphen_");
                    continue block9;
                }
                case '.': {
                    newName.append("_period_");
                    continue block9;
                }
                case ':': {
                    newName.append("_colon_");
                    continue block9;
                }
                case '\u00b7': {
                    newName.append("_dot_");
                    continue block9;
                }
                case '\u0387': {
                    newName.append("_anoteleia_");
                    continue block9;
                }
                case '\u06dd': {
                    newName.append("_endofayah_");
                    continue block9;
                }
                case '\u06de': {
                    newName.append("_startofrubelhizb_");
                    continue block9;
                }
                default: {
                    newName.append(chr);
                }
            }
        }
        return newName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getSubString(InputStream is, StringHolder sh, char delimit, String encoding) throws IOException {
        if (!is.markSupported()) {
            byte[] buf = new byte[is.available()];
            is.read(buf);
            sh.value = new String(buf);
            return new ByteArrayInputStream(sh.value.getBytes(encoding));
        }
        try {
            is.mark(0);
            int chunk = 100;
            byte[] buf = new byte[chunk];
            int numBytes = is.read(buf);
            sh.value = "";
            String text = new String(buf);
            while (text.indexOf(delimit) < 0 && numBytes == chunk) {
                sh.value = sh.value + text;
                numBytes = is.read(buf);
                text = new String(buf);
            }
            sh.value = sh.value + text;
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            is.reset();
            throw throwable;
        }
        is.reset();
        return is;
    }

    public static boolean isJDK14() {
        try {
            Class.forName("java.net.URI");
            return true;
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.utils.JavaUtils.isJDK14", "1553");
            return false;
        }
    }

    public static String getObjectIdentity(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    public static int find(byte[] search, byte[] bytes, int start, int end, boolean direction) {
        int idx = -1;
        if (search == null || search.length == 0 || bytes == null || bytes.length == 0 || start < 0 || end < 0) {
            return idx;
        }
        if (direction) {
            for (int i = start; idx < 0 && i <= end; ++i) {
                if (bytes[i] != search[0]) continue;
                boolean found = true;
                for (int i2 = 1; found && i2 < search.length; ++i2) {
                    found = i + i2 > end ? false : bytes[i + i2] == search[i2];
                }
                if (!found) continue;
                idx = i;
            }
        } else {
            for (int i = end; idx < 0 && i >= start; --i) {
                if (bytes[i] != search[0]) continue;
                boolean found = true;
                for (int i2 = 1; found && i2 < search.length; ++i2) {
                    found = i + i2 > end ? false : bytes[i + i2] == search[i2];
                }
                if (!found) continue;
                idx = i;
            }
        }
        return idx;
    }

    public static String convertBytesToString(byte[] bytes, String encoding) {
        String string;
        if (bytes == null) {
            string = null;
        } else if (encoding == null || encoding.length() == 0) {
            string = new String(bytes);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Message character encoding scheme: '" + encoding + "'");
            }
            try {
                string = new String(bytes, encoding);
            }
            catch (UnsupportedEncodingException ue) {
                FFDCFilter.processException((Throwable)ue, "com.ibm.ws.webservices.engine.SOAPPart.convertBytesToString", "1367", null);
                if (log.isDebugEnabled()) {
                    log.debug("Bad Encoding: '" + encoding + "', will ignore encoding");
                }
                string = new String(bytes);
            }
        }
        return string;
    }

    public static byte[] convertStringToBytes(String string, String encoding) {
        byte[] bytes;
        if (string == null) {
            bytes = null;
        } else if (encoding == null || encoding.length() == 0) {
            bytes = string.getBytes();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Message character encoding scheme: '" + encoding + "'");
            }
            try {
                bytes = string.getBytes(encoding);
            }
            catch (UnsupportedEncodingException ue) {
                FFDCFilter.processException((Throwable)ue, "com.ibm.ws.webservices.engine.SOAPPart.convertStringToBytes", "1394", null);
                if (log.isDebugEnabled()) {
                    log.debug("Bad Encoding: '" + encoding + "', will ignore encoding");
                }
                bytes = string.getBytes();
            }
        }
        return bytes;
    }

    public static String stackToDebugString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        text = text.substring(text.indexOf("at"));
        text = JavaUtils.replace(text, "at ", "DEBUG_FRAME = ");
        return text;
    }

    public static int convertStringToInt(String stringIn) {
        return JavaUtils.convertStringToInteger(stringIn);
    }

    public static int convertStringToInt(String stringIn, int defaultIn) {
        Integer defInteger = new Integer(defaultIn);
        return JavaUtils.convertStringToInteger(stringIn, defInteger);
    }

    public static Integer convertStringToInteger(String stringIn) {
        return JavaUtils.convertStringToInteger(stringIn, null);
    }

    public static Integer convertStringToInteger(String stringIn, Integer defaultIn) {
        Integer retValue = defaultIn;
        if (log.isDebugEnabled()) {
            log.debug("convertStringToInteger: stringIn[" + stringIn + "]  defaultIn[" + defaultIn + "]");
        }
        if (!JavaUtils.hasValue(stringIn)) {
            if (defaultIn == null) {
                retValue = new Integer(Integer.MIN_VALUE);
            }
            if (log.isDebugEnabled()) {
                log.debug("convertStringToInteger: stringIn value is missing, set to " + retValue);
            }
            return retValue;
        }
        try {
            retValue = Integer.valueOf(stringIn.trim());
        }
        catch (Throwable tw) {
            if (log.isDebugEnabled()) {
                log.debug("convertStringToInteger: valueOf exception " + tw);
            }
            retValue = defaultIn == null ? new Integer(Integer.MIN_VALUE) : defaultIn;
            return retValue;
        }
        return retValue;
    }

    static {
        loadableMap.put("byte", "B");
        loadableMap.put("char", "C");
        loadableMap.put("double", "D");
        loadableMap.put("float", "F");
        loadableMap.put("int", "I");
        loadableMap.put("long", "J");
        loadableMap.put("short", "S");
        loadableMap.put("boolean", "Z");
        checkForAttachmentSupport = true;
        attachmentSupportEnabled = false;
    }

    public static class HolderException
    extends Exception {
        public HolderException(String msg) {
            super(msg);
        }
    }

    public static interface ConvertCache {
        public void setConvertedValue(Class var1, Object var2);

        public Object getConvertedValue(Class var1);

        public Class getDestClass();
    }
}

