/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;

public final class AttributeUtils {
    public static final QName getTypeFromAttributes(String namespace, String localPart, Attributes attributes, MappingScope mappingScope) {
        QName typeQName = AttributeUtils.getTypeFromXSITypeAttr(attributes, mappingScope);
        if (typeQName == null && Constants.isSOAP_ENC(namespace)) {
            if (namespace.equals("http://www.w3.org/2002/06/soap-encoding")) {
                typeQName = QNameTable.createQName(namespace, localPart);
            } else if (localPart.equals(Constants.SOAP_ARRAY.getLocalPart())) {
                typeQName = Constants.SOAP_ARRAY;
            } else if (localPart.equals(Constants.SOAP_STRING.getLocalPart())) {
                typeQName = Constants.SOAP_STRING;
            } else if (localPart.equals(Constants.SOAP_BOOLEAN.getLocalPart())) {
                typeQName = Constants.SOAP_BOOLEAN;
            } else if (localPart.equals(Constants.SOAP_DOUBLE.getLocalPart())) {
                typeQName = Constants.SOAP_DOUBLE;
            } else if (localPart.equals(Constants.SOAP_FLOAT.getLocalPart())) {
                typeQName = Constants.SOAP_FLOAT;
            } else if (localPart.equals(Constants.SOAP_INT.getLocalPart())) {
                typeQName = Constants.SOAP_INT;
            } else if (localPart.equals(Constants.SOAP_LONG.getLocalPart())) {
                typeQName = Constants.SOAP_LONG;
            } else if (localPart.equals(Constants.SOAP_SHORT.getLocalPart())) {
                typeQName = Constants.SOAP_SHORT;
            } else if (localPart.equals(Constants.SOAP_BYTE.getLocalPart())) {
                typeQName = Constants.SOAP_BYTE;
            }
        }
        return typeQName;
    }

    public static final QName getTypeFromXSITypeAttr(Attributes attributes, MappingScope mappingScope) {
        if (attributes.getLength() == 0) {
            return null;
        }
        String value = Constants.getValue(attributes, Constants.URIS_SCHEMA_XSI, "type");
        if (value != null) {
            return QNameTable.createQName(value, mappingScope);
        }
        return null;
    }

    public static boolean isNil(Attributes attrs) {
        if (attrs.getLength() == 0) {
            return false;
        }
        return JavaUtils.isTrueExplicitly(Constants.getValue(attrs, Constants.QNAMES_NIL, Constants.QNAMES_NIL_ACCEPTABLE));
    }

    public static String getID(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return attributes.getValue("id");
    }

    public static String getHref(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        return attributes.getValue("href");
    }
}

