/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.TransactionSuspender;
import com.ibm.ws.webservices.engine.transport.jms.JMSCacheData;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionCache;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionData;
import com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperBase;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.trace.MessageTrace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.NamingException;
import javax.xml.soap.SOAPException;

public class JMSSenderHelperSPEC
extends JMSSenderHelperBase {
    private static final TraceComponent _tc = Tr.register(JMSSenderHelperSPEC.class, "WebServices", "com.ibm.ws.webservices.engine.resources.engineMessages");
    private static final int defaultRequestTimeout = 300000;
    private boolean isTopic = false;
    private static String msgTypeSystemPropValue = System.getProperty("com.ibm.websphere.webservices.transport.jms.messageType");

    public JMSSenderHelperSPEC() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperSPEC()");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "JMSSenderHelperSPEC()");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(MessageContext msgContext) throws WebServicesFault {
        JMSConnectionData connData = new JMSConnectionData();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperSPEC.invoke()");
        }
        try {
            try {
                this.initialize(msgContext, connData);
                this.sendMessage(msgContext, connData);
            }
            catch (WebServicesFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.JMSSenderHelperSPEC.invoke", "102", this);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSender.JMSSenderHelperSPEC.invoke", "104", this);
                WebServicesFault wsf = WebServicesFault.makeFault(e);
                throw wsf;
            }
            Object var6_3 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "JMSSenderHelperSPEC.invoke()");
            throw throwable;
        }
        Tr.exit(_tc, "JMSSenderHelperSPEC.invoke()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(MessageContext mc, JMSConnectionData connData) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperSPEC.initialize()");
        }
        try {
            try {
                URL targetURL = mc.getTargetEndpointAddressAsURL();
                this.parseURL(connData, targetURL);
                this.getJMSObjects(connData);
            }
            catch (WebServicesFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperSPEC.initialize", "178", this);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperSPEC.initialize", "183", this);
                WebServicesFault wsf = WebServicesFault.makeFault(e);
                throw wsf;
            }
            Object var6_6 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "JMSSenderHelperSPEC.initialize()");
            throw throwable;
        }
        Tr.exit(_tc, "JMSSenderHelperSPEC.initialize()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getJMSObjects(JMSConnectionData cd) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperSPEC.getJMSObjects()");
        }
        try {
            try {
                block15: {
                    try {
                        cd.jndiContext = this.getInitialContext(cd.initialContextFactory, cd.jndiProviderURL);
                    }
                    catch (NamingException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperSPEC.getJMSObjects", "357", this);
                        Tr.error(_tc, "JMS.JNDIError01", e.toString());
                        throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError01", e.toString()), null, null);
                    }
                    try {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Getting : connectionFactoryName: [" + cd.connectionFactoryName + "]");
                        }
                        cd.connectionFactory = (ConnectionFactory)this.getJNDIObject(cd, cd.connectionFactoryName);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Getting destinationName: [" + cd.destinationName + "]");
                        }
                        cd.destination = this.getJNDIObject(cd, cd.destinationName);
                        if (cd.destination instanceof Topic) {
                            this.isTopic = true;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Destination is of type Topic");
                            }
                            break block15;
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Destination is of type Queue");
                        }
                    }
                    catch (NamingException ne) {
                        FFDCFilter.processException((Throwable)ne, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperSPEC.getJMSObjects", "385", this);
                        Tr.error(_tc, "JMS.JNDIError02", ne.toString());
                        throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError02", ne.toString()), null, null);
                    }
                }
                Object var4_5 = null;
                if (!_tc.isEntryEnabled()) return;
            }
            catch (WebServicesFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperSPEC.getJMSObjects", "425", this);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "JMSSenderHelperSPEC.getJMSObjects()");
            throw throwable;
        }
        Tr.exit(_tc, "JMSSenderHelperSPEC.getJMSObjects()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeConnection(JMSConnectionData cd) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperSPEC.closeConnection()");
        }
        try {
            block5: {
                try {
                    if (cd.connection == null) break block5;
                    cd.connection.close();
                }
                catch (JMSException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperSPEC.closeConnection", "562", this);
                    Tr.error(_tc, "JMS.JMSError01", e.toString());
                    throw new WebServicesFault("JMS", Messages.getMessage("JMS.JMSError01", e.toString()), null, null);
                }
            }
            Object var4_2 = null;
            if (!_tc.isEntryEnabled()) return;
            Tr.exit(_tc, "JMSSenderHelperSPEC.closeConnection()");
            return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "JMSSenderHelperSPEC.closeConnection()");
            throw throwable;
        }
    }

    private void cleanUp(JMSConnectionData cd) throws WebServicesFault {
        if (!this.connectionManagementIsDesired()) {
            this.closeConnection(cd);
        } else {
            try {
                if (cd.session != null) {
                    cd.session.close();
                    cd.session = null;
                }
            }
            catch (JMSException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperSPEC.cleanUp", "612", this);
                Tr.error(_tc, "JMS.JMSError01", e.toString());
                throw new WebServicesFault("JMS", Messages.getMessage("JMS.JMSError01", e.toString()), null, null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendMessage(MessageContext msgContext, JMSConnectionData connData) throws WebServicesFault, IOException, SOAPException {
        block87: {
            TransactionSuspender tranSuspender;
            block88: {
                String prq;
                int requestTimeout;
                Integer tTimeToLive;
                Integer tPriority;
                Integer tDeliveryMode;
                boolean isTwoWay;
                OperationDesc oper;
                Object o;
                URL targetURL = msgContext.getTargetEndpointAddressAsURL();
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "JMSSenderHelperSPEC.sendMessage()");
                }
                if ((o = msgContext.getProperty("enableTransactionalOneWay")) != null) {
                    connData.enableTranOneWay = JavaUtils.isTrue(o);
                }
                boolean bl = (oper = msgContext.getOperation()) == null ? true : (isTwoWay = !oper.isOneway());
                if (isTwoWay) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Two way...");
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "One way...");
                }
                if (msgContext.isResponsePath()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Response path. Setting TwoWay to false...");
                    }
                    isTwoWay = false;
                }
                if (isTwoWay && this.isTopic) {
                    Tr.error(_tc, "JMS.NoTwoWay");
                    throw new WebServicesFault("JMS", Messages.getMessage("JMS.NoTwoWay"), null, null);
                }
                tranSuspender = null;
                boolean transactionalSession = false;
                if (!isTwoWay && connData.enableTranOneWay) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Bypassing transaction suspension...");
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Initiating transaction suspension...");
                    }
                    tranSuspender = new TransactionSuspender();
                    tranSuspender.suspendTransaction();
                    transactionalSession = TransactionSuspender.isTxnServiceEnabled();
                }
                Message reqMessage = msgContext.getRequestMessage();
                String user = msgContext.getUsername();
                String password = msgContext.getPassword();
                if (_tc.isDebugEnabled()) {
                    String tpassword;
                    String tuser = user == null || user.length() == 0 ? "<not-specified>" : user;
                    if (password == null || password.length() == 0) {
                        tpassword = "<not-specified>";
                    } else {
                        StringBuffer buf = new StringBuffer();
                        for (int i = 0; i < password.length(); ++i) {
                            buf.append('*');
                        }
                        tpassword = buf.toString();
                    }
                    Tr.debug(_tc, "Userid: " + tuser);
                    Tr.debug(_tc, "Password: " + tpassword);
                }
                if ((tDeliveryMode = (Integer)msgContext.getProperty("deliveryMode")) != null) {
                    connData.deliveryMode = tDeliveryMode;
                }
                if ((tPriority = (Integer)msgContext.getProperty("priority")) != null) {
                    connData.priority = tPriority;
                }
                if ((tTimeToLive = (Integer)msgContext.getProperty("timeToLive")) != null) {
                    connData.timeToLive = tTimeToLive;
                }
                if ((requestTimeout = msgContext.getTimeout() + msgContext.getWriteTimeout()) <= 0) {
                    requestTimeout = 300000;
                }
                if (requestTimeout > 0 && (connData.timeToLive <= 0 || connData.timeToLive > requestTimeout)) {
                    connData.timeToLive = requestTimeout;
                }
                if (tTimeToLive != null) {
                    connData.timeToLive = tTimeToLive;
                }
                if (connData.permanentReplyToQueueJNDI != null && (prq = (String)msgContext.getProperty("JMSReplyQueueJndiName")) != null) {
                    connData.permanentReplyToQueueJNDI = prq;
                }
                if (connData.messageType == 0) {
                    String msgType = null;
                    msgType = (String)msgContext.getProperty("com.ibm.websphere.webservices.transport.jms.messageType");
                    if (!JavaUtils.hasValue(msgType)) {
                        msgType = msgTypeSystemPropValue;
                    }
                    if (JavaUtils.hasValue(msgType)) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Message type obtained from properties: " + msgType);
                        }
                        if (msgType.equalsIgnoreCase("BYTES")) {
                            connData.messageType = 1;
                        } else {
                            if (!msgType.equalsIgnoreCase("TEXT")) throw new IllegalArgumentException();
                            connData.messageType = 2;
                        }
                    }
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Permanent reply queue (stub or client-binding) JNDI name property is " + connData.permanentReplyToQueueJNDI);
                }
                HashMap requestTransportHeaders = null;
                requestTransportHeaders = (HashMap)msgContext.getProperty("com.ibm.websphere.webservices.requestTransportProperties");
                HashMap responseTransportHeaders = null;
                responseTransportHeaders = (HashMap)msgContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties");
                MessageProducer sender = null;
                javax.jms.Message jmsMessage = null;
                ByteArrayOutputStream strm = null;
                String reqContentType = null;
                try {
                    block85: {
                        try {
                            String id;
                            this.getConnectionAndSession(connData, user, password, transactionalSession);
                            sender = connData.session.createProducer((Destination)connData.destination);
                            strm = new ByteArrayOutputStream();
                            if (connData.messageType == 2) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Creating a JMS TextMessage.");
                                }
                                jmsMessage = connData.session.createTextMessage();
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Set 'use base64' property on Message object.");
                                }
                                reqMessage.setProperty("com.ibm.ws.webservices.useBase64EncodingForNonTextualAttachments", Boolean.TRUE);
                                reqContentType = reqMessage.getContentType(msgContext.getSOAPConstants());
                                reqMessage.writeTo(strm, reqContentType);
                                reqMessage.removeAllAttachments();
                                strm.flush();
                                jmsMessage.setText(strm.toString());
                            } else {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Creating a JMS BytesMessage.");
                                }
                                jmsMessage = connData.session.createBytesMessage();
                                reqContentType = reqMessage.getContentType(msgContext.getSOAPConstants());
                                reqMessage.writeTo(strm, reqContentType);
                                reqMessage.removeAllAttachments();
                                strm.flush();
                                ((BytesMessage)jmsMessage).writeBytes(strm.toByteArray());
                            }
                            jmsMessage.setStringProperty("SOAPJMS_contentType", reqContentType);
                            jmsMessage.setStringProperty("SOAPJMS_targetService", connData.targetService);
                            jmsMessage.setStringProperty("SOAPJMS_requestIRI", targetURL.toString());
                            jmsMessage.setStringProperty("SOAPJMS_bindingVersion", "1.0");
                            if (!isTwoWay && connData.enableTranOneWay) {
                                jmsMessage.setStringProperty("enableTransaction", "true");
                            }
                            this.setSoapAction(jmsMessage, msgContext, "SOAPJMS_soapAction");
                            if (requestTransportHeaders != null) {
                                this.setRequestUserTransportProperties(jmsMessage, requestTransportHeaders);
                            }
                            Queue replyQueue = null;
                            String replySelectorID = null;
                            String pr2q = null;
                            if (isTwoWay) {
                                pr2q = this.getPermanentReplyQueueJNDI(connData.permanentReplyToQueueJNDI);
                                if (pr2q != null) {
                                    connData.permanentReplyToQueueJNDI = pr2q;
                                    try {
                                        replyQueue = (Queue)connData.jndiContext.lookup(connData.permanentReplyToQueueJNDI);
                                    }
                                    catch (NamingException ne) {
                                        FFDCFilter.processException((Throwable)ne, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperSPEC.sendMessage", "830", this);
                                        Tr.error(_tc, "JMS.JNDIError02", ne.toString());
                                        throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError02", ne.toString()), null, null);
                                    }
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "Using permanent reply-to queue " + pr2q);
                                    }
                                } else {
                                    replyQueue = connData.session.createTemporaryQueue();
                                }
                                jmsMessage.setJMSReplyTo(replyQueue);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Set the reply-to queue and started the queue connection in preparation for the reply message.");
                                }
                            }
                            if ((id = (String)msgContext.getProperty("asyncCorrelationID")) != null) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "jmsMessage setting correlation id : " + id);
                                }
                                jmsMessage.setJMSCorrelationID(id);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "About to send JMS request message: " + jmsMessage.toString());
                                Tr.debug(_tc, "Message send options:\ndeliveryMode=" + connData.deliveryMode + ", priority=" + connData.priority + ", timeToLive=" + connData.timeToLive);
                            }
                            if (MessageTrace.isTraceEnabled()) {
                                MessageTrace.log(MessageTrace.OUTBOUND_JMS_REQUEST, reqContentType, strm.toByteArray());
                            }
                            String requestMessageId = null;
                            sender.send(jmsMessage, connData.deliveryMode, connData.priority, connData.timeToLive);
                            requestMessageId = jmsMessage.getJMSMessageID();
                            if (transactionalSession) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "About to commit Session (send)");
                                }
                                connData.session.commit();
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Sent the message, messageID=" + requestMessageId);
                            }
                            if (replyQueue == null) break block85;
                            if (pr2q != null) {
                                replySelectorID = "JMSCorrelationID = '" + requestMessageId + "'";
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "About to create queue receiver with selector " + replySelectorID + " and receive response message, requestTimeout=" + requestTimeout + "ms.");
                            }
                            javax.jms.Message replyMsg = null;
                            MessageConsumer queueRcvr = null;
                            queueRcvr = connData.session.createConsumer(replyQueue, replySelectorID);
                            replyMsg = queueRcvr.receive(requestTimeout);
                            if (replyMsg == null) {
                                Tr.error(_tc, "JMS.RequestTimeOut");
                                throw new WebServicesFault(Messages.getMessage("JMS.RequestTimeOut"));
                            }
                            if (MessageTrace.isTraceEnabled()) {
                                Tr.debug(_tc, "Received JMS response message:\n" + replyMsg.toString());
                            }
                            if (transactionalSession) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "About to commit Session (receive)");
                                }
                                connData.session.commit();
                            }
                            String replyCorrelationId = replyMsg.getJMSCorrelationID();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Reply message contains correlation id: " + replyCorrelationId);
                            }
                            if (replyCorrelationId == null || !replyCorrelationId.equals(requestMessageId)) {
                                Tr.error(_tc, "JMS.MismatchedReply");
                                throw new WebServicesFault(Messages.getMessage("JMS.MismatchedReply"));
                            }
                            String contentType = replyMsg.getStringProperty("SOAPJMS_contentType");
                            contentType = contentType == null ? null : contentType.trim();
                            Message responseMsg = null;
                            if (replyMsg instanceof BytesMessage) {
                                ByteArrayOutputStream ostrm = new ByteArrayOutputStream();
                                byte[] chunk = new byte[4096];
                                int numBytes = 1;
                                while (numBytes > 0) {
                                    numBytes = ((BytesMessage)replyMsg).readBytes(chunk);
                                    if (numBytes <= 0) continue;
                                    ostrm.write(chunk, 0, numBytes);
                                }
                                ostrm.flush();
                                if (MessageTrace.isTraceEnabled()) {
                                    MessageTrace.log(MessageTrace.INBOUND_JMS_RESPONSE, contentType, ostrm.toByteArray());
                                }
                                ByteArrayInputStream istrm = new ByteArrayInputStream(ostrm.toByteArray());
                                responseMsg = new Message((Object)istrm, contentType, null);
                                msgContext.setResponseMessage(responseMsg);
                            } else {
                                if (!(replyMsg instanceof TextMessage)) {
                                    Tr.error(_tc, "JMS.InvalidReplyMsgType");
                                    throw new WebServicesFault(Messages.getMessage("JMS.InvalidReplyMsgType"));
                                }
                                String replyString = ((TextMessage)replyMsg).getText();
                                if (MessageTrace.isTraceEnabled()) {
                                    MessageTrace.log(MessageTrace.INBOUND_JMS_RESPONSE, contentType, replyString.getBytes());
                                }
                                responseMsg = new Message((Object)replyString, contentType, null);
                                msgContext.setResponseMessage(responseMsg);
                            }
                            if (responseTransportHeaders != null) {
                                this.getResponseUserTransportProperties(responseTransportHeaders, replyMsg);
                            }
                        }
                        catch (JMSException je) {
                            StringBuffer exceptionInfo;
                            block86: {
                                FFDCFilter.processException((Throwable)je, "com.ibm.ws.webservices.engine.transport.jms.JMSSenderHelperSPEC.sendMessage", "968", this);
                                exceptionInfo = new StringBuffer();
                                exceptionInfo.append(Messages.getMessage("JMS.JMSError01", je.toString()));
                                Exception e = je.getLinkedException();
                                while (e != null) {
                                    exceptionInfo.append("\n");
                                    exceptionInfo.append(Messages.getMessage("JMS.JMSError02", e.toString()));
                                    if (e instanceof JMSException) {
                                        e = ((JMSException)e).getLinkedException();
                                        continue;
                                    }
                                    e = null;
                                }
                                if (transactionalSession) {
                                    try {
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "Doing rollback of session due to JMSException.");
                                        }
                                        if (connData.session != null) {
                                            connData.session.rollback();
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "Rolled back session.");
                                            }
                                        }
                                        if (connData.queueSession != null) {
                                            connData.queueSession.rollback();
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "Rolled back queue session.");
                                            }
                                        }
                                        if (connData.topicSession == null) break block86;
                                        connData.topicSession.rollback();
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "Rolled back topic session.");
                                        }
                                    }
                                    catch (Throwable t) {
                                        if (!_tc.isDebugEnabled()) break block86;
                                        Tr.debug(_tc, "Session rollback failed with exception: " + t.toString());
                                    }
                                }
                            }
                            Tr.error(_tc, exceptionInfo.toString());
                            if (!_tc.isDebugEnabled()) throw new WebServicesFault("JMS", exceptionInfo.toString(), null, null);
                            Tr.debug(_tc, exceptionInfo.toString());
                            throw new WebServicesFault("JMS", exceptionInfo.toString(), null, null);
                        }
                    }
                    Object var36_42 = null;
                    if (tranSuspender == null) break block87;
                    if (!_tc.isDebugEnabled()) break block88;
                }
                catch (Throwable throwable) {
                    Object var36_43 = null;
                    if (tranSuspender != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Initiating transaction resumption...");
                        }
                        tranSuspender.resumeTransaction();
                    }
                    this.cleanUp(connData);
                    if (!_tc.isEntryEnabled()) throw throwable;
                    Tr.exit(_tc, "JMSSenderHelperSPEC.sendMessage()");
                    throw throwable;
                }
                Tr.debug(_tc, "Initiating transaction resumption...");
            }
            tranSuspender.resumeTransaction();
        }
        this.cleanUp(connData);
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "JMSSenderHelperSPEC.sendMessage()");
    }

    private void createConnection(JMSConnectionData cd, String user, String password) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperSPEC.createConnection()");
        }
        if (user != null && user.length() != 0 && password != null && password.length() != 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating connection with user [" + user + "] and password.");
            }
            cd.connection = cd.connectionFactory.createConnection(user, password);
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating connection without user/password.");
            }
            cd.connection = cd.connectionFactory.createConnection();
        }
        if (cd.connection != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Starting Connection...");
            }
            cd.connection.start();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "JMSSenderHelperSPEC.createConnection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConnectionAndSession(JMSConnectionData cd, String user, String password, boolean transactionalSession) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSSenderHelperSPEC.getConnectionAndSession()");
        }
        cd.connection = null;
        cd.session = null;
        if (!this.connectionManagementIsDesired()) {
            this.createConnection(cd, user, password);
        } else {
            JMSConnectionCache jMSConnectionCache = this.activeConnections;
            synchronized (jMSConnectionCache) {
                JMSCacheData cData;
                String key = this.getKey(cd, user);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for connection in cache, key=[" + key + "].");
                }
                if ((cData = this.activeConnections.get(key)) != null) {
                    cd.connection = cData.getConnection();
                }
                if (cd.connection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Connection found: " + cd.connection.toString());
                    }
                    try {
                        cd.session = cd.connection.createSession(transactionalSession, 1);
                    }
                    catch (JMSException e) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "createSession threw JMSException, must create fresh Connection.");
                        }
                        cd.connection.close();
                        cd.connection = null;
                        cd.session = null;
                    }
                }
                if (cd.connection == null) {
                    this.createConnection(cd, user, password);
                    this.activeConnections.put(key, cd.connection);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Connection added to cache, key=[" + this.getKey(cd, user) + "].");
                    }
                }
            }
        }
        if (cd.session == null) {
            cd.session = cd.connection.createSession(transactionalSession, 1);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "JMSSenderHelperSPEC.getConnectionAndSession()");
        }
    }
}

