/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.transport.Connection;
import com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.ws.webservices.utils.JavaUtils;
import java.security.PrivilegedAction;

public class OneWayConnection
extends Connection {
    private static final TraceComponent _tc = Tr.register(OneWayConnection.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");

    public OneWayConnection(WSOutboundConnection conn, long time) {
        this.connection = conn;
        this.recycleTime = time;
        this.oCache = (OutboundConnectionCache)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return OutboundConnectionCache.getInstance();
            }
        });
    }

    public void resetConnection() {
        block6: {
            try {
                if (this.connection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "OneWayConnection.resetConnection(). Connection Reset invoked for connection : " + this.connection);
                    }
                    this.connection.reset();
                    this.oCache.findGroupAndReturnConnection(this.connection);
                    this.connection = null;
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "OneWayConnection.resetConnection(). Connection is null");
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.OneWayConnection.resetConnection", "90", this);
                if (!_tc.isDebugEnabled()) break block6;
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
            }
        }
    }

    public void disconnectConnection() {
        block6: {
            try {
                if (this.connection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "OneWayConnection.disconnectConnection(). Connection Disconnect invoked for connection : " + this.connection);
                    }
                    this.connection.disconnect(null);
                    this.oCache.findGroupAndReturnConnection(this.connection);
                    this.connection = null;
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "OneWayConnection.disconnectConnection(). Connection is null");
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.OneWayConnection.disconnectConnection", "119", this);
                if (!_tc.isDebugEnabled()) break block6;
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
            }
        }
    }
}

