/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.net.TransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;

public class HttpChannelAddress
extends WSAddress {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register(HttpChannelAddress.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private InetSocketAddress isAddr = null;
    private String targetEndpoint = null;
    private String endpointHost = null;
    private int endpointPort = -1;
    private String targetURIPath = null;
    private String targetHost = null;
    private int targetPort = -1;
    private TransportClientProperties _tcp = null;
    private boolean forProxy = false;
    private URI _uri = null;
    private static final String PROXY_AUTH_INFO = "PROXY_TARGET_USER_PASS";
    private static final String PROXY_HOST_INFO = "PROXY_TARGET_HOST_PORT";
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String DEFAULT_HTTPS_PORT_STRING = "443";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final String DEFAULT_HTTP_PORT_STRING = "80";
    public static final String HTTPCHAN_MATCH_LOG_PROP = "com.ibm.ws.webservices.match.log";

    public HttpChannelAddress(URL url) throws URISyntaxException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpChannelAddress::HttpChannelAddress(url=" + url.toString() + ")");
        }
        if (url != null) {
            this.targetEndpoint = url.toString();
            this.endpointHost = url.getHost();
            this.endpointPort = url.getPort();
            URI urI = new URI(this.targetEndpoint);
            this.targetURIPath = urI.getPath();
            this.targetHost = url.getHost();
            this.targetPort = url.getPort();
            if (url.getProtocol().compareToIgnoreCase("https") == 0) {
                this.schemaType = 2;
                if (this.targetPort == -1) {
                    this.targetPort = 443;
                }
            } else if (url.getProtocol().compareToIgnoreCase("http") == 0) {
                this.schemaType = 1;
                if (this.targetPort == -1) {
                    this.targetPort = 80;
                }
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "connHost " + this.targetHost + " connPort " + this.targetPort);
            }
            this.isAddr = new InetSocketAddress(this.targetHost, this.targetPort);
            this._tcp = TransportClientPropertiesFactory.create(this.getSchemaInString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HttpChannelAddress::HttpChannelAddress(url=" + url.toString() + ")");
        }
    }

    public HttpChannelAddress(URL actualurl, TransportClientProperties tcp) throws URISyntaxException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpChannelAddress::HttpChannelAddress(url=" + actualurl.toString() + ", tcp)");
        }
        if (actualurl != null && tcp != null) {
            this.targetEndpoint = actualurl.toString();
            this.endpointHost = actualurl.getHost();
            this.endpointPort = actualurl.getPort();
            this.targetHost = tcp.getProxyHost();
            this.targetPort = Integer.valueOf(tcp.getProxyPort());
            if (actualurl.getProtocol().compareToIgnoreCase("https") == 0) {
                this.schemaType = 2;
                if (this.targetPort == -1) {
                    this.targetPort = 443;
                }
            } else if (actualurl.getProtocol().compareToIgnoreCase("http") == 0) {
                this.schemaType = 1;
                if (this.targetPort == -1) {
                    this.targetPort = 80;
                }
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Proxy connHost " + this.targetHost + " Proxy connPort " + this.targetPort);
            }
            this.isAddr = new InetSocketAddress(this.targetHost, this.targetPort);
            URI urI = new URI(this.getSchemaInString() + "://" + this.targetHost + ":" + this.targetPort);
            this.targetURIPath = urI.getPath();
            this._tcp = TransportClientPropertiesFactory.create(this.getSchemaInString());
        }
        this.forProxy = true;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HttpChannelAddress::HttpChannelAddress(url=" + actualurl.toString() + ", tcp)");
        }
    }

    public String getOutboundChainName() {
        if (this.getSchema() == 1) {
            return "HttpOutboundChain";
        }
        return "HttpsOutboundChain";
    }

    public HashMap infoForTunneling() throws MalformedURLException {
        HashMap<String, byte[]> hM = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpChannelAddress::infoForTunneling()");
        }
        if (this.forProxy && this._tcp != null) {
            String id = this._tcp.getProxyUser();
            String pwd = this._tcp.getProxyPassword();
            URL urL = new URL(this.targetEndpoint);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "targetEndpoint " + this.targetEndpoint);
            }
            String connHost = urL.getHost();
            String connPort = String.valueOf(urL.getPort());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "connHost " + connHost + " connPort " + connPort);
            }
            if (JavaUtils.hasValue(connHost) && JavaUtils.hasValue(connPort)) {
                hM = new HashMap<String, byte[]>();
                if (Integer.valueOf(connPort) == -1 && this.schemaType == 1) {
                    connPort = DEFAULT_HTTP_PORT_STRING;
                }
                if (Integer.valueOf(connPort) == -1 && this.schemaType == 2) {
                    connPort = DEFAULT_HTTPS_PORT_STRING;
                }
                hM.put(PROXY_HOST_INFO, (connHost + ":" + connPort).getBytes());
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "hM " + hM);
                }
                if (JavaUtils.hasValue(id) && JavaUtils.hasValue(pwd)) {
                    hM.put(PROXY_AUTH_INFO, XMLUtils.base64encode((id + ":" + pwd).getBytes()).getBytes());
                }
            }
            if (_tc.isDebugEnabled()) {
                String protocol = null;
                protocol = this.schemaType == 1 ? "HTTP" : "HTTPS";
                String msg = "Configured " + protocol + " proxy information. " + protocol + " Proxy Hostname: " + this.targetHost + " Proxy Port: " + String.valueOf(this.targetPort) + " Proxy Username: " + id + " Proxy Password: " + (JavaUtils.hasValue(pwd) ? "******" : "");
                Tr.debug(_tc, msg);
                Tr.debug(_tc, "Target endpoint host: " + connHost + ", Target endpoint port: " + connPort);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HttpChannelAddress::infoForTunneling()");
        }
        return hM;
    }

    public boolean isForwardProxy() {
        return this.schemaType == 1 ? this.isProxy() : false;
    }

    public boolean isProxy() {
        return this.forProxy;
    }

    public String keyValueforPool() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpChannelAddress::keyValueforPool()");
        }
        if (this.keyforPool == null) {
            if (this.getSchema() == 2) {
                if (!this.isProxy()) {
                    this.keyforPool = this.getOutboundChainName() + ":" + this.getHostname() + ":" + this.getPort() + ":" + this.cfg.hashCode();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "keyValueforPool.keyforPool (!this.isProxy()): " + this.keyforPool);
                    }
                } else {
                    this.keyforPool = this.getOutboundChainName() + ":" + this.getHostname() + ":" + this.getPort() + ":" + this.cfg.hashCode() + ":" + this.endpointHost + ":" + this.endpointPort;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "keyValueforPool.keyforPool (this.isProxy()): " + this.keyforPool);
                    }
                }
            } else {
                this.keyforPool = this.getOutboundChainName() + ":" + this.getHostname() + ":" + this.getPort();
            }
            if (this.isInProcess()) {
                this.keyforPool = "LOCAL:" + this.keyforPool;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HttpChannelAddress::keyValueforPool.keyforPool (final): " + this.keyforPool);
        }
        return this.keyforPool;
    }

    public InetSocketAddress getLocalAddress() {
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.isAddr;
    }

    public String getHostname() {
        return this.targetHost;
    }

    public URI getURI() throws URISyntaxException {
        if (this._uri == null && JavaUtils.hasValue(this.targetEndpoint)) {
            this._uri = new URI(this.targetEndpoint);
        }
        return this._uri;
    }

    public String getURIPath() throws URISyntaxException {
        if (this.targetURIPath == null && this.getURI() != null) {
            this.targetURIPath = this.getURI().getPath();
        }
        return this.targetURIPath;
    }

    public int getPort() {
        return this.targetPort;
    }

    public String toString() {
        if (this.forProxy) {
            return this.getSchemaInString() + "://" + this.getHostname() + ":" + String.valueOf(this.getPort());
        }
        return this.targetEndpoint;
    }

    public boolean equals(Object obj) {
        HttpChannelAddress haddr = (HttpChannelAddress)obj;
        if (!this.targetHost.equals(haddr.getHostname())) {
            return false;
        }
        if (this.targetPort != haddr.getPort()) {
            return false;
        }
        try {
            if (!this.targetURIPath.equals(haddr.getURIPath())) {
                return false;
            }
        }
        catch (URISyntaxException uSe) {
            return false;
        }
        return this.targetEndpoint.equals(haddr.getTargetEndPoint());
    }

    public String getTargetEndPoint() {
        return this.targetEndpoint;
    }

    public void updateTargetURL(String newURL) {
        this.targetEndpoint = newURL;
    }

    public void setConnectTimeout(int value) {
        this.connTimeout = value;
    }

    public TransportClientProperties getTCproperties() {
        return this._tcp;
    }

    public static WSAddress getProxyAddress(URL targetURL, TransportClientProperties tcp) throws MalformedURLException, URISyntaxException, WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpChannelAddress::getProxyAddress(" + targetURL + ", " + tcp + " ,");
        }
        HttpChannelAddress retAddr = null;
        if (HttpChannelAddress.hostIsInNonProxyList(targetURL.getHost(), tcp.getNonProxyHosts())) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, targetURL.getHost() + " is in the non proxy hosts list");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "HttpChannelAddress::getProxyAddress: " + retAddr);
            }
            return retAddr;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, targetURL.getHost() + " is NOT in the non proxy hosts list");
        }
        if (targetURL.getProtocol().equalsIgnoreCase("https")) {
            if (JavaUtils.hasValue(tcp.getProxyHost()) && JavaUtils.hasValue(tcp.getProxyPort())) {
                retAddr = new HttpChannelAddress(targetURL, tcp);
            }
        } else if (targetURL.getProtocol().equalsIgnoreCase("http")) {
            if (JavaUtils.hasValue(tcp.getProxyHost()) && JavaUtils.hasValue(tcp.getProxyPort())) {
                retAddr = new HttpChannelAddress(targetURL, tcp);
            }
        } else {
            throw new WebServicesFault(Messages.getMessage("httpUnsupportedSchema", targetURL.getProtocol()));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HttpChannelAddress::getProxyAddress: " + retAddr);
        }
        return retAddr;
    }

    private static boolean hostIsInNonProxyList(String host, String nonProxyHosts) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpChannelAddress::hostIsInNonProxyList: " + host + " " + nonProxyHosts);
        }
        if (nonProxyHosts == null || host == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "HttpChannelAddress::hostIsInNonProxyList: false");
            }
            return false;
        }
        boolean traceMatch = false;
        if (_tc.isDebugEnabled()) {
            String traceMatchStr = System.getProperty(HTTPCHAN_MATCH_LOG_PROP);
            if ("true".equals(traceMatchStr)) {
                traceMatch = true;
            } else {
                Tr.debug(_tc, "To trace the flow of the HttpChannelAddress.match() method, set the com.ibm.ws.webservices.match.log=true JVM System property.");
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|\"");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (!HttpChannelAddress.match(pattern, host, false, traceMatch)) continue;
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "HttpChannelAddress::hostIsInNonProxyList: " + Messages.getMessage("match00", new String[]{"HttpChannelAddress", host, pattern}));
            }
            return true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HttpChannelAddress::hostIsInNonProxyList: Host not in nonProxyHosts list");
        }
        return false;
    }

    private static boolean match(String pattern, String str, boolean isCaseSensitive, boolean traceMatch) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        if (traceMatch && _tc.isEntryEnabled()) {
            Tr.entry(_tc, "match: pattern=" + pattern + " str=" + str + " isCaseSensitive=" + isCaseSensitive);
        }
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                if (traceMatch && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. Pattern and string are not the same size");
                }
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (isCaseSensitive && ch2 != strArr[i]) {
                    if (traceMatch && _tc.isEntryEnabled()) {
                        Tr.exit(_tc, "match: Returning false. Case sensitive character mismatch");
                    }
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(strArr[i])) continue;
                if (traceMatch && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. Case insensitive character mismatch");
                }
                return false;
            }
            if (traceMatch && _tc.isEntryEnabled()) {
                Tr.exit(_tc, "match: Returning true.  Pattern matches.");
            }
            return true;
        }
        if (patIdxEnd == 0) {
            if (traceMatch && _tc.isEntryEnabled()) {
                Tr.exit(_tc, "match: Returning true.  Pattern contains only star.");
            }
            return true;
        }
        if (traceMatch && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "match: Processing chars before first star");
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                if (traceMatch && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. Case sensitive character mismatch with chars before first star.");
                }
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                if (traceMatch && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. Case insensitive character mismatch with chars before first star.");
                }
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                if (traceMatch && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. All characters in the string are used, non-stars left in pattern (1).");
                }
                return false;
            }
            if (traceMatch && _tc.isEntryEnabled()) {
                Tr.exit(_tc, "match: Returning true. All characters in the string are used, only-stars left in pattern (1).");
            }
            return true;
        }
        if (traceMatch && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "match: Processing chars after last star");
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                if (traceMatch && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. Case sensitive character mismatch with chars after last star.");
                }
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                if (traceMatch && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. Case insensitive character mismatch with chars after last star.");
                }
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                if (traceMatch && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false. All characters in the string are used, non-stars left in pattern (2).");
                }
                return false;
            }
            if (traceMatch && _tc.isEntryEnabled()) {
                Tr.exit(_tc, "match: Returning true. All characters in the string are used, only-stars left in pattern (2).");
            }
            return true;
        }
        if (traceMatch && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "match: Processing between stars");
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (isCaseSensitive && ch != strArr[strIdxStart + i3 + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i3 + j])) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                if (traceMatch && _tc.isEntryEnabled()) {
                    Tr.exit(_tc, "match: Returning false");
                }
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            if (traceMatch && _tc.isEntryEnabled()) {
                Tr.exit(_tc, "match: Returning false. All characters in the string are used, non-stars left in pattern (3).");
            }
            return false;
        }
        if (traceMatch && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "match: Returning true. All characters in the string are used, only-stars left in pattern (3).");
        }
        return true;
    }
}

