/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.session.SessionContext;
import com.ibm.ws.webservices.engine.transport.http.CookieValueList;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HTTPCookieManager
implements SessionContext {
    private static final TraceComponent _tc = Tr.register(HTTPCookieManager.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private HashMap chM = null;
    private CookieValueList cvs = null;

    public HTTPCookieManager() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPCookieManager ctor()");
        }
        this.chM = new HashMap();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPCookieManager ctor() this : " + this);
        }
    }

    public HTTPCookieManager(String cookie, String cookie2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HTTPCookieManager ctor()");
        }
        this.chM = new HashMap();
        this.setCookies(cookie, cookie2);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "HTTPCookieManager ctor() this : " + this);
        }
    }

    public static boolean newCookieHandling() {
        boolean result = false;
        String sysProp = System.getProperty("UseNewCookieHandling");
        if (sysProp != null) {
            result = Boolean.valueOf(sysProp);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "System property value of UseNewCookieHandling: " + sysProp);
            }
        }
        return result;
    }

    public void setCookies(String cookie, String cookie2, String reqPath) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setCookies this : " + this);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, HTTPConstants.HEADER_SET_COOKIE + " : " + cookie + "  " + HTTPConstants.HEADER_SET_COOKIE2 + " : " + cookie2);
            Tr.debug(_tc, "ReqPath = " + reqPath);
        }
        if (JavaUtils.hasValue(cookie)) {
            this.parseCookieAndStore(HTTPConstants.HEADER_SET_COOKIE, reqPath, cookie);
        }
        if (JavaUtils.hasValue(cookie2)) {
            this.parseCookieAndStore(HTTPConstants.HEADER_SET_COOKIE2, reqPath, cookie2);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Stored cookie LIST " + this.printCookieSet());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setCookies");
        }
    }

    public void setCookies(String cookie, String cookie2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "start deprecated setCookies this : " + this);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, HTTPConstants.HEADER_SET_COOKIE + " : " + cookie + "  " + HTTPConstants.HEADER_SET_COOKIE2 + " : " + cookie2);
        }
        if (JavaUtils.hasValue(cookie)) {
            this.parseCookieAndStore(HTTPConstants.HEADER_SET_COOKIE, null, cookie);
        }
        if (JavaUtils.hasValue(cookie2)) {
            this.parseCookieAndStore(HTTPConstants.HEADER_SET_COOKIE2, null, cookie2);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Stored cookie LIST " + this.printCookieSet());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "end deprecated set Cookies");
        }
    }

    public String getCookie(String path, String domain, int port, boolean secure) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCookie() this : " + this);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Stored cookie LIST " + this.printCookieSet());
        }
        StringBuffer token = new StringBuffer();
        Set HostKeys = this.chM.keySet();
        Iterator It = HostKeys.iterator();
        token.append("$Version=\"1\";");
        while (It.hasNext()) {
            String HostNow = (String)It.next();
            CookieValueList cvs = (CookieValueList)this.chM.get(HostNow);
            token.append(cvs.getList(path, domain, port, secure));
        }
        String result = token.toString().substring(0, token.length() - 1);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCookie() : " + result);
        }
        return result;
    }

    public String printCookieSet() {
        StringBuffer sb = new StringBuffer();
        sb.append("");
        Set keys = this.chM.keySet();
        Iterator It = keys.iterator();
        while (It.hasNext()) {
            String key = (String)It.next();
            CookieValueList cvs = (CookieValueList)this.chM.get(key);
            sb.append("{property=" + key + " cookieValueList={[");
            sb.append(cvs.printList());
            sb.append("]} ");
        }
        return sb.toString();
    }

    protected List splitMultipleCookies(String header) {
        ArrayList<String> cookies = new ArrayList<String>();
        int Count = 0;
        int b = 0;
        for (int a = 0; a < header.length(); ++a) {
            char ch = header.charAt(a);
            if (ch == '\"') {
                ++Count;
            }
            if (ch != ',' || Count % 2 != 0) continue;
            cookies.add(header.substring(b, a));
            b = a + 1;
        }
        cookies.add(header.substring(b));
        return cookies;
    }

    private void parseCookieAndStore(String cookieHTTPName, String requestPath, String cookie) {
        block23: {
            try {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "parseCookieAndStore() this : " + this);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "cookieHTTPName= " + cookieHTTPName);
                    Tr.debug(_tc, "requestpath= " + requestPath);
                    Tr.debug(_tc, "cookie= " + cookie);
                }
                if (cookie != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "cookie Received : " + cookie);
                    }
                    List cookies = this.splitMultipleCookies(cookie);
                    for (int i = 0; i < cookies.size(); ++i) {
                        String aCookie = (String)cookies.get(i);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, " Cookie " + i + " is: " + aCookie);
                        }
                        String propertyValue = null;
                        String attributes = null;
                        String property = null;
                        String value = null;
                        int separator = aCookie.indexOf(HTTPConstants.ATTR_TOKEN_SEPARATOR);
                        if (separator < 0) {
                            propertyValue = aCookie.trim();
                        } else {
                            propertyValue = aCookie.substring(0, separator).trim();
                            if (separator + 1 < aCookie.length() && (attributes = aCookie.substring(separator + 1).trim()).length() == 0) {
                                attributes = null;
                            }
                        }
                        if (propertyValue != null) {
                            int pvSeparator = propertyValue.indexOf(HTTPConstants.ATTR_VALUE_SEPARATOR);
                            if (pvSeparator < 0) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "  The Cookie's PropertyValue is not correct.  It is missing a " + HTTPConstants.ATTR_VALUE_SEPARATOR);
                                    Tr.debug(_tc, "  The Cookie is ignored. ");
                                }
                            } else {
                                property = propertyValue.substring(0, pvSeparator).trim();
                                value = propertyValue.substring(pvSeparator + 1).trim();
                            }
                        } else if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "  The Cookie's PropertyValue is null. The Cookie is ignored. ");
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "  The PropertyValue is: " + propertyValue);
                            Tr.debug(_tc, "  The Property is:      " + property);
                            Tr.debug(_tc, "  The Value is:         " + value);
                            Tr.debug(_tc, "  The Attributes are:   " + attributes);
                        }
                        if (property == null) continue;
                        this.cvs = null;
                        if (this.chM != null) {
                            Set HostKeys = this.chM.keySet();
                            Iterator It = HostKeys.iterator();
                            while (It.hasNext()) {
                                String HostNow = (String)It.next();
                                if (property.compareTo(HostNow) != 0) continue;
                                this.cvs = (CookieValueList)this.chM.get(HostNow);
                                if (!_tc.isDebugEnabled()) break;
                                Tr.debug(_tc, "   Found an existing CookieValueList with the same name as " + property + " : " + this.cvs);
                                break;
                            }
                        }
                        if (this.cvs == null) {
                            this.cvs = new CookieValueList(cookieHTTPName);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "   Created a " + cookieHTTPName + " CookieValueList for " + property + " : " + this.cvs);
                            }
                        }
                        this.cvs.setCookieNameValuePath(property, value, requestPath);
                        this.cvs.setCookie(attributes);
                        this.chM.put(property, this.cvs);
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.debug(_tc, "Stored cookie");
                    }
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.transport.http.HTTPCookieManager.parseCookieAndStore", "368", this);
                if (!_tc.isDebugEnabled()) break block23;
                Tr.debug(_tc, "Exception occurred during parseCookieAndStore.  Processing continues without this cookie information. ", t);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseCookieAndStore()");
        }
    }
}

