/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.transport.http.CookieComparator;
import com.ibm.ws.webservices.engine.transport.http.CookieValueItem;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import java.util.Iterator;
import java.util.TreeSet;

public class CookieValueList {
    private static final TraceComponent _tc = Tr.register(CookieValueList.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private String cookieName = null;
    private String cookieValue = null;
    private String requestPath = null;
    private TreeSet cookieTree = null;
    private String cookie_name = null;
    private CookieValueItem CV = null;

    public CookieValueList(String name) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Cookie is : " + name);
        }
        this.cookie_name = name;
        this.cookieTree = new TreeSet(new CookieComparator());
    }

    public void setCookieNameValuePath(String name, String value, String reqPath) {
        this.cookieName = name;
        this.cookieValue = value;
        this.requestPath = reqPath;
    }

    public void setCookie(String cookie) {
        if (_tc.isDebugEnabled()) {
            Tr.entry(_tc, "setCookie");
        }
        if (cookie != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, this.cookieName + HTTPConstants.ATTR_VALUE_SEPARATOR + this.cookieValue + " Attributes : " + cookie);
            }
            this.CV = new CookieValueItem(this.cookie_name, this.requestPath);
            this.CV.setCookieValue(this.cookieValue);
            boolean cookieOK = this.CV.setCookie(cookie);
            if (cookieOK) {
                if (this.cookie_name == HTTPConstants.HEADER_SET_COOKIE2 && this.CV.getVersion() != null) {
                    this.checkList(this.CV);
                    this.cookieTree.add(this.CV);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Added cookie");
                    }
                } else if (this.cookie_name == HTTPConstants.HEADER_SET_COOKIE) {
                    this.checkList(this.CV);
                    this.cookieTree.add(this.CV);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Added cookie");
                    }
                }
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.exit(_tc, "setCookie");
        }
    }

    private void checkList(CookieValueItem CV) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkList");
        }
        String path = CV.getPath();
        String domain = CV.getDomain();
        String storedPath = null;
        String storedDomain = null;
        Iterator iT = this.cookieTree.iterator();
        while (iT.hasNext()) {
            CookieValueItem CVstored = (CookieValueItem)iT.next();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Stored cookie : " + this.cookieName + HTTPConstants.ATTR_VALUE_SEPARATOR + CVstored.printList());
            }
            storedPath = CVstored.getPath();
            storedPath = this.stripPath(storedPath);
            path = this.stripPath(path);
            storedDomain = CVstored.getDomain();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Stored cookie path : " + storedPath + ". Received cookie path : " + path);
            }
            if (storedPath == null || path == null || !path.equals(storedPath)) continue;
            if (storedDomain == null && domain == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Path match : " + storedPath + ". Removing old cookie");
                }
                this.cookieTree.remove(CVstored);
                break;
            }
            if (CV.doesDomainMatch(domain, storedDomain)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Path : " + storedPath + " and Domain :  " + storedDomain + " match. Removing old cookie");
                }
                this.cookieTree.remove(CVstored);
                break;
            }
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "Domains don't match. Not removing old cookie");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkList");
        }
    }

    public String printList() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.cookie_name + " ");
        Iterator iT = this.cookieTree.iterator();
        while (iT.hasNext()) {
            CookieValueItem CV = (CookieValueItem)iT.next();
            sb.append("(path=" + CV.getPath() + " ");
            sb.append(this.cookieName + HTTPConstants.ATTR_VALUE_SEPARATOR);
            sb.append(CV.printList() + HTTPConstants.HEADER_TOKEN_SEPARATOR);
            sb.append(")");
        }
        return sb.toString();
    }

    public String getList(String path, String domain, int port, boolean secure) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getList path : " + path);
        }
        StringBuffer token = new StringBuffer();
        Iterator iT = this.cookieTree.iterator();
        boolean gotIt = false;
        while (iT.hasNext()) {
            String value;
            CookieValueItem CV = (CookieValueItem)iT.next();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Cookie Name : " + CV.getName() + " Stored cookie : " + this.cookieName + HTTPConstants.ATTR_VALUE_SEPARATOR + CV.printList());
            }
            if (CV.hasExpired()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Cookie has expired removing it : " + this.cookieName + HTTPConstants.ATTR_VALUE_SEPARATOR + CV.getList(domain, port, secure));
                }
                iT.remove();
                continue;
            }
            String storedPath = CV.getPath();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Path : " + path + " stored path : " + storedPath);
            }
            if (storedPath == null) {
                value = CV.getList(domain, port, secure);
                if (value != null) {
                    token.append(this.cookieName + HTTPConstants.ATTR_VALUE_SEPARATOR);
                    token.append(value);
                    gotIt = true;
                }
            } else {
                storedPath = this.stripPath(storedPath);
                if ((path = this.stripPath(path)).indexOf(storedPath) >= 0 && (value = CV.getList(domain, port, secure)) != null) {
                    token.append(this.cookieName + HTTPConstants.ATTR_VALUE_SEPARATOR);
                    token.append(value);
                    gotIt = true;
                }
            }
            if (!gotIt) continue;
            token.append(HTTPConstants.HEADER_TOKEN_SEPARATOR);
            gotIt = false;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getList : " + token.toString());
        }
        return token.toString();
    }

    private String stripPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith(HTTPConstants.STRING_VALUE_SEPARATOR) && path.endsWith(HTTPConstants.STRING_VALUE_SEPARATOR)) {
            int i = path.indexOf(HTTPConstants.STRING_VALUE_SEPARATOR);
            int j = path.lastIndexOf(HTTPConstants.STRING_VALUE_SEPARATOR);
            path = path.substring(i + 1, j);
        }
        return path;
    }
}

