/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.transport.channel.WSAddress;
import com.ibm.ws.webservices.engine.transport.channel.WSCFEndPointCriteriaImpl;
import com.ibm.ws.webservices.engine.transport.channel.WSChannelConstants;
import com.ibm.ws.webservices.engine.transport.channel.WSOutboundConnection;
import com.ibm.ws.webservices.engine.transport.http.HttpChannelAddress;
import com.ibm.ws.webservices.engine.transport.http.HttpOutboundChannelConnection;
import com.ibm.ws.webservices.engine.transport.http.HttpsOutboundChannelConnection;
import com.ibm.ws.webservices.engine.transport.security.ConfigSSL;
import com.ibm.ws.webservices.engine.transport.security.ConfigSSLProvider;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.WSVirtualConnectionFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.adapter.channel.ChannelTarget;
import com.ibm.wsspi.cluster.adapter.channel.NoAvailableEndPointException;
import com.ibm.wsspi.cluster.adapter.channel.SelectionEndPointCallback;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class WSChannelManager {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.webservices.resources.webservicesMessages");
    private static final TraceComponent _tc = Tr.register(WSChannelManager.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private static final String cfImplClass = "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl".intern();
    private static final String wbbpMgrImplClass = "com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl".intern();
    private static String tcpChannelFactoryName = "com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory";
    private static ChannelFramework cfS = null;
    private static WsByteBufferPoolManager wbbpMgr = null;
    private static WSChannelManager wMgr = null;
    private static Object o_RequestMapper = null;
    private static Object o_RequestFlowInfo = null;
    private static Method m_mapRequest = null;
    private static Method m_getClusterName = null;
    private static Method m_getVirtualHostName = null;
    private static Method m_getCellName = null;
    private static Method m_release = null;
    private static Class ac_UCFRoutingHelper = null;
    private static Method m_getHAClusterIdForDestinationEPR = null;
    private static Method m_getWLMClusterIdForDestinationEPR = null;
    private static Method m_getFragileClusterIdForDestinationEPR = null;
    private static Method m_isDestinationEPRFragile = null;
    private static Method m_getVirtualHostForDestinationEPR = null;
    private static boolean dwlmEnabled = true;
    private static ConfigSSLProvider cfgPvdr = null;
    public static int runtimeEnv = 3;

    private WSChannelManager() {
        if (WebServicesServiceHome.getWebServicesService() != null) {
            runtimeEnv = WebServicesServiceHome.getWebServicesService().isRoleApplicableToService(2) ? 1 : 2;
            tcpChannelFactoryName = "com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory";
        } else if (WebServicesServiceHome.getWebServicesSystemService() != null) {
            tcpChannelFactoryName = "com.ibm.ws.tcp.channel.impl.ZAioTCPChannelFactory";
            runtimeEnv = 1;
        }
        cfgPvdr = ConfigSSLProvider.getInstance();
    }

    public static final synchronized WSChannelManager getInstance() {
        if (wMgr == null) {
            wMgr = new WSChannelManager();
        }
        return wMgr;
    }

    public int getRuntime() {
        return runtimeEnv;
    }

    public final void setChannelFramework(ChannelFrameworkService incfS) {
        cfS = incfS;
    }

    public final synchronized ChannelFramework getChannelFramework() throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (cfS == null) {
            cfS = (ChannelFramework)this.getRequiredService(cfImplClass);
        }
        return cfS;
    }

    public final void setWsByteBufferPoolManager(WsByteBufferPoolManager inwbbpMgr) {
        wbbpMgr = inwbbpMgr;
    }

    public final synchronized WsByteBufferPoolManager getWsByteBufferPoolManager() throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (wbbpMgr == null) {
            wbbpMgr = (WsByteBufferPoolManager)this.getRequiredService(wbbpMgrImplClass);
        }
        return wbbpMgr;
    }

    private Object getRequiredService(String serviceClassName) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WSChannelManager::getRequiredService()");
        }
        Object retObj = null;
        InitialContext ctxt = null;
        try {
            ctxt = new InitialContext();
            if (serviceClassName.equals(cfImplClass)) {
                retObj = ctxt.lookup("services:websphere/ChannelFrameworkService");
            }
            if (serviceClassName.equals(wbbpMgrImplClass)) {
                retObj = ctxt.lookup("services:websphere/WsByteBufferPoolManager");
            }
            if (retObj != null && _tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("getRequiredService00", serviceClassName, retObj.toString()));
            }
        }
        catch (NamingException nex) {
        }
        catch (NoClassDefFoundError nex) {
            // empty catch block
        }
        if (retObj == null) {
            try {
                if (serviceClassName.equals(cfImplClass)) {
                    retObj = ctxt.lookup("websphere/ChannelFrameworkService");
                }
                if (serviceClassName.equals(wbbpMgrImplClass)) {
                    retObj = ctxt.lookup("websphere/WsByteBufferPoolManager");
                }
                if (retObj != null && _tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("getRequiredService00", serviceClassName, retObj.toString()));
                }
            }
            catch (NamingException nex) {
            }
            catch (NoClassDefFoundError nex) {
                // empty catch block
            }
        }
        if (retObj == null) {
            if (serviceClassName.equals(cfImplClass)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Using existing instance of ChannelFramework");
                }
                retObj = ChannelFrameworkFactory.getChannelFramework();
            } else {
                Class clazz;
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("j2wLoadClass00", serviceClassName));
                }
                if ((clazz = ClassUtils.forName(serviceClassName)) != null) {
                    Constructor ct = null;
                    try {
                        ct = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws NoSuchMethodException {
                                return clazz.getConstructor(null);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.channel.WSChannelManager", "405", this);
                        throw (NoSuchMethodException)e.getException();
                    }
                    retObj = ct.newInstance(null);
                }
                if (retObj != null && _tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("getRequiredService00", serviceClassName, retObj.toString()));
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WSChannelManager::getRequiredService()");
        }
        return retObj;
    }

    private String createChannel(String channelName, boolean sslEnabled, ConfigSSL sslProps) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WSChannelManager::createChannel()...");
        }
        boolean succeeded = false;
        String tmpChannelName = channelName;
        String sslalias = null;
        Class<?> sslChannFactory = null;
        if (channelName.equals("httpclient-ssl-outbound") && sslProps != null) {
            if (_tc.isDebugEnabled()) {
                Tr.entry(_tc, "Obtaining SSL Alias Information");
            }
            if ((sslChannFactory = Class.forName(runtimeEnv == 3 ? "com.ibm.ws.ssl.channel.impl.SSLChannelFactory" : "com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory")) != null) {
                sslalias = sslProps.configAliasProperty();
            }
            if (sslalias != null) {
                tmpChannelName = tmpChannelName.concat("/" + sslalias);
            }
        }
        if (cfS.getChannel(tmpChannelName) == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("createChannel00", channelName));
            }
            if (channelName.equals("httpclient-http-outbound")) {
                Class<?> httpChannFactory = Class.forName("com.ibm.ws.http.channel.outbound.impl.HttpOutboundChannelFactory");
                if (httpChannFactory != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using: " + httpChannFactory.toString());
                    }
                    cfS.addChannel("httpclient-http-outbound", httpChannFactory, null);
                    succeeded = true;
                }
            } else if (channelName.equals("httpclient-ssl-outbound")) {
                if (sslChannFactory != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using: " + sslChannFactory.toString());
                    }
                    Hashtable<Object, Object> inProps = new Hashtable<Object, Object>(sslProps);
                    cfS.addChannel(tmpChannelName, sslChannFactory, inProps);
                    succeeded = true;
                }
            } else if (channelName.equals("httpclient-tcp-outbound")) {
                Class<?> tcpChannFactory = null;
                try {
                    tcpChannFactory = Class.forName(tcpChannelFactoryName);
                }
                catch (ClassNotFoundException cEx) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, Messages.getMessage("exception01", cEx.getLocalizedMessage()));
                    }
                    tcpChannelFactoryName = "com.ibm.ws.tcp.channel.impl.TCPChannelFactory";
                    tcpChannFactory = Class.forName(tcpChannelFactoryName);
                }
                if (tcpChannFactory != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using: " + tcpChannFactory.toString());
                    }
                    cfS.addChannel("httpclient-tcp-outbound", tcpChannFactory, null);
                    succeeded = true;
                }
            }
        } else {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("createChannel01", channelName));
            }
            succeeded = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WSChannelManager::createChannel()...");
        }
        if (succeeded) {
            return tmpChannelName;
        }
        return null;
    }

    private void createChannelChain(String channelChainName, boolean sslEnabled, ConfigSSL sslProps) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WSChannelManager::createChannelChain()...");
        }
        if (cfS.getChain(channelChainName) == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, Messages.getMessage("createChannelChain00", channelChainName));
            }
            if (sslEnabled) {
                String sslChannelName = null;
                if (this.createChannel("httpclient-tcp-outbound", sslEnabled, sslProps) != null && (sslChannelName = this.createChannel("httpclient-ssl-outbound", sslEnabled, sslProps)) != null && this.createChannel("httpclient-http-outbound", sslEnabled, sslProps) != null) {
                    String[] channelArray = new String[]{"httpclient-http-outbound", sslChannelName, "httpclient-tcp-outbound"};
                    cfS.addChain(channelChainName, FlowType.OUTBOUND, channelArray);
                }
            } else if (this.createChannel("httpclient-tcp-outbound", sslEnabled, sslProps) != null && this.createChannel("httpclient-http-outbound", sslEnabled, sslProps) != null) {
                cfS.addChain(channelChainName, FlowType.OUTBOUND, WSChannelConstants.HTTP_CHAIN_ARRAY);
            }
        } else if (_tc.isEventEnabled()) {
            Tr.event(_tc, Messages.getMessage("createChannelChain01", channelChainName));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WSChannelManager::createChannelChain()...");
        }
    }

    public Identity clusterIdenFromEPR(WSCFEndPointCriteriaImpl crit) {
        Identity id;
        block24: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "WSChannelManager::clusterIdenFromEPR()");
            }
            id = null;
            if (this.getRuntime() != 3) {
                try {
                    Class[] argType = new Class[1];
                    Class clazz = argType[0] = javax.xml.rpc.handler.MessageContext.class;
                    if (ac_UCFRoutingHelper == null) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("j2wLoadClass00", "com.ibm.ws.wsaddressing.UCFRoutingHelper"));
                        }
                        ac_UCFRoutingHelper = ClassUtils.forName("com.ibm.ws.wsaddressing.UCFRoutingHelper");
                    }
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("invokeMethod00", "getHAClusterIdForDestinationEPR", "com.ibm.ws.wsaddressing.UCFRoutingHelper"));
                    }
                    Object[] msgContext = new Object[]{MessageContext.getCurrentThreadsContext()};
                    if (m_getHAClusterIdForDestinationEPR == null) {
                        m_getHAClusterIdForDestinationEPR = ac_UCFRoutingHelper.getMethod("getHAClusterIdForDestinationEPR", argType);
                    }
                    if ((id = (Identity)m_getHAClusterIdForDestinationEPR.invoke(null, msgContext)) == null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "com.ibm.ws.wsaddressing.UCFRoutingHelper.getHAClusterIdForDestinationEPR() returns null.");
                        }
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("invokeMethod00", "getWLMClusterIdForDestinationEPR", "com.ibm.ws.wsaddressing.UCFRoutingHelper"));
                        }
                        if (m_getWLMClusterIdForDestinationEPR == null) {
                            m_getWLMClusterIdForDestinationEPR = ac_UCFRoutingHelper.getMethod("getWLMClusterIdForDestinationEPR", argType);
                        }
                        id = (Identity)m_getWLMClusterIdForDestinationEPR.invoke(null, msgContext);
                    } else {
                        crit.setEPRtype(2);
                    }
                    if (id == null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "com.ibm.ws.wsaddressing.UCFRoutingHelper.getWLMClusterIdForDestinationEPR() returns null.");
                        }
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("invokeMethod00", "getFragileClusterIdForDestinationEPR", "com.ibm.ws.wsaddressing.UCFRoutingHelper"));
                        }
                        if (m_getFragileClusterIdForDestinationEPR == null) {
                            m_getFragileClusterIdForDestinationEPR = ac_UCFRoutingHelper.getMethod("getFragileClusterIdForDestinationEPR", argType);
                        }
                        if ((id = (Identity)m_getFragileClusterIdForDestinationEPR.invoke(null, msgContext)) != null) {
                            crit.setEPRtype(3);
                        }
                    } else {
                        crit.setEPRtype(1);
                    }
                    if (id != null) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("invokeMethod00", "getVirtualHostForDestinationEPR", "com.ibm.ws.wsaddressing.UCFRoutingHelper"));
                        }
                        if (m_getVirtualHostForDestinationEPR == null) {
                            m_getVirtualHostForDestinationEPR = ac_UCFRoutingHelper.getMethod("getVirtualHostForDestinationEPR", argType);
                        }
                        String vhost = (String)m_getVirtualHostForDestinationEPR.invoke(null, msgContext);
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Virtual host returned by com.ibm.ws.wsaddressing.UCFRoutingHelper: " + vhost);
                        }
                        crit.set("vhost", vhost);
                    }
                }
                catch (Exception ex) {
                    if (!_tc.isDebugEnabled()) break block24;
                    StackTraceElement[] sE = ex.getStackTrace();
                    Tr.debug(_tc, Messages.getMessage("proceedToNextOption00", ex.toString() + ", " + (sE != null && sE.length != 0 ? "" : sE[0].toString())));
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WSChannelManager::clusterIdenFromEPR()");
        }
        return id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Identity clusterIdenFromDWLMClient(WSAddress addrtoConnect, WSCFEndPointCriteriaImpl wsEndptCri) {
        Identity id;
        block33: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "WSChannelManager::clusterIdenFromDWLMClient()");
            }
            id = null;
            Class clazz = null;
            if (this.getRuntime() != 3) {
                try {
                    if (dwlmEnabled) {
                        if (o_RequestMapper == null || m_mapRequest == null || o_RequestFlowInfo == null || m_getClusterName == null || m_getVirtualHostName == null || m_release == null) {
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, Messages.getMessage("j2wLoadClass00", "com.ibm.wsspi.dwlm.client.DWLMClientFactory"));
                            }
                            if ((clazz = ClassUtils.forName("com.ibm.wsspi.dwlm.client.DWLMClientFactory")) == null) {
                                return id;
                            }
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, Messages.getMessage("invokeMethod00", "getDWLMClient", "com.ibm.wsspi.dwlm.client.DWLMClientFactory"));
                            }
                            Method getDWLMClient = clazz.getMethod("getDWLMClient", null);
                            Object dwlmClient = getDWLMClient.invoke(null, null);
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, Messages.getMessage("j2wLoadClass00", "com.ibm.wsspi.dwlm.client.DWLMClient"));
                            }
                            if ((clazz = ClassUtils.forName("com.ibm.wsspi.dwlm.client.DWLMClient")) == null) {
                                return id;
                            }
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, Messages.getMessage("invokeMethod00", "getRequestMapper", "com.ibm.wsspi.dwlm.client.DWLMClient"));
                            }
                            Method getMapper = clazz.getMethod("getRequestMapper", null);
                            o_RequestMapper = getMapper.invoke(dwlmClient, null);
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, Messages.getMessage("invokeMethod00", "createRequestFlowInfo", "com.ibm.wsspi.dwlm.client.DWLMClient"));
                            }
                            Method createRequestFlowInfo = clazz.getMethod("createRequestFlowInfo", null);
                            o_RequestFlowInfo = createRequestFlowInfo.invoke(dwlmClient, null);
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, Messages.getMessage("j2wLoadClass00", "com.ibm.wsspi.dwlm.client.RequestMapper"));
                            }
                            if ((clazz = ClassUtils.forName("com.ibm.wsspi.dwlm.client.RequestMapper")) == null) {
                                return id;
                            }
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, Messages.getMessage("invokeMethod00", "isEnabled", "com.ibm.wsspi.dwlm.client.RequestMapper"));
                            }
                            Method m_isEnabled = clazz.getMethod("isEnabled", null);
                            dwlmEnabled = (Boolean)m_isEnabled.invoke(o_RequestMapper, null);
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, Messages.getMessage("dwlmEnabled", Boolean.toString(dwlmEnabled)));
                            }
                            if (!dwlmEnabled) {
                                return id;
                            }
                            Class[] paratypes = new Class[]{String.class, Integer.TYPE, String.class, o_RequestFlowInfo.getClass().getInterfaces()[0]};
                            m_mapRequest = clazz.getMethod("mapRequest", paratypes);
                            clazz = ClassUtils.forName("com.ibm.wsspi.dwlm.client.RequestFlowInfo");
                            if (clazz == null) {
                                return id;
                            }
                            m_getClusterName = clazz.getMethod("getClusterName", null);
                            m_getVirtualHostName = clazz.getMethod("getVirtualHostName", null);
                            m_getCellName = clazz.getMethod("getCellName", null);
                            m_release = clazz.getMethod("release", null);
                        }
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("invokeMethod00", "release", "com.ibm.wsspi.dwlm.client.RequestFlowInfo"));
                        }
                        m_release.invoke(o_RequestFlowInfo, null);
                        Object[] arglist = new Object[4];
                        arglist[0] = addrtoConnect.getHostname();
                        arglist[1] = new Integer(addrtoConnect.getPort());
                        if (addrtoConnect.getSchema() != 1 && addrtoConnect.getSchema() != 2) {
                            if (!_tc.isEventEnabled()) return id;
                            Tr.event(_tc, Messages.getMessage("httpUnsupportedSchema", addrtoConnect.toString()));
                            return id;
                        }
                        arglist[2] = ((HttpChannelAddress)addrtoConnect).getURIPath();
                        arglist[3] = o_RequestFlowInfo;
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("invokeMethod00", "mapRequest", "com.ibm.wsspi.dwlm.client.RequestMapper"));
                        }
                        m_mapRequest.invoke(o_RequestMapper, arglist);
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("invokeMethod00", "getClusterName", "com.ibm.wsspi.dwlm.client.RequestFlowInfo"));
                        }
                        String clusterName = (String)m_getClusterName.invoke(o_RequestFlowInfo, null);
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("infoMappingClusterName", clusterName, String.valueOf(arglist[0]), String.valueOf(arglist[1]), String.valueOf(arglist[2])) + ", RequestFlowInfo object: " + String.valueOf(arglist[3]));
                        }
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("invokeMethod00", "getVirtualHostName", "com.ibm.wsspi.dwlm.client.RequestFlowInfo"));
                        }
                        String vHostName = (String)m_getVirtualHostName.invoke(o_RequestFlowInfo, null);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Mapped virtual host name: <" + vHostName + "> using host: " + String.valueOf(arglist[0]) + ", port: " + String.valueOf(arglist[1]) + ", URI: " + String.valueOf(arglist[2]) + ", RequestFlowInfo object: " + String.valueOf(arglist[3]));
                        }
                        if (vHostName == null) {
                            return id;
                        }
                        wsEndptCri.set("vhost", vHostName);
                        if (clusterName == null) return id;
                        String localCellName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return AdminServiceFactory.getAdminService().getCellName();
                            }
                        });
                        String mappedCellName = (String)m_getCellName.invoke(o_RequestFlowInfo, null);
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("cellNameInfo1", localCellName, mappedCellName));
                        }
                        if (_tc.isEventEnabled() && _tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("j2wLoadClass00", "com.ibm.wsspi.cluster.adapter.IdentityMapping"));
                        }
                        if ((clazz = ClassUtils.forName("com.ibm.wsspi.cluster.adapter.IdentityMapping")) == null) {
                            return id;
                        }
                        Object IdentityMapping2 = clazz.newInstance();
                        Class[] paratypes = new Class[2];
                        paratypes[0] = String.class;
                        Class clazz2 = paratypes[1] = String.class;
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("invokeMethod00", "getClusterIdentityFromClusterName", "com.ibm.wsspi.cluster.adapter.IdentityMapping"));
                        }
                        Method m_getClusterIdentityFromClusterName = clazz.getMethod("getClusterIdentityFromClusterName", paratypes);
                        Object[] args = new Object[]{mappedCellName, clusterName};
                        id = (Identity)m_getClusterIdentityFromClusterName.invoke(IdentityMapping2, args);
                    } else if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("dwlmEnabled", Boolean.FALSE.toString()));
                    }
                }
                catch (Exception ex) {
                    if (!_tc.isDebugEnabled()) break block33;
                    StackTraceElement[] sE = ex.getStackTrace();
                    Tr.debug(_tc, Messages.getMessage("proceedToNextOption01", ex.toString() + ", " + (sE != null && sE.length != 0 ? "" : sE[0].toString())));
                }
            }
        }
        if (!_tc.isEntryEnabled()) return id;
        Tr.exit(_tc, "WSChannelManager::clusterIdenFromDWLMClient()");
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFEndPoint identityToCFEndPoint(Identity id, WSCFEndPointCriteriaImpl wsEndptCri, Map contextMap, boolean callbackDisabled) {
        CFEndPoint cfEndPt;
        block34: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "WSChannelManager::identityToCFEndPoint()");
            }
            cfEndPt = null;
            try {
                Class ChannelSelectionAdapterImpl_C;
                Object wsaddr = null;
                if (_tc.isEventEnabled() && _tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("j2wLoadClass00", "com.ibm.ws.cluster.channel.ChannelSelectionAdapterImpl"));
                }
                if ((ChannelSelectionAdapterImpl_C = ClassUtils.forName("com.ibm.ws.cluster.channel.ChannelSelectionAdapterImpl")) == null) {
                    return cfEndPt;
                }
                Object ChannelSelectionAdapterImpl_Obj = ChannelSelectionAdapterImpl_C.newInstance();
                if (_tc.isEventEnabled() && _tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("j2wLoadClass00", "com.ibm.wsspi.cluster.adapter.channel.ChannelSelectionCriteria"));
                }
                Class ChannelSelectionCriteria_C = ClassUtils.forName("com.ibm.wsspi.cluster.adapter.channel.ChannelSelectionCriteria");
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("invokeMethod00", "getCriteria", "com.ibm.ws.cluster.channel.ChannelSelectionAdapterImpl"));
                }
                Class[] paratypes = new Class[]{ClassUtils.forName("com.ibm.wsspi.cluster.Identity"), Map.class, CFEndPointCriteria.class};
                Method m_getCriteria = ChannelSelectionAdapterImpl_C.getMethod("getCriteria", paratypes);
                Object[] args = new Object[]{id, contextMap, wsEndptCri};
                Object ChannelSelectionCriteria_Obj = null;
                ChannelSelectionCriteria_Obj = m_getCriteria.invoke(ChannelSelectionAdapterImpl_Obj, args);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getCriteria() returns " + ChannelSelectionCriteria_Obj);
                }
                if (ChannelSelectionCriteria_Obj != null) {
                    Object ChannelTarget_Obj;
                    block32: {
                        Class[] paratypes2 = new Class[]{ChannelSelectionCriteria_C};
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("invokeMethod00", "select", "com.ibm.ws.cluster.channel.ChannelSelectionAdapterImpl"));
                        }
                        Method m_select = ChannelSelectionAdapterImpl_C.getMethod("select", paratypes2);
                        Object[] args2 = new Object[]{ChannelSelectionCriteria_Obj};
                        ChannelTarget_Obj = null;
                        try {
                            ChannelTarget_Obj = m_select.invoke(ChannelSelectionAdapterImpl_Obj, args2);
                        }
                        catch (InvocationTargetException iEx) {
                            CallbackForClustering cb;
                            Throwable origEx = iEx.getCause();
                            if (callbackDisabled || origEx == null || !(origEx instanceof NoAvailableEndPointException)) break block32;
                            CallbackForClustering callbackForClustering = cb = new CallbackForClustering();
                            synchronized (callbackForClustering) {
                                block33: {
                                    if (_tc.isEventEnabled()) {
                                        Tr.event(_tc, Messages.getMessage("NoAvailableEndPointException00", ((Object)origEx).toString()));
                                    }
                                    ((NoAvailableEndPointException)origEx).callbackWhenAvailable(cb, null);
                                    try {
                                        String timeoutInString = null;
                                        timeoutInString = wsEndptCri.isSSLRequired() ? TransportClientPropertiesFactory.create("https").ucfCallbackTimeout() : TransportClientPropertiesFactory.create("http").ucfCallbackTimeout();
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "com.ibm.websphere.webservices.UCFSelectionTimeout: " + timeoutInString);
                                        }
                                        int timeout = 60;
                                        try {
                                            timeout = Integer.valueOf(timeoutInString);
                                        }
                                        catch (NumberFormatException nEx) {
                                            // empty catch block
                                        }
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "UCF callback wait timeout: " + timeout + " seconds.");
                                        }
                                        cb.wait(timeout * 1000);
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "UCF callback wait() was completed.");
                                        }
                                    }
                                    catch (InterruptedException intEx) {
                                        if (!_tc.isDebugEnabled()) break block33;
                                        Tr.debug(_tc, "UCF callback was interrupted.");
                                    }
                                }
                            }
                            if (cb.getSelectedTarget() != null) {
                                ChannelTarget_Obj = cb.getSelectedTarget();
                                if (_tc.isEventEnabled()) {
                                    Tr.event(_tc, Messages.getMessage("NoAvailableEndPointException02"), ChannelTarget_Obj.toString());
                                }
                            }
                            if (!_tc.isEventEnabled()) break block32;
                            Tr.event(_tc, Messages.getMessage("NoAvailableEndPointException01"));
                        }
                    }
                    if (ChannelTarget_Obj != null) {
                        Class ChannelTarget_C;
                        if (_tc.isEventEnabled() && _tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("j2wLoadClass00", "com.ibm.wsspi.cluster.adapter.channel.ChannelTarget"));
                        }
                        if ((ChannelTarget_C = ClassUtils.forName("com.ibm.wsspi.cluster.adapter.channel.ChannelTarget")) != null) {
                            Method m_getCFEndPoint;
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, Messages.getMessage("invokeMethod00", "getCFEndPoint", "com.ibm.wsspi.cluster.adapter.channel.ChannelTarget"));
                            }
                            if ((m_getCFEndPoint = ChannelTarget_C.getMethod("getCFEndPoint", null)) != null) {
                                cfEndPt = (CFEndPoint)m_getCFEndPoint.invoke(ChannelTarget_Obj, null);
                            }
                        }
                    }
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, Messages.getMessage("infoMappingCFEndPoint", cfEndPt == null ? null : cfEndPt.getName(), id.toString()));
                }
            }
            catch (Exception ex) {
                if (!_tc.isDebugEnabled()) break block34;
                StackTraceElement[] sE = ex.getStackTrace();
                Tr.debug(_tc, Messages.getMessage("proceedToNextOption01", ex.toString() + ", " + (sE != null && sE.length != 0 ? "" : sE[0].toString())));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WSChannelManager::identityToCFEndPoint()");
        }
        return cfEndPt;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final VirtualConnectionFactory getVCFactory(WSAddress addrtoConnect) throws WebServicesFault {
        void var2_7;
        block9: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "WSChannelManager::getVCFactory(): " + addrtoConnect.toString());
            }
            Object var2_2 = null;
            try {
                CFEndPoint cPt;
                boolean useSSL = addrtoConnect.getSchema() == 2;
                ConfigSSL sslProps = null;
                if (useSSL) {
                    sslProps = (ConfigSSL)addrtoConnect.transportConfiguration();
                }
                if ((cPt = addrtoConnect.getCFEndPoint()) == null) {
                    this.getChannelFramework();
                    if (cfS == null) throw new WebServicesFault(Messages.getMessage("channelframework01", "null ChannelFramework Service"));
                    String activeChainName = addrtoConnect.keyValueforPool();
                    this.createChannelChain(activeChainName, useSSL, sslProps);
                    VirtualConnectionFactory virtualConnectionFactory = cfS.getOutboundVCFactory(activeChainName);
                    if (virtualConnectionFactory == null) {
                        throw new WebServicesFault(Messages.getMessage("channelframework01", "null VirtualConnectionFactory"));
                    }
                } else if (useSSL) {
                    String sslalias = sslProps.configAliasProperty();
                    Hashtable<Object, Object> inProps = new Hashtable<Object, Object>(sslProps);
                    WSVirtualConnectionFactory wSVirtualConnectionFactory = cPt.getOutboundVCFactory(inProps, true);
                } else {
                    WSVirtualConnectionFactory wSVirtualConnectionFactory = cPt.getOutboundVCFactory();
                }
            }
            catch (Exception ex) {
                if (ex instanceof NamingException) break block9;
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.channel.WSChannelManager", "1417", this);
                throw WebServicesFault.makeFault(ex);
            }
        }
        if (!_tc.isEntryEnabled()) return var2_7;
        Tr.exit(_tc, "WSChannelManager::getVCFactory(): " + addrtoConnect.toString());
        return var2_7;
    }

    public final WSOutboundConnection getWSOutboundConnection(String chainName, WSAddress addrtoConnect, VirtualConnectionFactory vcf) throws WebServicesFault {
        HttpOutboundChannelConnection wsOC;
        block10: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "WSChannelManager::getWSOutboundConnection(): " + addrtoConnect.toString());
            }
            wsOC = null;
            try {
                if (vcf != null) {
                    OutboundVirtualConnection oVC = (OutboundVirtualConnection)vcf.createConnection();
                    if (oVC != null) {
                        int schemaType = addrtoConnect.getSchema();
                        if (schemaType == 1) {
                            wsOC = new HttpOutboundChannelConnection(oVC, addrtoConnect, chainName);
                        } else if (schemaType == 2) {
                            wsOC = new HttpsOutboundChannelConnection(oVC, addrtoConnect, chainName);
                        }
                        if (!((HttpChannelAddress)addrtoConnect).isProxy() || schemaType != 2) break block10;
                        HashMap hM = ((HttpChannelAddress)addrtoConnect).infoForTunneling();
                        if (hM != null) {
                            wsOC.updateConnectionCfg("FORWARD_PROXY_CONNECT", hM);
                            break block10;
                        }
                        throw new WebServicesFault(Messages.getMessage("httpProxyError"));
                    }
                    throw new WebServicesFault(Messages.getMessage("channelframework01", "null OutboundVirtualConnection."));
                }
                throw new WebServicesFault(Messages.getMessage("channelframework01", "null VirtualConnectionFactory"));
            }
            catch (Exception ex) {
                if (ex instanceof NamingException) break block10;
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.channel.WSChannelManager", "1504", this);
                throw WebServicesFault.makeFault(ex);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WSChannelManager::getWSOutboundConnection(): " + addrtoConnect.toString());
        }
        return wsOC;
    }

    public boolean isEPRFragile() {
        boolean result;
        block10: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "WSChannelManager::isEPRFragile()");
            }
            result = false;
            if (this.getRuntime() != 3) {
                try {
                    if (ac_UCFRoutingHelper == null) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, Messages.getMessage("j2wLoadClass00", "com.ibm.ws.wsaddressing.UCFRoutingHelper"));
                        }
                        ac_UCFRoutingHelper = ClassUtils.forName("com.ibm.ws.wsaddressing.UCFRoutingHelper");
                    }
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, Messages.getMessage("invokeMethod00", "isDestinationEPRFragile", "com.ibm.ws.wsaddressing.UCFRoutingHelper"));
                    }
                    Class[] argType = new Class[]{javax.xml.rpc.handler.MessageContext.class};
                    Object[] msgContext = new Object[]{MessageContext.getCurrentThreadsContext()};
                    if (m_isDestinationEPRFragile == null) {
                        m_isDestinationEPRFragile = ac_UCFRoutingHelper.getMethod("isDestinationEPRFragile", argType);
                    }
                    result = (Boolean)m_isDestinationEPRFragile.invoke(null, msgContext);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.channel.WSChannelManager", "1573", this);
                    if (!_tc.isDebugEnabled()) break block10;
                    Throwable t = ex.getCause();
                    Tr.debug(_tc, Messages.getMessage("failedToEvaluatefragileEPR", t == null ? ex.toString() : t.toString()));
                }
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "UCFRoutingHelper.isDestinationEPRFragile() returning: " + result);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WSChannelManager::isEPRFragile()");
        }
        return result;
    }

    private class CallbackForClustering
    implements SelectionEndPointCallback {
        private ChannelTarget selectedT = null;

        private CallbackForClustering() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(ChannelTarget arg0, Object arg1) {
            CallbackForClustering callbackForClustering = this;
            synchronized (callbackForClustering) {
                this.selectedT = arg0;
                this.notifyAll();
            }
        }

        public ChannelTarget getSelectedTarget() {
            return this.selectedT;
        }
    }
}

